<?php

namespace App\Livewire\Admin\SubscriptionPlanWizard;

use Livewire\Component;

class Step2PlanLimits extends Component
{
    public $included_doctors;
    public $included_staff;
    public $storage_limit_gb;
    public $teleconsultation_minutes;
    public $sms_limit;
    public $whatsapp_limit;
    public $additional_doctor_price;
    public $additional_staff_price;
    public $currency;


    protected $rules = [
        'included_doctors' => 'required|integer|min:0',
        'included_staff' => 'required|integer|min:0',
        'storage_limit_gb' => 'required|integer|min:0',
        'teleconsultation_minutes' => 'required|integer|min:0',
        'sms_limit' => 'required|integer|min:0',
        'whatsapp_limit' => 'nullable|integer|min:0',
        'additional_doctor_price' => 'required|numeric|min:0',
        'additional_staff_price' => 'required|numeric|min:0',
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function validationAttributes()
    {
        return [
            'included_doctors' => 'Max Doctors',
            'additional_doctor_price' => 'Additional Doctor Price',
            'included_staff' => 'Max Staff',
            'additional_staff_price' => 'Additional Staff Price',
            'storage_limit_gb' => 'Storage Limit',
            'teleconsultation_minutes' => 'Teleconsultation Minutes',
            'sms_limit' => 'SMS Limit',
            'whatsapp_limit' => 'WhatsApp Limit',
        ];
    }

    public function mount($data = null, $currency = null , $basic = null)
    {
        if ($data) {
            $this->fill($data);
        }
        if ($basic){
            $this->included_doctors = $basic['max_doctors'];
            $this->included_staff = $basic['max_staff'];
        }
        $this->currency = $currency ?? 'USD';
    }

    public function previous()
    {
        $this->dispatch('goToStep', step: 1);
    }

    public function next()
    {
        $this->validate();

        $data = $this->only([
            'included_doctors',
            'included_staff',
            'storage_limit_gb',
            'teleconsultation_minutes',
            'sms_limit',
            'whatsapp_limit',
            'additional_doctor_price',
            'additional_staff_price',
        ]);

        $this->dispatch('updatePlanData', step: 'limits', data: $data);
        $this->dispatch('goToStep', step: 3);
    }

    public function render()
    {
        return view('livewire.admin.subscription-plan-wizard.step2-plan-limits');
    }
}