<?php

namespace App\Livewire\Admin\Clinics;

use App\Models\Clinic;
use App\Models\CustomerSubscription;
use App\Models\SubscriptionPlan;
use App\Models\AddOn;
use Livewire\Component;
use Illuminate\Support\Facades\Gate;

class ViewClinic extends Component
{
    public Clinic $clinic;
    public $selectedPlanDetails = null;
    public $selectedPlanLimits = null;
    public $availablePlans;
    public $selected_plan_id = null;
    public $selected_add_on_id = [];
    public $showAddOnSelection;
    public $availableAddOns;
    public $selectedAddOnDetails = [];
    public $usedLimits = [];
    
    // Tab management
    public $activeTab = 'doctors'; // Default active tab
    public $loadedTabs = []; // Track which tabs have been loaded

    public function mount(Clinic $clinic)
    {
        if (!Gate::allows('view clinics')) {
            abort(403);
        }
        
        $this->clinic = $clinic;
        $this->availablePlans = SubscriptionPlan::where('plan_status', 'active')->get();
        $this->availableAddOns = AddOn::where('is_active', true)->get();

        // Load existing subscription if available
        if ($clinic->subscription_id) {
            $subscription = CustomerSubscription::find($clinic->subscription_id);
            $this->selected_plan_id = $subscription->plan_id;
            $this->selectedPlanDetails = $subscription->plan;
            $this->selectedPlanLimits = $this->selectedPlanDetails->limit;
            $this->loadUsedLimits();
            
            if ($clinic->subscription->subscriptionAddOns) {
                foreach($clinic->subscription->subscriptionAddOns as $index => $addOn) {
                    $addOn = $addOn->addOn;
                    $this->selected_add_on_id[$index] = $addOn->id;
                    $this->selectedAddOnDetails[$index] = $addOn;
                }
            }
        }

        // Load the default active tab
        $this->loadedTabs[$this->activeTab] = true;
    }

    public function switchTab($tab)
    {
        $this->activeTab = $tab;
        
        // Mark this tab as loaded
        if (!isset($this->loadedTabs[$tab])) {
            $this->loadedTabs[$tab] = true;
        }
        
        // Dispatch event to notify child components
        $this->dispatch('tabSwitched', $tab);
    }

    protected function loadUsedLimits()
    {
        $this->usedLimits['doctors'] = $this->clinic->doctorAssociations->count();
        $this->usedLimits['staffs'] = $this->clinic->staffAssociations->count();
        $this->usedLimits['storage_limit'] = $this->selectedPlanLimits->storage_limit_gb;
        $this->usedLimits['teleconsultation_limit'] = $this->selectedPlanLimits->teleconsultation_minutes;
        $this->usedLimits['sms_limit'] = $this->selectedPlanLimits->sms_limit;
        $this->usedLimits['whatsapp_limit'] = $this->selectedPlanLimits->whatsapp_limit;
    }

    public function render()
    {
        return view('livewire.admin.clinics.view-clinic');
    }
}