<?php
// Add this middleware to ensure auth guard is properly set

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Log;

class SetGuardByRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $currentRole = Session::get('current_role');
        
        if ($currentRole) {
            
            $guard = match ($currentRole) {
                'doctor' => 'doctor',
                'staff' => 'staff',
                'superadmin' => 'superadmin',
                'patient' => 'patient',
                default => 'web'
            };
            Log::info("setguard",['guard' => $guard]);
            Auth::shouldUse($guard);
        }
        
        return $next($request);
    }
}