<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\ValidationException;
use App\Models\ActiveDevice;
use App\Models\User;

class SuperAdminAuthController extends Controller
{
    public function showLoginForm()
    {   
        Log::channel('permission')->info('Showing superadmin login form');
        return view('admin.auth.login', ['role' => 'superadmin']);
    }

    public function logout(Request $request)
    {
        $user = Auth::user();
        $userId = $user ? $user->id : null;
        $email = $user ? $user->email : null;

        Log::channel('permission')->info('Superadmin logout initiated', [
            'user_id' => $userId,
            'email' => $email
        ]);

        if ($user) {
            try {
                $updated = ActiveDevice::where('user_id', $user->id)
                    ->where('device_id', $request->userAgent())
                    ->where('role_type', 'superadmin')
                    ->update([
                        'is_active' => false,
                        'last_active_at' => now(),
                    ]);

                Log::channel('permission')->debug('Active device records updated on logout', [
                    'records_updated' => $updated,
                    'user_id' => $user->id
                ]);
            } catch (\Exception $e) {
                Log::channel('permission')->error('Failed to update active device on logout', [
                    'error' => $e->getMessage(),
                    'user_id' => $user->id
                ]);
            }
        }

        Session::forget('current_role');
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        Log::channel('permission')->info('Superadmin logout completed', [
            'user_id' => $userId,
            'email' => $email
        ]);

        return redirect()->route('admin.login');
    }
}