<?php
/**
 * Footer widget widget class
 *
 * @since 2.8.0
 */
class sanbi_widget_footer_about extends WP_Widget {

    function __construct() {
        $widget_ops = array('classname' => 'widget_footer_about', 'description' => esc_html__( "Footer About", 'sanbi') );
        parent::__construct('footer-about', esc_html__('Footer About', 'sanbi'), $widget_ops);
        $this->alt_option_name = 'widget_footer_about';
    }

    function widget($args, $instance) {
        $cache = wp_cache_get('sanbi_widget_footer_about', 'widget');

        if ( !is_array($cache) )
            $cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = $this->id;

        if ( isset( $cache[ $args['widget_id'] ] ) ) {
            echo wp_specialchars_decode(esc_attr($cache[ $args['widget_id'] ]));
            return;
        }

        ob_start();
        extract($args);
        $about_description = ( ! empty( $instance['about_description'] ) ) ? $instance['about_description'] : esc_html__( '', 'sanbi' );
        $link_social_1 = ( ! empty( $instance['link_social_1'] ) ) ? $instance['link_social_1'] : esc_html__( '', 'sanbi' );
        $icon_social_1 = ( ! empty( $instance['icon_social_1'] ) ) ? $instance['icon_social_1'] : esc_html__( '', 'sanbi' );
        $link_social_2 = ( ! empty( $instance['link_social_2'] ) ) ? $instance['link_social_2'] : esc_html__( '', 'sanbi' );
        $icon_social_2 = ( ! empty( $instance['icon_social_2'] ) ) ? $instance['icon_social_2'] : esc_html__( '', 'sanbi' );
        $link_social_3 = ( ! empty( $instance['link_social_3'] ) ) ? $instance['link_social_3'] : esc_html__( '', 'sanbi' );
        $icon_social_3 = ( ! empty( $instance['icon_social_3'] ) ) ? $instance['icon_social_3'] : esc_html__( '', 'sanbi' );
        $link_social_4 = ( ! empty( $instance['link_social_4'] ) ) ? $instance['link_social_4'] : esc_html__( '', 'sanbi' );
        $icon_social_4 = ( ! empty( $instance['icon_social_4'] ) ) ? $instance['icon_social_4'] : esc_html__( '', 'sanbi' );
        $link_social_5 = ( ! empty( $instance['link_social_5'] ) ) ? $instance['link_social_5'] : esc_html__( '', 'sanbi' );
        $icon_social_5 = ( ! empty( $instance['icon_social_5'] ) ) ? $instance['icon_social_5'] : esc_html__( '', 'sanbi' );
        ?>
        <?php echo wp_specialchars_decode(esc_attr($before_widget),ENT_QUOTES); ?>
        
        <div class="footer-info">
          <!-- Footer Logo -->
          <div class="footer-info-logo">
            <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                <?php if(isset($sanbi_redux_demo['logo_footer']['url']) && $sanbi_redux_demo['logo_footer']['url'] != ''){ ?>
                <img src="<?php echo esc_url($sanbi_redux_demo['logo_footer']['url']); ?>" alt="logo" />
                <?php } else { ?>
                <img src="<?php echo get_template_directory_uri();?>/images/color-logo.png" alt="logo" />
                <?php } ?>
            </a>
          </div>
          <?php if(isset($about_description) && $about_description != ''){?>
          <div class="footer-info-text my-4">
            <p><?php echo esc_attr($about_description); ?></p>
          </div>
          <?php } ?> 
        </div>
        <div class="footer-social">
          <ul>
            <?php if(isset($link_social_1) && $link_social_1 != ''){?> 
            <li>
                <a href="<?php echo esc_attr($link_social_1); ?>">
                    <i class="<?php echo esc_attr($icon_social_1); ?>"></i>
                </a>
            </li>
            <?php } ?>
            <?php if(isset($link_social_2) && $link_social_2 != ''){?> 
            <li>
                <a href="<?php echo esc_attr($link_social_2); ?>">
                    <i class="<?php echo esc_attr($icon_social_2); ?>"></i>
                </a>
            </li>
            <?php } ?>
            <?php if(isset($link_social_3) && $link_social_3 != ''){?> 
            <li>
                <a href="<?php echo esc_attr($link_social_3); ?>">
                    <i class="<?php echo esc_attr($icon_social_3); ?>"></i>
                </a>
            </li>
            <?php } ?>
            <?php if(isset($link_social_4) && $link_social_4 != ''){?> 
            <li>
                <a href="<?php echo esc_attr($link_social_4); ?>">
                    <i class="<?php echo esc_attr($icon_social_4); ?>"></i>
                </a>
            </li>
            <?php } ?>
            <?php if(isset($link_social_5) && $link_social_5 != ''){?> 
            <li>
                <a href="<?php echo esc_attr($link_social_5); ?>">
                    <i class="<?php echo esc_attr($icon_social_5); ?>"></i>
                </a>
            </li>
            <?php } ?>
          </ul>
        </div>
        <?php echo wp_specialchars_decode(esc_attr($after_widget)); ?>
    <?php
        // Reset the global $the_post as this query will have stomped on it
        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('sanbi_widget_footer_about', $cache, 'widget');
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['about_description'] = strip_tags($new_instance['about_description']);
        $instance['link_social_1'] = strip_tags($new_instance['link_social_1']);
        $instance['icon_social_1'] = strip_tags($new_instance['icon_social_1']);
        $instance['link_social_2'] = strip_tags($new_instance['link_social_2']);
        $instance['icon_social_2'] = strip_tags($new_instance['icon_social_2']);
        $instance['link_social_3'] = strip_tags($new_instance['link_social_3']);
        $instance['icon_social_3'] = strip_tags($new_instance['icon_social_3']);
        $instance['link_social_4'] = strip_tags($new_instance['link_social_4']);
        $instance['icon_social_4'] = strip_tags($new_instance['icon_social_4']);
        $instance['link_social_5'] = strip_tags($new_instance['link_social_5']);
        $instance['icon_social_5'] = strip_tags($new_instance['icon_social_5']);

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset($alloptions['widget_footer_about']) )
            delete_option('widget_footer_about');
        return $instance;
    }

    function form( $instance ) {      
        $about_description     = isset( $instance['about_description'] ) ? esc_attr( $instance['about_description'] ) : '';
        $link_social_1     = isset( $instance['link_social_1'] ) ? esc_attr( $instance['link_social_1'] ) : '';
        $icon_social_1     = isset( $instance['icon_social_1'] ) ? esc_attr( $instance['icon_social_1'] ) : '';
        $link_social_2     = isset( $instance['link_social_2'] ) ? esc_attr( $instance['link_social_2'] ) : '';
        $icon_social_2     = isset( $instance['icon_social_2'] ) ? esc_attr( $instance['icon_social_2'] ) : '';
        $link_social_3     = isset( $instance['link_social_3'] ) ? esc_attr( $instance['link_social_3'] ) : '';
        $icon_social_3     = isset( $instance['icon_social_3'] ) ? esc_attr( $instance['icon_social_3'] ) : '';
        $link_social_4     = isset( $instance['link_social_4'] ) ? esc_attr( $instance['link_social_4'] ) : '';
        $icon_social_4     = isset( $instance['icon_social_4'] ) ? esc_attr( $instance['icon_social_4'] ) : '';
        $link_social_5     = isset( $instance['link_social_5'] ) ? esc_attr( $instance['link_social_5'] ) : '';
        $icon_social_5     = isset( $instance['icon_social_5'] ) ? esc_attr( $instance['icon_social_5'] ) : '';


?>
    <p><label for="<?php echo esc_attr($this->get_field_id( 'about_description' )); ?>"><?php esc_html_e( 'Description:', 'sanbi' ); ?></label>
    <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id( 'about_description' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'about_description' )); ?>" type="textarea"><?php echo esc_attr($about_description);?></textarea></p>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'link_social_1' )); ?>"><?php esc_html_e( 'Link 1:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link_social_1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_social_1' )); ?>" type="text" value="<?php echo esc_attr($link_social_1);?>"/></p>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'icon_social_1' )); ?>"><?php esc_html_e( 'Icon Social 1:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'icon_social_1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'icon_social_1' )); ?>" type="text" value="<?php echo esc_attr($icon_social_1); ?>"/></p>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'link_social_2' )); ?>"><?php esc_html_e( 'Link 2:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link_social_2' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_social_2' )); ?>" type="text" value="<?php echo esc_attr($link_social_2); ?>"/></p>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'icon_social_2' )); ?>"><?php esc_html_e( 'Icon Social 2:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'icon_social_2' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'icon_social_2' )); ?>" type="text" value="<?php echo esc_attr($icon_social_2); ?>" /></p>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'link_social_3' )); ?>"><?php esc_html_e( 'Link 3:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link_social_3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_social_3' )); ?>" type="text" value="<?php echo esc_attr($link_social_3); ?>" /></p>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'icon_social_3' )); ?>"><?php esc_html_e( 'Icon Social 3:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'icon_social_3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'icon_social_3' )); ?>" type="text" value="<?php echo esc_attr($icon_social_3); ?>" /></p>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'link_social_4' )); ?>"><?php esc_html_e( 'Link 4:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link_social_4' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_social_4' )); ?>" type="text" value="<?php echo esc_attr($link_social_4);?>" /></p>
    <p><label for="<?php echo esc_attr($this->get_field_id( 'icon_social_4' )); ?>"><?php esc_html_e( 'Icon Social 4:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'icon_social_4' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'icon_social_4' )); ?>" type="text" value="<?php echo esc_attr($icon_social_4); ?>" /></p>

    <p><label for="<?php echo esc_attr($this->get_field_id( 'link_social_5' )); ?>"><?php esc_html_e( 'Link 5:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'link_social_5' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'link_social_5' )); ?>" type="text" value="<?php echo esc_attr($link_social_5);?>" /></p>
    <p><label for="<?php echo esc_attr($this->get_field_id( 'icon_social_5' )); ?>"><?php esc_html_e( 'Icon Social 5:', 'sanbi' ); ?></label>
    <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'icon_social_5' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'icon_social_5' )); ?>" type="text" value="<?php echo esc_attr($icon_social_5); ?>" /></p>
<?php
    }
}
function sanbi_register_custom_widget_footer_about() {
    register_widget( 'sanbi_widget_footer_about' );
}
add_action( 'widgets_init', 'sanbi_register_custom_widget_footer_about' );