<?php
/**
 * The template for displaying 404 pages (Not Found)
 */
$sanbi_redux_demo = get_option('redux_demo');
get_header(); ?> 
<section class="sanbi_tm_section page-banner error-page text-center">
    <div class="sanbi_tm_news">
        <div class="news_inner">
            <div class="container">
                <div class="sanbi_tm_main_title blog-title">
                    <div class="title">
                        <h1><?php if(isset($sanbi_redux_demo['404_title'])){?>
                        <?php echo htmlspecialchars_decode(esc_attr($sanbi_redux_demo['404_title']));?>
                        <?php }else{?>
                        <?php echo esc_html__( '404', 'sanbi' ); } ?></h1>
                    </div>
                </div>
                <div class="full-detail-content error-desc">
                    <h5><?php if(isset($sanbi_redux_demo['404_desc'])){?>
                    <?php echo htmlspecialchars_decode(esc_attr($sanbi_redux_demo['404_desc']));?>
                    <?php }else{?>
                    <?php echo esc_html__( 'OOPPS! THE PAGE YOU WERE LOOKING FOR, COULD NOT BE FOUND.', 'sanbi' ); } ?></h5>
                </div>
                <div class="content">
                    <div class="breadcrumbs">
                        <a class="site-button anchor-button secondary button-sm" href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($redux_demo['404_button'])){?>
                        <?php echo htmlspecialchars_decode($redux_demo['404_button']);?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Back To Home', 'sanbi' ); } ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php get_footer(); ?>