<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsPricing extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-pricing';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Pricing', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Pricing widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-price-table';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Pricing widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'pricing' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Pricing', 'bdevs-elementor' ),
			]	
		);
		$this->add_control(
            'subheading',
            [
                'label'       => __( 'Subheading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subheading', 'bdevs-elementor' ),
                'default'     => __( 'CHOOSE AS YOUR NEED', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'Really Simple Pricing', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your description', 'bdevs-elementor' ),
                'default'     => __( 'No hidden fees, no limits', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Plans', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
                        'name'        => 'choose_style',
                        'label'     => esc_html__( 'Choose Style:', 'bdevs-elementor' ),
                        'type'      => Controls_Manager::SELECT,
                        'dynamic' => [ 'active' => true ],
                        'options'   => [
                        '1'  => esc_html__( 'Style 1', 'bdevs-elementor' ),
                        '2'  => esc_html__( 'Style 2', 'bdevs-elementor' ),
                        ],
                        'default'   => '1',
                    ],
                    [
                        'name'        => 'title',
                        'label'       => esc_html__( 'Title:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Basic' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'content',
                        'label'       => esc_html__( 'Content:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Small Business who are just starting on their marketing.' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'price',
                        'label'       => esc_html__( 'Price:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '$30.00' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'schedule',
                        'label'       => esc_html__( 'Schedule:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '/month' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    
                    [
                        'name'        => 'link_button',
                        'label'       => esc_html__( 'Link Button:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '#' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'button',
                        'label'       => esc_html__( 'Button:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Try free for 30 days' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'text',
                        'label'       => esc_html__( 'Text:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'No credit card required' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
				],
			]
		);
		$this->end_controls_section();
		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);	
         $this->add_control(
            'show_subheading',
            [
                'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);?>
		<section class="pricing-plan sp-tb" id="pricing">
	        <div class="container">
	          	<div class="row">
	            	<div class="col-md-8 mx-auto text-center mb-5">
	              	<!-- Section Heading -->
		              <?php if ( $settings['show_subheading'] ) : ?>
                        <div class="sub-heading">
                            <p><?php print wp_kses_post($settings['subheading']); ?></p>
                        </div>
                        <?php endif; ?>
                        <?php if ( $settings['show_heading'] ) : ?>
                        <div class="heading-title">
                            <h2><?php print wp_kses_post($settings['heading']); ?></h2>
                        </div>
                        <?php endif; ?>
                         <?php if(isset($settings['description']) && $settings['description'] != ''){?>
                        <div class="heading-description">
                            <p><?php print wp_kses_post($settings['description']); ?></p>
                        </div>
                        <?php } ?>
	              	<!-- Section Heading -->
	            	</div>
	          	</div>
	          	<div class="row">
	          		<?php 
                    foreach ( $settings['tabs'] as $item ) : 
                    ?>
                    <?php if( wp_kses_post($item['choose_style']) == '1'): ?>
		            <div class="col-lg-4 mb-lg-0 mb-4">
		              	<!-- Pricing Box -->
		              	<div class="pricing-plan-single p-5">
			                <div class="plan-heading mb-5">
			                  	<h3><?php print wp_kses_post($item['title']); ?></h3>
			                  	<p><?php print wp_kses_post($item['content']); ?></p>
			                </div>
			                <div class="plan-cost mb-5">
			                  <span class="price"><?php print wp_kses_post($item['price']); ?></span>
			                  <span class="schedule"><?php print wp_kses_post($item['schedule']); ?></span>
			                </div>
			                <div class="plan-action">
			                	<?php if(isset($item['link_button']) && $item['link_button'] != ''){?>
			                  	<div class="mb-4">
			                    	<a href="<?php print wp_kses_post($item['link_button']); ?>" class="anchor-button primary button-lg"><?php print wp_kses_post($item['button']); ?></a>
			                  	</div>
			                  	<?php } ?>
			                  	<div class="text-center"><?php print wp_kses_post($item['text']); ?></div>
			                </div>
		              	</div>
		              	<!-- Pricing Box -->
		            </div>
		            <?php elseif( wp_kses_post($item['choose_style']) == '2'): ?>
		            <div class="col-lg-4 mb-lg-0 mb-4">
		              <!-- Pricing Box -->
		              <div class="pricing-plan-single plan-professional p-5">
		                <div class="plan-heading mb-5">
			                <h3><?php print wp_kses_post($item['title']); ?></h3>
			                <p><?php print wp_kses_post($item['content']); ?></p>
		                </div>
		                <div class="plan-cost mb-5">
		                  	<span class="price"><?php print wp_kses_post($item['price']); ?></span>
			                <span class="schedule"><?php print wp_kses_post($item['schedule']); ?></span>
		                </div>
		                <div class="plan-action">
		                  	<?php if(isset($item['link_button']) && $item['link_button'] != ''){?>
		                  	<div class="mb-4">
		                    	<a href="<?php print wp_kses_post($item['link_button']); ?>" class="anchor-button secondary button-lg"><?php print wp_kses_post($item['button']); ?></a>
		                  	</div>
		                  	<?php } ?>
		                  	<div class="text-center"><?php print wp_kses_post($item['text']); ?></div>
		                </div>
		              </div>
		              <!-- Pricing Box -->
		            </div>
	            	<?php endif; ?>
                 	<?php endforeach; ?>
	         	</div>
	        </div>
	     </section>
	<?php
	}

}