<?php $__env->startSection('title', 'Patient Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<style>
.fl-wrapper[data-position^=top-] {
    top: 5em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Page Header -->
        <div class="mb-3 border-bottom pb-3">
            <h4 class="fw-bold mb-0">Clinic Details : About <?php echo e($clinic->name); ?></h4>
        </div>
        <!-- End Page Header -->

        <!-- Hospital Detail Page -->
        <div class="container my-4">

            <!-- Hospital Image -->
            <div class="card mb-3 shadow-sm border-0">
                <img src="<?php echo e(asset('assets/img/hospital.png')); ?>" class="card-img-top" alt="Hospital Image" style="border-radius: 10px; height: 200px; object-fit: cover;">
                <!-- <img src="<?php echo e($clinic->image ? url('storage/'.$clinic->image) : asset('assets/img/hospital.png')); ?>" class="me-3 rounded" width="120" height="120" alt="Clinic Image"> -->
            </div>

            <!-- Hospital Info -->
            <div class="card shadow-sm border-0 p-3 mb-4">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <h4 class="fw-bold mb-1"><i class="ti ti-building-hospital me-1"></i> <?php echo e($clinic->name); ?></h4>
                        <p class="text-muted mb-2"><i class="ti ti-map-pin me-1 text-primary"></i>  
                            <?php echo e($clinic->line1); ?>, <?php echo e($clinic->line2); ?>, 
                            <?php echo e($clinic->city); ?>, <?php echo e($clinic->state); ?>, 
                            <?php echo e($clinic->country); ?> - <?php echo e($clinic->pincode); ?>

                        </p>
                    </div>
                    <div class="text-end">
                        <span class="fw-bold fs-16 text-warning"><?php echo e($rating); ?> ★</span>
                    </div>
                </div>

                <!-- Specialties -->
                <div class="mt-3">
                    <h6 class="fw-semibold mb-2">Specialties</h6>
                    <div>
                        <?php $__empty_1 = true; $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speciality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <span class="badge bg-light text-dark border rounded-pill px-3 py-2 me-2">
                                <?php echo e(trim($speciality)); ?>

                            </span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <span class="text-muted">N/A</span>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Details -->
                <div class="mt-4">
                    <h6 class="fw-semibold mb-2">Details</h6>
                    <p class="text-muted mb-0" style="line-height: 1.6;">
                        <?php echo e($clinic->about ?? 'No details available.'); ?>

                    </p>
                </div>
            </div>

            <!-- Doctors Section -->
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0">Our Doctors</h5>
                <!-- <a href="#" class="text-primary small fw-medium">View All</a> -->
            </div>

            <?php $__empty_1 = true; $__currentLoopData = $clinic->doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <a href="<?php echo e(route('patient.doctor.doctorDetail', ['id' => $doctor['id']])); ?>" class="text-decoration-none text-dark">
                    <div class="card shadow-sm border-0 mb-3">
                        <div class="card-body d-flex align-items-center">
                            
                            <img src="<?php echo e($doctor->profileImage); ?>" alt="Doctor" class="rounded-circle me-3" style="width:50px; height:50px; object-fit:cover;">
                            <!-- <img 
                                src="<?php echo e($doctor->profile_image ? asset('uploads/doctor/' . $doctor->profile_image) : asset('assets/img/icons/sidebar-icon.svg')); ?>" 
                                alt="Doctor" 
                                class="rounded-circle me-3" 
                                style="width: 50px; height: 50px;"
                            > -->

                            <div class="flex-fill">
                                <h6 class="mb-1 fw-semibold"><?php echo e($doctor->name); ?></h6>
                                <p class="mb-1"><i class="ti ti-mail"></i> <?php echo e($doctor->email); ?></p>
                                <p class="mb-1"><i class="ti ti-phone"></i> <?php echo e($doctor->phone_number ?? 'N/A'); ?></p>
                                
                                
                                <p class="mb-0 text-muted small">
                                    <i class="ti ti-stethoscope"></i>
                                    <?php echo e($doctor->specializations); ?>

                                    <?php if(!empty($doctor['specializations'])): ?>
                                        <?php $__currentLoopData = $doctor['specializations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e($spec); ?><?php if(!$loop->last): ?>, <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        ---
                                    <?php endif; ?>
                                </p>
                            </div>
                            <i class="ti ti-chevron-right text-muted"></i>
                        </div>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-muted">No doctors assigned to this clinic yet.</p>
            <?php endif; ?>

        </div>
    </div>
    <!-- End Content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/patient/doctor/clinic-detail.blade.php ENDPATH**/ ?>