<div class="content" id="profilePage">
    <!-- Page Header -->
    <div class="mb-3 border-bottom pb-3">
        <h4 class="fw-bold mb-0">Patient Profile</h4>
    </div>
    <!-- End Page Header -->

    <div class="card">
        <div class="card-body p-0">
            <div class="settings-wrapper d-flex">

                <!-- Start Settings Sidebar -->
                <div class="sidebars settings-sidebar" id="sidebar2">
                    <div class="sidebar-inner" data-simplebar>
                        <div id="sidebar-menu5" class="sidebar-menu mt-0 p-0">
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);" class="active">
                                        <i class="ti ti-user-cog me-2"></i><span>Profile Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);" class="active">Basic Information</a></li>
                                        <li><a href="javascript:void(0);">Address Information</a></li>
                                        <li><a href="javascript:void(0);">Medical Information</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- End Settings Sidebar -->

                <div class="card flex-fill mb-0 border-0 bg-light-500 shadow-none">
                    <div class="card-header border-bottom px-0 mx-3">
                        <h5 class="fw-bold">Basic Information</h5>
                    </div>
                    <div class="card-body px-0 mx-3">
                        <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('success')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <?php if(session()->has('error')): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <form wire:submit.prevent="save">
                            <!-- start row -->
                            <div class="row border-bottom mb-3">
                                <div class="col-lg-12">
                                    <!-- Profile Image Section -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-2">
                                            <label class="form-label mb-0">Profile Image<span
                                                    class="text-danger ms-1">*</span></label>
                                        </div>
                                        <div class="col-lg-10">
                                            <div class="position-relative d-inline-block">
                                                <!--[if BLOCK]><![endif]--><?php if($new_profile_image): ?>
                                                    <!-- When new image is selected (preview) -->
                                                    <div class="position-relative">
                                                        <img src="<?php echo e($new_profile_image->temporaryUrl()); ?>"
                                                            alt="Profile" class="rounded-circle"
                                                            style="width: 80px; height: 80px; object-fit: cover;">
                                                        <button wire:click.prevent="removeProfileImage" type="button"
                                                            class="btn btn-danger btn-icon btn-xs position-absolute rounded-circle"
                                                            style="top: -5px; right: -5px; width: 20px; height: 20px; padding: 0; border: 2px solid white;">
                                                            <i class="ti ti-x" style="font-size: 10px;"></i>
                                                        </button>
                                                    </div>
                                                <?php elseif($profile_image): ?>
                                                    <!-- When existing image is present -->
                                                    <div class="position-relative">
                                                        <img src="<?php echo e($this->getProfileImageUrl()); ?>" alt="Profile"
                                                            class="rounded-circle"
                                                            style="width: 80px; height: 80px; object-fit: cover;">
                                                        <button wire:click.prevent="removeProfileImage" type="button"
                                                            class="btn btn-danger btn-icon btn-xs position-absolute rounded-circle"
                                                            style="top: -5px; right: -5px; width: 20px; height: 20px; padding: 0; border: 2px solid white;">
                                                            <i class="ti ti-x" style="font-size: 10px;"></i>
                                                        </button>
                                                    </div>
                                                <?php else: ?>
                                                    <!-- When no image - show initial letter avatar -->
                                                    <div class="position-relative">
                                                        <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center"
                                                            style="width: 80px; height: 80px; font-size: 32px; font-weight: bold;">
                                                            <?php echo e(strtoupper(substr($name ?: 'U', 0, 1))); ?>

                                                        </div>
                                                        <a href="javascript:void(0);"
                                                            class="position-absolute bottom-0 end-0 bg-dark rounded-circle p-1"
                                                            onclick="document.getElementById('profileUpload').click();">
                                                            <i class="ti ti-camera text-white"
                                                                style="font-size: 12px;"></i>
                                                        </a>
                                                    </div>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>

                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['new_profile_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger d-block mt-1"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->

                                            <!--[if BLOCK]><![endif]--><?php if($new_profile_image || $profile_image): ?>
                                                <div class="mt-2">
                                                    <button type="button" class="btn btn-outline-primary btn-sm"
                                                        onclick="document.getElementById('profileUpload').click();">
                                                        Change Image
                                                    </button>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                            <input type="file" wire:model="new_profile_image" id="profileUpload"
                                                style="display: none;" accept="image/*">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- Full Name -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">Full Name<span
                                                    class="text-danger ms-1">*</span></label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="name" type="text" class="form-control"
                                                placeholder="Enter your full name">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- Email -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">Email<span
                                                    class="text-danger ms-1">*</span></label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="email" type="email" class="form-control"
                                                placeholder="Enter your email">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- Phone Number -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">Phone Number<span
                                                    class="text-danger ms-1">*</span></label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="phone_number" type="text" class="form-control"
                                                placeholder="Enter phone number">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- Alternate Phone -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">Alternate Phone</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="phone" type="text" class="form-control"
                                                placeholder="Enter alternate phone">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end row -->

                            <!-- Additional Information Section -->
                            <div class="row border-bottom mb-3">
                                <div class="mb-3" id="Additional-info">
                                    <h5 class="fw-bold mb-0">Additional Information</h5>
                                </div>

                                <div class="col-lg-6">
                                    <!-- Gender -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">Gender</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <select wire:model="gender" class="form-select">
                                                <option value="">Select Gender</option>
                                                <option value="male">Male</option>
                                                <option value="female">Female</option>
                                                <option value="other">Other</option>
                                            </select>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="date_of_birth" class="form-label mb-1 fw-medium">Date Of
                                            Birth</label>
                                        <div class="input-icon-end position-relative">
                                            <input wire:ignore id="date_of_birth" type="text"
                                                class="form-control datetimepicker" placeholder="dd/mm/yyyy">
                                            <span class="input-icon-addon">
                                                <i class="ti ti-calendar"></i>
                                            </span>
                                        </div>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- Street Address -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">Street Address</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="street_address" type="text" class="form-control"
                                                placeholder="Enter street address">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['street_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- City -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">City</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="city" type="text" class="form-control"
                                                placeholder="Enter city">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- State -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">State</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="state" type="text" class="form-control"
                                                placeholder="Enter state">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- Postal Code -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">Postal Code</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="postal_code" type="text" class="form-control"
                                                placeholder="Enter postal code">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['postal_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <!-- Country -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-4">
                                            <label class="form-label mb-0">Country</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input wire:model="country" type="text" class="form-control"
                                                placeholder="Enter country">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <!-- Address -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-2">
                                            <label class="form-label mb-0">Address</label>
                                        </div>
                                        <div class="col-lg-10">
                                            <textarea wire:model="address" class="form-control" rows="3" placeholder="Enter complete address"></textarea>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end row -->

                            <!-- Medical Information Section -->
                            <div class="row mb-3">
                                <div class="mb-3">
                                    <h5 class="fw-bold mb-0">Medical Information</h5>
                                </div>

                                <div class="col-lg-12">
                                    <!-- Medical History -->
                                    <div class="row align-items-center mb-3">
                                        <div class="col-lg-2">
                                            <label class="form-label mb-0">Medical History</label>
                                        </div>
                                        <div class="col-lg-10">
                                            <textarea wire:model="medical_history" class="form-control" rows="4"
                                                placeholder="Enter any relevant medical history, allergies, or ongoing treatments..."></textarea>
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['medical_history'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end row -->

                            <div class="d-flex align-items-center justify-content-end">
                                <a href="<?php echo e(route('patient.patient-dashboard')); ?>"
                                    class="btn btn-light me-3">Cancel</a>
                                <button wire:click="save" type="submit" class="btn btn-primary">Save
                                    Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div><!-- end card body -->
    </div><!-- end card -->
</div>
<?php /**PATH /var/www/predcare/resources/views/livewire/patient/profile/patient-profile.blade.php ENDPATH**/ ?>