<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="<?php echo e(route('admin.clinics.index')); ?>" class="text-dark">
                        <i
                            class="ti ti-chevron-left me-1"></i><?php echo e(isset($clinic) && $clinic->exists ? 'Edit Clinic' : 'Add New Clinic'); ?>

                    </a>
                </h6>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                                <div class="alert alert-primary alert-dismissible fade show" role="alert">
                                    <?php echo e(session('message')); ?>

                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- New Wizard Progress -->
                            <div id="progressbarwizard">
                                <ul class="nav nav-pills nav-justified form-wizard-header mb-3">
                                    <li class="nav-item">
                                        <button href="#step-1" data-bs-toggle="tab" data-toggle="tab"
                                            class="nav-link rounded-0 py-2 <?php echo e($step == 1 ? 'active' : ''); ?>"
                                            wire:click.prevent="navigateToStep(1)">
                                            <span class="d-none d-sm-inline">Clinic Details</span>
                                        </button>
                                    </li>
                                    <li class="nav-item">
                                        <button href="#step-2" data-bs-toggle="tab" data-toggle="tab"
                                            class="nav-link rounded-0 py-2 <?php echo e($step == 2 ? 'active' : ''); ?>"
                                            wire:click.prevent="navigateToStep(2)">
                                            <span class="d-none d-sm-inline">Select Owner</span>
                                        </button>
                                    </li>
                                    <li class="nav-item">
                                        <button href="#step-3" data-bs-toggle="tab" data-toggle="tab"
                                            class="nav-link rounded-0 py-2 <?php echo e($step == 3 ? 'active' : ''); ?>"
                                            wire:click.prevent="navigateToStep(3)" <?php if($this->clinic->exists()): echo 'disabled'; endif; ?>>
                                            <span class="d-none d-sm-inline">Review & Save</span>
                                        </button>
                                    </li>
                                </ul>

                                <div class="tab-content b-0 mb-0">
                                    <div id="bar" class="progress mb-3" style="height: 7px;">
                                        <div class="bar progress-bar progress-bar-striped progress-bar-animated bg-primary"
                                            style="width: <?php echo e((($step - 1) / 2) * 100); ?>%"></div>
                                    </div>

                                    <!-- Step Content -->
                                    <div class="tab-pane active">
                                        <!-- Step 1: Clinic Details -->
                                        <!--[if BLOCK]><![endif]--><?php if($step === 1): ?>
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label for="name" class="form-label">Clinic Name</label>
                                                    <input wire:model.blur="name" type="text" id="name"
                                                        class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Enter clinic name">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="email" class="form-label">Email</label>
                                                    <input wire:model.defer="email" type="email" id="email"
                                                        class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Enter clinic email">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <!-- Status -->
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label mb-1 fw-medium">Status<span
                                                                class="text-danger ms-1">*</span></label>
                                                        <select
                                                            class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                            wire:model="status">
                                                            <option value="active">Active</option>
                                                            <option value="inactive">Inactive</option>
                                                        </select>
                                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="text-danger"><?php echo e($message); ?></span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                </div>

                                                <div class="col-md-12">
                                                    <label for="about" class="form-label">About</label>
                                                    <textarea wire:model.defer="about" id="about" class="form-control <?php $__errorArgs = ['about'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="3" placeholder="About the clinic"></textarea>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['about'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="line1" class="form-label">Address Line 1</label>
                                                    <input wire:model.defer="line1" type="text" id="line1"
                                                        class="form-control <?php $__errorArgs = ['line1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Address line 1">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['line1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="line2" class="form-label">Address Line 2</label>
                                                    <input wire:model.defer="line2" type="text" id="line2"
                                                        class="form-control <?php $__errorArgs = ['line2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Address line 2">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['line2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-3">
                                                    <label for="city" class="form-label">City</label>
                                                    <input wire:model.defer="city" type="text" id="city"
                                                        class="form-control <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="City">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-3">
                                                    <label for="state" class="form-label">State</label>
                                                    <input wire:model.defer="state" type="text" id="state"
                                                        class="form-control <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="State">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-3">
                                                    <label for="country" class="form-label">Country</label>
                                                    <input wire:model.defer="country" type="text" id="country"
                                                        class="form-control <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Country">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-3">
                                                    <label for="pincode" class="form-label">Pin Code</label>
                                                    <input wire:model.defer="pincode" type="text" id="pincode"
                                                        class="form-control <?php $__errorArgs = ['pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Pin code">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-12">
                                                    <label class="form-label">Contact Numbers</label>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $contact_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="input-group mb-2">
                                                            <input type="text" class="form-control <?php $__errorArgs = ['contact_numbers.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                wire:model.defer="contact_numbers.<?php echo e($index); ?>"
                                                                placeholder="Contact number">
                                                            <button class="btn btn-outline-danger" type="button"
                                                                wire:click="removeContactNumber(<?php echo e($index); ?>)">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                    <button type="button" class="btn btn-sm btn-outline-primary"
                                                        wire:click="addContactNumber">
                                                        <i class="fa fa-plus"></i> Add Contact Number
                                                    </button>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['contact_numbers.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-12">
                                                    <label class="form-label">Specialities</label>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $speciality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="input-group mb-2">
                                                            <input type="text" class="form-control <?php $__errorArgs = ['specialities.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                wire:model.defer="specialities.<?php echo e($index); ?>"
                                                                placeholder="Speciality">
                                                            <button class="btn btn-outline-danger" type="button"
                                                                wire:click="removeSpeciality(<?php echo e($index); ?>)">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                    <button type="button" class="btn btn-sm btn-outline-primary"
                                                        wire:click="addSpeciality">
                                                        <i class="fa fa-plus"></i> Add Speciality
                                                    </button>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['specialities.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-6">
                                                    <label class="form-label">Subscription Plan (Optional)</label>
                                                    <div class="input-group">
                                                        <select wire:model.live="selected_plan_id"
                                                            class="form-select <?php $__errorArgs = ['selected_plan_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                                            <option value="">-- No Plan Selected --</option>
                                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availablePlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($plan->id); ?>">
                                                                    <?php echo e($plan->plan_name); ?>

                                                                    (<?php echo e($plan->base_price); ?>/<?php echo e($plan->plan_type); ?>)
                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        </select>
                                                        <!--[if BLOCK]><![endif]--><?php if($selected_plan_id): ?>
                                                            <button wire:click="$set('selected_plan_id', null)"
                                                                class="btn btn-outline-danger" type="button">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                    <!--[if BLOCK]><![endif]--><?php if($selected_plan_id && $selectedPlanDetails): ?>
                                                        <div class="mt-2 small text-muted">
                                                            Selected: <?php echo e($selectedPlanDetails->plan_name); ?>

                                                            (<?php echo e($selectedPlanDetails->plan_type); ?>)
                                                        </div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label">Clinic Add On (Optional)</label>
                                                    <div class="dropdown <?php $__errorArgs = ['selected_add_on_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                                        <!-- Dynamic dropdown button title -->
                                                        <button class="form-select text-start dropdown-toggle"
                                                            type="button" id="addOnDropdown"
                                                            data-bs-toggle="dropdown" aria-expanded="false"
                                                            <?php if(empty($selected_plan_id)): echo 'disabled'; endif; ?>>
                                                            <!--[if BLOCK]><![endif]--><?php if(count($selected_add_on_id) > 0): ?>
                                                                <?php echo e(count($selected_add_on_id)); ?>

                                                                <?php echo e(count($selected_add_on_id) == 1 ? 'Add On' : 'Add Ons'); ?>

                                                                Selected
                                                            <?php else: ?>
                                                                -- Select Add Ons --
                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                        </button>

                                                        <!-- Checkbox options -->
                                                        <ul class="dropdown-menu w-100"
                                                            aria-labelledby="addOnDropdown">
                                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableAddOns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addOn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li>
                                                                    <div class="dropdown-item">
                                                                        <input type="checkbox"
                                                                            wire:model="selected_add_on_id"
                                                                            value="<?php echo e($addOn->id); ?>"
                                                                            id="addon-<?php echo e($addOn->id); ?>"
                                                                            wire:change="updateSelectedCount">
                                                                        <label for="addon-<?php echo e($addOn->id); ?>"
                                                                            class="ms-2">
                                                                            <?php echo e($addOn->name); ?>

                                                                            (<?php echo e($addOn->price_per_unit); ?>/<?php echo e($addOn->resource_type); ?>)
                                                                        </label>
                                                                    </div>
                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        </ul>
                                                    </div>

                                                    <!-- Selected items details -->
                                                    <!--[if BLOCK]><![endif]--><?php if(count($selected_add_on_id) > 0): ?>
                                                        <div class="mt-2 small text-muted">
                                                            <strong>Selected:</strong>
                                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableAddOns->whereIn('id', $selected_add_on_id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selected): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <span class="d-block">
                                                                    <?php echo e($selected->name); ?>

                                                                    (<?php echo e($selected->resource_type); ?>)
                                                                </span>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        </div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                                <div class="col-12">
                                                    <button wire:click="nextStep" class="btn btn-primary float-end">
                                                        Next: Select Owner
                                                    </button>
                                                </div>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <!-- Step 2: Select Owner -->
                                        <!--[if BLOCK]><![endif]--><?php if($step === 2 && !$showDoctorForm): ?>
                                            <div class="row g-3">
                                                <div class="col-md-12">
                                                    <h5>Select Clinic Owner</h5>
                                                    <p>Choose an existing doctor or
                                                        <?php echo e($clinic->exists && $clinic->owner ? 'edit' : 'create'); ?> a
                                                        new one to be
                                                        the
                                                        owner of this clinic.</p>
                                                </div>

                                                <!--[if BLOCK]><![endif]--><?php if(!$clinic->exists || !$clinic->owner): ?>
                                                    <div class="col-md-6">
                                                        <label for="owner_id" class="form-label">Select Existing
                                                            Doctor</label>
                                                        <select wire:model.defer="owner_id" id="owner_id"
                                                            class="form-select <?php $__errorArgs = ['owner_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                                            <option value="">Select Owner</option>
                                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $owners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($owner->id); ?>">
                                                                    <?php echo e($owner->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        </select>
                                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['owner_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                            <span class="text-danger"><?php echo e($message); ?></span>
                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>

                                                    <div class="col-md-12 text-center my-4">
                                                        <p class="text-muted">- OR -</p>
                                                    </div>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                <div class="col-md-12">
                                                    <h5><?php echo e($clinic->exists && $clinic->owner ? 'Edit' : 'Create New'); ?>

                                                        Doctor/Owner
                                                    </h5>
                                                    <button wire:click="showNewDoctorForm" type="button"
                                                        class="btn btn-outline-primary">
                                                        <i class="fa fa-plus"></i>
                                                        <?php echo e($clinic->exists && $clinic->owner ? 'Edit Owner Details' : 'Create New Doctor/Owner'); ?>

                                                    </button>
                                                </div>

                                                <div class="col-12 d-flex justify-content-between">
                                                    <button wire:click="previousStep" type="button"
                                                        class="btn btn-secondary">
                                                        Back
                                                    </button>
                                                    <button wire:click="nextStep" type="button"
                                                        class="btn btn-primary">
                                                        Next: Review
                                                    </button>
                                                </div>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <!-- New Doctor Form -->
                                        <!--[if BLOCK]><![endif]--><?php if($showDoctorForm): ?>
                                            <div class="row g-3">
                                                <div class="col-md-12">
                                                    <h5><?php echo e($editingDoctor ? 'Edit' : 'Create New'); ?> Doctor/Owner</h5>
                                                    <p>Fill in the details for the
                                                        <?php echo e($editingDoctor ? 'existing' : 'new'); ?> doctor
                                                        who
                                                        will
                                                        own this clinic.</p>
                                                </div>

                                                <!-- Add a hidden field to track if we're editing -->
                                                <input type="hidden" wire:model="editingDoctor">

                                                <div class="col-md-6">
                                                    <label for="doctor_name" class="form-label">Doctor Name</label>
                                                    <input wire:model="newDoctorData.name" type="text"
                                                        id="doctor_name" class="form-control <?php $__errorArgs = ['newDoctorData.name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Doctor's full name">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newDoctorData.name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="doctor_email" class="form-label">Email</label>
                                                    <input wire:model="newDoctorData.email" type="email"
                                                        id="doctor_email" class="form-control <?php $__errorArgs = ['newDoctorData.email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Doctor's email"
                                                        <?php echo e($editingDoctor ? 'readonly' : ''); ?>>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newDoctorData.email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="doctor_password" class="form-label">Password</label>
                                                    <input wire:model="newDoctorData.password" type="password"
                                                        id="doctor_password" class="form-control <?php $__errorArgs = ['newDoctorData.password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Leave blank to keep current password">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newDoctorData.password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="doctor_password_confirmation"
                                                        class="form-label">Confirm
                                                        Password</label>
                                                    <input wire:model="newDoctorData.password_confirmation"
                                                        type="password" id="doctor_password_confirmation"
                                                        class="form-control <?php $__errorArgs = ['newDoctorData.password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Confirm password">
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="specialization"
                                                        class="form-label">Specialization</label>
                                                    <input wire:model="newDoctorData.specialization" type="text"
                                                        id="specialization" class="form-control <?php $__errorArgs = ['newDoctorData.specialization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Specialization">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newDoctorData.specialization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-md-6">
                                                    <label for="license_number" class="form-label">License
                                                        Number</label>
                                                    <input wire:model="newDoctorData.license_number" type="text"
                                                        id="license_number" class="form-control <?php $__errorArgs = ['newDoctorData.license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="License number"
                                                        <?php echo e($editingDoctor ? 'readonly' : ''); ?>>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['newDoctorData.license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <div class="col-12 d-flex justify-content-between">
                                                    <!-- <button wire:click="showNewDoctorForm = false" type="button"
                                                        class="btn btn-secondary">
                                                        Back to Owner Selection
                                                    </button> -->
                                                    <button wire:click="previousStep" type="button"
                                                        class="btn btn-secondary">
                                                        <i class="fas fa-arrow-left me-2"></i>Back to Owner Selection
                                                    </button>
                                                    <button wire:click="nextStep" type="button"
                                                        class="btn btn-primary">
                                                        Next: Review
                                                    </button>
                                                </div>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <!-- Step 3: Review & Save -->
                                        <!--[if BLOCK]><![endif]--><?php if($step === 3): ?>
                                            <div class="review-section">
                                                <div class="row g-4">
                                                    <div class="col-12">
                                                        <div class="card review-card">
                                                            <div class="card-header bg-transparent">
                                                                <h5 class="mb-0"><i
                                                                        class="fas fa-hospital me-2"></i>Clinic
                                                                    Overview
                                                                </h5>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row">
                                                                    <div class="col-md-6 border-end pe-md-4">
                                                                        <div class="clinic-meta">
                                                                            <h3 class="clinic-name mb-3">
                                                                                <?php echo e($name); ?></h3>
                                                                            <div class="status-badge mb-3">
                                                                                <span
                                                                                    class="badge rounded-pill bg-<?php echo e($status == 'active' ? 'success' : 'danger'); ?>">
                                                                                    <?php echo e(ucfirst($status)); ?> Clinic
                                                                                </span>
                                                                            </div>
                                                                            <ul class="clinic-details list-unstyled">
                                                                                <li class="mb-2">
                                                                                    <i
                                                                                        class="fas fa-envelope fa-fw text-muted me-2"></i>
                                                                                    <a href="mailto:<?php echo e($email); ?>"
                                                                                        class="text-decoration-none"><?php echo e($email); ?></a>
                                                                                </li>
                                                                                <li class="mb-2">
                                                                                    <i
                                                                                        class="fas fa-map-marker-alt fa-fw text-muted me-2"></i>
                                                                                    <?php echo e($city); ?>,
                                                                                    <?php echo e($state); ?>,
                                                                                    <?php echo e($country); ?>

                                                                                </li>
                                                                                <li>
                                                                                    <i
                                                                                        class="fas fa-map-pin fa-fw text-muted me-2"></i>
                                                                                    <?php echo e($pincode); ?>

                                                                                </li>
                                                                            </ul>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Owner Details -->
                                                                    <div class="col-md-6 ps-md-4">
                                                                        <div class="owner-card">
                                                                            <h6 class="owner-title mb-3">
                                                                                <i
                                                                                    class="fas fa-user-shield me-2"></i>Clinic
                                                                                Owner
                                                                            </h6>
                                                                            <!--[if BLOCK]><![endif]--><?php if($tempDoctorData): ?>
                                                                                <div
                                                                                    class="new-owner alert alert-warning">
                                                                                    <div
                                                                                        class="d-flex align-items-center mb-2">
                                                                                        <i
                                                                                            class="fas fa-exclamation-circle me-2"></i>
                                                                                        <strong>New Doctor
                                                                                            Profile</strong>
                                                                                    </div>
                                                                                    <ul class="list-unstyled mb-0">
                                                                                        <li class="mb-2">
                                                                                            <i
                                                                                                class="fas fa-user-circle me-2"></i>
                                                                                            <?php echo e($tempDoctorData['name']); ?>

                                                                                        </li>
                                                                                        <li class="mb-2">
                                                                                            <i
                                                                                                class="fas fa-envelope me-2"></i>
                                                                                            <?php echo e($tempDoctorData['email']); ?>

                                                                                        </li>
                                                                                        <li class="mb-2">
                                                                                            <i
                                                                                                class="fas fa-stethoscope me-2"></i>
                                                                                            <?php echo e($tempDoctorData['specialization']); ?>

                                                                                        </li>
                                                                                        <li>
                                                                                            <i
                                                                                                class="fas fa-id-card me-2"></i>
                                                                                            <code><?php echo e($tempDoctorData['license_number']); ?></code>
                                                                                        </li>
                                                                                    </ul>
                                                                                </div>
                                                                            <?php elseif($selectedOwner): ?>
                                                                                <div
                                                                                    class="existing-owner alert alert-primary">
                                                                                    <div
                                                                                        class="d-flex align-items-center mb-2">
                                                                                        <i
                                                                                            class="fas fa-check-circle me-2"></i>
                                                                                        <strong>Existing Doctor</strong>
                                                                                    </div>
                                                                                    <div class="doctor-profile">
                                                                                        <h5 class="doctor-name mb-2">
                                                                                            <?php echo e($selectedOwner->name); ?>

                                                                                        </h5>
                                                                                        <div class="doctor-meta">
                                                                                            <div class="mb-2">
                                                                                                <i
                                                                                                    class="fas fa-envelope me-2"></i>
                                                                                                <?php echo e($selectedOwner->email); ?>

                                                                                            </div>
                                                                                            <div class="mb-2">
                                                                                                <i
                                                                                                    class="fas fa-phone me-2"></i>
                                                                                                <?php echo e($selectedOwner->doctorProfile->phone ?? 'N/A'); ?>

                                                                                            </div>
                                                                                            <div>
                                                                                                <i
                                                                                                    class="fas fa-certificate me-2"></i>
                                                                                                <?php echo e($selectedOwner->doctorProfile->license_number ?? 'N/A'); ?>

                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            <?php else: ?>
                                                                                <div
                                                                                    class="no-owner alert alert-secondary">
                                                                                    <i
                                                                                        class="fas fa-user-slash me-2"></i>
                                                                                    No owner assigned
                                                                                </div>
                                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Details Cards -->
                                                    <div class="col-lg-4">
                                                        <div class="card detail-card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0"><i
                                                                        class="fas fa-map-marked-alt me-2"></i>Address
                                                                    Details</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="address-details">
                                                                    <p class="mb-1"><?php echo e($line1); ?></p>
                                                                    <!--[if BLOCK]><![endif]--><?php if($line2): ?>
                                                                        <p class="mb-1"><?php echo e($line2); ?></p>
                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                    <div class="geo-meta text-muted small mt-2">
                                                                        <?php echo e($city); ?>, <?php echo e($state); ?>,
                                                                        <?php echo e($country); ?>

                                                                        - <?php echo e($pincode); ?>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4">
                                                        <div class="card detail-card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0"><i
                                                                        class="fas fa-phone-volume me-2"></i>Contact
                                                                    Information</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <!--[if BLOCK]><![endif]--><?php if(count($contact_numbers) > 0): ?>
                                                                    <ul class="contact-list list-unstyled mb-0">
                                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $contact_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li class="d-flex align-items-center mb-2">
                                                                                <i
                                                                                    class="fas fa-phone fa-sm me-2 text-muted"></i>
                                                                                <?php echo e($number); ?>

                                                                            </li>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                                    </ul>
                                                                <?php else: ?>
                                                                    <div class="text-muted">No contact numbers added
                                                                    </div>
                                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4">
                                                        <div class="card detail-card">
                                                            <div class="card-header">
                                                                <h6 class="mb-0"><i
                                                                        class="fas fa-star-of-life me-2"></i>Specialities
                                                                </h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <!--[if BLOCK]><![endif]--><?php if(count($specialities) > 0): ?>
                                                                    <div class="speciality-tags">
                                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speciality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <span
                                                                                class="badge bg-primary me-1 mb-1"><?php echo e($speciality); ?></span>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                                    </div>
                                                                <?php else: ?>
                                                                    <div class="text-muted">No specialities specified
                                                                    </div>
                                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!--[if BLOCK]><![endif]--><?php if($about): ?>
                                                        <div class="col-12">
                                                            <div class="card detail-card">
                                                                <div class="card-header">
                                                                    <h6 class="mb-0"><i
                                                                            class="fas fa-info-circle me-2"></i>About
                                                                        Clinic</h6>
                                                                </div>
                                                                <div class="card-body">
                                                                    <div class="clinic-about">
                                                                        <?php echo e($about); ?>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    <!-- Subscription Plan Card -->
                                                    <!--[if BLOCK]><![endif]--><?php if($showPlanSelection || $selectedPlanDetails): ?>
                                                        <div class="col-12">
                                                            <div class="card review-card">
                                                                <div class="card-header bg-transparent">
                                                                    <h5 class="mb-0"><i
                                                                            class="fas fa-credit-card me-2"></i>Subscription
                                                                        Plan
                                                                    </h5>
                                                                </div>
                                                                <div class="card-body">
                                                                    <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails): ?>
                                                                        <div class="alert alert-primary">
                                                                            <div
                                                                                class="d-flex justify-content-between align-items-center">
                                                                                <div>
                                                                                    <h6 class="mb-1">
                                                                                        <?php echo e($selectedPlanDetails->plan_name); ?>

                                                                                    </h6>
                                                                                    <div class="text-muted small">
                                                                                        <?php echo e(ucfirst($selectedPlanDetails->plan_type)); ?>

                                                                                        plan •
                                                                                        <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails->discounted_price): ?>
                                                                                            <span
                                                                                                class="text-danger ms-2">
                                                                                                <s>$<?php echo e(number_format($selectedPlanDetails->base_price, 2)); ?></s>
                                                                                                $<?php echo e(number_format($selectedPlanDetails->discounted_price, 2)); ?>

                                                                                            </span>
                                                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                                    </div>
                                                                                </div>
                                                                                <button
                                                                                    wire:click="togglePlanSelection"
                                                                                    class="btn btn-sm btn-outline-primary">
                                                                                    Change Plan
                                                                                </button>
                                                                            </div>

                                                                            <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails->description): ?>
                                                                                <div class="mt-3">
                                                                                    <p class="small mb-1">
                                                                                        <strong>Includes:</strong>
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanDetails->description); ?>

                                                                                    </p>
                                                                                </div>
                                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                                            <div class="mt-3 row">
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-user-md me-2"></i>
                                                                                        Doctors:</p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->included_doctors ?? 'Unlimited'); ?>

                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-users me-2"></i>
                                                                                        Staff:
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->included_staff ?? 'Unlimited'); ?>

                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-mobile-alt me-2"></i>
                                                                                        Devices:</p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanDetails->device_limit ?? 'Unlimited'); ?>

                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="mt-3 row">
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-database me-2"></i>
                                                                                        Storage:</p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->storage_limit_gb ?? 'Unlimited'); ?>

                                                                                        GB
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-video me-2"></i>
                                                                                        Teleconsultation:
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->teleconsultation_minutes ?? 'Unlimited'); ?>

                                                                                        Minutes
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-sms me-2"></i>
                                                                                        SMS:</p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->sms_limit ?? 'Unlimited'); ?>

                                                                                        Massages
                                                                                    </p>
                                                                                </div>
                                                                            </div>

                                                                            <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails->description): ?>
                                                                                <div class="mt-3">
                                                                                    <p class="small mb-1">
                                                                                        <strong>Remains:</strong>
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanDetails->description); ?>

                                                                                    </p>
                                                                                </div>
                                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                                            <div class="mt-3 row">
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-user-md me-2"></i>
                                                                                        Doctors:</p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->included_doctors - $usedLimits['doctors']); ?>

                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-users me-2"></i>
                                                                                        Staff:
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->included_staff - $usedLimits['staffs']); ?>

                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-mobile-alt me-2"></i>
                                                                                        Devices:</p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanDetails->device_limit ?? 'Unlimited'); ?>

                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="mt-3 row">
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-database me-2"></i>
                                                                                        Storage:</p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->storage_limit_gb - $usedLimits['storage_limit']); ?>

                                                                                        GB
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-video me-2"></i>
                                                                                        Teleconsultation:</p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->teleconsultation_minutes - $usedLimits['teleconsultation_limit']); ?>

                                                                                        Minutes
                                                                                    </p>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <p class="small mb-1"><i
                                                                                            class="fas fa-sms me-2"></i>
                                                                                        SMS:
                                                                                    </p>
                                                                                    <p class="small text-muted">
                                                                                        <?php echo e($selectedPlanLimits->sms_limit - $usedLimits['sms_limit']); ?>

                                                                                        Messages
                                                                                    </p>
                                                                                </div>
                                                                            </div>

                                                                        </div>
                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                                    <!--[if BLOCK]><![endif]--><?php if($showPlanSelection): ?>
                                                                        <div class="mt-4">
                                                                            <h6 class="mb-3">Select a Plan:</h6>
                                                                            <div class="row">
                                                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availablePlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <div class="col-md-4 mb-3">
                                                                                        <div class="card plan-card h-100 cursor-pointer <?php echo e($selected_plan_id == $plan->id ? 'border-primary' : ''); ?>"
                                                                                            wire:click="$set('selected_plan_id', <?php echo e($plan->id); ?>)">
                                                                                            <div class="card-body">
                                                                                                <h5 class="card-title">
                                                                                                    <?php echo e($plan->plan_name); ?>

                                                                                                </h5>
                                                                                                <h6 class="mb-3">
                                                                                                    $<?php echo e(number_format($plan->base_price, 2)); ?>

                                                                                                    <small
                                                                                                        class="text-muted">/<?php echo e($plan->plan_type); ?></small>
                                                                                                </h6>

                                                                                                <ul
                                                                                                    class="list-unstyled small">
                                                                                                    <li class="mb-2">
                                                                                                        <i
                                                                                                            class="fas fa-check-circle text-success me-2"></i>
                                                                                                        <?php echo e($plan->max_doctors ?? 'Unlimited'); ?>

                                                                                                        Doctors
                                                                                                    </li>
                                                                                                    <li class="mb-2">
                                                                                                        <i
                                                                                                            class="fas fa-check-circle text-success me-2"></i>
                                                                                                        <?php echo e($plan->max_staff ?? 'Unlimited'); ?>

                                                                                                        Staff
                                                                                                    </li>
                                                                                                    <li class="mb-2">
                                                                                                        <i
                                                                                                            class="fas fa-check-circle text-success me-2"></i>
                                                                                                        <?php echo e($plan->device_limit ?? 'Unlimited'); ?>

                                                                                                        Devices
                                                                                                    </li>
                                                                                                    <!--[if BLOCK]><![endif]--><?php if($plan->trial_period): ?>
                                                                                                        <li
                                                                                                            class="mb-2">
                                                                                                            <i
                                                                                                                class="fas fa-check-circle text-success me-2"></i>
                                                                                                            <?php echo e($plan->trial_period); ?>

                                                                                                            day trial
                                                                                                        </li>
                                                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                                                </ul>

                                                                                                <!--[if BLOCK]><![endif]--><?php if($plan->discounted_price): ?>
                                                                                                    <div
                                                                                                        class="badge bg-danger mb-2">
                                                                                                        Save
                                                                                                        <?php echo e(number_format(100 - ($plan->discounted_price / $plan->base_price) * 100, 0)); ?>%
                                                                                                    </div>
                                                                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                                            </div>

                                                                            <div
                                                                                class="d-flex justify-content-end mt-3">
                                                                                <button
                                                                                    wire:click="togglePlanSelection"
                                                                                    class="btn btn-secondary">
                                                                                    Cancel
                                                                                </button>
                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="text-center py-4">
                                                            <p class="text-muted mb-3">No subscription plan selected
                                                            </p>
                                                            <button wire:click="togglePlanSelection"
                                                                class="btn btn-primary">
                                                                <i class="fas fa-plus me-2"></i>Add Subscription Plan
                                                            </button>
                                                        </div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                    <!-- Add On Plan Card -->
                                                    <!--[if BLOCK]><![endif]--><?php if($showAddOnSelection || count($selectedAddOnDetails) > 0): ?>
                                                        <div class="col-12">
                                                            <div class="card review-card">
                                                                <div class="card-header bg-transparent">
                                                                    <div class="d-flex justify-content-between mt-3">
                                                                        <h5 class="mb-0"><i
                                                                                class="fas fa-credit-card me-2"></i>All
                                                                            Add On</h5>
                                                                        <!--[if BLOCK]><![endif]--><?php if(!$showAddOnSelection): ?>
                                                                            <button wire:click="toggleAddOnSelection"
                                                                                class="btn btn-sm btn-outline-primary">
                                                                                Change Add Ons
                                                                            </button>
                                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                    </div>
                                                                </div>
                                                                <div class="card-body">
                                                                    <!--[if BLOCK]><![endif]--><?php if($selectedAddOnDetails): ?>
                                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $selectedAddOnDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addOn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="alert alert-primary">
                                                                                <div
                                                                                    class="d-flex justify-content-between align-items-center">

                                                                                    <div>
                                                                                        <div>
                                                                                            <h6 class="mb-1">
                                                                                                <?php echo e($addOn->name); ?>

                                                                                            </h6>
                                                                                        </div>
                                                                                        <div>
                                                                                            <h6>Remaining:
                                                                                                <?php echo e('32'); ?>

                                                                                            </h6>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="text-muted small">
                                                                                        <?php echo e(ucfirst($addOn->resource_type)); ?>

                                                                                        Add On • Per
                                                                                        <?php echo e($addOn->unit); ?> Price
                                                                                        $<?php echo e(number_format($addOn->price_per_unit, 2)); ?>

                                                                                    </div>
                                                                                    <!--[if BLOCK]><![endif]--><?php if($addOn->price_per_unit): ?>
                                                                                        <div class="text-muted small">
                                                                                            Total amount •
                                                                                            <span
                                                                                                class="text-danger ms-2">
                                                                                                
                                                                                                $<?php echo e(number_format($addOn->price_per_unit * $addOn->unit_counts, 2)); ?>

                                                                                            </span>
                                                                                        </div>
                                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                                </div>

                                                                                <!--[if BLOCK]><![endif]--><?php if($addOn->description): ?>
                                                                                    <div class="mt-3">
                                                                                        <p class="small mb-1">
                                                                                            <strong>Includes:</strong>
                                                                                        </p>
                                                                                        <p class="small text-muted">
                                                                                            <?php echo e($addOn->description); ?>

                                                                                        </p>
                                                                                    </div>
                                                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                                    <!--[if BLOCK]><![endif]--><?php if($showAddOnSelection): ?>
                                                                        <div class="mt-4">
                                                                            <h6 class="mb-3">Select an Add On:</h6>
                                                                            <div class="col-md-6">
                                                                                <label class="form-label">Clinic Add On
                                                                                    (Optional)</label>
                                                                                <div class="dropdown">
                                                                                    <!-- Dynamic dropdown button title -->
                                                                                    <button
                                                                                        class="form-select text-start dropdown-toggle"
                                                                                        type="button"
                                                                                        id="addOnDropdown"
                                                                                        data-bs-toggle="dropdown"
                                                                                        aria-expanded="false">
                                                                                        <!--[if BLOCK]><![endif]--><?php if(count($selected_add_on_id) > 0): ?>
                                                                                            <?php echo e(count($selected_add_on_id)); ?>

                                                                                            <?php echo e(count($selected_add_on_id) == 1 ? 'Add On' : 'Add Ons'); ?>

                                                                                            Selected
                                                                                        <?php else: ?>
                                                                                            -- Select Add Ons --
                                                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                                    </button>

                                                                                    <!-- Checkbox options -->
                                                                                    <ul class="dropdown-menu w-100"
                                                                                        aria-labelledby="addOnDropdown">
                                                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableAddOns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addOn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                            <li>
                                                                                                <div
                                                                                                    class="dropdown-item">
                                                                                                    <input
                                                                                                        type="checkbox"
                                                                                                        wire:model="selected_add_on_id"
                                                                                                        value="<?php echo e($addOn->id); ?>"
                                                                                                        id="addon-<?php echo e($addOn->id); ?>"
                                                                                                        wire:change="updateSelectedCount">
                                                                                                    <label
                                                                                                        for="addon-<?php echo e($addOn->id); ?>"
                                                                                                        class="ms-2">
                                                                                                        <?php echo e($addOn->name); ?>

                                                                                                        (<?php echo e($addOn->price_per_unit); ?>/<?php echo e($addOn->resource_type); ?>)
                                                                                                    </label>
                                                                                                </div>
                                                                                            </li>
                                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                                                    </ul>
                                                                                </div>

                                                                                <!-- Selected items details -->
                                                                                <!--[if BLOCK]><![endif]--><?php if(count($selected_add_on_id) > 0): ?>
                                                                                    <div class="mt-2 small text-muted">
                                                                                        <strong>Selected:</strong>
                                                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableAddOns->whereIn('id', $selected_add_on_id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selected): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                            <span class="d-block">
                                                                                                <?php echo e($selected->name); ?>

                                                                                                (<?php echo e($selected->resource_type); ?>)
                                                                                            </span>
                                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                                                    </div>
                                                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                            </div>

                                                                            <div
                                                                                class="d-flex justify-content-between mt-3">
                                                                                <button
                                                                                    wire:click="toggleAddOnSelection"
                                                                                    class="btn btn-success">
                                                                                    Done
                                                                                </button>
                                                                                <button
                                                                                    wire:click="toggleAddOnSelection"
                                                                                    class="btn btn-secondary">
                                                                                    Cancel
                                                                                </button>
                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="text-center py-4">
                                                            <p class="text-muted mb-3">No Add On's selected
                                                            </p>
                                                            <button wire:click="toggleAddOnSelection"
                                                                class="btn btn-primary">
                                                                <i class="fas fa-plus me-2"></i>Add Add On
                                                            </button>
                                                        </div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                    <!-- Action Buttons -->
                                                    <div class="col-12">
                                                        <div
                                                            class="form-actions d-flex justify-content-between border-top pt-4">
                                                            <button wire:click="previousStep" type="button"
                                                                class="btn btn-secondary">
                                                                <i class="fas fa-arrow-left me-2"></i>Back
                                                            </button>
                                                            <button wire:click="save" type="button"
                                                                class="btn btn-success">
                                                                <?php echo e(isset($clinic) && $clinic->exists ? 'Update Clinic' : 'Create Clinic'); ?>

                                                                <i class="fas fa-save ms-2"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
    <style>
        .review-card {
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.05);
            border: 1px solid rgba(0, 0, 0, 0.08);
        }

        .detail-card {
            height: 100%;
            border-radius: 0.75rem;
            transition: transform 0.2s;
        }

        .detail-card:hover {
            transform: translateY(-3px);
        }

        .clinic-name {
            font-weight: 600;
            color: #2c3e50;
        }

        .owner-card .alert {
            border-radius: 0.75rem;
            border: none;
        }

        .speciality-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 0.5rem;
        }

        .doctor-name {
            font-weight: 500;
            color: #34495e;
        }

        .form-actions {
            padding-top: 2rem;
        }

        .clinic-about {
            line-height: 1.6;
            color: #4a5568;
        }

        .contact-list li {
            padding: 0.25rem 0;
        }

        .plan-card {
            transition: all 0.2s ease;
            border: 1px solid #e9ecef;
            border-radius: 0.75rem;
        }

        .plan-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.05);
        }

        .plan-card.border-primary {
            border: 2px solid #2B7F75;
            background-color: rgba(43, 127, 117, 0.03);
        }

        .cursor-pointer {
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/form-wizard.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php /**PATH /var/www/predcare/resources/views/livewire/admin/clinics/clinic-form.blade.php ENDPATH**/ ?>