<div class="content">
    <!-- Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">
                Staff Management
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Staff: <?php echo e($totalStaff ?? 0); ?>

                </span>
            </h4>
        </div>
        <div class="text-end d-flex">
            <a href="<?php echo e(route('admin.staff-management')); ?>" class="btn btn-primary ms-2 fs-13 btn-md">
                <i class="ti ti-plus me-1"></i>Add New Staff
            </a>
        </div>
    </div>

    <!-- Search and Filters -->
    <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3">
        <div class="search-set mb-3">
            <div class="d-flex align-items-center flex-wrap gap-2">
                <div class="table-search d-flex align-items-center mb-0">
                    <div class="search-input">
                        <a href="javascript:void(0);" class="btn-searchset"></a>
                        <div class="dataTables_filter">
                            <label>
                                <input type="search" class="form-control form-control-sm" placeholder="Search staff..."
                                    wire:model.live.debounce.300ms="searchTerm">
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex table-dropdown mb-3 pb-1 right-content align-items-center flex-wrap row-gap-3">
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" class="link-danger text-decoration-underline"
                                wire:click="resetFilters">Clear All</a>
                        </div>
                    </div>
                    <div>
                        <div class="filter-body pb-0">
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Status</label>
                                    <a href="javascript:void(0);" class="link-primary mb-1"
                                        wire:click="$set('tempStatusFilter', 'all')"
                                        wire:keydown.enter.prevent>Reset</a>
                                </div>
                                <select class="form-select" wire:model="tempStatusFilter" wire:keydown.enter.prevent>
                                    <option value="all">All Status</option>
                                    <option value="active">Active Only</option>
                                    <option value="inactive">Inactive Only</option>
                                </select>
                            </div>
                        </div>
                        <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                            <a href="javascript:void(0);" class="btn btn-light btn-md me-2" id="close-filter">Close</a>
                            <button type="button" class="btn btn-primary btn-md" wire:click="applyFilters">Apply
                                Filters</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sort Dropdown -->
            <div class="dropdown">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1">Sort By: </span>
                    <?php echo e(str_replace('_', ' ', $sortField)); ?> (<?php echo e($sortDirection); ?>)
                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li><a class="dropdown-item rounded-1" wire:click="sortBy('staff_name')">Name</a></li>
                    <li><a class="dropdown-item rounded-1" wire:click="sortBy('staff_email')">Email</a></li>
                    <li><a class="dropdown-item rounded-1" wire:click="sortBy('staff_status')">Status</a></li>
                    <li><a class="dropdown-item rounded-1" wire:click="sortBy('staff_created_at')">Created At</a></li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Staff Table -->
    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th wire:click="sortBy('staff_name')" style="cursor: pointer;">
                        Name <?php echo $sortField === 'staff_name' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : ''; ?>

                    </th>
                    <th wire:click="sortBy('staff_email')" style="cursor: pointer;">
                        Email <?php echo $sortField === 'staff_email' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : ''; ?>

                    </th>
                    <th>Phone</th>
                    <th wire:click="sortBy('staff_status')" style="cursor: pointer;">
                        Status <?php echo $sortField === 'staff_status' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : ''; ?>

                    </th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <!--[if BLOCK]><![endif]--><?php if($s->profile_image): ?>
                                    <div class="avatar avatar-md me-2">
                                        <img src="<?php echo e(Storage::url($s->profile_image)); ?>" alt="<?php echo e($s->staff_name); ?>" class="rounded-circle">
                                    </div>
                                <?php else: ?>
                                    <div class="avatar avatar-md me-2">
                                        <div class="avatar-initial rounded-circle <?php echo e($this->getAvatarColorClass($s->staff_name)); ?> text-white d-flex align-items-center justify-content-center fw-bold">
                                            <?php echo e($this->getInitials($s->staff_name)); ?>

                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <a href="<?php echo e(route('admin.staff-management.view', $s->user_id)); ?>" class="text-dark fw-semibold">
                                    <?php echo e($s->staff_name); ?>

                                </a>
                            </div>
                        </td>
                        <td><?php echo e($s->staff_email); ?></td>
                        <td><?php echo e($s->staff_phone ?? 'N/A'); ?></td>
                        <td>
                            <!--[if BLOCK]><![endif]--><?php if($s->staff_status === 'active'): ?>
                                <span class="badge badge-soft-success border border-success">Active</span>
                            <?php else: ?>
                                <span class="badge badge-soft-danger border border-danger">Inactive</span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="action-item">
                                    <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                        <i class="ti ti-dots-vertical"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end bg-white">
                                        <li>
                                            <a href="<?php echo e(route('admin.staff-management.view', $s->user_id)); ?>"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-eye me-2"></i> View
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e(route('admin.staff-management', ['id' => $s->user_id])); ?>"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-edit me-2"></i> Edit
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center"
                                                wire:click="toggleStatus(<?php echo e($s->staff_id); ?>)">
                                                <i class="ti ti-power me-2"></i>
                                                <?php echo e($s->staff_status === 'active' ? 'Deactivate' : 'Activate'); ?>

                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="text-center">No staff found.</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </tbody>
        </table>
    </div>

    <?php if (isset($component)) { $__componentOriginal7a1de95135fea4b7a0f524148344a9f0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0 = $attributes; } ?>
<?php $component = App\View\Components\Table\Pagination::resolve(['paginator' => $staff,'position' => 'both'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('table.pagination'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Table\Pagination::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $attributes = $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $component = $__componentOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>

    <!-- Delete Modal -->
    <div class="modal fade" id="delete_assignment" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center position-relative">
                   <img src="<?php echo e(asset('assets/img/bg/delete-modal-bg-01.png')); ?>" alt=""
                        class="img-fluid position-absolute top-0 start-0">
                    <img src="<?php echo e(asset('assets/img/bg/delete-modal-bg-02.png')); ?>" alt=""
                        class="img-fluid position-absolute bottom-0 end-0">

                    <div class="mb-3">
                        <span class="avatar avatar-lg bg-danger text-white"><i class="ti ti-trash fs-24"></i></span>
                    </div>
                    <h5 class="fw-bold mb-1">Delete Confirmation</h5>
                    <p class="mb-3">Are you sure you want to remove this staff assignment?</p>
                    <div class="d-flex justify-content-center">
                        <button class="btn btn-light position-relative z-1 me-3"
                            data-bs-dismiss="modal">Cancel</button>
                        <button class="btn btn-danger position-relative z-1" wire:click="deleteAssignment"
                            data-bs-dismiss="modal">Yes, Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('styles'); ?>
<style>
    .avatar-initial {
        width: 40px;
        height: 40px;
        font-size: 16px;
        font-weight: 600;
    }

    .avatar .avatar-initial {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .avatar-initial.bg-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    }

    .avatar-initial.bg-success {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%) !important;
    }

    .avatar-initial.bg-info {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%) !important;
    }

    .avatar-initial.bg-warning {
        background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%) !important;
    }

    .avatar-initial.bg-danger {
        background: linear-gradient(135deg, #fa709a 0%, #fee140 100%) !important;
    }

    .avatar-initial.bg-secondary {
        background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%) !important;
    }
</style>
<?php $__env->stopPush(); ?><?php /**PATH /var/www/predcare/resources/views/livewire/admin/staff/staff-list.blade.php ENDPATH**/ ?>