<?php $__env->startSection('title', 'Patient Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<style>
.fl-wrapper[data-position^=top-] {
    top: 5em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Start Page Header -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
            <div class="flex-grow-1">
                <h4 class="fw-bold mb-0"> Clinic/Doctors List</h4>
            </div>
        </div><br><br><br>
        <!-- End Page Header -->

        <?php if(session('success')): ?>
            <div class="alert alert-success mt-2">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger mt-2">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <!-- QR Code Section -->
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="text-center bg-white mb-4 p-4 rounded shadow-sm">
                    <h1 class="fw-bold mb-2">Please Enter Clinic ID</h1>
                    <p class="text-muted">To book an appointment, please enter the clinic's id to view associated doctors and schedule your booking.</p>
                    <form method="POST" action="<?php echo e(route('patient.doctor.clinic')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="form">
                            <div class="row">
                                <input type="text" id="clinic_id" name="clinic_id" class="form-control" placeholder="Enter the clinic id... Ex.: 1" required>
                            </div>
                        </div>
                            
                        <div class="align-items-center justify-content-end mt-3">
                            <a href="<?php echo e(route('patient.doctor.clinicList')); ?>" class="btn btn-info px-4 py-2 rounded-pill"><i class="ti ti-stethoscope me-2"></i> Clinic List</a>
                            <button type="submit" class="btn btn-primary px-4 py-2 rounded-pill">
                                <i class="ti ti-plus me-2"></i> Add Clinic
                            </button>
                        </div>
                    </form>

                    <!-- QR Code Image Placeholder -->
                    <!-- <div class="d-flex justify-content-center gap-3 mb-3 flex-wrap">
                        <img src="<?php echo e(asset('assets/img/qr_code.png')); ?>" alt="QR Code" class="img-fluid rounded shadow">

                    </div> -->

                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <!-- End QR Code Section -->

    </div>
    <!-- End Content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/patient/doctor/doctor-list.blade.php ENDPATH**/ ?>