<div class="content">
    <!-- Start Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">
                <a href="<?php echo e(route('admin.clinics.index')); ?>" class="text-decoration-none">Clinic Management</a>
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    <?php echo e($clinic->name); ?>

                </span>
            </h4>
        </div>

        <div class="text-end d-flex">
            <a href="<?php echo e(back()->getTargetUrl()); ?>" class="btn btn-secondary ms-2 fs-13 btn-md">
                <i class="ti ti-arrow-left me-1"></i>Back
            </a>
        </div>
    </div>
    <!-- End Page Header -->

    <div class="row g-4">
        <!-- Clinic Details Card -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-transparent border-bottom">
                    <h5 class="mb-0"><i class="ti ti-building-hospital me-2"></i>Clinic Information</h5>
                </div>
                <div class="card-body">
                    <div class="status-badge mb-3">
                        <span
                            class="badge badge-soft-<?php echo e($clinic->status == 'active' ? 'success' : 'danger'); ?> border border-<?php echo e($clinic->status == 'active' ? 'success' : 'danger'); ?>">
                            <?php echo e(ucfirst($clinic->status)); ?>

                        </span>
                    </div>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2 d-flex align-items-center">
                            <i class="ti ti-mail me-2 text-muted"></i>
                            <a href="mailto:<?php echo e($clinic->email); ?>" class="text-decoration-none"><?php echo e($clinic->email); ?></a>
                        </li>
                        <li class="mb-2 d-flex align-items-center">
                            <i class="ti ti-map-pin me-2 text-muted"></i>
                            <?php echo e($clinic->line1); ?>,
                            <!--[if BLOCK]><![endif]--><?php if($clinic->line2): ?>
                                <?php echo e($clinic->line2); ?>,
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php echo e($clinic->city); ?>, <?php echo e($clinic->state); ?>, <?php echo e($clinic->country); ?>

                        </li>
                        <li class="mb-2 d-flex align-items-center">
                            <i class="ti ti-map me-2 text-muted"></i>
                            <?php echo e($clinic->pincode); ?>

                        </li>
                        <!--[if BLOCK]><![endif]--><?php if($clinic->contact_numbers): ?>
                            <li class="mb-2 d-flex align-items-center">
                                <i class="ti ti-phone me-2 text-muted"></i>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $clinic->contact_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div><?php echo e($number); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </li>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </ul>
                    <!--[if BLOCK]><![endif]--><?php if($clinic->about): ?>
                        <div class="mt-4 pt-3 border-top">
                            <h6 class="mb-3"><i class="ti ti-info-circle me-2"></i>About</h6>
                            <p class="mb-0"><?php echo e($clinic->about); ?></p>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>

        <!-- Clinic Specialities -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-transparent border-bottom">
                    <h5 class="mb-0"><i class="ti ti-star me-2"></i>Specialities</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex flex-wrap gap-2">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $clinic->specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speciality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <span class="badge bg-primary"><?php echo e($speciality); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <span class="text-muted">No specialities specified</span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>

        <!-- Subscription Plan Card -->
        <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails): ?>
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-transparent border-bottom">
                        <h5 class="mb-0"><i class="ti ti-credit-card me-2"></i>Subscription Plan</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-primary bg-soft-primary border border-primary">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-1"><?php echo e($selectedPlanDetails->plan_name); ?></h6>
                                    <div class="text-muted small">
                                        <?php echo e(ucfirst($selectedPlanDetails->plan_type)); ?> plan •
                                        <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails->discounted_price): ?>
                                            <span class="text-danger ms-2">
                                                <s>$<?php echo e(number_format($selectedPlanDetails->base_price, 2)); ?></s>
                                                $<?php echo e(number_format($selectedPlanDetails->discounted_price, 2)); ?>

                                            </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails->description): ?>
                                <div class="mt-3">
                                    <p class="small mb-1"><strong>Includes:</strong></p>
                                    <p class="small text-muted">
                                        <?php echo e($selectedPlanDetails->description); ?>

                                    </p>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <div class="mt-3 row">
                                <div class="col-md-4">
                                    <p class="small mb-1"><i class="ti ti-user me-2"></i> Doctors:</p>
                                    <p class="small text-muted">
                                        <?php echo e($selectedPlanLimits->included_doctors ?? 'Unlimited'); ?>

                                    </p>
                                </div>
                                <div class="col-md-4">
                                    <p class="small mb-1"><i class="ti ti-users me-2"></i> Staff:</p>
                                    <p class="small text-muted">
                                        <?php echo e($selectedPlanLimits->included_staff ?? 'Unlimited'); ?>

                                    </p>
                                </div>
                                <div class="col-md-4">
                                    <p class="small mb-1"><i class="ti ti-device-mobile me-2"></i> Devices:</p>
                                    <p class="small text-muted">
                                        <?php echo e($selectedPlanDetails->device_limit ?? 'Unlimited'); ?>

                                    </p>
                                </div>
                            </div>
                            <div class="mt-3 row">
                                <div class="col-md-4">
                                    <p class="small mb-1"><i class="ti ti-database me-2"></i> Storage:</p>
                                    <p class="small text-muted">
                                        <?php echo e($selectedPlanLimits->storage_limit_gb ?? 'Unlimited'); ?> GB
                                    </p>
                                </div>
                                <div class="col-md-4">
                                    <p class="small mb-1"><i class="ti ti-video me-2"></i> Teleconsultation:</p>
                                    <p class="small text-muted">
                                        <?php echo e($selectedPlanLimits->teleconsultation_minutes ?? 'Unlimited'); ?> Minutes
                                    </p>
                                </div>
                                <div class="col-md-4">
                                    <p class="small mb-1"><i class="ti ti-message-circle me-2"></i> SMS:</p>
                                    <p class="small text-muted">
                                        <?php echo e($selectedPlanLimits->sms_limit ?? 'Unlimited'); ?> Messages
                                    </p>
                                </div>
                            </div>

                            <div class="mt-4 pt-3 border-top">
                                <h6 class="mb-3">Remaining Resources</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <p class="small mb-1"><i class="ti ti-user me-2"></i> Doctors:</p>
                                        <p class="small text-muted">
                                            <?php echo e($selectedPlanLimits->included_doctors - $usedLimits['doctors']); ?>

                                        </p>
                                    </div>
                                    <div class="col-md-4">
                                        <p class="small mb-1"><i class="ti ti-users me-2"></i> Staff:</p>
                                        <p class="small text-muted">
                                            <?php echo e($selectedPlanLimits->included_staff - $usedLimits['staffs']); ?>

                                        </p>
                                    </div>
                                    <div class="col-md-4">
                                        <p class="small mb-1"><i class="ti ti-device-mobile me-2"></i> Devices:</p>
                                        <p class="small text-muted">
                                            <?php echo e($selectedPlanDetails->device_limit ?? 'Unlimited'); ?>

                                        </p>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col-md-4">
                                        <p class="small mb-1"><i class="ti ti-database me-2"></i> Storage:</p>
                                        <p class="small text-muted">
                                            <?php echo e($selectedPlanLimits->storage_limit_gb - $usedLimits['storage_limit']); ?>

                                            GB
                                        </p>
                                    </div>
                                    <div class="col-md-4">
                                        <p class="small mb-1"><i class="ti ti-video me-2"></i> Teleconsultation:</p>
                                        <p class="small text-muted">
                                            <?php echo e($selectedPlanLimits->teleconsultation_minutes - $usedLimits['teleconsultation_limit']); ?>

                                            Minutes
                                        </p>
                                    </div>
                                    <div class="col-md-4">
                                        <p class="small mb-1"><i class="ti ti-message-circle me-2"></i> SMS:</p>
                                        <p class="small text-muted">
                                            <?php echo e($selectedPlanLimits->sms_limit - $usedLimits['sms_limit']); ?> Messages
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="col-12 text-center py-4">
                <p class="text-muted mb-3">No subscription plan selected</p>
                <a href="<?php echo e(route('admin.clinics.edit', $clinic)); ?>" class="btn btn-primary">
                    <i class="ti ti-plus me-2"></i>Add Subscription Plan
                </a>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Add On Plan Card -->
        <!--[if BLOCK]><![endif]--><?php if($selectedAddOnDetails): ?>
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-transparent border-bottom">
                        <h5 class="mb-0"><i class="ti ti-credit-card me-2"></i>All Add On</h5>
                    </div>
                    <div class="card-body">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $selectedAddOnDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addOn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="alert alert-primary bg-soft-primary border border-primary mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1"><?php echo e($addOn->name); ?></h6>
                                        <div class="text-muted small">
                                            <?php echo e(ucfirst($addOn->resource_type)); ?> Add On •
                                            Per <?php echo e($addOn->unit); ?> Price
                                            $<?php echo e(number_format($addOn->price_per_unit, 2)); ?>

                                        </div>
                                    </div>
                                    <div class="text-muted small">
                                        Total amount •
                                        <span class="text-danger ms-2">
                                            $<?php echo e(number_format($addOn->price_per_unit * $addOn->unit_counts, 2)); ?>

                                        </span>
                                    </div>
                                </div>

                                <!--[if BLOCK]><![endif]--><?php if($addOn->description): ?>
                                    <div class="mt-3">
                                        <p class="small mb-1"><strong>Includes:</strong></p>
                                        <p class="small text-muted">
                                            <?php echo e($addOn->description); ?>

                                        </p>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="col-12 text-center py-4">
                <p class="text-muted mb-3">No Add On's selected</p>
                <a href="<?php echo e(route('admin.clinics.edit', $clinic)); ?>" class="btn btn-primary">
                    <i class="ti ti-plus me-2"></i>Add Add On
                </a>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Associated Doctors, Patients & Staff Tabs -->
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-transparent border-bottom p-0">
                    <ul class="nav nav-tabs" id="clinicTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo e($activeTab === 'doctors' ? 'active' : ''); ?>"
                                wire:click="switchTab('doctors')" type="button" role="tab">
                                <i class="ti ti-user me-2"></i> Doctors
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo e($activeTab === 'patients' ? 'active' : ''); ?>"
                                wire:click="switchTab('patients')" type="button" role="tab">
                                <i class="ti ti-user me-2"></i> Patients
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php echo e($activeTab === 'staff' ? 'active' : ''); ?>"
                                wire:click="switchTab('staff')" type="button" role="tab">
                                <i class="ti ti-users me-2"></i> Staff
                            </button>
                        </li>
                    </ul>
                </div>       
                
                <div class="card-body">
                    <div class="tab-content" id="clinicTabsContent">
                        <div class="tab-pane fade <?php echo e($activeTab === 'doctors' ? 'show active' : ''); ?>" id="doctors"
                            role="tabpanel">
                            <!--[if BLOCK]><![endif]--><?php if(isset($loadedTabs['doctors'])): ?>
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.clinics.doctors-table',
                                    [
                                        'clinic' => $clinic,
                                        'loadImmediately' => $activeTab === 'doctors',
                                    ]);

$__html = app('livewire')->mount($__name, $__params, 'doctors-' . $clinic->id, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="tab-pane fade <?php echo e($activeTab === 'patients' ? 'show active' : ''); ?>"
                            id="patients" role="tabpanel">
                            <!--[if BLOCK]><![endif]--><?php if(isset($loadedTabs['patients'])): ?>
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.clinics.patients-table',
                                    [
                                        'clinic' => $clinic,
                                        'loadImmediately' => $activeTab === 'patients',
                                    ]);

$__html = app('livewire')->mount($__name, $__params, 'patients-' . $clinic->id, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="tab-pane fade <?php echo e($activeTab === 'staff' ? 'show active' : ''); ?>" id="staff"
                            role="tabpanel">
                            <!--[if BLOCK]><![endif]--><?php if(isset($loadedTabs['staff'])): ?>
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.clinics.staff-table',
                                    [
                                        'clinic' => $clinic,
                                        'loadImmediately' => $activeTab === 'staff',
                                    ]);

$__html = app('livewire')->mount($__name, $__params, 'staff-' . $clinic->id, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
    <style>
        .card {
            border-radius: 0.75rem;
            border: 1px solid rgba(0, 0, 0, 0.08);
            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.05);
        }

        .nav-tabs .nav-link {
            border: none;
            padding: 1rem 1.5rem;
            color: #6c757d;
            font-weight: 500;
        }

        .nav-tabs .nav-link.active {
            color: #2B7F75;
            border-bottom: 2px solid #2B7F75;
            background-color: transparent;
        }

        .alert {
            border-radius: 0.75rem;
        }

        .badge {
            font-weight: 500;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/clinics/view-clinic.blade.php ENDPATH**/ ?>