<div class="content pb-0">
    <!-- Start Page Header -->
    <div class="mb-3">
        <h6 class="fw-semibold fs-14 mb-0">
            <a href="<?php echo e(back()->getTargetUrl()); ?>"><i class="ti ti-chevron-left me-1"></i>Doctors</a>
        </h6>
    </div>
    <!-- End Page Header -->

    <div class="card">
        <div class="row align-items-end">
            <div class="col-xl-9 col-lg-8">
                <div class="d-sm-flex align-items-center position-relative z-0 overflow-hidden p-3">
                    <img src="<?php echo e(asset('assets/img/icons/shape-01.svg')); ?>" alt="img"
                        class="z-n1 position-absolute end-0 top-0 d-none d-lg-flex">

                    <div class="avatar avatar-xxxl patient-avatar me-2 flex-shrink-0">
                        <!--[if BLOCK]><![endif]--><?php if($doctor->profile_photo_url): ?>
                            <img src="<?php echo e($doctor->profile_photo_url); ?>" alt="<?php echo e($doctor->name); ?>" class="rounded">
                        <?php else: ?>
                            <div class="avatar avatar-xxxl <?php echo e(getAvatarColorClass($doctor->name)); ?> rounded d-flex align-items-center justify-content-center text-white"
                                style="font-size: 2rem;">
                                <?php echo e(getInitials($doctor->name)); ?>

                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div>
                        <p class="text-primary mb-1">#DR<?php echo e(str_pad($doctor->id, 4, '0', STR_PAD_LEFT)); ?></p>
                        <h5 class="mb-1">
                            <span class="fw-bold"><?php echo e($doctor->name); ?></span>
                            <span class="badge border bg-white text-dark fw-medium ms-2">
                                <i class="ti ti-point-filled me-1 text-info"></i>
                                <?php echo e($doctor->doctor->specialization ?? ($doctor->doctorProfile->specialization ?? 'N/A')); ?>

                            </span>
                        </h5>
                        <p class="mb-3"><?php echo e($doctor->doctor->qualifications ?? 'N/A'); ?></p>
                        <div class="d-flex align-items-center flex-wrap">
                            <!--[if BLOCK]><![endif]--><?php if($primaryClinic): ?>
                                <p class="mb-0 d-inline-flex align-items-center">
                                    <i class="ti ti-building-hospital me-1 text-dark"></i>Clinic :
                                    <span class="text-dark ms-1"><?php echo e($primaryClinic->name); ?></span>
                                </p>
                                <span class="mx-2 text-light">|</span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <p class="mb-0 d-inline-flex align-items-center">
                                <i
                                    class="ti ti-point-filled me-1 text-<?php echo e($doctor->status === 'active' ? 'success' : 'danger'); ?>"></i>Status
                                :
                                <span class="text-dark ms-1"><?php echo e(ucfirst($doctor->status)); ?></span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4">
                <div class="p-3 text-lg-end">
                    <!--[if BLOCK]><![endif]--><?php if($primaryClinic && $primaryClinic->pivot): ?>
                        <div class="mb-4">
                            <h6 class="fs-18 fw-bold mb-1">
                                ₹<?php echo e(number_format($primaryClinic->pivot->in_person_fee ?? 0, 2)); ?>

                                <span class="fw-normal text-body fs-14">/
                                    <?php echo e($primaryClinic->pivot->in_person_duration ?? 30); ?> Min</span>
                            </h6>
                            <p class="mb-0 fs-13">Consultation Charge</p>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <!-- <button type="button" class="btn btn-primary" wire:click="bookAppointment">
                        <i class="ti ti-calendar-event me-1"></i>Book Appointment
                    </button> -->
                    <a href="<?php echo e(route('doctor.appointments.create')); ?>" class="btn btn-primary ms-2 fs-13 btn-md"><i class="ti ti-calendar-event me-1"></i>Book Appointment </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- Availability Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Availability</h5>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availabilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $availability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = json_decode($availability->day, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $status = 'active'; // yeh aap dynamic bhi kar sakte ho
                            ?>
                            <span class="me-4 p-2">
                                <h6><?php echo e(ucfirst($day)); ?> - </h6>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availabilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $availability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = json_decode($availability->time_slot, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="#"
                                            class="d-inline-flex align-items-center bg-primary rounded flex-fill text-center justify-content-center p-1 text-light me-1 mb-3">
                                            <?php echo e($slot); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </span><hr/>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <!-- Bio Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Short Bio</h5>
                    <p><?php echo e($doctor->doctor->bio ?? ($doctor->doctorProfile->bio ?? 'No biography available.')); ?></p>
                    <!--[if BLOCK]><![endif]--><?php if(
                        ($doctor->doctor->bio ?? $doctor->doctorProfile->bio) &&
                            strlen($doctor->doctor->bio ?? $doctor->doctorProfile->bio) > 200): ?>
                        <div class="more-menu" style="display: none;">
                            <p><?php echo e(substr($doctor->doctor->bio ?? $doctor->doctorProfile->bio, 200)); ?></p>
                        </div>
                        <div class="view-all mt-2">
                            <a href="javascript:void(0);" class="viewall-button text-primary fw-medium">
                                <span>See More</span>
                                <i class="ti ti-chevron-down fs-10 ms-2"></i>
                            </a>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <!-- Education Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Education Information</h5>
                    <ul class="activity-feed rounded">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2"><?php echo e($education->institution); ?> - <?php echo e($education->degree); ?></h6>
                                <!--[if BLOCK]><![endif]--><?php if($education->field_of_study): ?>
                                    <p class="mb-1"><?php echo e($education->field_of_study); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <p>
                                    <?php echo e($education->start_year); ?> -
                                    <!--[if BLOCK]><![endif]--><?php if($education->is_current): ?>
                                        Present
                                    <?php else: ?>
                                        <?php echo e($education->end_year); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </p>
                                <!--[if BLOCK]><![endif]--><?php if($education->description): ?>
                                    <p class="mt-2"><?php echo e($education->description); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <li class="feed-item timeline-item">
                                <p>No education information available.</p>
                            </li>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </ul>
                </div>
            </div>

            <!-- Experience Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Work Experience</h5>
                    <ul class="activity-feed rounded">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2"><?php echo e($experience->position); ?> at
                                    <?php echo e($experience->organization); ?></h6>
                                <p>
                                    <?php echo e($experience->start_date->format('M Y')); ?> -
                                    <!--[if BLOCK]><![endif]--><?php if($experience->is_current): ?>
                                        Present
                                    <?php else: ?>
                                        <?php echo e($experience->end_date->format('M Y')); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </p>
                                <!--[if BLOCK]><![endif]--><?php if($experience->description): ?>
                                    <p class="mt-2"><?php echo e($experience->description); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <li class="feed-item timeline-item">
                                <p>No work experience information available.</p>
                            </li>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </ul>
                </div>
            </div>

            <!-- Certifications Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Certifications & Licenses</h5>
                    <div class="mb-3">
                        <div class="d-flex align-items-center mb-2">
                            <span class="me-2"><i class="ti ti-award"></i></span>
                            <h6 class="mb-0 fw-bold">License:
                                <?php echo e($doctor->doctor->license_number ?? ($doctor->doctorProfile->license_number ?? 'N/A')); ?>

                            </h6>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->license_state): ?>
                            <p>State: <?php echo e($doctor->doctorProfile->license_state); ?></p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->license_valid_until): ?>
                            <p>Valid Until: <?php echo e($doctor->doctorProfile->license_valid_until->format('M d, Y')); ?></p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!--[if BLOCK]><![endif]--><?php if($certificates): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-3">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="me-2"><i class="ti ti-certificate"></i></span>
                                    <h6 class="mb-0 fw-bold"><?php echo e($certificate->name ?? 'Certificate'); ?></h6>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(isset($certificate->uploaded_at)): ?>
                                    <p>Date: <?php echo e($certificate->uploaded_at); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <!-- Associated Clinics, Patients & Staff Tabs -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-transparent border-bottom p-0">
                        <ul class="nav nav-tabs" id="clinicTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="clinics-tab" data-bs-toggle="tab" data-bs-target="#clinics"
                                    type="button" role="tab">
                                    <i class="ti ti-user me-2"></i> Clinic
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="patients-tab" data-bs-toggle="tab" data-bs-target="#patients"
                                    type="button" role="tab">
                                    <i class="ti ti-user me-2"></i> Patients
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="staff-tab" data-bs-toggle="tab" data-bs-target="#staff"
                                    type="button" role="tab">
                                    <i class="ti ti-users me-2"></i> Staff
                                </button>
                            </li>
                        </ul>
                    </div>

                    <div class="card-body">
                        <div class="tab-content" id="clinicTabsContent">
                            <!-- Clinics Tab -->
                            <div class="tab-pane fade show active" id="clinics" role="tabpanel" aria-labelledby="clinics-tab">
                                <!-- Clinics Section -->
                                <!--[if BLOCK]><![endif]--><?php if($clinics->isNotEmpty()): ?>
                                    <div class="table-responsive">
                                        <h6>Clinic Management</h6><hr>
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Clinic Name</th>
                                                    <th>Email</th>
                                                    <th>Contact Number</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $clinics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <?php echo e($clinic->name); ?>

                                                            <!--[if BLOCK]><![endif]--><?php if($clinic->pivot->is_primary): ?>
                                                                <span class="badge bg-primary ms-2">Primary</span>
                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                        </td>
                                                        <td><?php echo e($clinic->email ?? '-'); ?></td>
                                                        <td>
                                                            <!--[if BLOCK]><![endif]--><?php if(!empty($clinic->contact_numbers)): ?>
                                                                
                                                                <?php
                                                                    $contacts = is_array($clinic->contact_numbers) 
                                                                        ? $clinic->contact_numbers 
                                                                        : explode(',', $clinic->contact_numbers);
                                                                ?>
                                                                <?php echo e(implode(', ', $contacts)); ?>

                                                            <?php else: ?>
                                                                -
                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                        </td>
                                                        <td>
                                                            <span
                                                                class="badge badge-soft-<?php echo e($clinic->pivot->status === 'active' ? 'success' : 'danger'); ?>">
                                                                <?php echo e(ucfirst($clinic->pivot->status)); ?>

                                                            </span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            </tbody>
                                        </table>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <!-- Patients Tab -->
                            <div class="tab-pane fade" id="patients" role="tabpanel" aria-labelledby="patients-tab">
                                <!-- Patients Section -->
                                <!--[if BLOCK]><![endif]--><?php if($patients->isNotEmpty()): ?>
                                    <div class="table-responsive">
                                        <h5>Patient Management</h5><hr>
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Assigned Doctor</th>
                                                    <th>Status</th>
                                                    <th>Approval Status</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($patient->name ?? '-'); ?></td>
                                                        <td><?php echo e($patient->email ?? '-'); ?></td>
                                                        <td><?php echo e($doctor->name ?? '-'); ?></td>
                                                        <td>
                                                            <span class="badge badge-soft-<?php echo e($patient->status === 'active' ? 'success' : 'danger'); ?>">
                                                                <?php echo e(ucfirst($patient->status)); ?>

                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-soft-<?php echo e($patient->approval_status === 'approved' ? 'success' : 'warning'); ?>">
                                                                <?php echo e(ucfirst($patient->approval_status)); ?>

                                                            </span>
                                                        </td>
                                                        <td class="action-item">
                                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                                <i class="ti ti-dots-vertical"></i>
                                                            </a>
                                                            <ul class="dropdown-menu p-2">
                                                                <li>
                                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center">
                                                                        <i class="ti ti-plus me-2"></i> Add
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center">
                                                                        <i class="ti ti-eye me-2"></i> View
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <p class="text-muted mt-2">No patients found.</p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <!-- Staff Tab -->
                            <div class="tab-pane fade" id="staff" role="tabpanel" aria-labelledby="staff-tab">
                                <!-- Staff Section -->
                                <!--[if BLOCK]><![endif]--><?php if($staff->isNotEmpty()): ?>
                                    <div class="table-responsive">
                                        <h5>Staff Members</h5><hr/>
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Supervisor Doctor</th>
                                                    <th>Status</th>
                                                    <th>Approval Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($member->name ?? '-'); ?></td>
                                                        <td><?php echo e($member->email ?? '-'); ?></td>
                                                        <td><?php echo e($doctor->name ?? '-'); ?></td>
                                                        <td>
                                                            <span class="badge badge-soft-<?php echo e($member->status === 'active' ? 'success' : 'danger'); ?>">
                                                                <?php echo e(ucfirst($member->status)); ?>

                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-soft-<?php echo e($member->approval_status === 'approved' ? 'success' : 'warning'); ?>">
                                                                <?php echo e(ucfirst($member->approval_status)); ?>

                                                            </span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <p class="text-muted mt-2">No staff members found.</p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar Section -->
        <div class="col-xl-4 theiaStickySidebar">
            <div class="card">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">About</h6>
                    <div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-file"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Medical License Number</h6>
                                <p><?php echo e($doctor->doctor->license_number ?? ($doctor->doctorProfile->license_number ?? 'N/A')); ?>

                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-phone"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Phone Number</h6>
                                <p><?php echo e($doctor->phone_number ?? 'N/A'); ?></p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-mail"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Email Address</h6>
                                <p><?php echo e($doctor->email); ?></p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-user-check"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Years of Experience</h6>
                                <p><?php echo e($doctor->doctor->experience_years ?? ($doctor->doctorProfile->years_of_experience ?? '0')); ?>

                                    Years</p>
                            </div>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->languages_spoken): ?>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-language"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Languages Spoken</h6>
                                    <p><?php echo e(implode(', ', $doctor->doctorProfile->languages_spoken)); ?></p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->sub_specializations): ?>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-stethoscope"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Sub-specializations</h6>
                                    <p><?php echo e(implode(', ', $doctor->doctorProfile->sub_specializations)); ?></p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile): ?>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-user-plus"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Accepts New Patients</h6>
                                    <p><?php echo e($doctor->doctorProfile->accepts_new_patients ? 'Yes' : 'No'); ?></p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->verification_status): ?>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-shield-check"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Verification Status</h6>
                                    <p class="text-capitalize"><?php echo e($doctor->doctorProfile->verification_status); ?></p>
                                    <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile->verified_at): ?>
                                        <small class="text-muted">Verified on:
                                            <?php echo e($doctor->doctorProfile->verified_at->format('M d, Y')); ?></small>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Ratings Section -->
            <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && ($doctor->doctorProfile->rating || $doctor->doctorProfile->reviews_count)): ?>
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">Ratings & Reviews</h6>
                        <div class="text-center">
                            <div class="d-flex align-items-center justify-content-center mb-2">
                                <h2 class="me-2 mb-0"><?php echo e(number_format($doctor->doctorProfile->rating, 1)); ?></h2>
                                <div class="star-rating">
                                    <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= 5; $i++): ?>
                                        <!--[if BLOCK]><![endif]--><?php if($i <= floor($doctor->doctorProfile->rating)): ?>
                                            <i class="ti ti-star-filled text-warning"></i>
                                        <?php elseif($i - 0.5 <= $doctor->doctorProfile->rating): ?>
                                            <i class="ti ti-star-half-filled text-warning"></i>
                                        <?php else: ?>
                                            <i class="ti ti-star text-warning"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                            <p class="text-muted"><?php echo e($doctor->doctorProfile->reviews_count); ?> reviews</p>
                            <a href="#" class="btn btn-outline-primary btn-sm">View All Reviews</a>
                        </div>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        // For the "See More" functionality
        $(document).ready(function() {
            $('.viewall-button').click(function() {
                $(this).closest('.card-body').find('.more-menu').toggle();
                var span = $(this).find('span');
                var icon = $(this).find('i');

                if (span.text() === 'See More') {
                    span.text('See Less');
                    icon.removeClass('ti ti-chevron-down').addClass('ti ti-chevron-up');
                } else {
                    span.text('See More');
                    icon.removeClass('ti ti-chevron-up').addClass('ti ti-chevron-down');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .card {
            border-radius: 0.75rem;
            border: 1px solid rgba(0, 0, 0, 0.08);
            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.05);
        }

        .nav-tabs .nav-link {
            border: none;
            padding: 1rem 1.5rem;
            color: #6c757d;
            font-weight: 500;
        }

        .nav-tabs .nav-link.active {
            color: #2B7F75;
            border-bottom: 2px solid #2B7F75;
            background-color: transparent;
        }

        .alert {
            border-radius: 0.75rem;
        }

        .badge {
            font-weight: 500;
        }
    </style>
<?php $__env->stopPush(); ?><?php /**PATH /var/www/predcare/resources/views/livewire/doctor/doctor/doctor-view.blade.php ENDPATH**/ ?>