<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo $__env->yieldContent('title', 'Admin Dashboard - PRED Care'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="Dreams Technologies">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/img/favicon.png')); ?>">

    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="<?php echo e(asset('assets/img/apple-icon.png')); ?>">

    <!-- Theme Config Js -->
    <script src="<?php echo e(asset('assets/js/theme-script.js')); ?>"></script>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">

    <!-- Datetimepicker CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap-datetimepicker.min.css')); ?>">

    <!-- Daterangepikcer CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/daterangepicker/daterangepicker.css')); ?>">

    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/fontawesome/css/fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/fontawesome/css/all.min.css')); ?>">

    <!-- Tabler Icon CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/tabler-icons/tabler-icons.min.css')); ?>">

    <!-- Wizard CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/twitter-bootstrap-wizard/form-wizard.css')); ?>">

    <!-- Simplebar CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/simplebar/simplebar.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/select2/css/select2.min.css')); ?>">

    <!-- Include intlTelInput CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/intltelinput/css/intlTelInput.css')); ?>" />

    <!-- Main CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>" id="app-style">
    <style>
        .modal {
            display: none;
        }

        .modal.show {
            display: block;
        }
    </style>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>
    <div class="main-wrapper">
        <?php echo $__env->make('layouts.partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php if(Auth::guard('superadmin')->check()): ?>
            <?php echo $__env->make('layouts.partials.admin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php elseif(Auth::guard('doctor')->check()): ?>
            <?php echo $__env->make('layouts.partials.doctor-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php elseif(Auth::guard('patient')->check()): ?>
            <?php echo $__env->make('layouts.partials.patient-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <div class="page-wrapper">
            <?php echo $__env->yieldContent('content'); ?>
            <?php echo $__env->make('layouts.partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>

    <?php echo $__env->make('layouts.partials.delete-modals', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- jQuery -->
    <script src="<?php echo e(asset('assets/js/jquery-3.7.1.min.js')); ?>"></script>

    <!-- Bootstrap Core JS -->
    <script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>


    <script src="<?php echo e(asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>

    <!-- Simplebar JS -->
    <script src="<?php echo e(asset('assets/plugins/simplebar/simplebar.min.js')); ?>"></script>

    <!-- Chart JS -->
    <script src="<?php echo e(asset('assets/plugins/apexchart/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/apexchart/chart-data.js')); ?>"></script>

    <!-- Daterangepikcer JS -->
    <script src="<?php echo e(asset('assets/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/daterangepicker/daterangepicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap-datetimepicker.min.js')); ?>"></script>

    <!-- Include intlTelInput JS -->
    <script src="<?php echo e(asset('assets/plugins/intltelinput/js/intlTelInput.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/intltelinput/js/utils.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/plugins/theia-sticky-sidebar/theia-sticky-sidebar.js')); ?>"></script>

    <!-- Main JS -->
    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>


    <!-- Wizrd JS -->
    <script src="<?php echo e(asset('assets/plugins/vanilla-wizard/js/wizard.min.js')); ?>"></script>

    <!-- Wizard JS -->
    <script src="<?php echo e(asset('assets/js/deletemodel.js')); ?>"></script>
    <script>
        window.addEventListener('clinic-changed-refresh', function () {
            window.location.reload();
        });
    </script>
    <script>
        window.addEventListener('doctor-clinic-changed-refresh', function () {
            window.location.reload();
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH /var/www/predcare/resources/views/layouts/app.blade.php ENDPATH**/ ?>