<div class="card">
    <div class="card-header">
        <h5>Review Plan Details</h5>
        <p class="mb-0 text-muted">Please review all information before submitting</p>
    </div>
    <div class="card-body">
        <!-- Basic Information -->
        <div class="mb-5">
            <h6 class="border-bottom pb-2 mb-3">Basic Information</h6>
            <div class="row">
                <div class="col-md-4">
                    <p><strong>Plan Code:</strong> <?php echo e($planData['basic']['plan_code'] ?? 'N/A'); ?></p>
                </div>
                <div class="col-md-4">
                    <p><strong>Plan Name:</strong> <?php echo e($planData['basic']['plan_name'] ?? 'N/A'); ?></p>
                </div>
                <div class="col-md-4">
                    <p><strong>Plan Type:</strong> <?php echo e(ucfirst($planData['basic']['plan_type'] ?? 'N/A')); ?></p>
                </div>
                <div class="col-md-4">
                    <p><strong>Duration:</strong> <?php echo e($planData['basic']['duration'] ?? 'N/A'); ?>

                        <?php echo e(($planData['basic']['plan_type'] ?? '') === 'monthly' ? 'Month(s)' : 'Year(s)'); ?></p>
                </div>
                <div class="col-md-4">
                    <p><strong>Base Price:</strong> <?php echo e($planData['basic']['currency'] ?? 'N/A'); ?>

                        <?php echo e(number_format($planData['basic']['base_price'] ?? 0, 2)); ?></p>
                </div>
                <div class="col-md-4">
                    <p><strong>Status:</strong> <?php echo e(ucfirst($planData['basic']['plan_status'] ?? 'N/A')); ?></p>
                </div>
            </div>
        </div>
        <!-- Plan Limits -->
        <div class="mb-5">
            <h6 class="border-bottom pb-2 mb-3">Plan Limits</h6>
            <div class="row">
                <div class="col-md-4">
                    <p><strong>Max Doctors:</strong> <?php echo e($planData['limits']['included_doctors'] ?? 'N/A'); ?></p>
                </div>
                <div class="col-md-4">
                    <p><strong>Additional Doctor Price:</strong> <?php echo e($planData['basic']['currency'] ?? 'N/A'); ?>

                        <?php echo e(number_format($planData['limits']['additional_doctor_price'] ?? 0, 2)); ?></p>
                </div>
                <div class="col-md-4">
                </div>
                <div class="col-md-4">
                    <p><strong>Max Staff:</strong> <?php echo e($planData['limits']['included_staff'] ?? 'N/A'); ?></p>
                </div>
                <div class="col-md-4">
                    <p><strong>Storage Limit:</strong> <?php echo e($planData['limits']['storage_limit_gb'] ?? 'N/A'); ?> GB</p>
                </div>
                <div class="col-md-4">
                    <p><strong>Teleconsultation:</strong> <?php echo e($planData['limits']['teleconsultation_minutes'] ?? 'N/A'); ?>

                        minutes</p>
                </div>
            </div>
        </div>
        <!-- Included Features -->
        <div class="mb-5">
            <h6 class="border-bottom pb-2 mb-3">Included Features (<?php echo e(count($planData['features'] ?? [])); ?>)</h6>
            <div class="row">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $available_features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 mb-2">
                        <i class="fas fa-check-circle text-success me-2"></i>
                        <?php echo e($feature->feature_name); ?>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
        <!-- Usage Rates -->
        <div class="mb-4">
            <h6 class="border-bottom pb-2 mb-3">Usage Rates (<?php echo e(count($planData['rates'] ?? [])); ?>)</h6>
            <!--[if BLOCK]><![endif]--><?php if(count($planData['rates'] ?? []) > 0): ?>
                <div class="table-responsive">
                    <table class="table table-sm table-bordered">
                        <thead>
                            <tr>
                                <th>Usage Type</th>
                                <th>Per Unit Rate</th>
                                <th>Free Units</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $planData['rates']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $type = $available_usage_types->get($rate['usage_type_id'] ?? null);
                                ?>
                                <tr>
                                    <td> <strong><?php echo e($type->type_name ?? 'N/A'); ?></strong>
                                        <div class="small text-muted"><?php echo e($type->unit_name ?? ''); ?>

                                    </td>
                                    <td><?php echo e(number_format($rate['rate_per_unit'] ?? 0, 2)); ?>

                                        <?php echo e($planData['basic']['currency'] ?? ''); ?> Per
                                        <?php echo e($type->unit_name ?? ''); ?>

                                    </td>
                                    <td><?php echo e(number_format($rate['free_units'] ?? 0)); ?> <?php echo e($type->unit_name ?? ''); ?></td>
                                    
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-muted">No usage rates configured</p>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>

        <!-- Combo Plan Card -->
        <div class="mb-4">
            <h6 class="border-bottom pb-2 mb-3">Combo Plan
                <?php echo ($planData['basic']['is_combo'] ?? false)
                    ? '<i class="fas fa-check-circle text-success"></i>'
                    : '<i class="fas fa-times-circle text-danger"></i>'; ?></h6>
            <!--[if BLOCK]><![endif]--><?php if($planData['basic']['is_combo'] ?? false): ?>
                <!--[if BLOCK]><![endif]--><?php if($showPlanSelection || $selectedPlanDetails): ?>
                    <div class="col-12">
                        <div class="card review-card">
                            <div class="card-header bg-transparent">
                                <h5 class="mb-0"><i class="fas fa-credit-card me-2"></i>Subscription Plan
                                </h5>
                            </div>
                            <div class="card-body">
                                <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails): ?>
                                    <div class="alert alert-primary">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <h6 class="mb-1">
                                                    <?php echo e($selectedPlanDetails->plan_name); ?>

                                                </h6>
                                                <div class="text-muted small">
                                                    <?php echo e(ucfirst($selectedPlanDetails->plan_type)); ?>

                                                    plan •
                                                    <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails->discounted_price): ?>
                                                        <span class="text-danger ms-2">
                                                            <s>$<?php echo e(number_format($selectedPlanDetails->base_price, 2)); ?></s>
                                                            $<?php echo e(number_format($selectedPlanDetails->discounted_price, 2)); ?>

                                                        </span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </div>
                                            <button wire:click="togglePlanSelection"
                                                class="btn btn-sm btn-outline-primary">
                                                Change Plan
                                            </button>
                                        </div>

                                        <!--[if BLOCK]><![endif]--><?php if($selectedPlanDetails->description): ?>
                                            <div class="mt-3">
                                                <p class="small mb-1"><strong>Includes:</strong>
                                                </p>
                                                <p class="small text-muted">
                                                    <?php echo e($selectedPlanDetails->description); ?>

                                                </p>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <div class="mt-3 row">
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-user-md me-2"></i>
                                                    Doctors:</p>
                                                <p class="small text-muted">
                                                    <?php echo e($selectedPlanLimits->included_doctors ?? 'Unlimited'); ?>

                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-users me-2"></i>
                                                    Staff:
                                                </p>
                                                <p class="small text-muted">
                                                    <?php echo e($selectedPlanLimits->included_staff ?? 'Unlimited'); ?>

                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-mobile-alt me-2"></i>
                                                    Devices:</p>
                                                <p class="small text-muted">
                                                    <?php echo e($selectedPlanDetails->device_limit ?? 'Unlimited'); ?>

                                                </p>
                                            </div>
                                        </div>
                                        <div class="mt-3 row">
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-database me-2"></i>
                                                    Storage:</p>
                                                <p class="small text-muted">
                                                    <?php echo e($selectedPlanLimits->storage_limit_gb ?? 'Unlimited'); ?>

                                                    GB
                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-video me-2"></i>
                                                    Teleconsultation:
                                                </p>
                                                <p class="small text-muted">
                                                    <?php echo e($selectedPlanLimits->teleconsultation_minutes ?? 'Unlimited'); ?>

                                                    Minutes
                                                </p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="small mb-1"><i class="fas fa-sms me-2"></i>
                                                    SMS:</p>
                                                <p class="small text-muted">
                                                    <?php echo e($selectedPlanLimits->sms_limit ?? 'Unlimited'); ?>

                                                    Massages
                                                </p>
                                            </div>
                                        </div>

                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!--[if BLOCK]><![endif]--><?php if($showPlanSelection): ?>
                                    <div class="mt-4">
                                        <h6 class="mb-3">Select a Plan:</h6>
                                        <div class="row">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availablePlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-4 mb-3">
                                                    <div class="card plan-card h-100 cursor-pointer <?php echo e($selected_plan_id == $plan->id ? 'border-primary' : ''); ?>"
                                                        wire:click="$set('selected_plan_id', <?php echo e($plan->id); ?>)">
                                                        <div class="card-body">
                                                            <h5 class="card-title">
                                                                <?php echo e($plan->plan_name); ?>

                                                            </h5>
                                                            <h6 class="mb-3">
                                                                $<?php echo e(number_format($plan->base_price, 2)); ?>

                                                                <small
                                                                    class="text-muted">/<?php echo e($plan->plan_type); ?></small>
                                                            </h6>

                                                            <ul class="list-unstyled small">
                                                                <li class="mb-2">
                                                                    <i
                                                                        class="fas fa-check-circle text-success me-2"></i>
                                                                    <?php echo e($plan->max_doctors ?? 'Unlimited'); ?>

                                                                    Doctors
                                                                </li>
                                                                <li class="mb-2">
                                                                    <i
                                                                        class="fas fa-check-circle text-success me-2"></i>
                                                                    <?php echo e($plan->max_staff ?? 'Unlimited'); ?>

                                                                    Staff
                                                                </li>
                                                                <li class="mb-2">
                                                                    <i
                                                                        class="fas fa-check-circle text-success me-2"></i>
                                                                    <?php echo e($plan->device_limit ?? 'Unlimited'); ?>

                                                                    Devices
                                                                </li>
                                                                <!--[if BLOCK]><![endif]--><?php if($plan->trial_period): ?>
                                                                    <li class="mb-2">
                                                                        <i
                                                                            class="fas fa-check-circle text-success me-2"></i>
                                                                        <?php echo e($plan->trial_period); ?>

                                                                        day trial
                                                                    </li>
                                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                            </ul>

                                                            <!--[if BLOCK]><![endif]--><?php if($plan->discounted_price): ?>
                                                                <div class="badge bg-danger mb-2">
                                                                    Save
                                                                    <?php echo e(number_format(100 - ($plan->discounted_price / $plan->base_price) * 100, 0)); ?>%
                                                                </div>
                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <div class="d-flex justify-content-end mt-3">
                                            <button wire:click="togglePlanSelection" class="btn btn-secondary">
                                                Cancel
                                            </button>
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <p class="text-muted mb-3">No subscription plan selected
                        </p>
                        <button wire:click="togglePlanSelection" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add Subscription Plan
                        </button>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!-- Add On Plan Card -->
                <!--[if BLOCK]><![endif]--><?php if($showAddOnSelection || $selectedAddOnDetails): ?>
                    <div class="col-12">
                        <div class="card review-card">
                            <div class="card-header bg-transparent">
                                <div class="d-flex justify-content-between mt-3">
                                    <h5 class="mb-0"><i class="fas fa-credit-card me-2"></i>All
                                        Add On</h5>
                                    <!--[if BLOCK]><![endif]--><?php if(!$showAddOnSelection): ?>
                                        <button wire:click="toggleAddOnSelection"
                                            class="btn btn-sm btn-outline-primary">
                                            Change Add Ons
                                        </button>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                            <div class="card-body">
                                <!--[if BLOCK]><![endif]--><?php if($selectedAddOnDetails): ?>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $selectedAddOnDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addOn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="alert alert-primary">
                                            <div class="d-flex justify-content-between align-items-center">

                                                <div>
                                                    <h6 class="mb-1">
                                                        <?php echo e($addOn->name); ?>

                                                    </h6>
                                                </div>
                                                <div class="text-muted small">
                                                    <?php echo e(ucfirst($addOn->resource_type)); ?>

                                                    Add On • Per <?php echo e($addOn->unit); ?> Price
                                                    $<?php echo e(number_format($addOn->price_per_unit, 2)); ?>

                                                </div>
                                                <!--[if BLOCK]><![endif]--><?php if($addOn->price_per_unit): ?>
                                                    <div class="text-muted small">
                                                        Total amount •
                                                        <span class="text-danger ms-2">
                                                            
                                                            $<?php echo e(number_format($addOn->price_per_unit * $addOn->unit_counts, 2)); ?>

                                                        </span>
                                                    </div>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>

                                            <!--[if BLOCK]><![endif]--><?php if($addOn->description): ?>
                                                <div class="mt-3">
                                                    <p class="small mb-1">
                                                        <strong>Includes:</strong>
                                                    </p>
                                                    <p class="small text-muted">
                                                        <?php echo e($addOn->description); ?>

                                                    </p>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!--[if BLOCK]><![endif]--><?php if($showAddOnSelection): ?>
                                    <div class="mt-4">
                                        <h6 class="mb-3">Select an Add On:</h6>
                                        <div class="col-md-6">
                                            <label class="form-label">Clinic Add On
                                                (Optional)</label>
                                            <div class="dropdown">
                                                <!-- Dynamic dropdown button title -->
                                                <button class="form-select text-start dropdown-toggle" type="button"
                                                    id="addOnDropdown" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    <!--[if BLOCK]><![endif]--><?php if(count($selected_add_on_id) > 0): ?>
                                                        <?php echo e(count($selected_add_on_id)); ?>

                                                        <?php echo e(count($selected_add_on_id) == 1 ? 'Add On' : 'Add Ons'); ?>

                                                        Selected
                                                    <?php else: ?>
                                                        -- Select Add Ons --
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </button>

                                                <!-- Checkbox options -->
                                                <ul class="dropdown-menu w-100" aria-labelledby="addOnDropdown">
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableAddOns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addOn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li>
                                                            <div class="dropdown-item">
                                                                <input type="checkbox" wire:model="selected_add_on_id"
                                                                    value="<?php echo e($addOn->id); ?>"
                                                                    id="addon-<?php echo e($addOn->id); ?>"
                                                                    wire:change="updateSelectedCount">
                                                                <label for="addon-<?php echo e($addOn->id); ?>"
                                                                    class="ms-2">
                                                                    <?php echo e($addOn->name); ?>

                                                                    (<?php echo e($addOn->price_per_unit); ?>/<?php echo e($addOn->resource_type); ?>)
                                                                </label>
                                                            </div>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </ul>
                                            </div>

                                            <!-- Selected items details -->
                                            <!--[if BLOCK]><![endif]--><?php if(count($selected_add_on_id) > 0): ?>
                                                <div class="mt-2 small text-muted">
                                                    <strong>Selected:</strong>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableAddOns->whereIn('id', $selected_add_on_id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selected): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <span class="d-block">
                                                            <?php echo e($selected->name); ?>

                                                            (<?php echo e($selected->resource_type); ?>)
                                                        </span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <div class="d-flex justify-content-between mt-3">
                                            <button wire:click="toggleAddOnSelection" class="btn btn-success">
                                                Done
                                            </button>
                                            <button wire:click="toggleAddOnSelection" class="btn btn-secondary">
                                                Cancel
                                            </button>
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="text-center py-4">
                        <p class="text-muted mb-3">No Add On's selected
                        </p>
                        <button wire:click="toggleAddOnSelection" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add Add On
                        </button>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>
    <div class="card-footer">
        <div class="mt-4 d-flex justify-content-between">
            <button type="button" wire:click="previous" class="btn btn-secondary">Previous</button>
            <button type="button" wire:click="submit" class="btn btn-success">
                <i class="fas fa-check-circle me-2"></i>
                <?php echo e($isEditing ? 'Update Plan' : 'Create Plan'); ?>

            </button>
        </div>
    </div>
</div>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/subscription-plan-wizard/step5-review.blade.php ENDPATH**/ ?>