<?php $__env->startSection('title', 'Availability List'); ?>

<?php $__env->startSection('content'); ?>
<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>

    <div class="content">

        <!-- Start Page Header -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
            <div class="flex-grow-1">
                <h4 class="fw-bold mb-0">
                    Doctors Availability List
                    <!-- <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                         Availability
                    </span> -->
                </h4>
            </div>

            <div class="text-end d-flex">
                <a href="<?php echo e(route('availability.create')); ?>" class="btn btn-primary ms-2 fs-13 btn-md"><i
                        class="ti ti-plus me-1"></i>Add Availability</a>
            </div>
        </div>
        <!-- End Page Header -->

        <div class=" d-flex align-items-center justify-content-between flex-wrap row-gap-3">
            <div>
                <div class="search-set mb-3">
                    <div class="d-flex align-items-center flex-wrap gap-2">
                        <div class="table-search d-flex align-items-center mb-0">
                            <div class="search-input">
                                <input type="text" wire:model.live.debounce.300ms="searchTerm"
                                    class="form-control form-control-md" placeholder="Search doctors...">
                                <a href="javascript:void(0);" class="btn-searchset"></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- <div class="d-flex table-dropdown mb-3 pb-1 right-content align-items-center flex-wrap row-gap-3">
                <div class="dropdown me-2">
                    <a href="javascript:void(0);"
                        class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                        data-bs-toggle="dropdown" data-bs-auto-close="outside">
                        <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                    </a>
                    <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                        <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                            <h4 class="mb-0">Filter</h4>
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" wire:click="resetFilters"
                                    class="link-danger text-decoration-underline">Clear All</a>
                            </div>
                        </div>
                        <form wire:submit.prevent="applyFilters">
                            <div class="filter-body pb-0">
                                <!-- Status Filter --
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <label class="form-label">Status</label>
                                        <a href="javascript:void(0);" wire:click="$set('statusFilter', 'all')"
                                            class="link-primary mb-1">Reset</a>
                                    </div>
                                    <select class="form-select" wire:model="statusFilter">
                                        <option value="all">All Status</option>
                                        <option value="active">Active</option>
                                        <option value="inactive">Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                                <a href="javascript:void(0);" class="btn btn-light btn-md me-2" id="close-filter">Close</a>
                                <button type="submit" class="btn btn-primary btn-md">Apply Filters</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="dropdown">
                    <a href="javascript:void(0);"
                        class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                        data-bs-toggle="dropdown">
                        <span class="me-1"> Sort By : </span> Recent
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1">Recently Added</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1">Ascending</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1">Desending</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1">Last Month</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1">Last 7 Days</a>
                        </li>
                    </ul>
                </div>
            </div> -->
        </div>

        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead class="">
                    <tr>
                        <th class="no-sort">
                            Doctor Name
                        </th>
                        <th>Days</th>
                        <th>Slot Duration</th>
                        <th>Time Slot (From - To)</th>
                        <th>Fee</th>
                        <th>Status</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $availabilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $availability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <!-- Doctor Name + Avatar -->
                            <td>
                                <div class="d-flex align-items-center">
                                    <a href="#" class="text-dark fw-semibold">
                                        Dr. <?php echo e($availability->doctor_name); ?>

                                        <span class="text-body fs-13 fw-normal d-block"><?php echo e($availability->doctor_email); ?></span>
                                    </a>
                                </div>
                            </td>

                            <!-- Days -->
                            <td>
                                <?php $__currentLoopData = json_decode($availability->day, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $status = 'active'; // or make this dynamic if needed
                                    ?>
                                    <span class="badge <?php echo e($status === 'active' ? 'bg-success' : 'bg-secondary'); ?> me-1">
                                        <?php echo e(ucfirst($day)); ?>

                                    </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>

                            <!-- Slot Duration -->
                            <td><span class="fs-13"><?php echo e($availability->slot_duration); ?> Min</span></td>

                            <!-- Time Slot Range -->
                            <td><span class="fs-13"><?php echo e($availability->from_time); ?> - <?php echo e($availability->to_time); ?></span></td>

                            <!-- Fee Structure -->
                            <td>
                                <span class="fs-13 d-block"><strong>In-Person:</strong> ₹<?php echo e($availability->in_person_fee); ?></span>
                                <span class="fs-13 d-block"><strong>Video:</strong> ₹<?php echo e($availability->video_fee); ?></span>
                            </td>

                            <!-- Status -->
                            <td>
                                <?php if($availability->status == '1'): ?>
                                    <span class="badge badge-soft-success border border-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-soft-danger border border-danger">Inactive</span>
                                <?php endif; ?>
                            </td>

                            <!-- Actions -->
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="action-item">
                                        <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end bg-white">
                                            <li>
                                                <a href="<?php echo e(route('availability.edit', $availability->id)); ?>" class="dropdown-item d-flex align-items-center">
                                                    <i class="ti ti-edit me-2"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center view-slots" data-slots='<?php echo json_encode(json_decode($availability->time_slot), 15, 512) ?>'>
                                                    <i class="ti ti-eye me-2"></i> View Slots
                                                </a>
                                            </li>
                                            <li>
                                                <a href="<?php echo e(route('availability.toggle-status', $availability->id)); ?>" class="dropdown-item d-flex align-items-center">
                                                    <i class="ti ti-power me-2"></i>
                                                    <?php echo e($availability->status == 1 ? 'Deactivate' : 'Activate'); ?>

                                                </a>
                                            </li>
                                            <li>
                                                <form method="POST" action="<?php echo e(route('availability.destroy', $availability->id)); ?>" class="delete-form d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button" class="dropdown-item d-flex align-items-center text-danger confirm-delete" data-doctor="<?php echo e($availability->doctor_name); ?>">
                                                        <i class="ti ti-trash me-2"></i> Delete
                                                    </button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </div>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
            </table>
        </div>

        <style>
            .avatar-initial {
                width: 40px;
                height: 40px;
                font-size: 16px;
                font-weight: 600;
            }

            .avatar .avatar-initial {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            }

            .avatar-initial.bg-primary {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
            }

            .avatar-initial.bg-success {
                background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%) !important;
            }

            .avatar-initial.bg-info {
                background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%) !important;
            }

            .avatar-initial.bg-warning {
                background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%) !important;
            }

            .avatar-initial.bg-danger {
                background: linear-gradient(135deg, #fa709a 0%, #fee140 100%) !important;
            }

            .avatar-initial.bg-secondary {
                background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%) !important;
            }
        </style>
    </div>

    <script>
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".confirm-delete").forEach(function (button) {
            button.addEventListener("click", function () {
                const form = this.closest('form');
                const doctorName = this.dataset.doctor || 'this doctor';

                Swal.fire({
                    title: 'Are you sure?',
                    text: `You are about to delete ${doctorName}'s availability.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, delete it!',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        });
    });
</script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".view-slots").forEach(function (btn) {
            btn.addEventListener("click", function () {
                try {
                    const slots = JSON.parse(this.dataset.slots);

                    function to12Hour(timeRange) {
                        // e.g., "13:30 - 14:30"
                        return timeRange.split(' - ').map(time => {
                            const [hour, minute] = time.split(':');
                            const h = parseInt(hour);
                            const ampm = h >= 12 ? 'PM' : 'AM';
                            const hour12 = h % 12 || 12;
                            return `${hour12}:${minute} ${ampm}`;
                        }).join(' - ');
                    }

                    let slotHtml = `<div style="display: flex; flex-wrap: wrap; gap: 10px;">`;

                    slots.forEach(slot => {
                        const displaySlot = to12Hour(slot); // Convert to 12-hour
                        slotHtml += `
                            <div style="
                                border: 1px solid #ccc;
                                border-radius: 6px;
                                padding: 8px 12px;
                                background-color: #f9f9f9;
                                font-weight: 500;
                                font-size: 14px;
                                color: #333;
                            ">
                                ${displaySlot}
                            </div>`;
                    });

                    slotHtml += `</div>`;

                    Swal.fire({
                        title: 'Time Slots',
                        html: slotHtml,
                        icon: 'info',
                        confirmButtonText: 'OK',
                        width: '625px',
                    });

                } catch (e) {
                    Swal.fire('Error', 'Invalid slot data format', 'error');
                }
            });
        });
    });
</script>



<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/doctor/availability/availability-list.blade.php ENDPATH**/ ?>