<?php
    use App\Models\User;
    $isEditing = $editId !== null;
?>

<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="<?php echo e(route('admin.clinics.view', $clinic)); ?>" class="text-dark">
                        <i
                            class="ti ti-chevron-left me-1"></i><?php echo e(isset($editId) && $editId ? 'Edit Doctor' : 'Add New Doctor'); ?>

                    </a>
                </h6>
            </div>

            <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('message')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <?php if(session()->has('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            <form wire:submit.prevent="<?php echo e($isEditing ? 'updateDoctor' : 'createDoctor'); ?>">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($isEditing ? 'Edit Doctor' : 'Add New Doctor'); ?>

                            <!--[if BLOCK]><![endif]--><?php if($isEditing && $has_primary_clinic): ?>
                                <span class="badge bg-primary">
                                    Primary
                                </span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </h4>
                    </div>

                    <div class="card-body">
                        
                        <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('message')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <?php if(session()->has('error')): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php echo e(session('error')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        
                        <!--[if BLOCK]><![endif]--><?php if(!$editId): ?>
                            <div class="mb-3 col-md-12">
                                <label class="form-label d-block">Doctor Selection Mode</label>
                                <div class="form-check form-check-inline">
                                    <input type="radio" name="doctorMode" class="form-check-input" id="createMode"
                                        wire:click="toggleDoctorMode('create')" value="create"
                                        <?php if($doctorMode === 'create'): echo 'checked'; endif; ?>>
                                    <label class="form-check-label" for="createMode">Create New Doctor</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input type="radio" name="doctorMode" class="form-check-input" id="selectMode"
                                        wire:click="toggleDoctorMode('select')" value="select"
                                        <?php if($doctorMode === 'select'): echo 'checked'; endif; ?>>
                                    <label class="form-check-label" for="selectMode">Select Existing Doctor</label>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        
                        <!--[if BLOCK]><![endif]--><?php if($doctorMode === 'select'): ?>
                            <div class="mb-3 col-md-6" x-data>
                                <label class="form-label">Select Doctor</label>

                                <div class="position-relative">
                                    <input type="text" class="form-control" placeholder="Search doctor..."
                                        wire:model.live.debounce.300ms="searchTerm" @focus="dropdownVisible = true"
                                        x-ref="searchInput">

                                    <!--[if BLOCK]><![endif]--><?php if($dropdownVisible): ?>
                                        <div class="mt-1 dropdown-menu d-block position-absolute w-100 bg-white"
                                            style="z-index: 1000; max-height: 300px; overflow-y: auto;">
                                            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $existingDoctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <button type="button" class="dropdown-item"
                                                    wire:click="selectDoctor(<?php echo e($doctor->id); ?>)">
                                                    <?php echo e($doctor->name); ?> (<?php echo e($doctor->email); ?>)
                                                </button>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <div class="dropdown-item text-muted">No doctor found</div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <!--[if BLOCK]><![endif]--><?php if($selectedExistingDoctor): ?>
                                    <div class="p-2 mt-2 rounded bg-light">
                                        <strong>Selected:</strong>
                                        <?php echo e(optional(User::find($selectedExistingDoctor))->name); ?>

                                        <button type="button" class="btn btn-sm btn-link text-danger"
                                            wire:click="$set('selectedExistingDoctor', null)">
                                            Clear
                                        </button>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedExistingDoctor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($doctorMode === 'create' && !$editId): ?>
                            <div class="row">
                                
                                <div class="col-12">
                                    <h6 class="text-muted mb-3">Basic Information</h6>
                                </div>

                                <!-- Profile Image -->
                                <div class="col-lg-12">
                                    <div class="mb-3 d-flex align-items-center">
                                        <label class="form-label mb-0 fw-medium">Profile Image</label>
                                        <div
                                            class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 ms-4 p-0">

                                            <?php
                                                $imageUrl = $this->getProfileImageUrl();
                                            ?>

                                            <!--[if BLOCK]><![endif]--><?php if($imageUrl): ?>
                                                <!-- Show current image -->
                                                <img src="<?php echo e($imageUrl); ?>" alt="Profile" class="w-100 h-100"
                                                    style="object-fit: cover;">
                                                <!-- Remove button -->
                                                <div class="position-absolute top-0 end-0 m-1">
                                                    <button type="button" wire:click="removeProfileImage"
                                                        class="btn btn-danger btn-sm rounded-circle p-1"
                                                        style="width: 24px; height: 24px; z-index: 10;">
                                                        <i class="ti ti-x fs-12"></i>
                                                    </button>
                                                </div>
                                            <?php else: ?>
                                                <!-- Show placeholder when no image -->
                                                <i class="ti ti-user-plus fs-16"></i>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                            <!-- File input -->
                                            <input type="file" wire:model="profile_image"
                                                class="form-control image-sign position-absolute top-0 start-0 w-100 h-100 opacity-0"
                                                accept="image/*" style="cursor: pointer;">

                                            <!-- Camera icon overlay -->
                                            <div class="position-absolute bottom-0 end-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center"
                                                style="z-index: 1;">
                                                <span
                                                    class="text-white d-flex align-items-center justify-content-center">
                                                    <i class="ti ti-photo fs-14"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Loading indicator -->
                                    <div wire:loading wire:target="profile_image" class="text-primary">
                                        <small><i class="spinner-border spinner-border-sm me-1"></i>Uploading
                                            image...</small>
                                    </div>

                                    <!-- Error display -->
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['profile_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="name" class="form-label">Name <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="name" wire:model="name" placeholder="Enter doctor's full name">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email <span
                                            class="text-danger">*</span></label>
                                    <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="email" wire:model="email" placeholder="doctor@example.com">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label mb-1 fw-medium">Status<span
                                                class="text-danger ms-1">*</span></label>
                                        <select class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            wire:model="status">
                                            <option value="active">Active</option>
                                            <option value="inactive">Inactive</option>
                                        </select>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                
                                <div class="col-12 mt-4">
                                    <h6 class="text-muted mb-3">Professional Information</h6>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="specialization" class="form-label">Specialization <span
                                            class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control <?php $__errorArgs = ['specialization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="specialization" wire:model="specialization"
                                        placeholder="e.g., Cardiology, Pediatrics">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['specialization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="license_number" class="form-label">License Number <span
                                            class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control <?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="license_number" wire:model="license_number"
                                        placeholder="Medical license number">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="qualifications" class="form-label">Qualifications</label>
                                    <input type="text"
                                        class="form-control <?php $__errorArgs = ['qualifications'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="qualifications" wire:model="qualifications"
                                        placeholder="e.g., MD, MBBS, PhD">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['qualifications'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="experience_years" class="form-label">Years of Experience</label>
                                    <input type="number"
                                        class="form-control <?php $__errorArgs = ['experience_years'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="experience_years" wire:model="experience_years" min="0"
                                        placeholder="0">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['experience_years'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <div class="col-12 mb-3">
                                    <label for="bio" class="form-label">Bio</label>
                                    <textarea class="form-control <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="bio" rows="3" wire:model="bio"
                                        placeholder="Brief description about the doctor's background and expertise"></textarea>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($editId): ?>
                            <div class="row">
                                
                                <div class="col-12">
                                    <h6 class="text-muted mb-3">Basic Information</h6>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="name" class="form-label">Name <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="name" wire:model="name" placeholder="Enter doctor's full name"
                                        readonly>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email <span
                                            class="text-danger">*</span></label>
                                    <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="email" wire:model="email" placeholder="doctor@example.com" readonly>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        
                        
                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="fw-bold mb-0">Doctor Permissions</h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive border">
                                    <table class="table table-nowrap">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Module</th>
                                                <th>CREATE</th>
                                                <th>EDIT</th>
                                                <th>DELETE</th>
                                                <th>VIEW</th>
                                                <th>TOGGLE ALL</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $permissionGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $groupPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $allChecked =
                                                        count(array_intersect($groupPermissions, $permissions)) ===
                                                            count($groupPermissions) ||
                                                        $groupName === 'Dashboard Access';
                                                    $isDisabled = in_array($groupName, [
                                                        'Appointment Management',
                                                        'Medical Records',
                                                        'Financial',
                                                        'Staff Management',
                                                    ]);
                                                ?>
                                                <tr>
                                                    <td>
                                                        <p class="fw-medium text-dark"><?php echo e($groupName); ?></p>
                                                    </td>
                                                    <?php
                                                        $permissionTypes = ['create', 'edit', 'delete', 'view'];
                                                        $permissionColumns = [];

                                                        foreach ($permissionTypes as $type) {
                                                            $permissionColumns[$type] = false;
                                                            foreach ($groupPermissions as $permission) {
                                                                if (str_contains($permission, $type)) {
                                                                    $permissionColumns[$type] = $permission;
                                                                    break;
                                                                }
                                                            }
                                                        }

                                                        if ($groupName === 'Dashboard Access') {
                                                            $permissionColumns['view'] = 'access admin dashboard';
                                                        }
                                                    ?>

                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $permissionTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <td>
                                                            <!--[if BLOCK]><![endif]--><?php if($permissionColumns[$type]): ?>
                                                                <div class="form-check form-check-md">
                                                                    <input class="form-check-input" type="checkbox"
                                                                        id="perm_<?php echo e($permissionColumns[$type]); ?>"
                                                                        <?php if(
                                                                            $permissionColumns[$type] === 'access admin dashboard' ||
                                                                                (is_array($permissions) && in_array($permissionColumns[$type], $permissions))): echo 'checked'; endif; ?>
                                                                        <?php if($permissionColumns[$type] === 'access admin dashboard' || $isDisabled): echo 'disabled'; endif; ?>
                                                                        wire:click="togglePermission('<?php echo e($permissionColumns[$type]); ?>')">
                                                                    <!--[if BLOCK]><![endif]--><?php if($permissionColumns[$type] === 'access admin dashboard'): ?>
                                                                        <span class="text-muted">(Required)</span>
                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                </div>
                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                        </td>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                                                    <td>
                                                        <button type="button"
                                                            class="btn btn-sm <?php echo e($allChecked ? 'btn-outline-danger' : 'btn-outline-primary'); ?>"
                                                            wire:click="toggleAllPermissionsInGroup('<?php echo e($groupName); ?>')"
                                                            <?php if($permissionColumns[$type] === 'access admin dashboard' || $isDisabled): echo 'disabled'; endif; ?>>
                                                            <?php echo e($allChecked ? 'Deny All' : 'Allow All'); ?>

                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </tbody>
                                    </table>
                                </div>

                                <!--[if BLOCK]><![endif]--><?php if($doctorMode === 'create' && !$editId): ?>
                                    <div class="alert alert-warning mt-3">
                                        A default password will be generated for the new sub doctor. They can reset it
                                        via the "Forgot Password" option.
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['permissions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>



                    
                    <div class="card-footer d-flex justify-content-between">
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>
                                <?php echo e($isEditing ? 'Update Doctor' : 'Create Doctor'); ?>

                            </button>
                        </div>

                        <div>
                            <a href="<?php echo e(route('admin.clinics.view', $clinic)); ?>" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>
                                Cancel
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH /var/www/predcare/resources/views/livewire/doctor/doctor/doctor-form.blade.php ENDPATH**/ ?>