<?php $__env->startSection('title', 'Add Availability'); ?>

<?php $__env->startSection('content'); ?>
<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>

    <div class="content">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <!-- Page Header -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-0 d-flex align-items-center">
                        <a href="<?php echo e(route('availability.list')); ?>" class="text-dark">
                            <i class="ti ti-chevron-left me-1"></i>Doctor Availability
                        </a>
                    </h6>
                </div>

                <!-- Form Start -->
                <form action="<?php echo e(route('availability.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Add New Availability</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Select Doctor <span class="text-danger">*</span></label>
                                    <select class="form-select" name="doctor_id" required>
                                        <option value="">Select Any one</option>
                                        <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($entry->doctor->id); ?>"><?php echo e($entry->doctor->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <!-- Clinic ID (Hidden or visible) -->
                                    <input type="hidden" name="clinic_id" value="<?php echo e($entry->clinic->id); ?>">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Slot Duration <span class="text-danger">*</span></label>
                                    <select class="form-select" name="slot_duration" required>
                                        <option value="">Select</option>
                                        <option value="15">15 minutes</option>
                                        <option value="30">30 minutes</option>
                                        <option value="60">60 minutes</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">From</label>
                                        <input type="time" class="form-control" name="from_time" required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">To</label>
                                        <input type="time" class="form-control" name="to_time" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="row">
                                        <label class="form-label">Select Days</label>
                                        <?php $__currentLoopData = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-3 mt-2">
                                                <ul class="list-group">
                                                    <li class="list-group-item">
                                                        <div class="form-check">
                                                            <input class="form-check-input me-1" type="checkbox" name="days[]" value="<?php echo e($day); ?>" id="day_<?php echo e($day); ?>">
                                                            <label class="form-check-label" for="day_<?php echo e($day); ?>"><?php echo e($day); ?></label>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">Doctor Fee</label>
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">In-Person Fee</label>
                                                    <input type="number" class="form-control" name="in_person_fee" placeholder="Enter the fee" min="0" required>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Video Fee</label>
                                                    <input type="number" class="form-control" name="video_fee" placeholder="Enter the fee" min="0" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-between">
                            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i> Create Slot</button>
                            <a href="<?php echo e(route('availability.list')); ?>" class="btn btn-secondary"><i class="fas fa-times me-2"></i> Cancel</a>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/doctor/availability/availability-form.blade.php ENDPATH**/ ?>