<div class="content">
    <!-- Page Header -->
    <?php $__env->slot('title'); ?>
        Patient Management
    <?php $__env->endSlot(); ?>
    <?php $__env->slot('li_1'); ?>
        Manage Patients
    <?php $__env->endSlot(); ?>

    <!-- /Page Header -->

    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="<?php echo e(route('doctor.patient.list')); ?>" class="text-dark">
                        <i
                            class="ti ti-chevron-left me-1"></i><?php echo e($userIdBeingEdited ? 'Edit Patient' : 'Add New Patient'); ?>

                    </a>
                </h6>
            </div>
            <!-- page header end -->

            <!-- card start -->
            <div class="card">
                <div class="card-body pb-0">
                    <div id="patient-form" class="form">
                        <h6 class="fw-bold mb-3">Patient Information</h6>

                        <div class="row">
                            <!-- Profile Image -->
                            <div class="col-lg-12">
                                <div class="mb-3 d-flex align-items-center">
                                    <label class="form-label mb-0 fw-medium">Profile Image</label>
                                    <div class="position-relative ms-4">
                                        <div
                                            class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 p-0">
                                            <!--[if BLOCK]><![endif]--><?php if($profileImage): ?>
                                                <!-- Preview new image -->
                                                <img src="<?php echo e($profileImage->temporaryUrl()); ?>" alt="Preview"
                                                    class="w-100 h-100 object-fit-cover rounded-circle">
                                            <?php elseif($currentProfileImage): ?>
                                                <!-- Show existing image -->
                                                <img src="<?php echo e(Storage::url($currentProfileImage)); ?>"
                                                    alt="Current Profile"
                                                    class="w-100 h-100 object-fit-cover rounded-circle">
                                            <?php else: ?>
                                                <!-- Default icon -->
                                                <i class="ti ti-user-plus fs-16"></i>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                            <input type="file" wire:model="profileImage"
                                                class="position-absolute top-0 start-0 w-100 h-100 opacity-0 cursor-pointer"
                                                accept="image/*">

                                            <div
                                                class="position-absolute bottom-0 end-0 start-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center z-n1">
                                                <a href="javascript:void(0);"
                                                    class="text-white d-flex align-items-center justify-content-center">
                                                    <i class="ti ti-photo fs-14"></i>
                                                </a>
                                            </div>
                                        </div>

                                        <!--[if BLOCK]><![endif]--><?php if($profileImage || $currentProfileImage): ?>
                                            <button type="button" wire:click="$set('profileImage', null)"
                                                class="btn btn-sm btn-danger position-absolute top-0 end-0 rounded-circle p-1"
                                                style="transform: translate(25%, -25%);">
                                                <i class="ti ti-x fs-12"></i>
                                            </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['profileImage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->

                                <!-- Loading indicator for file upload -->
                                <div wire:loading wire:target="profileImage" class="text-info small">
                                    <i class="spinner-border spinner-border-sm me-1"></i>
                                    Uploading image...
                                </div>
                            </div>

                            <!-- Doctor and Clinic Assignment -->
                            <!--[if BLOCK]><![endif]--><?php if(!empty($doctors)): ?>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="selectedDoctor" class="form-label mb-1 fw-medium">Assign Doctor<span
                                                class="text-danger ms-1">*</span></label>
                                        <select wire:model.live="selectedDoctor" id="selectedDoctor" class="form-select">
                                            <option value="">Select Doctor</option>
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($doctor['id']); ?>"><?php echo e($doctor['name']); ?>

                                                    (<?php echo e($doctor['email']); ?>)
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </select>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedDoctor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Patient Mode Selection -->
                            <!--[if BLOCK]><![endif]--><?php if(!$userIdBeingEdited): ?>
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label mb-1 fw-medium d-block">Patient Selection Mode</label>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" name="patientMode" class="form-check-input"
                                                id="createMode" wire:click="togglePatientMode('create')" value="create"
                                                <?php if($patientMode === 'create'): echo 'checked'; endif; ?>>
                                            <label class="form-check-label" for="createMode">Create New Patient</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" name="patientMode" class="form-check-input"
                                                id="selectMode" wire:click="togglePatientMode('select')" value="select"
                                                <?php if($patientMode === 'select'): echo 'checked'; endif; ?>>
                                            <label class="form-check-label" for="selectMode">Select Existing
                                                User</label>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Existing User Selection -->
                            <!--[if BLOCK]><![endif]--><?php if($patientMode === 'select'): ?>
                                <div class="col-md-12" x-data="{ dropdownOpen: <?php if ((object) ('dropdownVisible') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('dropdownVisible'->value()); ?>')<?php echo e('dropdownVisible'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('dropdownVisible'); ?>')<?php endif; ?> }">
                                    <div class="mb-3">
                                        <label class="form-label mb-1 fw-medium">Select User<span
                                                class="text-danger ms-1">*</span></label>

                                        <div class="position-relative">
                                            <input type="text" class="form-control" placeholder="Search users..."
                                                wire:model.live.debounce.300ms="searchTerm"
                                                @focus="$wire.set('dropdownVisible', true)"
                                                @click.away="$wire.set('dropdownVisible', false)">

                                            <!--[if BLOCK]><![endif]--><?php if($dropdownVisible && count($existingUsers) > 0): ?>
                                                <div class="mt-1 dropdown-menu d-block position-absolute w-100 bg-white"
                                                    style="z-index: 1000; max-height: 300px; overflow-y: auto;">
                                                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $existingUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <button type="button"
                                                            class="dropdown-item d-flex justify-content-between"
                                                            wire:click="selectUser(<?php echo e($user->id); ?>)">
                                                            <span><?php echo e($user->name); ?></span>
                                                            <small class="text-muted"><?php echo e($user->email); ?></small>
                                                        </button>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <div class="dropdown-item text-muted">No users found</div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!--[if BLOCK]><![endif]--><?php if($selectedExistingUser): ?>
                                            <?php
                                                $selectedUser = \App\Models\User::find($selectedExistingUser);
                                            ?>
                                            <div
                                                class="p-2 mt-2 rounded bg-light d-flex justify-content-between align-items-center">
                                                <div>
                                                    <strong>Selected:</strong> <?php echo e($selectedUser->name); ?>

                                                    <br>
                                                    <small class="text-muted"><?php echo e($selectedUser->email); ?></small>
                                                </div>
                                                <button type="button" class="btn btn-sm btn-outline-danger"
                                                    wire:click="$set('selectedExistingUser', null)">
                                                    <i class="fas fa-times"></i> Clear
                                                </button>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedExistingUser'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Name Fields -->
                            <!--[if BLOCK]><![endif]--><?php if($patientMode === 'create' || $userIdBeingEdited): ?>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="name" class="form-label mb-1 fw-medium">Full Name<span
                                                class="text-danger ms-1">*</span></label>
                                        <input wire:model="name" type="text" id="name" class="form-control"
                                            placeholder="John Doe"
                                            <?php echo e($patientMode === 'select' && $selectedExistingUser ? 'readonly' : ''); ?>>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label mb-1 fw-medium">Email Address<span
                                                class="text-danger ms-1">*</span></label>
                                        <input wire:model="email" type="email" id="email" class="form-control"
                                            placeholder="example@email.com"
                                            <?php echo e($patientMode === 'select' && $selectedExistingUser ? 'readonly' : ''); ?>>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <!-- Password fields only for create mode -->
                                <!--[if BLOCK]><![endif]--><?php if($patientMode === 'create' || $userIdBeingEdited): ?>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="password" class="form-label mb-1 fw-medium">
                                                Password
                                                <!--[if BLOCK]><![endif]--><?php if($userIdBeingEdited): ?>
                                                    <small class="text-muted">(Leave blank to keep current)</small>
                                                <?php else: ?>
                                                    <span class="text-danger ms-1">*</span>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </label>
                                            <input wire:model="password" type="password" id="password"
                                                class="form-control"
                                                placeholder="<?php echo e($userIdBeingEdited ? 'Leave blank to keep current' : 'Password'); ?>">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="password_confirmation"
                                                class="form-label mb-1 fw-medium">Confirm Password</label>
                                            <input wire:model="password_confirmation" type="password"
                                                id="password_confirmation" class="form-control"
                                                placeholder="Confirm Password">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Patient Details -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="phone" class="form-label mb-1 fw-medium">Phone Number<span
                                            class="text-danger ms-1">*</span></label>
                                    <input wire:model="phone" type="tel" id="phone" class="form-control"
                                        placeholder="+1234567890">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="date_of_birth" class="form-label mb-1 fw-medium">DOB<span
                                            class="text-danger ms-1">*</span></label>
                                    <div class="input-icon-end position-relative">
                                        <input wire:ignore id="date_of_birth" type="text"
                                            class="form-control datetimepicker" placeholder="dd/mm/yyyy">
                                        <span class="input-icon-addon">
                                            <i class="ti ti-calendar"></i>
                                        </span>
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label mb-1 fw-medium">Gender<span
                                            class="text-danger ms-1">*</span></label>
                                    <select wire:model="gender" class="form-select">
                                        <option value="">Select</option>
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                        <option value="other">Other</option>
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label mb-1 fw-medium">Status<span
                                            class="text-danger ms-1">*</span></label>
                                    <div class="mt-2">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" wire:model="status"
                                                id="statusActive" value="active">
                                            <label class="form-check-label" for="statusActive">Active</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" wire:model="status"
                                                id="statusInactive" value="inactive">
                                            <label class="form-check-label" for="statusInactive">Inactive</label>
                                        </div>
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="medical_history" class="form-label mb-1 fw-medium">Medical
                                        History</label>
                                    <textarea wire:model="medical_history" id="medical_history" class="form-control" rows="3"
                                        placeholder="Any known medical conditions..."></textarea>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['medical_history'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="notes" class="form-label mb-1 fw-medium">Additional Notes</label>
                                    <textarea wire:model="notes" id="notes" class="form-control" rows="2"
                                        placeholder="Any additional notes about this patient assignment..."></textarea>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        </div>

                        <h6 class="fw-bold mb-3 border-top pt-3">Address Information</h6>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="address" class="form-label mb-1 fw-medium">Address<span
                                            class="text-danger ms-1">*</span></label>
                                    <textarea wire:model="address" id="address" class="form-control" placeholder="Enter full street address, city, state, and zip code"></textarea>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        </div>

                        <!-- Password Note for new patients -->
                        <!--[if BLOCK]><![endif]--><?php if($patientMode === 'create' && !$userIdBeingEdited): ?>
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i>
                                <strong>Note:</strong> A password is required for new patients. They can change it later
                                through their profile.
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Assignment Note for existing users -->
                        <!--[if BLOCK]><![endif]--><?php if($patientMode === 'select' && !$userIdBeingEdited): ?>
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle"></i>
                                <strong>Note:</strong> This will assign the selected user as a patient to the chosen
                                clinic and doctor. They will receive an email notification.
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <!-- card end -->

            <div class="d-flex align-items-center justify-content-end">
                <button type="button" wire:click="resetForm" class="btn btn-light me-2">
                    <i class="ti ti-refresh"></i> Reset Form
                </button>
                <button wire:click="save" wire:loading.attr="disabled" class="btn btn-primary">
                    <span wire:loading.remove>
                        <!--[if BLOCK]><![endif]--><?php if($userIdBeingEdited): ?>
                            <i class="ti ti-device-floppy"></i> Update Patient
                        <?php elseif($patientMode === 'select'): ?>
                            <i class="ti ti-user-plus"></i> Assign as Patient
                        <?php else: ?>
                            <i class="ti ti-plus"></i> Add New Patient
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </span>
                    <span wire:loading>
                        <i class="ti ti-loader fa-spin"></i> Processing...
                    </span>
                </button>
            </div>

        </div>
    </div>
    <!-- row end -->
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('scroll-to-form', () => {
                document.getElementById('patient-form').scrollIntoView({
                    behavior: 'smooth'
                });
            });

            // Handle clicking outside dropdown to close it
            document.addEventListener('click', function(event) {
                const dropdown = document.querySelector('.dropdown-menu');
                const input = document.querySelector('input[placeholder="Search users..."]');

                if (dropdown && input && !dropdown.contains(event.target) && !input.contains(event
                        .target)) {
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('dropdownVisible', false);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .dropdown-menu {
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }

        .dropdown-item:hover {
            background-color: #f8f9fa;
        }

        .dropdown-item:active {
            background-color: #e9ecef;
        }

        .form-check-input:checked {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }

        .alert {
            border: none;
            border-radius: 0.5rem;
        }

        .alert-info {
            background-color: #d1ecf1;
            color: #0c5460;
        }

        .alert-warning {
            background-color: #fff3cd;
            color: #856404;
        }

        .input-icon-addon {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            color: #6c757d;
        }

        .drag-upload-btn {
            width: 80px;
            height: 80px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
        }

        .drag-upload-btn input[type="file"] {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            cursor: pointer;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/predcare/resources/views/livewire/doctor/patient/patient-management.blade.php ENDPATH**/ ?>