<div class="content pb-0">
    <!-- Start Page Header -->
    <div class="mb-3">
        <h6 class="fw-semibold fs-14 mb-0">
            <a href="<?php echo e(back()->getTargetUrl()); ?>"><i class="ti ti-chevron-left me-1"></i>Doctors</a>
        </h6>
    </div>
    <!-- End Page Header -->

    <div class="card">
        <div class="card-body d-flex align-items-center justify-content-between flex-wrap row-gap-3">
            <div class="d-flex align-items-center flex-sm-nowrap flex-wrap row-gap-3">
                <img src="<?php echo e(asset('assets/img/icons/shape-01.svg')); ?>" alt="img" class="z-n1 position-absolute end-0 top-0 d-none d-lg-flex">
                <div class="me-3 doctor-profile-img">
                    <!--[if BLOCK]><![endif]--><?php if($doctor->profile_photo_url): ?>
                        <img src="<?php echo e($doctor->profile_photo_url); ?>" class="rounded" alt="Doctor Photo"
                            style="width: 120px; height: 120px; object-fit: cover;">
                    <?php else: ?>
                        <?php echo $doctor->getInitialsAvatar(); ?>

                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="flex-fill">
                    <div class="d-flex align-items-center mb-1">
                        <h6 class="mb-0 fw-semibold"><?php echo e($doctor->name); ?></h6>
                        <span class="badge border bg-white text-dark fw-medium ms-2">
                            <i class="ti ti-point-filled me-1 text-info"></i>
                            <?php echo e($doctor->doctor->specialization ?? ($doctor->doctorProfile->specialization ?? 'N/A')); ?>

                        </span>
                    </div>
                    <span class="d-block mb-3 fs-13"><?php echo e($doctor->doctor->qualifications ?? 'N/A'); ?></span>
                    <div class="d-flex align-items-center">
                        <!--[if BLOCK]><![endif]--><?php if($primaryClinic): ?>
                            <p class="mb-0 fs-13"><i class="ti ti-building-hospital me-1"></i>
                                Clinic : <?php echo e($primaryClinic->name); ?>

                            </p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <span
                            class="badge badge-soft-<?php echo e($doctor->status === 'active' ? 'success' : 'danger'); ?> fw-medium ms-2">
                            <i
                                class="ti ti-point-filled me-1 text-<?php echo e($doctor->status === 'active' ? 'success' : 'danger'); ?>"></i>
                            <?php echo e(ucfirst($doctor->status)); ?>

                        </span>
                    </div>
                </div>
            </div>
            <div>
                <!--[if BLOCK]><![endif]--><?php if($primaryClinic && $primaryClinic->pivot): ?>
                    <p class="mb-2">Consultation Charge</p>
                    <h6 class="fs-18 fw-bold mb-3">
                        ₹<?php echo e(number_format($primaryClinic->pivot->in_person_fee ?? 0, 2)); ?>

                        <span class="fw-normal text-body fs-14"> /
                            <?php echo e($primaryClinic->pivot->in_person_duration ?? 30); ?> Min</span>
                    </h6>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <a href="#" class="btn btn-primary"><i class="ti ti-calendar-event me-1"></i>Book Appointment</a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- Availability Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Availability</h5>
                    <ul class="nav nav-tabs nav-bordered nav-border-bottom mb-3">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item flex-fill">
                                <a class="nav-link text-center fw-semibold <?php echo e($loop->first ? 'active' : ''); ?>"
                                    href="javascript:void(0);" data-bs-toggle="tab"
                                    data-bs-target="#available-tab-<?php echo e($loop->index + 1); ?>">
                                    <?php echo e($day); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </ul>
                    <div class="tab-content" id="pills-tabContent">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = range(1, 5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="tab-pane fade <?php echo e($loop->first ? 'active show' : ''); ?>"
                                id="available-tab-<?php echo e($day); ?>" role="tabpanel">
                                <div class="d-flex align-items-center flex-wrap gap-2">
                                    <!-- You would replace this with actual availability data -->
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = ['11:30 AM - 12:30 PM', '12:30 PM - 01:30 PM', '02:30 PM - 03:30 PM']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $time): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="#"
                                            class="d-inline-flex align-items-center bg-light rounded flex-fill text-center justify-content-center p-1 text-dark">
                                            <?php echo e($time); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Bio Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Short Bio</h5>
                    <p><?php echo e($doctor->doctor->bio ?? ($doctor->doctorProfile->bio ?? 'No biography available.')); ?></p>
                    <!--[if BLOCK]><![endif]--><?php if(
                        ($doctor->doctor->bio ?? $doctor->doctorProfile->bio) &&
                            strlen($doctor->doctor->bio ?? $doctor->doctorProfile->bio) > 200): ?>
                        <div class="more-menu" style="display: none;">
                            <p><?php echo e(substr($doctor->doctor->bio ?? $doctor->doctorProfile->bio, 200)); ?></p>
                        </div>
                        <div class="view-all mt-2">
                            <a href="javascript:void(0);" class="viewall-button text-primary fw-medium">
                                <span>See More</span>
                                <i class="ti ti-chevron-down fs-10 ms-2"></i>
                            </a>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>

            <!-- Education Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Education Information</h5>
                    <ul class="activity-feed rounded">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2"><?php echo e($education->institution); ?> - <?php echo e($education->degree); ?></h6>
                                <!--[if BLOCK]><![endif]--><?php if($education->field_of_study): ?>
                                    <p class="mb-1"><?php echo e($education->field_of_study); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <p>
                                    <?php echo e($education->start_year); ?> -
                                    <!--[if BLOCK]><![endif]--><?php if($education->is_current): ?>
                                        Present
                                    <?php else: ?>
                                        <?php echo e($education->end_year); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </p>
                                <!--[if BLOCK]><![endif]--><?php if($education->description): ?>
                                    <p class="mt-2"><?php echo e($education->description); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <li class="feed-item timeline-item">
                                <p>No education information available.</p>
                            </li>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </ul>
                </div>
            </div>

            <!-- Experience Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Work Experience</h5>
                    <ul class="activity-feed rounded">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2"><?php echo e($experience->position); ?> at
                                    <?php echo e($experience->organization); ?></h6>
                                <p>
                                    <?php echo e($experience->start_date->format('M Y')); ?> -
                                    <!--[if BLOCK]><![endif]--><?php if($experience->is_current): ?>
                                        Present
                                    <?php else: ?>
                                        <?php echo e($experience->end_date->format('M Y')); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </p>
                                <!--[if BLOCK]><![endif]--><?php if($experience->description): ?>
                                    <p class="mt-2"><?php echo e($experience->description); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <li class="feed-item timeline-item">
                                <p>No work experience information available.</p>
                            </li>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </ul>
                </div>
            </div>

            <!-- Clinics Section -->
            <!--[if BLOCK]><![endif]--><?php if($clinics->isNotEmpty()): ?>
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">Associated Clinics</h5>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Clinic Name</th>
                                        <th>Status</th>
                                        <th>Services</th>
                                        <th>Fees</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $clinics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php echo e($clinic->name); ?>

                                                <!--[if BLOCK]><![endif]--><?php if($clinic->pivot->is_primary): ?>
                                                    <span class="badge bg-primary ms-2">Primary</span>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </td>
                                            <td>
                                                <span
                                                    class="badge badge-soft-<?php echo e($clinic->pivot->status === 'active' ? 'success' : 'danger'); ?>">
                                                    <?php echo e(ucfirst($clinic->pivot->status)); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <!--[if BLOCK]><![endif]--><?php if($clinic->pivot->offers_in_person): ?>
                                                    In-Person
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                <!--[if BLOCK]><![endif]--><?php if($clinic->pivot->offers_video): ?>
                                                    Video
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                <!--[if BLOCK]><![endif]--><?php if($clinic->pivot->offers_home_visit): ?>
                                                    Home Visit
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </td>
                                            <td>
                                                <!--[if BLOCK]><![endif]--><?php if($clinic->pivot->offers_in_person): ?>
                                                    ₹<?php echo e(number_format($clinic->pivot->in_person_fee, 2)); ?>

                                                    (<?php echo e($clinic->pivot->in_person_duration); ?> min)
                                                    <br>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                <!--[if BLOCK]><![endif]--><?php if($clinic->pivot->offers_video): ?>
                                                    ₹<?php echo e(number_format($clinic->pivot->video_fee, 2)); ?>

                                                    (<?php echo e($clinic->pivot->video_duration); ?> min)<br>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                <!--[if BLOCK]><![endif]--><?php if($clinic->pivot->offers_home_visit): ?>
                                                    ₹<?php echo e(number_format($clinic->pivot->home_visit_fee, 2)); ?>

                                                    (<?php echo e($clinic->pivot->home_visit_duration); ?> min)
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!-- Certifications Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Certifications & Licenses</h5>
                    <div class="mb-3">
                        <div class="d-flex align-items-center mb-2">
                            <span class="me-2"><i class="ti ti-award"></i></span>
                            <h6 class="mb-0 fw-bold">License:
                                <?php echo e($doctor->doctor->license_number ?? ($doctor->doctorProfile->license_number ?? 'N/A')); ?>

                            </h6>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->license_state): ?>
                            <p>State: <?php echo e($doctor->doctorProfile->license_state); ?></p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->license_valid_until): ?>
                            <p>Valid Until: <?php echo e($doctor->doctorProfile->license_valid_until->format('M d, Y')); ?></p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->certificates): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $doctor->doctorProfile->certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-3">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="me-2"><i class="ti ti-certificate"></i></span>
                                    <h6 class="mb-0 fw-bold"><?php echo e($certificate['name'] ?? 'Certificate'); ?></h6>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php if(isset($certificate['date'])): ?>
                                    <p>Date: <?php echo e($certificate['date']); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if(isset($certificate['issuer'])): ?>
                                    <p>Issuer: <?php echo e($certificate['issuer']); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>

        <!-- Sidebar Section -->
        <div class="col-xl-4 theiaStickySidebar">
            <div class="card">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">About</h6>
                    <div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-file"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Medical License Number</h6>
                                <p><?php echo e($doctor->doctor->license_number ?? ($doctor->doctorProfile->license_number ?? 'N/A')); ?>

                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-phone"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Phone Number</h6>
                                <p><?php echo e($doctor->phone ?? 'N/A'); ?></p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-mail"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Email Address</h6>
                                <p><?php echo e($doctor->email); ?></p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-user-check"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Years of Experience</h6>
                                <p><?php echo e($doctor->doctor->experience_years ?? ($doctor->doctorProfile->years_of_experience ?? '0')); ?>

                                    Years</p>
                            </div>
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->languages_spoken): ?>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-language"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Languages Spoken</h6>
                                    <p><?php echo e(implode(', ', $doctor->doctorProfile->languages_spoken)); ?></p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->sub_specializations): ?>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-stethoscope"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Sub-specializations</h6>
                                    <p><?php echo e(implode(', ', $doctor->doctorProfile->sub_specializations)); ?></p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile): ?>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-user-plus"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Accepts New Patients</h6>
                                    <p><?php echo e($doctor->doctorProfile->accepts_new_patients ? 'Yes' : 'No'); ?></p>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && $doctor->doctorProfile->verification_status): ?>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-shield-check"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Verification Status</h6>
                                    <p class="text-capitalize"><?php echo e($doctor->doctorProfile->verification_status); ?></p>
                                    <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile->verified_at): ?>
                                        <small class="text-muted">Verified on:
                                            <?php echo e($doctor->doctorProfile->verified_at->format('M d, Y')); ?></small>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

            <!-- Ratings Section -->
            <!--[if BLOCK]><![endif]--><?php if($doctor->doctorProfile && ($doctor->doctorProfile->rating || $doctor->doctorProfile->reviews_count)): ?>
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">Ratings & Reviews</h6>
                        <div class="text-center">
                            <div class="d-flex align-items-center justify-content-center mb-2">
                                <h2 class="me-2 mb-0"><?php echo e(number_format($doctor->doctorProfile->rating, 1)); ?></h2>
                                <div class="star-rating">
                                    <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= 5; $i++): ?>
                                        <!--[if BLOCK]><![endif]--><?php if($i <= floor($doctor->doctorProfile->rating)): ?>
                                            <i class="ti ti-star-filled text-warning"></i>
                                        <?php elseif($i - 0.5 <= $doctor->doctorProfile->rating): ?>
                                            <i class="ti ti-star-half-filled text-warning"></i>
                                        <?php else: ?>
                                            <i class="ti ti-star text-warning"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                            <p class="text-muted"><?php echo e($doctor->doctorProfile->reviews_count); ?> reviews</p>
                            <a href="#" class="btn btn-outline-primary btn-sm">View All Reviews</a>
                        </div>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        // For the "See More" functionality
        $(document).ready(function() {
            $('.viewall-button').click(function() {
                $(this).closest('.card-body').find('.more-menu').toggle();
                var span = $(this).find('span');
                var icon = $(this).find('i');

                if (span.text() === 'See More') {
                    span.text('See Less');
                    icon.removeClass('ti ti-chevron-down').addClass('ti ti-chevron-up');
                } else {
                    span.text('See More');
                    icon.removeClass('ti ti-chevron-up').addClass('ti ti-chevron-down');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/doctor/doctor-view.blade.php ENDPATH**/ ?>