<?php $__env->startSection('title', 'Patient Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<style>
.fl-wrapper[data-position^=top-] {
    top: 5em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Page Header -->
        <div class="mb-3 border-bottom pb-3">
            <h4 class="fw-bold mb-0">Doctor Details : About <?php echo e($data['name']); ?></h4>
        </div>
        <!-- End Page Header -->

        <div class="container my-4">
            <!-- Doctor Profile -->
            <div class="card shadow-sm border-0 mb-4 p-3">
                <div class="d-flex align-items-center">
                    <!-- Doctor Image -->
                    <img src="<?php echo e($data['profile_image'] ?? asset('assets/img/icons/sidebar-icon.svg')); ?>" alt="Doctor" class="rounded" style="width: 100px; height: 100px; object-fit: cover;">
                    <!-- <img src="<?php echo e(asset('./assets/img/icons/sidebar-icon.svg')); ?>" 
                        alt="Doctor" 
                        class="rounded" 
                        style="width: 100px; height: 100px; object-fit: cover;"> -->

                    <!-- Doctor Details -->
                    <div class="ms-3 flex-fill">
                        <h5 class="fw-bold mb-1"><?php echo e($data['name']); ?></h5>
                        <p class="text-muted mb-2 d-flex align-items-center">
                            <i class="ti ti-heart-filled text-danger me-1"></i>
                             <?php echo e(is_array($data['specialization']) ? implode(', ', $data['specialization']) : ($data['specialization'] ?? 'N/A')); ?>



                            <span class="ms-3">
                                <i class="ti ti-star text-warning"></i> <?php echo e($data['rating'] ?? '0'); ?> (<?php echo e($data['reviews_count'] ?? '0'); ?> reviews)
                            </span>
                        </p>
                        <a href="<?php echo e(route('patient.appointments.create')); ?>" class="btn btn-primary btn-sm">
                            <i class="ti ti-calendar"></i>&nbsp;Book Consultation
                        </a>
                    </div>
                </div>
            </div>

            <!-- Details Section -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-2">Details</h6>
                    <p class="text-muted medium">
                        <?php echo e($data['bio'] ?? 'No bio available.'); ?>

                    </p>
                </div>
            </div>

            <!-- Education -->
            <?php if($data['education']->isNotEmpty()): ?>
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Education</h6>
                    <ul class="list-group list-group-flush">
                        <?php $__currentLoopData = $data['education']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $edu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item"><?php echo e($edu->degree); ?> - <?php echo e($edu->institute); ?> (<?php echo e($edu->year ?? 'N/A'); ?>)</li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <?php endif; ?>

            <!-- Experience -->
            <?php if($data['experiences']->isNotEmpty()): ?>
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Experience</h6>
                    <ul class="list-group list-group-flush">
                        <?php $__currentLoopData = $data['experiences']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item"><?php echo e($exp->position); ?> at <?php echo e($exp->organization); ?> (<?php echo e($exp->start_year ?? 'N/A'); ?> - <?php echo e($exp->end_year ?? 'Present'); ?>)</li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <?php endif; ?>

            <!-- Consultation Type -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Consultation Type</h6>
                    <div class="d-flex gap-2">
                        <button class="btn btn-outline-primary active"><i class="ti ti-user"></i> In-person - </button>
                        <!-- <button class="btn btn-outline-secondary"><i class="ti ti-phone"></i> Phone Call</button> -->
                        <button class="btn btn-outline-secondary"><i class="ti ti-video"></i> Video Call - </button>
                    </div>
                </div>
            </div>

            <!-- Upcoming Slots -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Upcoming Slots <i class="ti ti-calendar ms-1"></i></h6>
                    
                    <p class="fw-semibold">Today</p>
                    <div class="d-flex flex-wrap gap-2 mb-3">
                        <button class="btn btn-outline-secondary btn-sm" disabled>10:00 AM<br><small>Unavailable</small></button>
                        <button class="btn btn-outline-primary btn-sm">11:00 AM<br><small>Available</small></button>
                        <button class="btn btn-outline-primary btn-sm">12:00 PM<br><small>Available</small></button>
                        <button class="btn btn-outline-primary btn-sm">01:00 PM<br><small>Available</small></button>
                    </div>

                    <p class="fw-semibold">Tomorrow</p>
                    <div class="d-flex flex-wrap gap-2">
                        <button class="btn btn-outline-primary btn-sm">10:00 AM<br><small>Available</small></button>
                        <button class="btn btn-outline-secondary btn-sm" disabled>11:00 AM<br><small>Unavailable</small></button>
                        <button class="btn btn-outline-primary btn-sm">12:00 PM<br><small>Available</small></button>
                        <button class="btn btn-outline-primary btn-sm">01:00 PM<br><small>Available</small></button>
                    </div>


                
                           <?php
    // Ensure availability is a Collection (safe even if controller passed array or null)
    $availabilities = collect($data['availability'] ?? []);
    // Group by day (normalize to lowercase). If your DB stores weekday names use that; otherwise adapt mapping.
    $grouped = $availabilities->groupBy(function($item) {
        return strtolower(data_get($item, 'day', 'unknown'));
    });
?>

<?php if($grouped->isEmpty()): ?>
    <p class="text-muted">No availability slots found.</p>
<?php else: ?>
    <?php $__currentLoopData = $grouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day => $slots): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <p class="fw-semibold"><?php echo e(ucfirst($day)); ?></p>
        <div class="d-flex flex-column gap-2 mb-3">
            <?php $__currentLoopData = $slots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="border rounded p-2 d-flex flex-wrap align-items-center gap-3">
                    <!-- From Time -->
                    <div>
                        <strong>From:</strong>
                        <?php echo e(data_get($slot, 'from_time') ? \Carbon\Carbon::parse(data_get($slot, 'from_time'))->format('h:i A') : 'N/A'); ?>

                    </div>

                    <!-- To Time -->
                    <div>
                        <strong>To:</strong>
                        <?php echo e(data_get($slot, 'to_time') ? \Carbon\Carbon::parse(data_get($slot, 'to_time'))->format('h:i A') : 'N/A'); ?>

                    </div>

                    <!-- Slot Duration -->
                    <div>
                        <strong>Duration:</strong> <?php echo e(data_get($slot, 'slot_duration', 'N/A')); ?> mins
                    </div>

                    <!-- Time Slot (raw/time_slot field) -->
                    <div>
                        <strong>Time Slot:</strong> <?php echo e(data_get($slot, 'time_slot', 'N/A')); ?>

                    </div>

                    <!-- In-Person Fee -->
                    <div>
                        <strong>In-Person:</strong> ₹<?php echo e(number_format(data_get($slot, 'in_person_fee', 0), 0)); ?>

                    </div>

                    <!-- Video Fee -->
                    <div>
                        <strong>Video:</strong> ₹<?php echo e(number_format(data_get($slot, 'video_fee', 0), 0)); ?>

                    </div>

                    <!-- Availability -->
                    <div>
                        <span class="badge bg-<?php echo e(data_get($slot, 'status') == 1 ? 'success' : 'secondary'); ?>">
                            <?php echo e(data_get($slot, 'status') == 1 ? 'Available' : 'Unavailable'); ?>

                        </span>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

                        
                    
            


                </div>
            </div>

            <!-- Book Button -->
            <div class="text-center">
                <a href="<?php echo e(route('patient.appointments.create')); ?>" class="btn btn-primary w-50 py-3 fw-semibold d-inline-block">
                    <i class="ti ti-calendar"></i>&nbsp; Book Consultation
                </a>
            </div>

        </div>
    </div>
    <!-- End Content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/patient/doctor/doctor-detail.blade.php ENDPATH**/ ?>