<?php $__env->startSection('title', 'Appointment Create'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Start Content -->
    <div class="content">

        <!-- row start -->
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <!-- page header start -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-0 d-flex align-items-center"> <a href="<?php echo e(route('admin.appointment-list')); ?>" class="text-dark"> <i class="ti ti-chevron-left me-1"></i>Appointments</a></h6>
                </div>
                <!-- page header end -->

                <form method="POST" action="<?php echo e(route('admin.appointments.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <!-- card start -->
                    <div class="card">
                        <div class="card-body">
                            <div class="form">

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label mb-0 fw-medium">Clinic <span class="text-danger">*</span></label>
                                            <select name="clinic_id" class="form-control select" required>
                                                <option value="">Select Clinic</option>
                                                <?php $__currentLoopData = $clinics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($clinic->id); ?>"><?php echo e($clinic->name); ?> - <?php echo e($clinic->city); ?>, <?php echo e($clinic->state); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label mb-1 fw-medium">Department<span class="text-danger ms-1">*</span></label>
                                            <select class="select" name="department" id="department">
                                                <option value="">Select</option>
                                                <option value="General Medicine">General Medicine</option>
                                                <option value="Pediatrics">Pediatrics</option>
                                                <option value="Gynecology">Gynecology</option>
                                                <option value="Cardiology">Cardiology</option>
                                                <option value="Orthopedics">Orthopedics</option>
                                                <option value="Dermatology">Dermatology</option>
                                                <option value="ENT">ENT</option>
                                                <option value="Neurology">Neurology</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label mb-1 fw-medium">Doctor<span class="text-danger ms-1">*</span></label>
                                            <!-- Doctor Dropdown -->
                                            <select name="doctor_id" class="form-control select" required>
                                                <option value="">Select Doctor</option>
                                                <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($doctor->id); ?>"><?php echo e($doctor->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <!-- <ul>
                                                <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($doctor->name); ?> (ID: <?php echo e($doctor->id); ?>)</li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul> -->
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="appointment_type" class="form-label mb-1 fw-medium">Appointment Type<span class="text-danger ms-1">*</span></label>
                                            <select name="appointment_type" id="appointment_type" class="form-control" required>
                                                <option value="">-- Select Type --</option>
                                                <option value="In Person">In Person</option>
                                                <option value="Online">Online</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label mb-1 fw-medium">Date of Appointment<span class="text-danger ms-1">*</span></label>
                                            <div class="input-icon-end position-relative">  
                                                <input type="text" name="appointment_date" id="appointment_date" class="form-control datetimepicker" placeholder="dd/mm/yyyy" value="dd/mm/yyyy" required>
                                                <span class="input-icon-addon">
                                                    <i class="ti ti-calendar"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="appointment_time" class="form-label mb-1 fw-medium">Time<span class="text-danger ms-1">*</span></label>
                                            <div class="input-icon-end position-relative">
                                                <input type="text" class="form-control timepicker" name="appointment_time" id="appointment_time" required>
                                                <span class="input-icon-addon">
                                                    <i class="ti ti-clock text-gray-7"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <div class="d-flex align-items-center justify-content-between mb-1">
                                                <label class="form-label mb-0 fw-medium">Patient<span class="text-danger ms-1">*</span></label>
                                            </div>
                                            <!-- Patient Dropdown -->
                                            <select name="patient_id" class="form-control select" required>
                                                <option value="">Select Patient</option>
                                                <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($patient->id); ?>"><?php echo e($patient->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <!-- <ul>
                                                <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($patient->name); ?> (ID: <?php echo e($patient->id); ?>)</li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul> -->
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="appointment_id" class="form-label">Appointment ID</label>
                                            <input type="text" name="appointment_id" id="appointment_id" class="form-control" required value="<?php echo e(old('appointment_id', 'PC-' . uniqid())); ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label for="status" class="form-label mb-1 fw-medium">Status<span class="text-danger ms-1">*</span></label>
                                            <select name="status" id="statu" class="form-control" required>
                                                <option value="Schedule">Schedule</option>
                                                <option value="Confirmed">Confirmed</option>
                                                <option value="Checked In">Checked In</option>
                                                <option value="Checked Out">Checked Out</option>
                                                <option value="Cancelled">Cancelled</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-0">
                                    <label class="form-label mb-1 fw-medium">Appointment Reason<span class="text-danger ms-1">*</span></label>
                                    <textarea name="reason" id="reason" class="form-control" rows="3" required></textarea>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- card end -->

                    <div class="d-flex align-items-center justify-content-end">
                        <a href="javascript:void(0);" class="btn btn-light me-2">Cancel</a>
                        <button type="submit" class="btn btn-primary"><i class="ti ti-plus"></i> Create Appointment</button>
                    </div>
                </form>

            </div>
        </div>
        <!-- row end -->               
        
    </div>
    <!-- End Content -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/admin/appointments/appointment-form.blade.php ENDPATH**/ ?>