<div class="content">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="<?php echo e(route('admin.subscription-plans.list')); ?>" class="text-dark">
                        <i class="ti ti-chevron-left me-1"></i><?php echo e(isset($editingPlanId) ? 'Edit Plan' : 'Add Plan'); ?>

                    </a>
                </h6>
            </div>

            <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('message')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <?php if(session()->has('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <?php
                $steps = [
                    1 => 'Plan Details',
                    2 => 'Plan Limits',
                    3 => 'Plan Features',
                    4 => 'Usage Rates',
                    5 => 'Review & Save',
                ];
            ?>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div
                            class="card-header d-flex justify-content-between align-items-center border-bottom border-dashed">
                            <h4 class="header-title"><?php echo e($isEditing ? 'Edit' : 'Create'); ?> Subscription Plan</h4>
                        </div>
                        <div class="card-body">
                            <div id="progressbarwizard">
                                <ul class="nav nav-pills nav-justified form-wizard-header mb-3">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $steps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stepNumber => $stepLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item">
                                            <a href="#step-<?php echo e($stepNumber); ?>" data-bs-toggle="tab" data-toggle="tab"
                                                class="nav-link rounded-0 py-2 <?php echo e($currentStep == $stepNumber ? 'active' : ''); ?> <?php echo e(!$isEditing && $stepNumber > $highestStep ? 'disabled' : ''); ?>"
                                                wire:click.prevent="goToStep(<?php echo e($stepNumber); ?>)">
                                                <span class="d-none d-sm-inline"><?php echo e($stepLabel); ?></span>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </ul>

                                <div class="tab-content b-0 mb-0">
                                    <div id="bar" class="progress mb-3" style="height: 7px;">
                                        <div class="bar progress-bar progress-bar-striped progress-bar-animated bg-primary"
                                            style="width: <?php echo e((($currentStep - 1) / (count($steps) - 1)) * 100); ?>%">
                                        </div>
                                    </div>

                                    <!-- Step Content -->
                                    <div class="tab-pane active">
                                        <!--[if BLOCK]><![endif]--><?php if($currentStep == 1): ?>
                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.subscription-plan-wizard.step1-plan-details', ['data' => [
                                                    'basic' => $planData['basic'] ?? [],
                                                    'combo' => $planData['is_combo'] ?? [],
                                                ],'editingPlanId' => $editingPlanId]);

$__html = app('livewire')->mount($__name, $__params, 'step1-' . $editingPlanId, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        <?php elseif($currentStep == 2): ?>
                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.subscription-plan-wizard.step2-plan-limits', ['data' => $planData['limits'] ?? [],'basic' => $planData['basic'],'rates' => $planData['rates'],'currency' => $planData['basic']['currency'] ?? 'INR']);

$__html = app('livewire')->mount($__name, $__params, 'step2-' . $editingPlanId, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        <?php elseif($currentStep == 3): ?>
                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.subscription-plan-wizard.step3-plan-features', ['data' => $planData['features'] ?? [],'isEditing' => !!$editingPlanId,'currency' => $planData['basic']['currency'] ?? 'INR']);

$__html = app('livewire')->mount($__name, $__params, 'step3-' . $editingPlanId, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        <?php elseif($currentStep == 4): ?>
                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.subscription-plan-wizard.step4-usage-rates', ['data' => $planData['rates'] ?? [],'currency' => $planData['basic']['currency'] ?? 'INR']);

$__html = app('livewire')->mount($__name, $__params, 'step4-' . $editingPlanId, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        <?php elseif($currentStep == 5): ?>
                                            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.subscription-plan-wizard.step5-review', ['planData' => $planData,'isEditing' => !!$editingPlanId]);

$__html = app('livewire')->mount($__name, $__params, 'step5-' . $editingPlanId, $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/form-wizard.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/subscription-plan-wizard/wizard.blade.php ENDPATH**/ ?>