<?php $__env->startSection('title', 'Video Conference'); ?>

<?php $__env->startSection('content'); ?>
<div id="vc-app">
  <div class="vc-topbar">
    <div class="vc-brand">Appointment Call</div>
    <div class="vc-right">
      <input id="vcMeetingId" type="text" class="vc-input" readonly placeholder="Meeting ID …">
    </div>
  </div>

  <!-- Join gate (pre-join status) -->
  <div id="vcGate" class="vc-gate">
    <div id="vcStatus" class="vc-status">Preparing meeting…</div>
  </div>

  <!-- Stage -->
  <section id="vcStage" class="vc-stage vc-hidden">
    <!-- Waiting overlay until 2nd participant joins -->
    <div id="vcWaiting" class="vc-wait vc-hidden">
      <div class="vc-wait-card">
        <div class="vc-wait-title">Waiting for the other participant…</div>
        <div class="vc-hint">Ask them to open the same appointment link.</div>
      </div>
    </div>

    <!-- Remote grid -->
    <div id="vcRemoteGrid" class="vc-remote-grid"></div>
  </section>

  <!-- Screen Share overlay (fills the center stage) -->
  <div id="vcShareWrap" class="vc-share vc-hidden">
    <video id="vcShareVideo" playsinline autoplay></video>
  </div>

  <!-- Local PiP (draggable) -->
  <div id="vcPiP" class="vc-pip vc-hidden">
    <video id="vcLocal" playsinline autoplay muted></video>
  </div>

  <!-- Controls dock -->
  <div id="vcControls" class="vc-controls vc-hidden">
    <button id="vcMic" class="vc-btn vc-on" title="Toggle Mic"><i class="ti ti-microphone"></i></button>
    <button id="vcCam" class="vc-btn vc-on" title="Toggle Camera"><i class="ti ti-camera"></i></button>
    <button id="vcSwitch" class="vc-btn" title="Switch Front/Back Camera"><i class="ti ti-arrows-shuffle"></i></button>
    <button id="vcShare" class="vc-btn" title="Share Screen"><i class="ti ti-screen-share"></i></button>
    <button id="vcRec" class="vc-btn" title="Start/Stop Recording"><i class="ti ti-record-mail"></i></button>
    <button id="vcLeave" class="vc-btn vc-leave" title="Leave"><i class="ti ti-phone-off"></i></button>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/tabler-icons.min.css" rel="stylesheet">
<style>
  :root{ --bg:#0b1020; --layer:#0f172a; --panel:#111827; --muted:#9aa4b2; --line:#1f2937; --accent:#3b82f6; --danger:#ef4444; }
  *{ box-sizing:border-box }
  body{ background:var(--bg); color:#e5e7eb; }
  /* Topbar */
  .vc-topbar{ display:flex; align-items:center; justify-content:space-between; padding:10px 14px; background:var(--layer); border-bottom:1px solid var(--line) }
  .vc-brand{ font-weight:700; letter-spacing:.2px }
  .vc-input{ background:#0b1020; border:1px solid var(--line); border-radius:8px; padding:8px 10px; color:#b3b8c5; min-width:220px }

  /* Gate */
  .vc-gate{ height:calc(100vh - 56px); display:flex; align-items:center; justify-content:center }
  .vc-status{ font-size:16px; color:#cbd5e1 }

  /* Stage */
  .vc-stage{ position:relative; height:calc(100vh - 56px); background:radial-gradient(1200px 600px at 70% -200px,#111827,transparent) }
  .vc-remote-grid{ position:absolute; inset:0; padding:10px; display:grid; grid-template-columns:repeat(auto-fit,minmax(260px,1fr)); gap:10px }
  .vc-tile{ position:relative; background:#0b1020; border:1px solid var(--line); border-radius:12px; overflow:hidden }
  .vc-tile video{ width:100%; height:100%; object-fit:cover; display:block }
  .vc-name{ position:absolute; left:8px; bottom:8px; background:rgba(0,0,0,.55); padding:4px 8px; border-radius:6px; font-size:12px }

  /* Waiting */
  .vc-wait{ position:absolute; inset:0; display:flex; align-items:center; justify-content:center; backdrop-filter:blur(1px); background:rgba(15,23,42,.55); z-index:20 }
  .vc-wait-card{ background:#0f172a; border:1px solid var(--line); padding:18px 22px; border-radius:12px; color:#cbd5e1; box-shadow:0 10px 30px rgba(0,0,0,.25) }
  .vc-wait-title{ font-weight:700; margin-bottom:6px }
  .vc-hint{ font-size:12px; color:#94a3b8 }

  /* Share */
  .vc-share{ position:fixed; left:12px; right:12px; top:64px; bottom:88px; border:1px solid var(--line); border-radius:14px; overflow:hidden; background:#0b1020; z-index:45; box-shadow:0 20px 40px rgba(0,0,0,.35) }
  .vc-share video{ width:100%; height:100%; object-fit:contain; background:#0b1020 }

  /* PiP */
  .vc-pip{ position:fixed; right:16px; bottom:16px; width:240px; max-width:40vw; aspect-ratio:16/9; border-radius:14px; overflow:hidden; border:1px solid var(--line); box-shadow:0 12px 30px rgba(0,0,0,.35); touch-action:none; z-index:50; background:#0b1020 }
  .vc-pip video{ width:100%; height:100%; object-fit:cover }

  /* Controls */
  .vc-controls{ position:fixed; left:50%; transform:translateX(-50%); bottom:14px; display:flex; gap:10px; z-index:60 }
  .vc-btn{ display:inline-flex; align-items:center; justify-content:center; width:46px; height:46px; border-radius:999px; border:1px solid var(--line); background:#0f172a; color:#e5e7eb; cursor:pointer; transition:background .18s, border-color .18s, transform .05s }
  .vc-btn:hover{ background:#111c35 }
  .vc-btn.vc-off{ background:#1f2937; color:#94a3b8 }
  .vc-btn.vc-on { background:rgba(59,130,246,.18); border-color:var(--accent); color:#dbeafe }
  .vc-btn.vc-rec-on{ background:#b91c1c; border-color:#7f1d1d }
  .vc-btn.vc-share-on{ background:#1e3a8a; border-color:#3b82f6 }
  .vc-btn.vc-leave{ background:var(--danger); border-color:#b91c1c }

  /* Utils */
  .vc-hidden{ display:none !important }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
  // Values from controller, with safe fallbacks:
  window.VC_ROLE  = <?php echo json_encode($role ?? null, 15, 512) ?>;
  window.VC_UID   = <?php echo json_encode($uid ?? null, 15, 512) ?>;
  window.VC_APPT  = <?php echo json_encode($appointmentId ?? request('appointment_id'), 15, 512) ?>;
  window.VC_MEET_ENDPOINT = <?php echo json_encode($jsonEndpoint ?? null, 15, 512) ?>;
</script>
<script src="https://sdk.videosdk.live/js-sdk/0.1.6/videosdk.js"></script>
<script>
(function(){
  // -------- helpers --------
  const qs = new URLSearchParams(location.search);
  const appointment_id = window.VC_APPT || qs.get('appointment_id') || '';
  // derive role/id from controller or query fallback
  let role = window.VC_ROLE || (qs.get('user_type')||'').toLowerCase() || null;
  let uid  = window.VC_UID  || qs.get('user_id') || null;
  if(!role){
    if(qs.get('patient_id')){ role='patient'; uid=qs.get('patient_id'); }
    else if(qs.get('doctor_id')){ role='doctor'; uid=qs.get('doctor_id'); }
  }

  const Gate   = document.getElementById('vcGate');
  const Stage  = document.getElementById('vcStage');
  const Waiting= document.getElementById('vcWaiting');
  const Remote = document.getElementById('vcRemoteGrid');
  const PiP    = document.getElementById('vcPiP');
  const LocalV = document.getElementById('vcLocal');
  const ShareW = document.getElementById('vcShareWrap');
  const ShareV = document.getElementById('vcShareVideo');
  const Controls = document.getElementById('vcControls');
  const Status = document.getElementById('vcStatus');
  const MeetingTxt = document.getElementById('vcMeetingId');

  const MicBtn = document.getElementById('vcMic');
  const CamBtn = document.getElementById('vcCam');
  const SwitchBtn = document.getElementById('vcSwitch');
  const ShareBtn = document.getElementById('vcShare');
  const RecBtn   = document.getElementById('vcRec');
  const leaveButton = document.getElementById('vcLeave');

  let meeting=null, meetingId='', TOKEN='';
  let micOn=true, camOn=true, recording=false, sharing=false;
  let cams=[], camIdx=0;

  if(!appointment_id){ Status.textContent='Error: appointment_id missing in URL.'; return; }

  // endpoint fallback by role if controller didn't pass:


  let endpoint = window.VC_MEET_ENDPOINT;
// normalize scheme if someone passed an absolute http URL
if (endpoint && /^http:\/\//i.test(endpoint)) endpoint = endpoint.replace(/^http:/i, 'https:');
if (!endpoint) {
  if (role === 'doctor') endpoint = '/doctor/videosdk/meeting';
  else if (role === 'patient') endpoint = '/patient/videosdk/meeting';
  else endpoint = '/admin/videosdk/meeting';
}

  // ---------- bootstrap: fetch/create then auto-join ----------
  (async function boot(){
    Status.textContent = 'Fetching meeting for appointment #' + appointment_id + '…';
    try{
      const u = new URL(endpoint, location.origin);
      u.searchParams.set('appointment_id', appointment_id);
      if(role==='doctor' && uid)  u.searchParams.set('doctor_id', uid);
      if(role==='patient' && uid) u.searchParams.set('patient_id', uid);

      const r = await fetch(u.toString());
      const j = await r.json();
      if(j.error){ Status.textContent = 'Server error: ' + (j.message||j.error); return; }
      meetingId = j.meeting_id; TOKEN = j.token;
      if(MeetingTxt) MeetingTxt.value = meetingId;

      Status.textContent = (j.status==='join' ? 'Joining meeting…' : 'Created meeting, joining…');
      initMeeting();
    }catch(e){
      Status.textContent = 'Network error: ' + e.message;
    }
  })();

  // ---------- drag PiP ----------
  (function enableDrag(){
    let sx=0, sy=0, ox=0, oy=0, dragging=false;
    const start=e=>{ dragging=true; const p=(e.touches?e.touches[0]:e);
      sx=p.clientX; sy=p.clientY; const r=PiP.getBoundingClientRect(); ox=r.left; oy=r.top; e.preventDefault(); };
    const move =e=>{ if(!dragging) return; const p=(e.touches?e.touches[0]:e);
      const nx = Math.min(innerWidth - PiP.offsetWidth, Math.max(0, ox + (p.clientX - sx)));
      const ny = Math.min(innerHeight - PiP.offsetHeight, Math.max(0, oy + (p.clientY - sy)));
      PiP.style.left=nx+'px'; PiP.style.top=ny+'px'; PiP.style.right='auto'; PiP.style.bottom='auto';
    };
    const end = ()=> dragging=false;
    PiP.addEventListener('mousedown', start); PiP.addEventListener('touchstart', start, {passive:false});
    addEventListener('mousemove', move); addEventListener('touchmove', move, {passive:false});
    addEventListener('mouseup', end); addEventListener('touchend', end);
  })();

  // ---------- VideoSDK wiring ----------
  function initMeeting(){
    if(!TOKEN || !meetingId){ Status.textContent='Missing token/meetingId'; return; }
    const displayName = (role==='doctor'?'Doctor': role==='patient'?'Patient':'User') + (uid?(' #'+uid):'');

    window.VideoSDK.config(TOKEN);
    meeting = window.VideoSDK.initMeeting({ meetingId, name: displayName, micEnabled:true, webcamEnabled:true });

    meeting.on('meeting-joined', async ()=>{
      Gate.classList.add('vc-hidden'); Stage.classList.remove('vc-hidden'); Controls.classList.remove('vc-hidden'); PiP.classList.remove('vc-hidden');
      setWaiting(meeting.participants.size === 0);
      try { cams = await meeting.getWebcams(); camIdx=0; } catch(e){}
      setBtnStates();
    });

    meeting.on('meeting-left', ()=> location.reload());

    meeting.on('participant-joined', p=>{ addRemote(p); setWaiting(false); });
    meeting.on('participant-left',  p=>{ removeRemote(p); setWaiting(meeting.participants.size === 0); });

    meeting.on('recording-started', ()=>{ recording=true; RecBtn.classList.add('vc-rec-on'); });
    meeting.on('recording-stopped', ()=>{ recording=false; RecBtn.classList.remove('vc-rec-on'); });

    meeting.on('presenter-changed', (presenterId)=>{
      const active = !!presenterId;
      sharing = active && presenterId === meeting.localParticipant.id;
      ShareBtn.classList.toggle('vc-share-on', sharing);
      if(!active) hideShare();
    });

    meeting.localParticipant.on('stream-enabled', s=> attachLocal(s));
    meeting.join();

    // bind controls
    MicBtn.addEventListener('click', toggleMic);
    CamBtn.addEventListener('click', toggleCam);
    SwitchBtn.addEventListener('click', switchCam);
    ShareBtn.addEventListener('click', toggleShare);
    RecBtn.addEventListener('click', toggleRec);
    leaveButton.addEventListener('click', ()=> meeting && meeting.leave());


    // leave Meeting Button Event Listener
    leaveButton.addEventListener("click", async () => {
        if(meeting) await meeting.leave();
        window.history.back(); // last visited page pe redirect
    });


    // keyboard shortcuts
    addEventListener('keydown', (e)=>{
      if(e.target && ['INPUT','TEXTAREA'].includes(e.target.tagName)) return;
      if(e.key==='m' || e.key==='M') toggleMic();
      if(e.key==='v' || e.key==='V') toggleCam();
      if(e.key==='s' || e.key==='S') toggleShare();
      if(e.key==='r' || e.key==='R') toggleRec();
    });

    // double-click Local PiP to switch camera
    LocalV.addEventListener('dblclick', switchCam);
  }

  // UI helpers
  function setWaiting(v){ Waiting.classList.toggle('vc-hidden', !v); }
  function setBtnStates(){
    MicBtn.classList.toggle('vc-on', micOn);  MicBtn.classList.toggle('vc-off', !micOn);
    CamBtn.classList.toggle('vc-on', camOn);  CamBtn.classList.toggle('vc-off', !camOn);
  }

  // Local stream attach
  function attachLocal(stream){
    if(stream.kind==='video'){
      const ms = new MediaStream(); ms.addTrack(stream.track);
      LocalV.srcObject = ms; LocalV.play().catch(()=>{});
    }
  }

  // Remote tiles
  function addRemote(participant){
    const id = 'vc-p-' + participant.id;
    if(document.getElementById(id)) return;
    const tile = document.createElement('div'); tile.className='vc-tile'; tile.id=id;
    const v = document.createElement('video'); v.autoplay=true; v.playsInline=true; tile.appendChild(v);
    const tag = document.createElement('div'); tag.className='vc-name'; tag.textContent = participant.displayName || 'Guest'; tile.appendChild(tag);
    Remote.appendChild(tile);

    participant.on('stream-enabled', s => attachRemote(s, v, true));
    participant.on('stream-disabled', s => { if(s.kind==='share') hideShare(); });
  }
  function removeRemote(participant){
    const el = document.getElementById('vc-p-' + participant.id);
    if(el) el.remove();
  }

  function attachRemote(stream, videoEl, isRemote){
    if(stream.kind==='video'){
      const ms = new MediaStream(); ms.addTrack(stream.track);
      videoEl.srcObject = ms; videoEl.play().catch(()=>{});
    } else if(stream.kind==='audio' && isRemote){
      const a = new Audio(); const ms = new MediaStream(); ms.addTrack(stream.track);
      a.srcObject = ms; a.play().catch(()=>{});
    } else if(stream.kind==='share'){
      const ms = new MediaStream(); ms.addTrack(stream.track);
      ShareV.srcObject = ms; ShareW.classList.remove('vc-hidden'); ShareV.play().catch(()=>{});
    } else if(stream.kind==='shareAudio'){
      const a = new Audio(); const ms = new MediaStream(); ms.addTrack(stream.track);
      a.srcObject = ms; a.play().catch(()=>{});
    }
  }
  function hideShare(){ ShareW.classList.add('vc-hidden'); ShareV.srcObject = null; }

  // Controls
  async function toggleMic(){
    if(!meeting) return;
    try{
      if(micOn) await meeting.muteMic(); else await meeting.unmuteMic();
      micOn = !micOn; setBtnStates();
    }catch(e){ console.warn('mic toggle failed', e); }
  }
  async function toggleCam(){
    if(!meeting) return;
    try{
      if(camOn) await meeting.disableWebcam(); else await meeting.enableWebcam();
      camOn = !camOn; setBtnStates();
    }catch(e){ console.warn('cam toggle failed', e); }
  }
  async function switchCam(){
    if(!meeting) return;
    try{
      const list = cams && cams.length ? cams : await meeting.getWebcams();
      if(!list || !list.length) return;
      camIdx = (camIdx + 1) % list.length;
      await meeting.changeWebcam(list[camIdx].deviceId);
    }catch(e){ console.warn('switch camera failed', e); }
  }
  async function toggleShare(){
    if(!meeting) return;
    const isMobile = /android|iphone|ipad|ipod/i.test(navigator.userAgent);
    if(isMobile){ alert('Screen share works on desktop browsers.'); return; }
    try{
      if(!sharing) await meeting.enableScreenShare();
      else         await meeting.disableScreenShare();
      // presenter-changed updates UI
    }catch(e){ console.warn('screenshare error', e); }
  }
  async function toggleRec(){
    if(!meeting) return;
    try{
      if(!recording) await meeting.startRecording();
      else           await meeting.stopRecording();
      // events update UI color
    }catch(e){ console.warn('recording error', e); }
  }
})();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/video-conference.blade.php ENDPATH**/ ?>