<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Http;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\VideoSDKController;
use App\Http\Controllers\InvoiceController;

// Pages
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/home', [HomeController::class, 'index'])->name('home.home');
Route::get('/forgot-password', [HomeController::class, 'forgotPassword'])->name('forgot-password');
Route::get('/reset-password/{token}/{email}', [HomeController::class, 'showResetForm'])->name('password.reset');

// Route::middleware('auth:superadmin,doctor,patient')->get('/call' , [VideoSDKController::class , 'videoCall']);
// Route::middleware('auth:superadmin,doctor,patient')->get('/videosdk-token', [VideoSDKController::class, 'getToken']);

/********************************************************************
 * ✅ Super Admin, Doctor and Patient API Routes
 *******************************************************************/

// Super Admin
Route::prefix('admin')->middleware(['auth:superadmin'])->group(function () {
    Route::get('/call', [VideoSDKController::class, 'videoCall'])->name('admin.call');
    Route::get('/videosdk-token', [VideoSDKController::class, 'getToken'])->name('admin.videosdk.token');
    Route::get('/videosdk/meeting', [VideoSDKController::class, 'createOrFetchMeeting'])->name('admin.videosdk.meeting');
});

// Doctor
Route::prefix('doctor')->middleware(['auth:doctor'])->group(function () {
    Route::get('/call', [VideoSDKController::class, 'videoCall'])->name('doctor.call');
    Route::get('/videosdk-token', [VideoSDKController::class, 'getToken'])->name('doctor.videosdk.token');
    Route::get('/videosdk/meeting', [VideoSDKController::class, 'createOrFetchMeeting'])->name('doctor.videosdk.meeting');
});

// Patient
Route::prefix('patient')->middleware(['auth:patient'])->group(function () {
    Route::get('/call', [VideoSDKController::class, 'videoCall'])->name('patient.call');
    Route::get('/videosdk-token', [VideoSDKController::class, 'getToken'])->name('patient.videosdk.token');
    Route::get('/videosdk/meeting', [VideoSDKController::class, 'createOrFetchMeeting'])->name('patient.videosdk.meeting');
});


##########  Invoice Link 
// Super Admin
Route::prefix('admin')->middleware(['auth:superadmin'])->group(function () {
    Route::get('/invoice/{id}', [InvoiceController::class, 'show'])->name('admin.invoice.show');
    Route::get('/invoice/download/{id}', [InvoiceController::class, 'downloadInvoice'])->name('admin.invoice.download');
});

// Doctor
Route::prefix('doctor')->middleware(['auth:doctor'])->group(function () {
    Route::get('/invoice/{id}', [InvoiceController::class, 'show'])->name('doctor.invoice.show');
    Route::get('/invoice/download/{id}', [InvoiceController::class, 'downloadInvoice'])->name('doctor.invoice.download');
});

// Patient
Route::prefix('patient')->middleware(['auth:patient'])->group(function () {
    Route::get('/invoice/{id}', [InvoiceController::class, 'show'])->name('patient.invoice.show');
    Route::get('/invoice/download/{id}', [InvoiceController::class, 'downloadInvoice'])->name('patient.invoice.download');
});


/********************************************************************
 * ✅ Super Admin, Doctor and Patient API Routes
 *******************************************************************/

// routes/web.php
Route::middleware(['auth:doctor,patient,superadmin'])->get('/videosdk/diagnostics', [VideoSDKController::class, 'diagnostics'])
    ->name('videosdk.diagnostics');


Route::get('/test-videosdk-api', [VideoSDKController::class, 'testToken']);

// Load admin routes
require __DIR__ . '/admin.php';
require __DIR__ . '/doctor.php';
require __DIR__ . '/patient.php';
require __DIR__ . '/api.php';