<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Patient\Auth\PatientAuthController;
use App\Http\Controllers\Admin\CustomAuthController;
use App\Http\Controllers\Patient\AppointmentController;
use App\Http\Controllers\Patient\DoctorController;
use App\Http\Controllers\Patient\TransactionController;


Route::get('transaction-list', [TransactionController::class, 'index'])->name('patient.transaction.list');

Route::prefix('patient')->group(function () {
    Route::middleware(['redirect_if_authenticated:patient'])->group(function () {
        Route::get('login', [PatientAuthController::class, 'showLoginForm'])->name('patient.login');
        Route::get('register', [PatientAuthController::class, 'registration'])->name('patient.register');
        //Route::post('custom-register', [CustomAuthController::class, 'customRegistration'])->name('doctor.register.custom');
        //Route::get('signout', [CustomAuthController::class, 'signOut'])->name('doctor.signout');
    });

    Route::middleware(['auth:patient'])->group(function () {
        Route::middleware(['role:patient'])->group(function () {
            Route::post('logout', [PatientAuthController::class, 'logout'])->name('patient.logout');
            Route::get('patient-dashboard', [DashboardController::class, 'patientDashboard'])->name('patient.patient-dashboard');
            Route::get('profile', [PatientAuthController::class, 'profile'])->name('patient.profile');

            // Appointments Management
            Route::get('appointments-create', [AppointmentController::class, 'create'])->name('patient.appointments.create');
            Route::get('appointments-list', [AppointmentController::class, 'index'])->name('patient.appointments.list');
            Route::delete('del-appointments/{id}', [AppointmentController::class, 'destroy'])->name('patient.appointments.destroy');
            Route::get('appointments/{id}', [AppointmentController::class, 'show'])->name('patient.appointments.show');

            Route::get('/get-doctors-by-specialization-name/{specialization}', [AppointmentController::class, 'getDoctorsBySpecializationName'])->name('patient.appointments.getDoctorsBySpecializationName');
            Route::get('get-available-slots/{id}', [AppointmentController::class, 'getSlots'])->name('patient.appointments.getSlots');
            Route::get('get-doctor-availability/{id}', [AppointmentController::class, 'getAvailability'])->name('patient.appointments.getAvailability');
            Route::get('get-doctor-fee/{id}', [AppointmentController::class, 'getFee'])->name('patient.appointments.getFee');

            // Others Pages
            Route::get('doctor-list', [DoctorController::class, 'index'])->name('patient.doctor.list');
            Route::post('add-clinic', [DoctorController::class, 'store'])->name('patient.doctor.clinic');
            Route::get('clinic-list', [DoctorController::class, 'cliniclist'])->name('patient.doctor.clinicList');
            Route::get('clinic-detail/{id}', [DoctorController::class, 'clinicdetail'])->name('patient.doctor.clinicDetail');
            Route::get('doctor-detail/{id}', [DoctorController::class, 'doctordetail'])->name('patient.doctor.doctorDetail');

            Route::get('prescriptions-list', [DoctorController::class, 'prescriptions'])->name('patient.prescriptions.list');
            Route::get('transaction-list', [TransactionController::class, 'index'])->name('patient.transaction.list');
        });
    });
});
