<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Admin\Clinic\ClinicController;
use App\Http\Controllers\Admin\CustomAuthController;
use App\Http\Controllers\Admin\SubscriptionPlanController;
use App\Http\Controllers\Admin\UserManagementController;
use App\Http\Controllers\Doctor\Auth\DoctorAuthController;
use App\Http\Controllers\Doctor\Auth\StaffAuthController;
use App\Http\Controllers\Doctor\DoctorManagementController;
use App\Http\Controllers\Doctor\PatientManagementController;
use App\Http\Controllers\Doctor\Staff\DoctorStaffController;
use App\Http\Livewire\Doctor\Doctor\DoctorList;
use App\Livewire\Doctor\Doctor\DoctorForm;
use App\Livewire\Doctor\Doctor\DoctorView;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AvailabilityController;
use App\Http\Controllers\Doctor\AppointmentController;

Route::prefix('doctor')->group(function () {
    Route::middleware(['redirect_if_authenticated:doctor'])->group(function () {
        Route::get('login', [DoctorAuthController::class, 'showLoginForm'])->name('doctor.login');
        Route::get('/staff/login', [StaffAuthController::class, 'showLoginForm'])->name('doctor.staff.login');
        //Route::post('custom-login', [CustomAuthController::class, 'customLogin'])->name('doctor.login.custom');
        //Route::get('register', [CustomAuthController::class, 'registration'])->name('doctor.register');
        //Route::post('custom-register', [CustomAuthController::class, 'customRegistration'])->name('doctor.register.custom');
        //Route::get('signout', [CustomAuthController::class, 'signOut'])->name('doctor.signout');
    });

    // Protected doctor routes
    Route::middleware(['auth:doctor,web'])->group(function () {
        Route::middleware(['role:primary_doctor|sub_doctor|doctor|doctorstaff', 'check_doctor_clinic'])->group(function () {
            Route::post('logout', [DoctorAuthController::class, 'logout'])->name('doctor.logout');
            Route::get('doctor-dashboard', [DashboardController::class, 'doctorDashboard'])->name('doctor.doctor-dashboard');
            Route::get('staff/staff-dashboard', [DashboardController::class, 'doctorStaffDashboard'])->name('doctor.staff.doctor-dashboard');

            Route::get('profile', [DoctorAuthController::class, 'profile'])->name('doctor.profile.setup');
//            Route::get('staff/profile', [DoctorAuthController::class, 'profile'])->name('doctor.staff.profile.setup');
//            Route::view('role-manager', 'doctor/role-manager')->name('doctor.role-manager');
//            Route::get('subscription-plans', [SubscriptionPlanController::class, 'index'])->name('doctor.subscription-plans');
//            Route::get('user-management', [UserManagementController::class, 'index'])->name('doctor.user-management');

            Route::prefix('patient')->name('doctor.patient.')->group(function () {
                Route::get('management/{id?}', [PatientManagementController::class, 'index'])
                    ->name('management');

                Route::get('list', [PatientManagementController::class, 'list'])
                    ->name('list');
                Route::get('patient-view/{id?}', [PatientManagementController::class, 'view'])
                    ->name('view');
            });
            /* Route::get('patient-management/{id?}', [PatientManagementController::class, 'index'])
                ->name('admin.patient-management'); */

            Route::prefix('staff')->name('doctor.staff.')->group(function () {
                Route::get('/list', [DoctorStaffController::class, 'index'])
                    ->name('list')
                    ->middleware('clinic_permission:list staff');

                Route::get('/add', [DoctorStaffController::class, 'addstaff'])
                    ->name('add')
                    ->middleware('clinic_permission:create staff');

                Route::get('/view/{staff}', [DoctorStaffController::class, 'view'])
                    ->name('view')
                    ->middleware('clinic_permission:view staff');
            });
            Route::get('/{doctor}/staff/{staff}/edit', [DoctorStaffController::class, 'edit'])
                    ->name('doctor.staff.edit')
                    ->middleware('clinic_permission:edit staff');

                    
            Route::prefix('doctor-management')->name('doctor.doctor-management.')->group(function () {
                Route::get('list', [DoctorManagementController::class, 'index'])
                    ->name('list')
                    ->middleware('clinic_permission:list doctors');
                Route::get('create', [DoctorManagementController::class, 'create'])
                    ->name('create')
                    ->middleware('clinic_permission:create doctors');
                Route::get('edit/{id}', [DoctorManagementController::class, 'edit'])
                    ->name('edit')
                    ->middleware('clinic_permission:edit doctors');
                Route::get('view/{id}', [DoctorManagementController::class, 'view'])
                    ->name('view')
                    ->middleware('clinic_permission:view doctor profile');
            });

            Route::prefix('availability')->name('availability.')->group(function () {
                Route::get('list', [AvailabilityController::class, 'index'])->name('list');
                Route::get('create', [AvailabilityController::class, 'create'])->name('create');
                Route::post('store', [AvailabilityController::class, 'store'])->name('store');
                Route::delete('delete/{id}', [AvailabilityController::class, 'destroy'])->name('destroy');
                Route::get('toggle-status/{id}', [AvailabilityController::class, 'toggleStatus'])->name('toggle-status');
                Route::get('edit/{id}', [AvailabilityController::class, 'edit'])->name('edit');
                Route::post('availability/{id}', [AvailabilityController::class, 'update'])->name('update');
            });

            // Route::prefix('appointments-management')->name('doctor.appointments.')->group(function () {
            //     Route::get('list', [AppointmentController::class, 'index'])->name('list');
            //     Route::get('create', [AppointmentController::class, 'create'])->name('create');
            //     Route::post('store', [AppointmentController::class, 'store'])->name('store');
            //     // Route::get('edit/{id}', [AppointmentController::class, 'edit'])->name('edit');
            //     // Route::get('view/{id}', [AppointmentController::class, 'view'])->name('view');
            //     Route::get('/get-doctor-specialization/{id}', [AppointmentController::class, 'getSpecialization']);

            // });

            Route::prefix('appointments-management')->name('doctor.appointments.')->group(function () {
                Route::get('list', [AppointmentController::class, 'index'])->name('list');
                Route::get('create', [AppointmentController::class, 'create'])->name('create');
                Route::post('store', [AppointmentController::class, 'store'])->name('store');

                // routes/web.php
                Route::post('patientsstore', [AppointmentController::class, 'createNewPatient'])->name('patientsstore');


                // Doctor Appointment Routes
                Route::delete('/doctor/appointments/{id}', [AppointmentController::class, 'destroy'])->name('destroy');
                Route::get('/appointments/{id}', [AppointmentController::class, 'show'])->name('show');

                Route::get('/get-doctors-by-specialization-name/{specialization}', [AppointmentController::class, 'getDoctorsBySpecializationName'])->name('getDoctorsBySpecializationName');
                
                //Route::get('get-doctors-by-specialization/{id}', [AppointmentController::class, 'getDoctorsBySpecialization'])->name('getDoctorsBySpecialization');
                Route::get('get-doctor-specialization/{id}', [AppointmentController::class, 'getSpecialization'])->name('getSpecialization');
                Route::get('get-doctor-availability/{id}', [AppointmentController::class, 'getAvailability'])->name('getAvailability');
                Route::get('get-available-slots/{id}', [AppointmentController::class, 'getSlots'])->name('getSlots');
                Route::get('get-doctor-fee/{id}', [AppointmentController::class, 'getFee'])->name('getFee');
                Route::get('appointments/{id}/status/{status}', [AppointmentController::class, 'updateStatus'])->name('update-status');
            });

        });
    });
});
