<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Doctor\Api\V1\DoctorApiAuthController;
use App\Http\Controllers\Doctor\Api\V1\CommonApiController;
use App\Http\Controllers\Doctor\Api\V1\DoctorClinicApiController;
use App\Http\Controllers\Doctor\Api\V1\DoctorPrescriptionController;

//use App\Http\Controllers\Admin\Api\V1\ClinicApiController;
use App\Http\Controllers\Admin\Api\V1\ClinicApiController as AdminClinicApiController;
use App\Http\Controllers\Patient\Api\V1\ClinicApiController as PatientClinicApiController;
use App\Http\Controllers\Patient\Api\V1\PatientApiAuthController;
use App\Http\Controllers\Patient\Api\V1\PatientPrescriptionController;
use App\Http\Controllers\Admin\Api\V1\SuperAdminApiAuthController;

use App\Http\Controllers\BasicSettingController;
use App\Http\Controllers\SupportController;
use App\Http\Controllers\VideoSDKController;

/********************************************************************
 * ✅ Admin API Routes
 *******************************************************************/

Route::prefix('v1/admin')->group(function () {

    Route::prefix('auth')->group(function () {
        Route::post('login', [SuperAdminApiAuthController::class, 'login'])->name('api.admin.v1.auth.login');

        Route::middleware(['auth:sanctum', 'role:superadmin'])->group(function () {
            Route::post('logout', [SuperAdminApiAuthController::class, 'logout'])->name('api.admin.v1.auth.logout');
            Route::get('user', [SuperAdminApiAuthController::class, 'user'])->name('api.admin.v1.auth.user');
            Route::post('profile', [SuperAdminApiAuthController::class, 'updateProfile'])->name('api.admin.v1.auth.updateProfile');
        });

    });

    Route::middleware(['auth:sanctum', 'role:superadmin|superadminstaff'])->group(function () {
        Route::get('dashboard', function () {
            return response()->json([
                'message' => 'Welcome to the dashboard',
                'user' => auth()->user()
            ]);
        })->name('api.dashboard');
    });
});

Route::prefix('v1/admin')->middleware(['auth:sanctum', 'role:superadmin|superadminstaff'])->group(function () {
    Route::prefix('clinics')->group(function () {
        Route::get('/', [AdminClinicApiController::class, 'index'])->name('api.admin.v1.clinics.index');
        Route::post('/', [AdminClinicApiController::class, 'store'])->name('api.admin.v1.clinics.store');

        // ✅ Place static routes before the dynamic {clinic}
        Route::post('/create-doctor', [AdminClinicApiController::class, 'createDoctor'])->name('api.admin.v1.clinics.create-doctor');
        Route::get('/available-owners', [AdminClinicApiController::class, 'availableOwners'])->name('api.admin.v1.clinics.available-owners');
        Route::get('/available-plans', [AdminClinicApiController::class, 'availablePlans'])->name('api.admin.v1.clinics.available-plans');

        // ⛔ Keep dynamic route at the bottom
        Route::get('/{clinic}', [AdminClinicApiController::class, 'show'])->name('api.admin.v1.clinics.show');
        Route::put('/{clinic}', [AdminClinicApiController::class, 'update'])->name('api.admin.v1.clinics.update');
        Route::delete('/{clinic}', [AdminClinicApiController::class, 'destroy'])->name('api.admin.v1.clinics.destroy');
    });
});

/********************************************************************
 * ✅ Patient API Routes
 *******************************************************************/

Route::prefix('v1/patient')->group(function () {

    Route::post('sendOtp', [PatientApiAuthController::class, 'sendOtp'])->name('api.patient.v1.sendOtp'); // ✅ Send OTP (for mobile verification during signup or login)
    Route::post('verifyOtp', [PatientApiAuthController::class, 'verifyOtp'])->name('api.patient.v1.verifyOtp'); // ✅ Verify Mobile (OTP verification)
    Route::post('signup', [PatientApiAuthController::class, 'signup'])->name('api.patient.v1.signup'); // ✅ Signup
    Route::post('loginOtp', [PatientApiAuthController::class, 'loginOtp'])->name('api.patient.v1.loginOtp'); // ✅ Send OTP Login
    Route::post('login', [PatientApiAuthController::class, 'login'])->name('api.patient.v1.login'); // ✅ Login (email/mobile)
    Route::post('logout', [PatientApiAuthController::class, 'logout'])->middleware('auth:sanctum')->name('api.patient.v1.logout'); // ✅ Logout

    //######### ✅ Get clinics associated with patient #########
    Route::get('{id}/details', [PatientClinicApiController::class, 'show'])->name('api.patient.v1.details');
    Route::get('clinic/{id}/redirect', [PatientClinicApiController::class, 'qrRedirect'])->name('clinic.qr.redirect'); // Web route for QR code redirect

    // ✅ Protected Routes (Need Bearer Token)
    Route::middleware('auth:sanctum')->group(function () {

        // Basic Information
        Route::post('getProfile', [PatientApiAuthController::class, 'getProfile'])->name('api.patient.v1.getProfile');
        Route::post('updateProfile', [PatientApiAuthController::class, 'updateProfile'])->name('api.patient.v1.updateProfile');

        // Clinic Details
        Route::post('addClinic', [PatientClinicApiController::class, 'addClinic'])->name('api.patient.v1.addClinic');
        Route::post('getClinics', [PatientClinicApiController::class, 'getClinics'])->name('api.patient.v1.getClinics');
        Route::post('clinicDetails', [PatientClinicApiController::class, 'clinicDetails'])->name('api.patient.v1.clinicDetails');
        Route::post('doctorDetails', [PatientClinicApiController::class, 'doctorDetails'])->name('api.patient.v1.doctorDetails');
        Route::post('getDoctorSlots', [PatientClinicApiController::class, 'getSlots'])->name('api.patient.v1.getDoctorSlots');
        Route::post('bookAppointment', [PatientClinicApiController::class, 'bookAppointment'])->name('api.patient.v1.bookAppointment');
        Route::post('getAppointment', [PatientClinicApiController::class, 'getAppointment'])->name('api.patient.v1.getAppointment');
        Route::post('updateAppointmentStatus', [PatientClinicApiController::class, 'updateAppointmentStatus'])->name('api.patient.v1.updateAppointmentStatus');

        // Basic Setting page 
        Route::get('faqPatient', [BasicSettingController::class, 'faqPatient'])->name('api.patient.v1.faqPatient'); 
        Route::get('privacyPolicyPatient', [BasicSettingController::class, 'privacyPolicyPatient'])->name('api.patient.v1.privacyPolicyPatient'); 
        Route::get('termsPatient', [BasicSettingController::class, 'termsPatient'])->name('api.patient.v1.termsPatient');

        // Prescriptions
        Route::post('patientPrescriptions', [PatientPrescriptionController::class, 'patientPrescriptions'])->name('api.patient.v1.patientPrescriptions');
        Route::post('getPatientPrescriptions', [PatientPrescriptionController::class, 'getPatientPrescriptions'])->name('api.patient.v1.getPatientPrescriptions');
        Route::post('updatePatientPrescriptions', [PatientPrescriptionController::class, 'updatePatientPrescriptions'])->name('api.patient.v1.updatePatientPrescriptions');

        Route::post('downloadPrescriptionPDF', [PatientPrescriptionController::class, 'downloadPrescriptionPDF'])->name('api.patient.v1.downloadPrescriptionPDF');
        Route::post('patientUploadEMR', [PatientPrescriptionController::class, 'patientUploadEMR'])->name('api.patient.v1.patientUploadEMR');
        Route::post('getpatientUploadEMR', [PatientPrescriptionController::class, 'getpatientUploadEMR'])->name('api.patient.v1.getpatientUploadEMR');

        // Support 
        Route::post('support', [SupportController::class, 'patientStore']);   // create ticket
        Route::post('getSupport', [SupportController::class, 'patientTickets']); // list patient tickets
        Route::post('getSupportAppointment', [SupportController::class, 'getSupportAppointment']); // list patient tickets

    });

});

/********************************************************************
 * ✅ Common API Routes
 *******************************************************************/

Route::prefix('v1/patient')->middleware(['token.query', 'auth:sanctum'])->group(function () {
    Route::get('call', [VideoSDKController::class, 'videoCallApi']);
});

Route::post('v1/updateMeeting', [CommonApiController::class, 'updateMeetingId']); // Common APi for Both Side 
Route::post('v1/updateMeetingIdToken', [CommonApiController::class, 'updateMeetingIdToken']); // Common APi for Both Side 

/********************************************************************
 * ✅ Doctor API Routes
 *******************************************************************/

Route::prefix('v1/doctor')->group(function () {

    // Common Details for Doctor 
    Route::get('specialization', [CommonApiController::class, 'getSpecializations'])->name('api.doctor.v1.specialization');
    Route::get('clinics', [CommonApiController::class, 'getClinics'])->name('api.doctor.v1.clinics');

    Route::post('sendOtp', [DoctorApiAuthController::class, 'sendOtp'])->name('api.doctor.v1.sendOtp'); // ✅ Send OTP (for mobile verification during signup or login)
    Route::post('verifyOtp', [DoctorApiAuthController::class, 'verifyOtp'])->name('api.doctor.v1.verifyOtp'); // ✅ Verify Mobile (OTP verification)
    Route::post('signup', [DoctorApiAuthController::class, 'signup']); // ✅ Signup
    Route::post('loginOtp', [DoctorApiAuthController::class, 'loginOtp'])->name('api.doctor.v1.loginOtp'); // ✅ Send OTP Login
    Route::post('login', [DoctorApiAuthController::class, 'login']) ->name('api.doctor.v1.login'); // ✅ Login (email/mobile & password)
    Route::post('logout', [DoctorApiAuthController::class, 'logout'])->middleware('auth:sanctum')->name('api.doctor.v1.logout'); // ✅ Logout

    // ✅ Protected Routes (Need Bearer Token)
    Route::middleware(['auth:sanctum', 'role:doctor|primary_doctor|sub_doctor'])->group(function () {

        Route::post('dashboard', [DoctorApiAuthController::class, 'dashboard']) ->name('api.doctor.v1.dashboard');

        // Basic Information
        Route::post('getProfile', [DoctorApiAuthController::class, 'getProfile']) ->name('api.doctor.v1.getProfile');
        Route::post('updateProfile', [DoctorApiAuthController::class, 'updateProfile']) ->name('api.doctor.v1.updateProfile');

        // Doctor with Clinic Details
        Route::post('getClinics', [DoctorClinicApiController::class, 'getClinics'])->name('api.doctor.v1.getClinics');
        Route::post('addAvailability', [DoctorClinicApiController::class, 'addAvailability'])->name('api.doctor.v1.addAvailability');
        Route::post('getAvailability', [DoctorClinicApiController::class, 'getAvailability'])->name('api.doctor.v1.getAvailability');
        Route::post('updateAvailability', [DoctorClinicApiController::class, 'updateAvailability'])->name('api.doctor.v1.updateAvailability');
        Route::post('getDoctorAppointments', [DoctorClinicApiController::class, 'getDoctorAppointments'])->name('api.doctor.v1.getDoctorAppointments');
        Route::post('acceptAppoinments', [DoctorClinicApiController::class, 'acceptAppoinments'])->name('api.doctor.v1.acceptAppoinments');
        Route::post('updateAppointmentStatus', [DoctorClinicApiController::class, 'updateAppointmentStatus'])->name('api.doctor.v1.updateAppointmentStatus');
        
        // Basic Setting page 
        Route::get('faqDoctor', [BasicSettingController::class, 'faqDoctors'])->name('api.doctor.v1.faqDoctors');
        Route::get('privacyPolicyDoctor', [BasicSettingController::class, 'privacyPolicyDoctor'])->name('api.doctor.v1.privacyPolicyDoctor');
        Route::get('termsDoctor', [BasicSettingController::class, 'termsDoctor'])->name('api.doctor.v1.termsDoctor');

        // Prescriptions
        Route::post('doctorPrescriptions', [DoctorPrescriptionController::class, 'doctorPrescriptions'])->name('api.doctor.v1.doctorPrescriptions');
        Route::post('getDoctorPrescriptions', [DoctorPrescriptionController::class, 'getDoctorPrescriptions'])->name('api.doctor.v1.getDoctorPrescriptions');
        Route::post('updateDoctorPrescriptions', [DoctorPrescriptionController::class, 'updateDoctorPrescriptions'])->name('api.doctor.v1.updateDoctorPrescriptions');

        
        Route::post('downloadPrescriptionPDF', [DoctorPrescriptionController::class, 'downloadPrescriptionPDF'])->name('api.doctor.v1.downloadPrescriptionPDF');
        Route::post('doctorUploadEMR', [DoctorPrescriptionController::class, 'doctorUploadEMR'])->name('api.doctor.v1.doctorUploadEMR');
        Route::post('getDoctorUploadEMR', [DoctorPrescriptionController::class, 'getDoctorUploadEMR'])->name('api.doctor.v1.getDoctorUploadEMR');

        // Support 
        Route::post('support', [SupportController::class, 'doctorStore']);   // create ticket
        Route::post('getSupport', [SupportController::class, 'doctorTickets']); // list doctor tickets
        Route::post('getSupportDoctorAppointment', [SupportController::class, 'getSupportDoctorAppointment']); // list patient tickets
    });

});

