<?php

use App\Http\Controllers\Admin\Auth\SuperAdminAuthController;
use App\Http\Controllers\Admin\Auth\SuperAdminStaffAuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Admin\Clinic\ClinicController;
use App\Http\Controllers\Admin\CustomAuthController;
use App\Http\Controllers\Admin\DeviceTracking\DeviceTrackingController;
use App\Http\Controllers\Admin\DoctorManagementController;
use App\Http\Controllers\Admin\PatientManagementController;
use App\Http\Controllers\Admin\Plans\AddonController;
use App\Http\Controllers\Admin\Plans\FeatureController;
use App\Http\Controllers\Admin\Plans\UsageTypeController;
use App\Http\Controllers\Admin\StaffManagementController;
use App\Http\Controllers\Admin\SubscriptionPlanController;
use App\Http\Controllers\Admin\UserManagementController;
use App\Http\Controllers\Admin\AppointmentsController;
use App\Http\Controllers\Admin\SettingController;
use Illuminate\Support\Facades\Route;

Route::get('/login', function () {
    return redirect()->route('admin.login');
})->name('login');

Route::prefix('admin')->group(function () {

    Route::middleware(['redirect_if_authenticated:superadmin'])->group(function () {
        Route::get('login', [SuperAdminAuthController::class, 'showLoginForm'])->name('admin.login');
        Route::get('staff/login', [SuperAdminStaffAuthController::class, 'showLoginForm'])->name('admin.staff.login');
        Route::get('signout', [SuperAdminAuthController::class, 'signOut'])->name('admin.signout');
        // Route::post('custom-login', [CustomAuthController::class, 'customLogin'])->name('admin.login.custom');
        #Route::get('register', [CustomAuthController::class, 'registration'])->name('admin.register');
        #Route::post('custom-register', [CustomAuthController::class, 'customRegistration'])->name('admin.register.custom');
    });

    Route::middleware(['auth:superadmin'])->group(function () {
    Route::post('logout', [SuperAdminAuthController::class, 'logout'])->name('admin.logout');
    Route::get('dashboard', [DashboardController::class, 'adminDashboard'])->name('admin.dashboard');

        Route::middleware(['role:superadmin'])->group(function () {
        //            Route::view('role-manager', 'admin/role-manager')->name('admin.role-manager');
        Route::get('profile', [CustomAuthController::class, 'profile'])->name('admin.profile.setup');
        Route::get('track-device', [DeviceTrackingController::class, 'index'])->name('admin.track-device');
        //            Route::get('user-management', [UserManagementController::class, 'index'])->name('admin.user-management');
        Route::get('patient-list', [PatientManagementController::class, 'list'])->name('admin.patient-list');
        Route::get('patient-management/{id?}', [PatientManagementController::class, 'index'])
            ->name('admin.patient-management');
        Route::get('patient-view/{id?}', [PatientManagementController::class, 'view'])
            ->name('admin.patient-view');
        //            /* Route::view('staff-list', 'Staff/staff-list')->name('admin.staff-list');
        //            Route::view('add-staff', 'Staff/add-staff')->name('admin.add-staff'); */
        //            Route::view('departments', 'Departments/departments')->name('admin.departments');
        //            Route::view('add-department', 'Departments/add-department')->name('admin.add-department');
        //
        Route::prefix('plans/usage-types')->group(function () {
            Route::get('/form', [UsageTypeController::class, 'form'])
                ->name('admin.plans.usage-types.create');

            Route::get('/form/{usageType}', [UsageTypeController::class, 'form'])
                ->name('admin.plans.usage-types.edit');

            Route::get('/', [UsageTypeController::class, 'index'])
                ->name('admin.plans.usage-types.index');
        });

        Route::prefix('plans/features')->group(function () {
            Route::get('/', [FeatureController::class, 'index'])
                ->name('admin.plans.features.index');

            Route::get('/create', [FeatureController::class, 'form'])
                ->name('admin.plans.features.create');

            Route::get('/edit/{feature}', [FeatureController::class, 'form'])
                ->name('admin.plans.features.edit');
        });

        Route::prefix('plans/addons')->group(function () {
            Route::get('/', [AddonController::class, 'index'])
                ->name('admin.plans.addons.index');

            Route::get('/create', [AddonController::class, 'form'])
                ->name('admin.plans.addons.create');

            Route::get('/edit/{addon}', [AddonController::class, 'form'])
                ->name('admin.plans.addons.edit');
        });

        Route::get('subscription-plans', [SubscriptionPlanController::class, 'index'])->name('admin.subscription-plans');
        Route::get('subscription-plans/list', [SubscriptionPlanController::class, 'planlist'])->name('admin.subscription-plans.list');
        Route::get('subscription-plans/{plan}', [SubscriptionPlanController::class, 'show'])
            ->name('admin.subscription-plans.show');
        Route::get('subscription-plans/{plan}/edit', [SubscriptionPlanController::class, 'edit'])
            ->name('admin.subscription-plans.edit');
        });

        Route::middleware(['role:superadmin|superadminstaff', 'permission:list staff|create staff|edit staff|manage staff'])
            ->group(function () {
                // Specific routes first
                Route::get('staff-management/create', [StaffManagementController::class, 'create'])
                    ->name('admin.staff-management.create')
                    ->middleware('permission:create staff');

                Route::get('staff-management/edit/{id}', [StaffManagementController::class, 'edit'])
                    ->name('admin.staff-management.edit')
                    ->middleware('permission:edit staff');

                Route::get('staff-management/view/{id}', [StaffManagementController::class, 'view'])
                    ->name('admin.staff-management.view')
                    ->middleware('permission:view staff');

                // General routes last
                Route::get('staff-management/{id?}', [StaffManagementController::class, 'index'])
                    ->name('admin.staff-management')
                    ->middleware('permission:list staff|manage staff');

                Route::get('staff-list', [StaffManagementController::class, 'list'])
                    ->name('admin.staff-list')
                    ->middleware('permission:list staff');
        });

        Route::middleware(['role:superadmin|superadminstaff', 'permission:list doctors|create doctors|edit doctors|view doctor profile'])
            ->group(function () {
                Route::get('doctor-management', [DoctorManagementController::class, 'index'])
                    ->name('admin.doctor-management')
                    ->middleware('permission:list doctors');

                Route::get('doctor-management/create', [DoctorManagementController::class, 'create'])
                    ->name('admin.doctor-management.create')
                    ->middleware('permission:create doctors');

                Route::get('doctor-management/edit/{id}', [DoctorManagementController::class, 'edit'])
                    ->name('admin.doctor-management.edit')
                    ->middleware('permission:edit doctors');

                Route::get('doctor-management/view/{id}', [DoctorManagementController::class, 'view'])
                    ->name('admin.doctor-management.view')
                    ->middleware('permission:view doctor profile');

                Route::get('doctor-management/clinic-manager/{doctorId?}', [DoctorManagementController::class, 'clinicManager'])
                    ->name('admin.doctor-management.clinic-manager')
                    ->middleware('permission:edit doctors');
        });

        Route::prefix('clinics')->middleware(['role:superadmin|superadminstaff', 'permission:list clinics|create clinics|edit clinics|view clinics'])
            ->group(function () {
                Route::get('/', [ClinicController::class, 'index'])
                    ->name('admin.clinics.index')
                    ->middleware('permission:list clinics');

                Route::get('/create', [ClinicController::class, 'form'])
                    ->name('admin.clinics.create')
                    ->middleware('permission:create clinics');

                Route::get('/edit/{clinic}', [ClinicController::class, 'form'])
                    ->name('admin.clinics.edit')
                    ->middleware('permission:edit clinics');

                Route::get('/view/{clinic}', [ClinicController::class, 'view'])
                    ->name('admin.clinics.view')
                    ->middleware('permission:view clinics');

                Route::get('/view/{clinic}/doctor-management/edit/{id}', [ClinicController::class, 'clinicDoctorEdit'])
                    ->name('admin.clinics.doctor.management.edit')
                    ->middleware('permission:edit clinics');

                Route::get('/view/{clinic}/doctor-management/create', [ClinicController::class, 'clinicDoctorCreate'])
                    ->name('admin.clinics.doctor.management.create')
                    ->middleware('permission:edit clinics');
        });

        Route::middleware(['role:superadmin'])->group(function () {
            Route::get('appointment-list', [AppointmentsController::class, 'index'])->name('admin.appointment-list');
            Route::get('newappointments/create', [AppointmentsController::class, 'create'])->name('admin.appointment.create');
            Route::post('appointments/store', [AppointmentsController::class, 'store'])->name('admin.appointments.store');
            // Route::get('appointments/edit/{id}', [AppointmentController::class, 'edit'])->name('appointment.edit');
            // Route::post('appointments/update/{id}', [AppointmentController::class, 'update'])->name('appointment.update');
            // Route::get('appointments/delete/{id}', [AppointmentController::class, 'destroy'])->name('appointment.delete');
        });

        Route::middleware(['role:superadmin'])
            ->group(function () {
                Route::get('/specialization', [SettingController::class, 'specializationIndex'])->name('admin.specialization-index');
                Route::post('/specialization/store', [SettingController::class, 'specializationStore'])->name('admin.specialization.store');
                Route::get('/specialization/edit/{id}', [SettingController::class, 'specializationEdit'])->name('admin.specialization.edit');
                Route::post('/specialization/update/{id}', [SettingController::class, 'specializationUpdate'])->name('admin.specialization.update');
                Route::get('/specialization/delete/{id}', [SettingController::class, 'specializationDelete'])->name('admin.specialization.delete');
                Route::get('/specialization/toggle/{id}', [SettingController::class, 'specializationToggle'])->name('admin.specialization.toggle');

                // Terms and Conditions
                Route::get('patient-terms', [SettingController::class, 'terms'])->name('admin.patient-terms');
                Route::post('patient-terms/store', [SettingController::class, 'storeTerm'])->name('admin.patient-terms.store');
                Route::get('patient-terms/edit/{id}', [SettingController::class, 'editTerm'])->name('admin.terms.edit');
                Route::post('patient-terms/update/{id}', [SettingController::class, 'updateTerm'])->name('admin.terms.update');
                Route::get('patient-terms/delete/{id}', [SettingController::class, 'deleteTerm'])->name('admin.patient-terms.delete');
                Route::get('patient-terms/toggle-status/{id}', [SettingController::class, 'toggleStatus'])->name('admin.patient-terms.toggle-status');

                Route::get('doctor-terms', [SettingController::class, 'dterms'])->name('admin.doctor-terms');
                Route::post('doctor-terms/store', [SettingController::class, 'dstoreTerm'])->name('admin.doctor-terms.store');
                Route::get('doctor-terms/delete/{id}', [SettingController::class, 'ddeleteTerm'])->name('admin.doctor-terms.delete');
                Route::get('doctor-terms/toggle-status/{id}', [SettingController::class, 'dtoggleStatus'])->name('admin.doctor-terms.toggle-status');
                
                // Privacy Policy
                Route::get('patient-privacy', [SettingController::class, 'privacy'])->name('admin.patient-privacy');
                Route::post('patient-privacy/store', [SettingController::class, 'storePrivacy'])->name('admin.patient-privacy.store');
                Route::get('patient-privacy/edit/{id}', [SettingController::class, 'editPrivacy'])->name('admin.privacy.edit');
                Route::post('patient-privacy/update/{id}', [SettingController::class, 'updatePrivacy'])->name('admin.privacy.update');
                Route::get('patient-privacy/delete/{id}', [SettingController::class, 'deletePrivacy'])->name('admin.patient-privacy.delete');
                Route::get('patient-privacy/toggle-status/{id}', [SettingController::class, 'togglePrivacyStatus'])->name('admin.patient-privacy.toggle-status');

                Route::get('doctor-privacy', [SettingController::class, 'dprivacy'])->name('admin.doctor-privacy');
                Route::post('doctor-privacy/store', [SettingController::class, 'dstorePrivacy'])->name('admin.doctor-privacy.store');
                Route::get('doctor-privacy/delete/{id}', [SettingController::class, 'ddeletePrivacy'])->name('admin.doctor-privacy.delete');
                Route::get('doctor-privacy/toggle-status/{id}', [SettingController::class, 'dtogglePrivacyStatus'])->name('admin.doctor-privacy.toggle-status');

                // FAQ
                Route::get('patient-faq', [SettingController::class, 'faq'])->name('admin.patient-faq');
                Route::post('patient-faq/store', [SettingController::class, 'storeFaq'])->name('admin.patient-faq.store');
                Route::get('patient-faq/edit/{id}', [SettingController::class, 'editFaq'])->name('admin.faq.edit');
                Route::post('patient-faq/update/{id}', [SettingController::class, 'updateFaq'])->name('admin.faq.update');
                Route::delete('patient-faq/delete/{id}', [SettingController::class, 'destroyFaq'])->name('admin.patient-faq.delete');
                Route::get('patient-faq/toggle-status/{id}', [SettingController::class, 'toggleFaqStatus'])->name('admin.patient-faq.toggle-status');

                Route::get('doctor-faq', [SettingController::class, 'dfaq'])->name('admin.doctor-faq');
                Route::post('doctor-faq/store', [SettingController::class, 'dstoreFaq'])->name('admin.doctor-faq.store');
                Route::delete('doctor-faq/delete/{id}', [SettingController::class, 'ddestroyFaq'])->name('admin.doctor-faq.delete');
                Route::get('doctor-faq/toggle-status/{id}', [SettingController::class, 'dtoggleFaqStatus'])->name('admin.doctor-faq.toggle-status');

                // Notification
                Route::get('notification', [SettingController::class, 'notification'])->name('admin.notification');
                Route::post('notifications/store', [SettingController::class, 'storeNotification'])->name('admin.notification.store');
                Route::delete('notifications/delete/{id}', [SettingController::class, 'destroyNotification'])->name('admin.notification.delete');

        });

        // Route::middleware(['role:doctor'])->group(function () {
        //     Route::view('doctor-dashboard', 'Dashboard/doctor-dashboard')->name('admin.doctor-dashboard');
        //     Route::view('patients', 'Patients/patients')->name('admin.patients');
        //     Route::view('schedule', 'Doctorschedule/schedule')->name('admin.schedule');
        // });

        // Route::middleware(['auth', 'role:patient'])->group(function () {
        //     Route::get('patient-dashboard', function () {
        //         return view('Dashboard/patient-dashboard', ['user' => auth()->user()]);
        //     })->name('admin.patient-dashboard');
        // });
    });
});
