@extends('layouts.app')

@section('title', 'Patient Dashboard')

@section('content')

<style>
.fl-wrapper[data-position^=top-] {
    top: 5em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Page Header -->
        <div class="mb-3 border-bottom pb-3">
            <h4 class="fw-bold mb-0">Doctor Details : About {{ $data['name'] }}</h4>
        </div>
        <!-- End Page Header -->

        <div class="container my-4">
            <!-- Doctor Profile -->
            <div class="card shadow-sm border-0 mb-4 p-3">
                <div class="d-flex align-items-center">
                    <!-- Doctor Image -->
                    <img src="{{ $data['profile_image'] ?? asset('assets/img/icons/sidebar-icon.svg') }}" alt="Doctor" class="rounded" style="width: 100px; height: 100px; object-fit: cover;">
                    <!-- <img src="{{ asset('./assets/img/icons/sidebar-icon.svg') }}" 
                        alt="Doctor" 
                        class="rounded" 
                        style="width: 100px; height: 100px; object-fit: cover;"> -->

                    <!-- Doctor Details -->
                    <div class="ms-3 flex-fill">
                        <h5 class="fw-bold mb-1">{{ $data['name'] }}</h5>
                        <p class="text-muted mb-2 d-flex align-items-center">
                            <i class="ti ti-heart-filled text-danger me-1"></i>
                             {{ is_array($data['specialization']) ? implode(', ', $data['specialization']) : ($data['specialization'] ?? 'N/A') }}


                            <span class="ms-3">
                                <i class="ti ti-star text-warning"></i> {{ $data['rating'] ?? '0' }} ({{ $data['reviews_count'] ?? '0' }} reviews)
                            </span>
                        </p>
                        <a href="{{ route('patient.appointments.create') }}" class="btn btn-primary btn-sm">
                            <i class="ti ti-calendar"></i>&nbsp;Book Consultation
                        </a>
                    </div>
                </div>
            </div>

            <!-- Details Section -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-2">Details</h6>
                    <p class="text-muted medium">
                        {{ $data['bio'] ?? 'No bio available.' }}
                    </p>
                </div>
            </div>

            <!-- Education -->
            @if($data['education']->isNotEmpty())
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Education</h6>
                    <ul class="list-group list-group-flush">
                        @foreach($data['education'] as $edu)
                            <li class="list-group-item">{{ $edu->degree }} - {{ $edu->institute }} ({{ $edu->year ?? 'N/A' }})</li>
                        @endforeach
                    </ul>
                </div>
            </div>
            @endif

            <!-- Experience -->
            @if($data['experiences']->isNotEmpty())
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Experience</h6>
                    <ul class="list-group list-group-flush">
                        @foreach($data['experiences'] as $exp)
                            <li class="list-group-item">{{ $exp->position }} at {{ $exp->organization }} ({{ $exp->start_year ?? 'N/A' }} - {{ $exp->end_year ?? 'Present' }})</li>
                        @endforeach
                    </ul>
                </div>
            </div>
            @endif

            <!-- Consultation Type -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Consultation Type</h6>
                    <div class="d-flex gap-2">
                        <button class="btn btn-outline-primary active"><i class="ti ti-user"></i> In-person - </button>
                        <!-- <button class="btn btn-outline-secondary"><i class="ti ti-phone"></i> Phone Call</button> -->
                        <button class="btn btn-outline-secondary"><i class="ti ti-video"></i> Video Call - </button>
                    </div>
                </div>
            </div>

            <!-- Upcoming Slots -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-semibold mb-3">Upcoming Slots <i class="ti ti-calendar ms-1"></i></h6>
                    
                    <p class="fw-semibold">Today</p>
                    <div class="d-flex flex-wrap gap-2 mb-3">
                        <button class="btn btn-outline-secondary btn-sm" disabled>10:00 AM<br><small>Unavailable</small></button>
                        <button class="btn btn-outline-primary btn-sm">11:00 AM<br><small>Available</small></button>
                        <button class="btn btn-outline-primary btn-sm">12:00 PM<br><small>Available</small></button>
                        <button class="btn btn-outline-primary btn-sm">01:00 PM<br><small>Available</small></button>
                    </div>

                    <p class="fw-semibold">Tomorrow</p>
                    <div class="d-flex flex-wrap gap-2">
                        <button class="btn btn-outline-primary btn-sm">10:00 AM<br><small>Available</small></button>
                        <button class="btn btn-outline-secondary btn-sm" disabled>11:00 AM<br><small>Unavailable</small></button>
                        <button class="btn btn-outline-primary btn-sm">12:00 PM<br><small>Available</small></button>
                        <button class="btn btn-outline-primary btn-sm">01:00 PM<br><small>Available</small></button>
                    </div>


                
                           @php
    // Ensure availability is a Collection (safe even if controller passed array or null)
    $availabilities = collect($data['availability'] ?? []);
    // Group by day (normalize to lowercase). If your DB stores weekday names use that; otherwise adapt mapping.
    $grouped = $availabilities->groupBy(function($item) {
        return strtolower(data_get($item, 'day', 'unknown'));
    });
@endphp

@if($grouped->isEmpty())
    <p class="text-muted">No availability slots found.</p>
@else
    @foreach($grouped as $day => $slots)
        <p class="fw-semibold">{{ ucfirst($day) }}</p>
        <div class="d-flex flex-column gap-2 mb-3">
            @foreach($slots as $slot)
                <div class="border rounded p-2 d-flex flex-wrap align-items-center gap-3">
                    <!-- From Time -->
                    <div>
                        <strong>From:</strong>
                        {{ data_get($slot, 'from_time') ? \Carbon\Carbon::parse(data_get($slot, 'from_time'))->format('h:i A') : 'N/A' }}
                    </div>

                    <!-- To Time -->
                    <div>
                        <strong>To:</strong>
                        {{ data_get($slot, 'to_time') ? \Carbon\Carbon::parse(data_get($slot, 'to_time'))->format('h:i A') : 'N/A' }}
                    </div>

                    <!-- Slot Duration -->
                    <div>
                        <strong>Duration:</strong> {{ data_get($slot, 'slot_duration', 'N/A') }} mins
                    </div>

                    <!-- Time Slot (raw/time_slot field) -->
                    <div>
                        <strong>Time Slot:</strong> {{ data_get($slot, 'time_slot', 'N/A') }}
                    </div>

                    <!-- In-Person Fee -->
                    <div>
                        <strong>In-Person:</strong> ₹{{ number_format(data_get($slot, 'in_person_fee', 0), 0) }}
                    </div>

                    <!-- Video Fee -->
                    <div>
                        <strong>Video:</strong> ₹{{ number_format(data_get($slot, 'video_fee', 0), 0) }}
                    </div>

                    <!-- Availability -->
                    <div>
                        <span class="badge bg-{{ data_get($slot, 'status') == 1 ? 'success' : 'secondary' }}">
                            {{ data_get($slot, 'status') == 1 ? 'Available' : 'Unavailable' }}
                        </span>
                    </div>
                </div>
            @endforeach
        </div>
    @endforeach
@endif

                        
                    
            


                </div>
            </div>

            <!-- Book Button -->
            <div class="text-center">
                <a href="{{ route('patient.appointments.create') }}" class="btn btn-primary w-50 py-3 fw-semibold d-inline-block">
                    <i class="ti ti-calendar"></i>&nbsp; Book Consultation
                </a>
            </div>

        </div>
    </div>
    <!-- End Content -->
@endsection
