@extends('layouts.app')

@section('title', 'Patient Dashboard')

@section('content')

<style>
.fl-wrapper[data-position^=top-] {
    top: 5em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Page Header -->
        <div class="mb-3 border-bottom pb-3">
            <h4 class="fw-bold mb-0">Clinic Details : About {{ $clinic->name }}</h4>
        </div>
        <!-- End Page Header -->

        <!-- Hospital Detail Page -->
        <div class="container my-4">

            <!-- Hospital Image -->
            <div class="card mb-3 shadow-sm border-0">
                <img src="{{ asset('assets/img/hospital.png') }}" class="card-img-top" alt="Hospital Image" style="border-radius: 10px; height: 200px; object-fit: cover;">
                <!-- <img src="{{ $clinic->image ? url('storage/'.$clinic->image) : asset('assets/img/hospital.png') }}" class="me-3 rounded" width="120" height="120" alt="Clinic Image"> -->
            </div>

            <!-- Hospital Info -->
            <div class="card shadow-sm border-0 p-3 mb-4">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <h4 class="fw-bold mb-1"><i class="ti ti-building-hospital me-1"></i> {{ $clinic->name }}</h4>
                        <p class="text-muted mb-2"><i class="ti ti-map-pin me-1 text-primary"></i>  
                            {{ $clinic->line1 }}, {{ $clinic->line2 }}, 
                            {{ $clinic->city }}, {{ $clinic->state }}, 
                            {{ $clinic->country }} - {{ $clinic->pincode }}
                        </p>
                    </div>
                    <div class="text-end">
                        <span class="fw-bold fs-16 text-warning">{{ $rating }} ★</span>
                    </div>
                </div>

                <!-- Specialties -->
                <div class="mt-3">
                    <h6 class="fw-semibold mb-2">Specialties</h6>
                    <div>
                        @forelse($specialities as $speciality)
                            <span class="badge bg-light text-dark border rounded-pill px-3 py-2 me-2">
                                {{ trim($speciality) }}
                            </span>
                        @empty
                            <span class="text-muted">N/A</span>
                        @endforelse
                    </div>
                </div>

                <!-- Details -->
                <div class="mt-4">
                    <h6 class="fw-semibold mb-2">Details</h6>
                    <p class="text-muted mb-0" style="line-height: 1.6;">
                        {{ $clinic->about ?? 'No details available.' }}
                    </p>
                </div>
            </div>

            <!-- Doctors Section -->
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0">Our Doctors</h5>
                <!-- <a href="#" class="text-primary small fw-medium">View All</a> -->
            </div>

            @forelse($clinic->doctors as $doctor)
                <a href="{{ route('patient.doctor.doctorDetail', ['id' => $doctor['id']]) }}" class="text-decoration-none text-dark">
                    <div class="card shadow-sm border-0 mb-3">
                        <div class="card-body d-flex align-items-center">
                            {{-- Doctor Image --}}
                            <img src="{{ $doctor->profileImage }}" alt="Doctor" class="rounded-circle me-3" style="width:50px; height:50px; object-fit:cover;">
                            <!-- <img 
                                src="{{ $doctor->profile_image ? asset('uploads/doctor/' . $doctor->profile_image) : asset('assets/img/icons/sidebar-icon.svg') }}" 
                                alt="Doctor" 
                                class="rounded-circle me-3" 
                                style="width: 50px; height: 50px;"
                            > -->

                            <div class="flex-fill">
                                <h6 class="mb-1 fw-semibold">{{ $doctor->name }}</h6>
                                <p class="mb-1"><i class="ti ti-mail"></i> {{ $doctor->email }}</p>
                                <p class="mb-1"><i class="ti ti-phone"></i> {{ $doctor->phone_number ?? 'N/A' }}</p>
                                
                                {{-- Doctor Specialisations --}}
                                <p class="mb-0 text-muted small">
                                    <i class="ti ti-stethoscope"></i>
                                    {{ $doctor->specializations }}
                                    @if(!empty($doctor['specializations']))
                                        @foreach($doctor['specializations'] as $spec)
                                            {{ $spec }}@if(!$loop->last), @endif
                                        @endforeach
                                    @else
                                        ---
                                    @endif
                                </p>
                            </div>
                            <i class="ti ti-chevron-right text-muted"></i>
                        </div>
                    </div>
                </a>
            @empty
                <p class="text-muted">No doctors assigned to this clinic yet.</p>
            @endforelse

        </div>
    </div>
    <!-- End Content -->
@endsection
