
<!DOCTYPE html>
<html lang="en">

<head>

	<!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Patient Details - Medical & Hospital - Bootstrap 5 Admin Template</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="author" content="Dreams Technologies">
	
    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/img/favicon.png">

    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="assets/img/apple-icon.png">

    <!-- Theme Config Js -->
    <script src="assets/js/theme-script.js"></script>

    <!-- Font Awosome Icon CSS -->
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <!-- intel input -->
    <link rel="stylesheet" href="assets/plugins/intltelinput/css/intlTelInput.css">

    <!-- Tabler Icon CSS -->
    <link rel="stylesheet" href="assets/plugins/tabler-icons/tabler-icons.min.css">

    <!-- Select2 CSS -->
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

    <!-- Daterangepikcer CSS -->
	<link rel="stylesheet" href="assets/plugins/daterangepicker/daterangepicker.css">

    <!-- Datetimepicker CSS -->
    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <!-- Datatable CSS -->
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap5.min.css">

    <!-- Rangeslider CSS -->
	<link rel="stylesheet" href="assets/plugins/ion-rangeslider/css/ion.rangeSlider.css">
	<link rel="stylesheet" href="assets/plugins/ion-rangeslider/css/ion.rangeSlider.min.css">

    <!-- Simplebar CSS -->
    <link rel="stylesheet" href="assets/plugins/simplebar/simplebar.min.css">

    <!-- Datatable CSS -->
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap5.min.css">

    <!-- Main CSS -->
    <link rel="stylesheet" href="assets/css/style.css" id="app-style">

</head>

<body>

    <!-- Begin Wrapper -->
    <div class="main-wrapper">

        <!-- Topbar Start -->
        <header class="navbar-header">
            <div class="page-container topbar-menu">
                <div class="d-flex align-items-center gap-2">

                    <!-- Logo -->
                    <a href="index.html" class="logo">

                        <!-- Logo Normal -->
                        <span class="logo-light">
                            <span class="logo-lg"><img src="assets/img/logo.svg" alt="logo"></span>
                            <span class="logo-sm"><img src="assets/img/logo-small.svg" alt="small logo"></span>
                        </span>

                        <!-- Logo Dark -->
                        <span class="logo-dark">
                            <span class="logo-lg"><img src="assets/img/logo-white.svg" alt="dark logo"></span>
                        </span>
                    </a>

                    <!-- Sidebar Mobile Button -->
                    <a id="mobile_btn" class="mobile-btn" href="#sidebar">
                        <i class="ti ti-menu-deep fs-24"></i>
                    </a>
                       
                    <button class="sidenav-toggle-btn btn border-0 p-0 active" id="toggle_btn2"> 
                        <i class="ti ti-arrow-right"></i>
                    </button>  
					
                    <!-- Search -->
                    <div class="me-auto d-flex align-items-center header-search d-lg-flex d-none">
                        <!-- Search -->
                        <div class="input-icon-start position-relative me-2">
                            <span class="input-icon-addon">
                                <i class="ti ti-search"></i>
                            </span>
                           <input type="text" class="form-control shadow-sm" placeholder="Search">
                           <span class="input-icon-addon text-dark shadow fs-18 d-inline-flex p-0 header-search-icon"><i class="ti ti-command"></i></span>
                        </div>
                        <!-- /Search -->
                    </div>
					
                </div>

                <div class="d-flex align-items-center">
				
                    <!-- Search for Mobile -->
                    <div class="header-item d-flex d-lg-none me-2">
                        <button class="topbar-link btn btn-icon" data-bs-toggle="modal" data-bs-target="#searchModal" type="button">
                            <i class="ti ti-search fs-16"></i>
                        </button>
                    </div>
					
                    <!-- AI Assistance -->
					<a href="javascript:void(0);" class="btn btn-liner-gradient me-3 d-lg-flex d-none">AI Assistance<i class="ti ti-chart-bubble-filled ms-1"></i></a>
                    <!-- AI Assistance -->

                    <!-- Appointment -->
                    <div class="header-item">
                        <div class="dropdown me-2">
                            <a href="new-appointment.html" class="btn topbar-link"><i class="ti ti-calendar-due"></i></a>
                        </div>
                    </div>                    
                    <!-- Appointment -->

                    <!-- Settings -->
                    <div class="header-item">
                        <div class="dropdown me-2">
                            <a href="profile-settings.html" class="btn topbar-link"><i class="ti ti-settings-2"></i></a>
                        </div> 
                    </div> 
                    <!-- Settings -->                   

                    <!-- Light/Dark Mode Button -->
                    <div class="header-item d-none d-sm-flex me-2">
                        <button class="topbar-link btn btn-icon topbar-link" id="light-dark-mode" type="button">
                            <i class="ti ti-moon fs-16"></i>
                        </button>
                    </div>
                    
					
					<!-- Notification Dropdown -->
                    <div class="header-item">
						<div class="dropdown me-3">
						
							<button class="topbar-link btn btn-icon topbar-link dropdown-toggle drop-arrow-none" data-bs-toggle="dropdown" data-bs-offset="0,24" type="button" aria-haspopup="false" aria-expanded="false">
								<i class="ti ti-bell-check fs-16 animate-ring"></i>
								<span class="notification-badge"></span>
							</button>
							
							<div class="dropdown-menu p-0 dropdown-menu-end dropdown-menu-lg" style="min-height: 300px;">
							
								<div class="p-2 border-bottom">
									<div class="row align-items-center">
										<div class="col">
											<h6 class="m-0 fs-16 fw-semibold"> Notifications</h6>
										</div>
									</div>
								</div>
								
								<!-- Notification Body -->
								<div class="notification-body position-relative z-2 rounded-0" data-simplebar>
								 
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-1">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-01.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Dr. Smith</p>
												<p class="mb-1 text-wrap">
													updated the <span class="fw-medium text-dark">surgery</span> schedule. 
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>4 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-1">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
							
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-2">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-06.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Dr. Patel</p>
												<p class="mb-1 text-wrap">
                                                    completed a <span class="fw-medium text-dark">follow-up</span> report for patient <span class="fw-medium text-dark">Emily</span>.
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>8 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-2">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-3">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-02.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Emily</p>
												<p class="mb-1 text-wrap">
                                                    booked an appointment with <span class="fw-medium text-dark">Dr. Patel</span> for <span class="fw-medium text-dark">April 15</span>
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>15 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-3">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap" id="notification-4">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-07.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Amelia</p>
												<p class="mb-1 text-wrap">
                                                    completed the <span class="fw-medium text-dark">pre-visit</span> health questionnaire.
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>20 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-4">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									 
								</div>
								
								<!-- View All-->
								<div class="p-2 rounded-bottom border-top text-center">
									<a href="notifications.html" class="text-center text-decoration-underline fs-14 mb-0">
										View All Notifications
									</a>
								</div>
								
							</div>
						</div>
					</div>
					
					<!-- User Dropdown -->
					<div class="dropdown profile-dropdown d-flex align-items-center justify-content-center">
                        <a href="javascript:void(0);" class="topbar-link dropdown-toggle drop-arrow-none position-relative" data-bs-toggle="dropdown" data-bs-offset="0,22" aria-haspopup="false" aria-expanded="false">
                            <img src="assets/img/users/user-01.jpg" width="32" class="rounded-circle d-flex" alt="user-image">
                            <span class="online text-success"><i class="ti ti-circle-filled d-flex bg-white rounded-circle border border-1 border-white"></i></span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end dropdown-menu-md p-2">
                        
                            <div class="d-flex align-items-center bg-light rounded-3 p-2 mb-2">
                                <img src="assets/img/users/user-01.jpg" class="rounded-circle" width="42" height="42" alt="">
                                <div class="ms-2">
                                    <p class="fw-medium text-dark mb-0">Jimmy Anderson</p>
                                    <span class="d-block fs-13">Administrator</span>
                                </div>
                            </div>

                            <!-- Item-->
                            <a href="profile-settings.html" class="dropdown-item">
                                <i class="ti ti-user-circle me-1 align-middle"></i>
                                <span class="align-middle">Profile Settings</span>
                            </a>

                            <!-- Item-->
                            <a href="account-settings.html" class="dropdown-item">
                                <i class="ti ti-settings me-1 align-middle"></i>
                                <span class="align-middle">Account Settings</span>
                            </a>

                            <!-- item -->
                            <div class="form-check form-switch form-check-reverse d-flex align-items-center justify-content-between dropdown-item mb-0">
                                <label class="form-check-label" for="notify"><i class="ti ti-bell me-1"></i>Notifications</label>
                                <input class="form-check-input me-0" type="checkbox" role="switch" id="notify">
                            </div>

                            <!-- Item-->
                            <a href="transactions.html" class="dropdown-item">
                                <i class="ti ti-transition-right me-1 align-middle"></i>
                                <span class="align-middle">Transactions</span>
                            </a>

                                        
                            
                            <!-- Item-->
                            <div class="pt-2 mt-2 border-top">
                                <a href="login.html" class="dropdown-item text-danger">
                                    <i class="ti ti-logout me-1 fs-17 align-middle"></i>
                                    <span class="align-middle">Log Out</span>
                                </a>
                            </div>
                        </div>
                    </div>
						
                </div>
            </div>
        </header>
        <!-- Topbar End -->

        <!-- Search Modal -->
        <div class="modal fade" id="searchModal">
            <div class="modal-dialog modal-lg">
                <div class="modal-content bg-transparent">
                    <div class="card shadow-none mb-0">
                        <div class="px-3 py-2 d-flex flex-row align-items-center" id="search-top">
                            <i class="ti ti-search fs-22"></i>
                            <input type="search" class="form-control border-0" placeholder="Search">
                            <button type="button" class="btn p-0" data-bs-dismiss="modal" aria-label="Close"><i class="ti ti-x fs-22"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidenav Menu Start -->
        <div class="sidebar" id="sidebar">
            
            <!-- Start Logo -->
            <div class="sidebar-logo">
                <div>
                    <!-- Logo Normal -->
                    <a href="index.html" class="logo logo-normal">
                        <img src="assets/img/logo.svg" alt="Logo">
                    </a>

                    <!-- Logo Small -->
                    <a href="index.html" class="logo-small">
                        <img src="assets/img/logo-small.svg" alt="Logo">
                    </a>

                    <!-- Logo Dark -->
                    <a href="index.html" class="dark-logo">
                        <img src="assets/img/logo-white.svg" alt="Logo">
                    </a>
                </div>
                <button class="sidenav-toggle-btn btn border-0 p-0 active" id="toggle_btn"> 
                    <i class="ti ti-arrow-left"></i>
                </button>

                <!-- Sidebar Menu Close -->
                <button class="sidebar-close">
                    <i class="ti ti-x align-middle"></i>
                </button>                
            </div>
            <!-- End Logo -->

            <!-- Sidenav Menu -->
            <div class="sidebar-inner" data-simplebar>                
                <div id="sidebar-menu" class="sidebar-menu">
                    <div class="sidebar-top shadow-sm p-2 rounded-1 mb-3 dropend">
                        <a href="javascript:void(0);" class="drop-arrow-none" data-bs-toggle="dropdown" data-bs-auto-close="outside" data-bs-offset="0,22" aria-haspopup="false" aria-expanded="false">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <span class="avatar rounded-circle flex-shrink-0 p-2"><img src="./assets/img/icons/trustcare.svg" alt="img"></span>
                                    <div class="ms-2">
                                        <h6 class="fs-14 fw-semibold mb-0">Trustcare Clinic</h6>
                                        <p class="fs-13 mb-0">Lasvegas</p>
                                    </div>
                                </div>
                                <i class="ti ti-arrows-transfer-up"></i>                            
                            </div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-lg">
                            <div class="p-2"> 
                                <label class="dropdown-item d-flex align-items-center justify-content-between p-1">
                                    <span class="d-flex align-items-center">
                                        <span class="me-2"><img src="assets/img/icons/clinic-01.svg" alt=""></span>
                                        <span class="fw-semibold text-dark">CureWell Medical Hub<small class="d-block text-muted fw-normal fs-13">Ohio</small></span>
                                    </span>
                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                </label> 
                                <label class="dropdown-item d-flex align-items-center justify-content-between p-1">
                                    <span class="d-flex align-items-center">
                                        <span class="me-2"><img src="assets/img/icons/clinic-02.svg" alt=""></span>
                                        <span class="fw-semibold text-dark">Trustcare Clinic<small class="d-block text-muted fw-normal fs-13">Lasvegas</small></span>
                                    </span>
                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                </label> 
                                <label class="dropdown-item d-flex align-items-center justify-content-between p-1">
                                    <span class="d-flex align-items-center">
                                        <span class="me-2"><img src="assets/img/icons/clinic-03.svg" alt=""></span>
                                        <span class="fw-semibold text-dark">NovaCare Medical<small class="d-block text-muted fw-normal fs-13">Washington</small></span>
                                    </span>
                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                </label> 
                                <label class="dropdown-item d-flex align-items-center justify-content-between p-1">
                                    <span class="d-flex align-items-center">
                                        <span class="me-2"><img src="assets/img/icons/clinic-04.svg" alt=""></span>
                                        <span class="fw-semibold text-dark">Greeny Medical Clinic<small class="d-block text-muted fw-normal fs-13">Illinios</small></span>
                                    </span>
                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                </label> 
                            </div>
                        </div>
                    </div>
                    <ul>
                        <li class="menu-title"><span>Main Menu</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-layout-dashboard"></i><span>Dashboard</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="index.html">Admin Dashboard</a></li>
                                        <li><a href="doctor-dashboard.html">Doctor Dashboard</a></li>
                                        <li><a href="patient-dashboard.html">Patient Dashboard</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-apps"></i><span>Applications</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="chat.html">Chat</a></li>
                                        <li class="submenu submenu-two">
                                            <a href="#">Calls<span class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="voice-call.html">Voice Call</a></li>
                                                <li><a href="video-call.html">Video Call</a></li>
                                                <li><a href="outgoing-call.html">Outgoing Call</a></li>
                                                <li><a href="incoming-call.html">Incoming Call</a></li>
                                                <li><a href="call-history.html">Call History</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="calendar.html">Calendar</a></li>
                                        <li><a href="contacts.html">Contacts</a></li>		
                                        <li><a href="email.html">Email</a></li>
                                        <li class="submenu submenu-two">
                                            <a href="#">Invoices<span class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="invoice.html">Invoices</a></li>
                                                <li><a href="invoice-details.html">Invoice Details</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="todo.html">To Do</a></li>
                                        <li><a href="notes.html">Notes</a></li>
                                        <li><a href="kanban-view.html">Kanban Board</a></li>
                                        <li><a href="file-manager.html">File Manager</a></li>
                                        <li><a href="social-feed.html">Social Feed</a></li>
                                        <li><a href="search-list.html">Search Result</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="../../frontend/index.html" target="_blank">
                                        <i class="ti ti-world"></i><span>Frontend</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-layout-sidebar"></i><span>Layouts</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="index.html">Default</a></li>
                                        <li><a href="layout-mini.html">Mini</a></li>
                                        <li><a href="layout-hover-view.html">Hover View</a></li>
                                        <li><a href="layout-hidden.html">Hidden</a></li>
                                        <li><a href="layout-full-width.html">Full Width</a></li>
                                        <li><a href="layout-rtl.html">RTL</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Clinic</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-user-plus"></i><span>Doctors</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="doctors.html">Doctors</a></li>
                                        <li><a href="doctor-details.html">Doctor Details</a></li>
                                        <li><a href="add-doctor.html">Add Doctor</a></li>
                                        <li><a href="doctor-schedule.html">Doctor Schedule</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);" class="active subdrop">
                                        <i class="ti ti-user-heart"></i><span>Patients</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="patients.html">Patients</a></li>
                                        <li><a href="patient-details.html" class="active">Patient Details</a></li>
                                        <li><a href="create-patient.html">Create Patient</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-calendar-check"></i><span>Appointments</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="appointments.html">Appointments</a></li>
                                        <li><a href="new-appointment.html">New Appointment</a></li>
                                        <li><a href="appointment-calendar.html">Calendar</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="locations.html">
                                        <i class="ti ti-map-pin"></i><span>Locations</span>
                                    </a>
                                </li>  
                                <li>
                                    <a href="services.html">
                                        <i class="ti ti-user-cog"></i><span>Services</span>
                                    </a>
                                </li>  
                                <li>
                                    <a href="specializations.html">
                                        <i class="ti ti-user-shield"></i><span>Specializations</span>
                                    </a>
                                </li> 
                                <li>
                                    <a href="assets.html">
                                        <i class="ti ti-asset"></i><span>Assets</span>
                                    </a>
                                </li>  
                                <li>
                                    <a href="activities.html">
                                        <i class="ti ti-activity"></i><span>Activities</span>
                                    </a>
                                </li> 
                                <li>
                                    <a href="messages.html">
                                        <i class="ti ti-messages"></i><span>Messages</span>
                                    </a>
                                </li>                           
                            </ul>
                        </li>
                        <li class="menu-title"><span>HRM</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="staffs.html">
                                        <i class="ti ti-users-group"></i><span>Staffs</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="hrm-departments.html">
                                        <i class="ti ti-building-bank"></i><span>Departments</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="designation.html">
                                        <i class="ti ti-user-cog"></i><span>Designation</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="attendance.html">
                                        <i class="ti ti-user-check"></i><span>Attendance</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-users-minus"></i><span>Leaves</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="leaves.html">Leaves</a></li>
                                        <li><a href="leave-type.html">Leave Type</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="holidays.html">
                                        <i class="ti ti-home-exclamation"></i><span>Holidays</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="payroll.html">
                                        <i class="ti ti-coin"></i><span>Payroll</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Finance & Accounts</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-credit-card"></i><span>Expenses</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="expenses.html">Expenses</a></li>
                                        <li><a href="expense-category.html">Expense Category</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="income.html">
                                        <i class="ti ti-coins"></i><span>Income</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-file-invoice"></i><span>Invoices</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="invoices.html">Invoices</a></li>
                                        <li><a href="invoices-details.html">Invoice Details</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="payments.html">
                                        <i class="ti ti-cards"></i><span>Payments</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="transactions.html">
                                        <i class="ti ti-transition-right"></i><span>Transactions</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Administration</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-user"></i><span>Users</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="roles-and-permissions.html">Roles & Permissions</a></li>
                                        <li><a href="delete-account-request.html">Delete Account Request</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-report"></i><span>Reports</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="income-report.html">Income Report</a></li>
                                        <li><a href="expense-report.html">Expense Report</a></li>
                                        <li><a href="profit-and-loss.html">Profit & Loss</a></li>
                                        <li><a href="appointment-report.html">Appointment Report</a></li>
                                        <li><a href="patient-report.html">Patient Report</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Content</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="pages.html">
                                        <i class="ti ti-brand-pagekit"></i><span>Pages</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-brand-blogger"></i><span>Blogs</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="add-blog.html">Add Blog</a></li>
                                        <li><a href="blogs.html">Blogs</a></li>
                                        <li><a href="blog-categories.html">Blog Categories</a></li>
                                        <li><a href="blog-comments.html">Blog Comments</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-map-pins"></i><span>Location</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="countries.html">Countries</a></li>
                                        <li><a href="states.html">States</a></li>
                                        <li><a href="cities.html">Cities</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="testimonials.html">
                                        <i class="ti ti-brand-wechat"></i><span>Testimonials</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="faq.html">
                                        <i class="ti ti-question-mark"></i><span>FAQ</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Support</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="contact-messages.html">
                                        <i class="ti ti-message-dots"></i><span>Contact Messages</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="tickets.html">
                                        <i class="ti ti-ticket"></i><span>Tickets</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="announcements.html">
                                        <i class="ti ti-speakerphone"></i><span>Announcements</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="newsletters.html">
                                        <i class="ti ti-mail-bolt"></i><span>Newsletters</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Pages</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="starter.html">
                                        <i class="ti ti-player-play"></i><span>Starter</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="profile.html">
                                        <i class="ti ti-user-circle"></i><span>Profile</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="gallery.html">
                                        <i class="ti ti-photo"></i><span>Gallery</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="timeline.html">
                                        <i class="ti ti-timeline-event-text"></i><span>Timeline</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="pricing.html">
                                        <i class="ti ti-tag"></i><span>Pricing</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="coming-soon.html">
                                        <i class="ti ti-sparkles"></i><span>Coming Soon</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="under-maintenance.html">
                                        <i class="ti ti-settings-down"></i><span>Under Maintenance</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="privacy-policy.html">
                                        <i class="ti ti-shield-check"></i><span>Privacy Policy</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="terms-and-conditions.html">
                                        <i class="ti ti-file-time"></i><span>Terms & Conditions</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Authentication</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-login"></i><span>Login</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="login-cover.html">Cover</a></li>
                                        <li><a href="login-illustration.html">Illustration</a></li>
                                        <li><a href="login-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-file-pencil"></i><span>Register</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="register-cover.html">Cover</a></li>
                                        <li><a href="register-illustration.html">Illustration</a></li>
                                        <li><a href="register-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-lock-exclamation"></i><span>Forgot Password</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="forgot-password-cover.html">Cover</a></li>
                                        <li><a href="forgot-password-illustration.html">Illustration</a></li>
                                        <li><a href="forgot-password-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-restore"></i><span>Reset Password</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="reset-password-cover.html">Cover</a></li>
                                        <li><a href="reset-password-illustration.html">Illustration</a></li>
                                        <li><a href="reset-password-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-mail-check"></i><span>Email Verification</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="email-verification-cover.html">Cover</a></li>
                                        <li><a href="email-verification-illustration.html">Illustration</a></li>
                                        <li><a href="email-verification-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-discount-check"></i><span>2 Step Verification</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="two-step-verification-cover.html">Cover</a></li>
                                        <li><a href="two-step-verification-illustration.html">Illustration</a></li>
                                        <li><a href="two-step-verification-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="lock-screen.html">
                                        <i class="ti ti-lock"></i><span>Lock Screen</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-exclamation-mark-off"></i><span>Error Pages</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="error-404.html">404 Error</a></li>
                                        <li><a href="error-500.html">500 Error</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Settings</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-user-cog"></i><span>Account Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="profile-settings.html">Profile</a></li>
                                        <li><a href="security-settings.html">Security</a></li>
                                        <li><a href="notifications-settings.html">Notifications</a></li>
                                        <li><a href="integrations-settings.html">Integrations</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-world-cog"></i><span>Website Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="organization-settings.html">Organization</a></li>
                                        <li><a href="localization-settings.html">Localization</a></li>
                                        <li><a href="prefixes-settings.html">Prefixes</a></li>
                                        <li><a href="seo-setup-settings.html">SEO Setup</a></li>
                                        <li><a href="language-settings.html">Language</a></li>
                                        <li><a href="maintenance-mode-settings.html">Maintenance Mode</a></li>
                                        <li><a href="login-and-register-settings.html">Login & Register</a></li>
                                        <li><a href="preferences-settings.html">Preferences</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-building-hospital"></i><span>Clinic Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="appointment-settings.html">Appointment</a></li>
                                        <li><a href="working-hours-settings.html">Working Hours</a></li>
                                        <li><a href="cancellation-reason-settings.html">Cancellation Reason</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-device-mobile-cog"></i><span>App Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="invoice-settings.html">Invoice Settings</a></li>
                                        <li><a href="invoice-templates-settings.html">Invoice Templates</a></li>
                                        <li><a href="signatures-settings.html">Signatures</a></li>
                                        <li><a href="custom-fields-settings.html">Custom Fields</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-device-desktop-cog"></i><span>System Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="email-settings.html">Email Settings</a></li>
                                        <li><a href="email-templates-settings.html">Email Templates</a></li>
                                        <li><a href="sms-gateways-settings.html">SMS Gateways</a></li>
                                        <li><a href="sms-templates-settings.html">SMS Templates</a></li>
                                        <li><a href="gdpr-cookies-settings.html">GDPR Cookies</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-settings-dollar"></i><span>Finance & Accounts</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="payment-methods-settings.html">Payment Methods</a></li>
                                        <li><a href="bank-accounts-settings.html">Bank Accounts</a></li>
                                        <li><a href="tax-rates-settings.html">Tax Rates</a></li>
                                        <li><a href="currencies-settings.html">Currencies</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-settings-2"></i><span>Other Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="sitemap-settings.html">Sitemap</a></li>
                                        <li><a href="clear-cache-settings.html">Clear Cache</a></li>
                                        <li><a href="storage-settings.html">Storage</a></li>
                                        <li><a href="cronjob-settings.html">Cronjob</a></li>
                                        <li><a href="ban-ip-address-settings.html">Ban IP Address</a></li>
                                        <li><a href="system-backup-settings.html">System Backup</a></li>
                                        <li><a href="database-backup-settings.html">Database Backup</a></li>
                                        <li><a href="database-backup-settings.html">System Update</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>UI Interface</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-chart-pie"></i><span>Base UI</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="ui-accordion.html">Accordion</a></li>
                                        <li><a href="ui-alerts.html">Alerts</a></li>
                                        <li><a href="ui-avatar.html">Avatar</a></li>
                                        <li><a href="ui-badges.html">Badges</a></li>
                                        <li><a href="ui-breadcrumb.html">Breadcrumb</a></li>
                                        <li><a href="ui-buttons.html">Buttons</a></li>
                                        <li><a href="ui-buttons-group.html">Button Group</a></li>
                                        <li><a href="ui-cards.html">Card</a></li>
                                        <li><a href="ui-carousel.html">Carousel</a></li>
                                        <li><a href="ui-collapse.html">Collapse</a></li>
                                        <li><a href="ui-dropdowns.html">Dropdowns</a></li>
                                        <li><a href="ui-ratio.html">Ratio</a></li>
                                        <li><a href="ui-grid.html">Grid</a></li>
                                        <li><a href="ui-images.html">Images</a></li>
                                        <li><a href="ui-links.html">Links</a></li>
                                        <li><a href="ui-list-group.html">List Group</a></li>
                                        <li><a href="ui-modals.html">Modals</a></li>
                                        <li><a href="ui-offcanvas.html">Offcanvas</a></li>
                                        <li><a href="ui-pagination.html">Pagination</a></li>
                                        <li><a href="ui-placeholders.html">Placeholders</a></li>
                                        <li><a href="ui-popovers.html">Popovers</a></li>
                                        <li><a href="ui-progress.html">Progress</a></li>
                                        <li><a href="ui-scrollspy.html">Scrollspy</a></li>
                                        <li><a href="ui-spinner.html">Spinner</a></li>
                                        <li><a href="ui-nav-tabs.html">Tabs</a></li>
                                        <li><a href="ui-toasts.html">Toasts</a></li>
                                        <li><a href="ui-tooltips.html">Tooltips</a></li>
                                        <li><a href="ui-typography.html">Typography</a></li>
                                        <li><a href="ui-utilities.html">Utilities</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-radar"></i><span>Advanced UI</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="extended-dragula.html">Dragula</a></li>
                                        <li><a href="ui-clipboard.html">Clipboard</a></li>
                                        <li><a href="ui-rangeslider.html">Range Slider</a></li>
                                        <li><a href="ui-sweetalerts.html">Sweet Alerts</a></li>
										<li><a href="ui-lightbox.html">Lightbox</a></li>
										<li><a href="ui-rating.html">Rating</a></li>
										<li><a href="ui-scrollbar.html">Scrollbar</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-forms"></i><span>Forms</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li class="submenu submenu-two">
                                            <a href="javascript:void(0);">Form Elements<span class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="form-basic-inputs.html">Basic Inputs</a></li>
                                                <li><a href="form-checkbox-radios.html">Checkbox & Radios</a></li>
                                                <li><a href="form-input-groups.html">Input Groups</a></li>
                                                <li><a href="form-grid-gutters.html">Grid & Gutters</a></li>
                                                <li><a href="form-mask.html">Input Masks</a></li>
                                                <li><a href="form-fileupload.html">File Uploads</a></li>
                                            </ul>
                                        </li>
                                        <li class="submenu submenu-two">
                                            <a href="javascript:void(0);">Layouts<span class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="form-horizontal.html">Horizontal Form</a></li>
                                                <li><a href="form-vertical.html">Vertical Form</a></li>
                                                <li><a href="form-floating-labels.html">Floating Labels</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="form-validation.html">Form Validation</a></li>
                                        <li><a href="form-select2.html">Select2</a></li>
                                        <li><a href="form-wizard.html">Form Wizard</a></li>
                                        <li><a href="form-pickers.html">Form Picker</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-table-row"></i><span>Tables</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="tables-basic.html">Basic Tables </a></li>
                                        <li><a href="data-tables.html">Data Table </a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-chart-donut"></i>
                                        <span>Charts</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="chart-apex.html">Apex Charts</a></li>
                                        <li><a href="chart-c3.html">Chart C3</a></li>
                                        <li><a href="chart-js.html">Chart Js</a></li>
                                        <li><a href="chart-morris.html">Morris Charts</a></li>
                                        <li><a href="chart-flot.html">Flot Charts</a></li>
                                        <li><a href="chart-peity.html">Peity Charts</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-icons"></i>
                                        <span>Icons</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="icon-fontawesome.html">Fontawesome Icons</a></li>
                                        <li><a href="icon-tabler.html">Tabler Icons</a></li>
                                        <li><a href="icon-bootstrap.html">Bootstrap Icons</a></li>
                                        <li><a href="icon-remix.html">Remix Icons</a></li>
                                        <li><a href="icon-feather.html">Feather Icons</a></li>
                                        <li><a href="icon-ionic.html">Ionic Icons</a></li>
                                        <li><a href="icon-material.html">Material Icons</a></li>
                                        <li><a href="icon-pe7.html">Pe7 Icons</a></li>
                                        <li><a href="icon-simpleline.html">Simpleline Icons</a></li>
                                        <li><a href="icon-themify.html">Themify Icons</a></li>
                                        <li><a href="icon-weather.html">Weather Icons</a></li>
                                        <li><a href="icon-typicons.html">Typicons Icons</a></li>
                                        <li><a href="icon-flag.html">Flag Icons</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Help</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="javascript:void(0);"><i class="ti ti-file-dots"></i><span>Documentation</span></a>
                                </li>
                                <li>
                                    <a href="javascript:void(0);"><i class="ti ti-status-change"></i><span>Changelog</span><span class="badge bg-danger ms-2 badge-md rounded-2 fs-12 fw-medium">v1.6.7</span></a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-versions"></i><span>Multi Level</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);">Multilevel 1</a></li>
                                        <li class="submenu submenu-two">
                                            <a href="javascript:void(0);">Multilevel 2<span
                                                    class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="javascript:void(0);">Multilevel 2.1</a></li>
                                                <li class="submenu submenu-two submenu-three">
                                                    <a href="javascript:void(0);">Multilevel 2.2<span
                                                            class="menu-arrow inside-submenu inside-submenu-two"></span></a>
                                                    <ul>
                                                        <li><a href="javascript:void(0);">Multilevel 2.2.1</a></li>
                                                        <li><a href="javascript:void(0);">Multilevel 2.2.2</a></li>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </li>
                                        <li><a href="javascript:void(0);">Multilevel 3</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>                        
                    </ul>                   
                </div>
                <div class="sidebar-footer border-top mt-3">
                    <div class="trial-item mt-0 p-3 text-center">
                        <div class="trial-item-icon rounded-4 mb-3 p-2 text-center shadow-sm d-inline-flex">
                            <img src="./assets/img/icons/sidebar-icon.svg" alt="img">
                        </div>
                        <div>
                            <h6 class="fs-14 fw-semibold mb-1">Upgrade To Pro</h6>
                            <p class="fs-13 mb-0">Check 1 min video and begin use Preclinic like a pro</p>
                        </div>
                        <a href="javascript:void(0);" class="close-icon shadow-sm"><i class="ti ti-x"></i></a>
                    </div>
                </div>
            </div>

        </div>
        <!-- Sidenav Menu End -->

        <!-- ========================
			Start Page Content
		========================= -->
         
        <div class="page-wrapper">

            <!-- Start Content -->
            <div class="content">

                <!-- page header start -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-0 d-flex align-items-center"> <a href="patients.html" class="text-dark"> <i class="ti ti-chevron-left me-1"></i>Patients</a></h6>
                </div>
                <!-- page header end -->

                <!-- card start -->
                <div class="card">
                    <div class="row align-items-end">
                        <div class="col-xl-9 col-lg-8">
                            <div class="d-sm-flex align-items-center position-relative z-0 overflow-hidden p-3">
                                <img src="./assets/img/icons/shape-01.svg" alt="img" class="z-n1 position-absolute end-0 top-0 d-none d-lg-flex">
                                <a href="javascript:void(0);" class="avatar avatar-xxxl patient-avatar me-2 flex-shrink-0">
                                    <img src="assets/img/users/user-08.jpg" alt="product" class="rounded">
                                </a>
                                <div>
                                    <p class="text-primary mb-1">#PT0025</p>
                                    <h5 class="mb-1"><a href="javascript:void(0);" class="fw-bold">Alberto Ripley</a></h5>
                                    <p class="mb-3">4150 Hiney Road, Las Vegas, NV 89109</p>
                                    <div class="d-flex align-items-center flex-wrap">
                                        <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-phone me-1 text-dark"></i>Phone : <span class="text-dark ms-1">+1 54546 45648</span></p>
                                        <span class="mx-2 text-light">|</span>
                                        <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-calendar-time me-1 text-dark"></i>Last Visited : <span class="text-dark ms-1">30 Apr 2025</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-4">
                            <div class="p-3 text-lg-end">
                                <div class="mb-4">
                                    <a href="javascript:void(0);" class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2"><i class="ti ti-phone"></i></a>
                                    <a href="javascript:void(0);" class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2"><i class="ti ti-message-circle"></i></a>
                                    <a href="javascript:void(0);" class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14"><i class="ti ti-video"></i></a>
                                </div>
                                <a href="new-appointment.html" class="btn btn-primary"><i class="ti ti-calendar-event me-1"></i>Book Apppointment</a>
                            </div>
                        </div>
                      </div>
                </div>
                <!-- card end -->

                <!-- row start -->
                <div class="row">
                    <div class="col-xl-5 d-flex">
                       <div class="card shadow-sm flex-fill w-100">
                           <div class="card-header">
                              <h5 class="fw-bold mb-0"><i class="ti ti-user-star me-1"></i>About</h5>
                           </div>
                           <div class="card-body pb-0">
                               <div class="row">
                                  <div class="col-sm-5">
                                      <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2"><i class="ti ti-calendar-event fs-16"></i></span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1">DOB</h6>
                                            <p class="mb-0">25 Jan 1990</p>
                                        </div>
                                      </div>
                                  </div>
                                  <div class="col-sm-7">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2"><i class="ti ti-droplet fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1">Blood Group</h6>
                                          <p class="mb-0">O +ve</p>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-sm-5">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2"><i class="ti ti-gender-male fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1">Gender</h6>
                                          <p class="mb-0">Male</p>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-sm-7">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2"><i class="ti ti-mail fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1">Email</h6>
                                          <p class="mb-0 text-break">alberto@example.com</p>
                                      </div>
                                    </div>
                                  </div>
                               </div>
                           </div>
                       </div>
                    </div>
                    <div class="col-xl-7 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header">
                               <h5 class="fw-bold mb-0"><i class="ti ti-book me-1"></i>Vital Signs</h5>
                            </div>
                            <div class="card-body pb-0">
                                <div class="row">
                                   <div class="col-sm-4">
                                       <div class="d-flex align-items-center mb-3">
                                         <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-droplet fs-16"></i></span>
                                         <div>
                                             <h6 class="fs-13 fw-bold mb-1 text-truncate">Blood Pressure</h6>
                                             <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-success fs-18"></i>100/67 mmHg</p>
                                         </div>
                                       </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-heart-rate-monitor fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1 text-truncate">Heart Rate</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-danger fs-18"></i>89 Bpm</p>
                                      </div>
                                    </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-hexagons fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1">SPO2</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-success fs-18"></i>98 %</p>
                                      </div>
                                    </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-temperature fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1 text-truncate">Temperature</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-success fs-18"></i>101 C</p>
                                      </div>
                                    </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-activity fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1 text-truncate">Respiratory Rate</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-danger fs-18"></i>24 rpm</p>
                                      </div>
                                    </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-weight fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1 text-truncate">Weight</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-success fs-18"></i>100 kg</p>
                                      </div>
                                    </div>
                                   </div>
                                </div>
                            </div>
                        </div>
                     </div>
                </div>
                <!-- row end -->

                <!-- tab start -->
                <ul class="nav nav-tabs nav-bordered mb-3">
                    <li class="nav-item">
                        <a href="#appointments" data-bs-toggle="tab" aria-expanded="false" class="nav-link active bg-transparent">
                            <span>Appointments</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#transactions" data-bs-toggle="tab" aria-expanded="true" class="nav-link bg-transparent">
                            <span>Transactions</span>
                        </a>
                    </li>
                </ul>
                <!-- tab end -->                

                <!-- tab content start -->
                <div class="tab-content">
                    <div class="tab-pane show active" id="appointments">

                        <!--  Start Filter -->
                        <div class=" d-flex align-items-center justify-content-between flex-wrap">
                            <div class="d-flex align-items-center gap-2">
                                <div class="search-set mb-3">
                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                        <div class="table-search d-flex align-items-center mb-0">
                                            <div class="search-input">
                                                <a href="javascript:void(0);" class="btn-searchset"></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex right-content align-items-center flex-wrap mb-3">
                                    <div class="reportrange-picker d-flex align-items-center reportrange">
                                        <i class="ti ti-calendar text-gray-5 fs-14 me-1"></i><span class="reportrange-picker-field">16 Apr 25 - 16 Apr 25</span>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
                                <div class="dropdown me-2">
                                    <a href="javascript:void(0);" class="bg-white border rounded btn btn-md text-dark fs-14 py-1 align-items-center d-flex fw-normal" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                                        <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                                    </a>
                                    <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown p-0">
                                        <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                                            <h4 class="mb-0 fw-bold">Filter</h4>
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="link-danger text-decoration-underline">Clear All</a>
                                            </div>
                                        </div>
                                        <form action="#">
                                            <div class="filter-body pb-0">
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Doctor</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-01.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Mick Thompson
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-02.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Sarah Johnson
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-03.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Emily Carter
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-04.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. David Lee
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-05.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Anna Kim
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Designation</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Cardiologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Orthopedic Surgeon
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Pediatrician
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Gynecologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Psychiatrist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Neurosurgeon
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Oncologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Pulmonologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Urologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Dermatologist
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Mode</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        In Person
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Online
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label mb-1 text-dark fs-14 fw-medium">Date<span class="text-danger">*</span></label>
                                                    <div class="input-icon-end position-relative">  
                                                        <input type="text" class="form-control bookingrange" placeholder="dd/mm/yyyy">
                                                        <span class="input-icon-addon">
                                                            <i class="ti ti-calendar"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Status</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Checked Out
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Checked In
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Cancelled
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Schedule
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Confirmed
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                                                <a href="javascript:void(0);" class="btn btn-light btn-md me-2 fw-medium close-filter">Close</a>
                                                <button type="submit" class="btn btn-primary btn-md fw-medium">Filter</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--  End Filter -->

                        <!--  Start Table -->
                        <div class="table-responsive">
                            <table class="table datatable table-nowrap">
                                <thead class="">
                                    <tr>
                                        <th class="no-sort">
                                            Date & Time
                                        </th>
                                        <th>Doctor Name</th>
                                        <th>Mode</th>
                                        <th>Status</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>30 Apr 2025 - 09:30 AM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="doctor-details.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-01.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="doctor-details.html" class="fw-semibold">Dr. Mick Thompson</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Cardiologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            In-person
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-info rounded text-info fw-medium">Checked Out</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    
                                </tbody>
                            </table>
                        </div>
                        <!--  End Table -->

                    </div>
                    <div class="tab-pane" id="transactions">

                        <!--  Start Filter -->
                        <div class=" d-flex align-items-center justify-content-between flex-wrap">
                            <div class="d-flex align-items-center gap-2">
                                <div class="search-set mb-3">
                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                        <div class="table-search d-flex align-items-center mb-0">
                                            <div class="search-input">
                                                <a href="javascript:void(0);" class="btn-searchset"></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex right-content align-items-center flex-wrap mb-3">
                                    <div class="reportrange-picker d-flex align-items-center reportrange">
                                        <i class="ti ti-calendar text-gray-5 fs-14 me-1"></i><span class="reportrange-picker-field">16 Apr 25 - 16 Apr 25</span>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
                                <div class="dropdown me-2">
                                    <a href="javascript:void(0);" class="bg-white border rounded btn btn-md text-dark fs-14 py-1 align-items-center d-flex fw-normal" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                                        <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                                    </a>
                                    <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown p-0">
                                        <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                                            <h4 class="mb-0 fw-bold">Filter</h4>
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="link-danger text-decoration-underline">Clear All</a>
                                            </div>
                                        </div>
                                        <form action="#">
                                            <div class="filter-body pb-0">
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Transaction ID</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        #TNX0025
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Description</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        General Consultation
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Dental Cleaning
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Eye Checkup
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        X-Ray
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Physiotherapy Session
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Cardiac Screening
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Skin Allergy Test
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label mb-1 text-dark fs-14 fw-medium">Date<span class="text-danger">*</span></label>
                                                    <div class="input-icon-end position-relative">  
                                                        <input type="text" class="form-control datetimepicker" placeholder="dd/mm/yyyy">
                                                        <span class="input-icon-addon">
                                                            <i class="ti ti-calendar"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Payment Method</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        PayPal
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Debit Card
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Cheque
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Amount</label>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle form-control" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">							
                                                            <div class="filter-range">
                                                                <input type="text" id="range_03">
                                                                <p>Range : <span class="text-gray-9">$200 - $5695</span></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Status</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Completed
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Pending
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 filter-close">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                                                <a href="javascript:void(0);" class="btn btn-light btn-md me-2 fw-medium close-filter">Close</a>
                                                <button type="submit" class="btn btn-primary btn-md fw-medium">Filter</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--  End Filter -->

                        <!--  Start Table -->
                        <div class="table-responsive">
                            <table class="table table-nowrap datatable">
                                <thead class="thead-light">
                                    <tr>
                                        <th class="no-sort">
                                            Transaction ID
                                        </th>
                                        <th>Description</th>
                                        <th>Paid  Date</th>
                                        <th>Payment Method</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0025</a></td>
                                        <td class="text-dark"> General Consultation </td>
                                        <td class="text-dark"> 30 Apr 2025</td>
                                        <td class="text-dark"> PayPal</td>
                                        <td class="text-dark"> $800</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0024</a></td>
                                        <td class="text-dark">Dental Cleaning</td>
                                        <td class="text-dark"> 15 Apr 2025</td>
                                        <td class="text-dark"> Debit Card </td>
                                        <td class="text-dark"> $930</td>
                                        <td> <span class="badge fs-13 badge-soft-info rounded text-info fw-medium border border-info">Pending</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0023</a></td>
                                        <td class="text-dark"> Eye Checkup </td>
                                        <td class="text-dark"> 02 Apr 2025 </td>
                                        <td class="text-dark"> Cheque </td>
                                        <td class="text-dark"> $850</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0022</a></td>
                                        <td class="text-dark"> X-Ray </td>
                                        <td class="text-dark"> 27 Mar 2025 </td>
                                        <td class="text-dark"> Debit Card</td>
                                        <td class="text-dark"> $80</td>
                                        
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0021</a></td>
                                        <td class="text-dark">
                                            Physiotherapy Session
                                        </td>
                                        <td class="text-dark"> 12 Mar 2025</td>
                                        <td class="text-dark"> PayPal</td>
                                        <td class="text-dark"> $650</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0020</a></td>
                                        <td class="text-dark">
                                            Cardiac Screening
                                        </td>
                                        <td class="text-dark"> 05 Mar 2025 </td>
                                        <td class="text-dark"> Cheque </td>
                                        <td class="text-dark"> $430 </td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0019</a></td>
                                        <td class="text-dark">
                                            Skin Allergy Test
                                        </td>
                                        <td class="text-dark"> 24 Feb 2025 </td>
                                        <td class="text-dark"> Debit Card </td>
                                        <td class="text-dark"> $300</td>
                                        
                                        <td> <span class="badge fs-13 badge-soft-info rounded text-info fw-medium border border-info">Pending</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0018</a></td>
                                        <td class="text-dark">
                                            Blood Test
                                        </td>
                                        <td class="text-dark"> 16 Feb 2025 </td>
                                        <td class="text-dark"> Cheque </td>
                                        <td class="text-dark"> $450</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0017</a></td>
                                        <td class="text-dark">
                                            ENT Consultation
                                        </td>
                                        <td class="text-dark"> 01 Feb 2025 </td>
                                        <td class="text-dark"> Debit Card </td>
                                        <td class="fw-semibold text-dark"> $570</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success"> completed</span> </td>
                                    </tr>
                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0017</a></td>
                                        <td class="text-dark">
                                            Nutrition Counseling
                                        </td>
                                        <td class="text-dark"> 25 Jan 2025 </td>
                                        <td class="text-dark"> PayPal</td>
                                        <td class="text-dark"> $800</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        <!--  End Table -->

                    </div>
                </div>
                <!-- tab content end -->
                
            </div>
            <!-- End Content -->

            <!-- Footer Start -->
            <div class="footer text-center bg-white p-2 border-top">
                <p class="text-dark mb-0">2025 &copy; <a href="javascript:void(0);" class="link-primary">Preclinic</a>, All Rights Reserved</p>
            </div>
            <!-- Footer End -->

        </div>

        <!-- ========================
			End Page Content
		========================= -->

    </div>
    <!-- End Wrapper -->

      <!-- Start View Details -->
      <div class="offcanvas offcanvas-offset offcanvas-end" tabindex="-1" id="view_details">
        <div class="offcanvas-header d-block pb-0 px-0">
            <div class="border-bottom d-flex align-items-center justify-content-between pb-3 px-3">
                <h5 class="offcanvas-title fs-18 fw-bold">Appointment Details <span class="badge badge-soft-primary border pt-1 px-2 border-primary fw-medium ms-2">#AP544658</span></h5>
                <button type="button" class="btn-close custom-btn-close opacity-100" data-bs-dismiss="offcanvas" aria-label="Close"><i class="ti ti-x bg-white fs-16 text-dark"></i></button>            </div>
        </div>
        <div class="offcanvas-body pt-0 px-0">
            <h6 class="bg-light py-2 px-3 fw-bold"> When & Where </h6>
            <div class="px-3 my-4">
                <div class="bg-light p-3 mb-3 border rounded-3 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center">
                        <a href="javascript:void(0);" class="avatar avatar-md me-2">
                            <img src="assets/img/doctors/doctor-03.jpg" alt="product" class="rounded-circle">
                        </a>
                        <a href="javascript:void(0);" class="text-dark fw-semibold">Dr. Emily Carter <span class="text-body fs-13 fw-normal d-block">Pediatrician </span>  </a>
                    </div>
                    <div class="flex-shrink-0">
                        <a href="javascript:void(0);" class="btn btn-outline-white bg-white fs-14 d-inline-flex border rounded-2 p-1 me-1">
                            <i class="ti ti-brand-hipchat"></i>
                        </a>
                        <a href="javascript:void(0);" class="btn btn-outline-white bg-white shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                            <i class="ti ti-video"></i>
                        </a>
                    </div>
                </div>
                <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> Appointment On <span class="text-body fw-normal"> Saturday, 25 Apr 2025  </span> </p>
                <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> Time <span class="text-body fw-normal"> 09:00 AM - 11:00 AM  </span> </p>
                <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> Location <span class="text-body fw-normal">Newyork , USA   </span> </p>
                <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> Appointment Type <span class="text-body fw-normal"> Online Consultation </span> </p>
                <div class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> Patient Details 
                    <div class="text-body fw-normal d-flex align-items-center"> 
                        <div class="avatar avatar-xs flex-shrink-0">
                            <img src="assets/img/users/avatar-2.jpg" alt="" class="rounded-circle me-1 flex-shrink-0">
                        </div>
                            James Adrian 
                    </div> 
                </div>
            </div>
            <h6 class="bg-light py-2 px-3 text-dark fw-bold"> Appointment Details  </h6>
            <div class="px-3 my-4">
                <div class="d-flex align-items-center justify-content-between mb-3">
                    <div class="d-flex align-items-center"> 
                        Telehealth 
                        <label class="d-flex align-items-center form-switch ps-1">
                            <input class="form-check-input m-0 me-2" type="checkbox" checked>
                        </label>
                    </div>
                    <div>  <a href="appointment-consultations.html" class="btn-primary btn btn-sm rounded d-flex align-items-center"> <i class="ti ti-video me-1"></i> Start </a></div>
                </div>
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-6">
                        <p class="text-dark"> Status </p>
                    </div>
                    
                    <div class="col-lg-6 col-md-6"> 
                        <div class="mb-3">
                            <div class="dropdown">
                                <a href="javascript:void(0);" class="dropdown-toggle form-control rounded d-flex align-items-center justify-content-between border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                    Pending
                                </a>
                                <div class="dropdown-menu shadow-lg w-100 dropdown-info">
                                    <div class="mb-3">
                                        <div class="input-icon-start position-relative">
                                            <span class="input-icon-addon fs-12">
                                                <i class="ti ti-search"></i>
                                            </span>
                                            <input type="text" class="form-control form-control-sm" placeholder="Select">
                                        </div>
                                    </div>
                                    <ul class="mb-0 list-style-none">
                                        <li>
                                            <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                <input class="form-check-input m-0 me-2" type="checkbox">
                                                Checked Out
                                            </label>
                                        </li>
                                        <li>
                                            <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                <input class="form-check-input m-0 me-2" type="checkbox" checked>
                                                Checked In
                                            </label>
                                        </li>
                                        <li>
                                            <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                <input class="form-check-input m-0 me-2" type="checkbox">
                                                Cancelled
                                            </label>
                                        </li>
                                        <li>
                                            <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                <input class="form-check-input m-0 me-2" type="checkbox">
                                                Scheduled
                                            </label>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!-- End Add New Appointment-->

    <!-- Start Delete Modal  -->
    <div class="modal fade" id="delete_modal">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center position-relative">
                    <img src="assets/img/bg/delete-modal-bg-01.png" alt="" class="img-fluid position-absolute top-0 start-0 z-0">
                    <img src="assets/img/bg/delete-modal-bg-02.png" alt="" class="img-fluid position-absolute bottom-0 end-0 z-0">
                    <div class="mb-3 position-relative z-1">
                        <span class="avatar avatar-lg bg-danger text-white"><i class="ti ti-trash fs-24"></i></span>
                    </div>
                    <h5 class="fw-bold mb-1 position-relative z-1">Delete Confirmation</h5>
                    <p class="mb-3 position-relative z-1">Are you sure want to delete?</p>
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btn btn-light position-relative z-1 me-3" data-bs-dismiss="modal">Cancel</a>
                        <a href="" class="btn btn-danger position-relative z-1" data-bs-dismiss="modal">Yes, Delete</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Delete Modal  -->


    <!-- jQuery -->
    <script src="assets/js/jquery-3.7.1.min.js"></script>

    <!-- Bootstrap Core JS -->
    <script src="assets/js/bootstrap.bundle.min.js"></script>    

	<!-- Simplebar JS -->
	<script src="assets/plugins/simplebar/simplebar.min.js"></script>

    <!-- Select2 JS -->
    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <!-- intel Input -->
    <script src="assets/plugins/intltelinput/js/intlTelInput.js"></script>

    <!-- Daterangepikcer JS -->
	<script src="assets/js/moment.min.js"></script>
	<script src="assets/plugins/daterangepicker/daterangepicker.js"></script>

    <!-- Datetimepicker JS -->
    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script> 

    <!-- Rangeslider JS -->
	<script src="assets/plugins/ion-rangeslider/js/ion.rangeSlider.js"></script>
	<script src="assets/plugins/ion-rangeslider/js/custom-rangeslider.js"></script>
	<script src="assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js"></script>

    <!-- Datatable JS -->
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/dataTables.bootstrap5.min.js"></script>

    <!-- Main JS -->
    <script src="assets/js/script.js"></script>

</body>

</html>