
    
    <!DOCTYPE html>
<html>
<head>
  <title>VideoSDK Meeting</title>
  <meta charset="UTF-8">
  <script src="https://sdk.videosdk.live/js-sdk/0.0.87/videosdk.js"></script>
</head>
<body>
  <h2>VideoSDK Meeting Demo</h2>
  <button id="joinBtn">Join Meeting</button>
  <div id="video-container"></div>

  <script>
    let meeting;

    const token = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhcGlrZXkiOiI1Y2U2MmQzOS1lNDA2LTQ0MjMtOTEzNi0xMGNhMDUwNmQ5MjkiLCJwZXJtaXNzaW9ucyI6WyJhbGxvd19qb2luIl0sImlhdCI6MTc1Nzc0MTA2MiwiZXhwIjoxOTE1NTI5MDYyfQ.t17wlttdFz0dE3uf4JmzOxQtR85tkF78SanYAIZT0cY";
    const apiKey = "64487a4e-ace6-41b2-b4db-246990cd9476";

    const config = {
      meetingId: "meeting-" + Math.floor(Math.random() * 10000),
      name: "Mahendra",
      apiKey: apiKey,
      containerId: "video-container",
      micEnabled: true,
      webcamEnabled: true,
      token: token,
    };

    meeting = VideoSDK.initMeeting(config);

    document.getElementById("joinBtn").addEventListener("click", () => {
      meeting.join();
    });
  </script>
</body>
</html>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>VideoSDK Meeting Demo</title>
</head>
<body>
  <h2>VideoSDK Meeting Demo</h2>

  <input type="text" id="meetingId" placeholder="Enter Meeting ID" />
  <button id="joinBtn">Join Meeting</button>

  <div id="video-container"></div>

  <!-- VideoSDK CDN -->
  <script src="https://sdk.videosdk.live/js-sdk/0.0.86/videosdk.js"></script>

  <script>
    let meeting = null;

    const apiKey = "{{ env('VIDEOSDK_API_KEY') }}";   // Laravel se key inject karo
    const token = "{{ env('VIDEOSDK_TOKEN') ?? '' }}"; // agar backend se generate karte ho
    const name = "Guest User";

    const joinBtn = document.getElementById("joinBtn");
    const meetingInput = document.getElementById("meetingId");
    const container = document.getElementById("video-container");

    joinBtn.addEventListener("click", async () => {
      const meetingId = meetingInput.value.trim();

      if (!meetingId) {
        alert("Please enter Meeting ID");
        return;
      }

      // Initialize Meeting
      meeting = VideoSDK.initMeeting({
        meetingId: meetingId,
        name: name,
        apiKey: apiKey,
        token: token, // agar JWT token banaya hai backend se
        micEnabled: true,
        webcamEnabled: true,
      });

      // Join meeting
      meeting.join();

      // Participants join hone par video show karna
      meeting.on("participant-joined", (participant) => {
        console.log("New Participant", participant);
      });

      // Apna video stream show karna
      meeting.localParticipant.on("stream-enabled", (stream) => {
        const mediaEl = document.createElement(stream.kind);
        mediaEl.srcObject = stream.track;
        mediaEl.autoplay = true;
        mediaEl.playsInline = true;
        container.appendChild(mediaEl);
      });
    });
  </script>
</body>
</html>



    
   