@extends('layouts.mail')

@section('title', 'Staff Account Update Notification – PRED Care')

@section('content')
    <h2>Hi {{ $staffName }},</h2>
    <p>Your staff account details at <strong>{{ $clinicName }}</strong> have been updated.</p>
    
    <div style="margin: 20px 0; padding: 15px; background: #f8f9fa; border-radius: 5px;">
        <h3 style="margin-top: 0;">Account Information</h3>
        
        <p><strong>Clinic Owner:</strong> {{ $ownerName }}</p>
        
        @if($assignedDoctor)
            <p><strong>Assigned Doctor:</strong> {{ $assignedDoctor }}</p>
        @endif
        
        <p><strong>Your Role:</strong> {{ $role }}</p>
        <p><strong>Access Level:</strong> {{ $accessLevel }}</p>
    </div>

    @if(count($updatedModules))
        <h3>Updated Permissions:</h3>
        <ul>
            @foreach($updatedModules as $module)
                <li>{{ ucfirst(str_replace('_', ' ', $module)) }}</li>
            @endforeach
        </ul>
    @endif

    <p style="margin-top: 20px;">
        If you have any questions about these changes or need assistance, 
        please contact your clinic administrator or our support team at 
        <a href="mailto:support@predcare.in">support@predcare.in</a>.
    </p>

    <p>Best regards,<br>
    <strong>The PRED Care Team</strong></p>
    
    <div style="margin-top: 30px; font-size: 12px; color: #6c757d;">
        <p>This is an automated notification. Please do not reply to this email.</p>
    </div>
@endsection