@extends('components.emails.header')

@section('title', 'Patient Profile Updated')

<h2>Hi Dr. {{ $adminDoctor->name }},</h2>
<p>A patient profile has just been updated under your clinic on PRED Care.</p>

<h3>Updated Patient Information:</h3>
<ul>
    <li><strong>Name:</strong> {{ $patient->user->name }}</li>
    <li><strong>Patient ID:</strong> {{ $patient->id }}</li>
    <li><strong>Updated By:</strong> {{ $updatedBy->name }}</li>
    <li><strong>Updated On:</strong> {{ $updatedAt->format('d/m/Y H:i') }}</li>
    <li><strong>Fields Changed:</strong>
        <ul>
            @foreach($changedFields as $field)
            <li>{{ ucfirst(str_replace('_', ' ', $field)) }}</li>
            @endforeach
        </ul>
    </li>
</ul>

<p>Please review the changes in your PRED Care dashboard for confirmation.</p>

<p style="text-align: center;">
    <a href="{{ config('app.url') }}/login" class="action-button">Login to PRED Care</a>
</p>

<p><strong>Quick Access:</strong><br>
<a href="{{ config('app.url') }}/help">Help Center</a><br>
<a href="mailto:info@predcare.in">Contact Support</a>
</p>

<p>Sincerely,<br>The PRED Care Team</p>

@extends('components.emails.footer')