<div class="content">
    <!-- Start Page Header -->
    <div class="mb-4">
        <h6 class="fw-bold mb-0 d-flex align-items-center"> <a href="{{ back()->getTargetUrl() }}" class="text-dark"> <i
                    class="ti ti-chevron-left me-1"></i>Staff</a></h6>
    </div>
    <!-- End Page Header -->

    @if ($staff)
        <div class="card">
            <div class="row align-items-end">
                <div class="col-xl-9 col-lg-8">
                    <div class="d-sm-flex align-items-center position-relative z-0 overflow-hidden p-3">
                        <img src="{{ asset('assets/img/icons/shape-01.svg') }}" alt="img"
                            class="z-n1 position-absolute end-0 top-0 d-none d-lg-flex">
                        <div class="avatar avatar-xxxl patient-avatar me-2 flex-shrink-0">
                            @if ($staff->staff && $staff->staff->profile_image)
                                <img src="{{ Storage::url($staff->staff->profile_image) }}" class="rounded"
                                    alt="Staff Photo" style="width: 120px; height: 120px; object-fit: cover;">
                            @else
                                <div class="avatar avatar-xl rounded d-flex align-items-center justify-content-center bg-primary text-white fw-bold fs-3"
                                    style="width: 120px; height: 120px;">
                                    @php
                                        $words = explode(' ', $staff->name);
                                        $initials =
                                            count($words) >= 2
                                                ? strtoupper(substr($words[0], 0, 1) . substr(end($words), 0, 1))
                                                : strtoupper(substr($staff->name, 0, 2));
                                    @endphp
                                    {{ $initials }}
                                </div>
                            @endif
                        </div>
                        <div>
                            <p class="text-primary mb-1"> #{{ $staff->id }}</p>
                            <h5 class="mb-1"><span class="fw-bold">{{ $staff->name }}</span></h5>
                            <p class="mb-3">
                                <span class="badge border bg-white text-dark fw-medium">
                                    <i class="ti ti-point-filled me-1 text-info"></i>
                                    @if ($staff->roles->count() > 0)
                                        {{ ucfirst(str_replace('_', ' ', $staff->roles->first()->name)) }}
                                    @else
                                        Staff Member
                                    @endif
                                </span>
                            </p>
                            <div class="d-flex align-items-center flex-wrap">
                                <p class="mb-0 d-inline-flex align-items-center">
                                    <i class="ti ti-phone me-1 text-dark"></i>Phone :
                                    <span class="text-dark ms-1">{{ $staff->phone_number ?: 'Not provided' }}</span>
                                </p>
                                <span class="mx-2 text-light">|</span>
                                <p class="mb-0 d-inline-flex align-items-center">
                                    <span
                                        class="badge badge-soft-{{ $staffRecord->status === 'active' ? 'success' : 'danger' }} fw-medium">
                                        <i
                                            class="ti ti-point-filled me-1 text-{{ $staffRecord->status === 'active' ? 'success' : 'danger' }}"></i>
                                        {{ ucfirst($staffRecord->status) }}
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4">
                    <div class="p-3 text-lg-end">
                        <div class="mb-4">
                            <p class="mb-2">Total Clinic Assignments</p>
                            <h6 class="fs-18 fw-bold mb-3">
                                {{ count($staffClinics) }}
                                <span class="fw-normal text-body fs-14">Active Assignments</span>
                            </h6>
                        </div>
                        {{-- <div class="btn-group">
                            <button type="button"
                                class="btn {{ $staffRecord->status === 'active' ? 'btn-danger' : 'btn-success' }}"
                                wire:click="toggleStatus"
                                onclick="return confirm('Are you sure you want to {{ $staffRecord->status === 'active' ? 'deactivate' : 'activate' }} this staff member?')">
                                <i class="ti ti-power me-1"></i>
                                {{ $staffRecord->status === 'active' ? 'Deactivate' : 'Activate' }}
                            </button>
                        </div> --}}
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <!-- Role & Permissions Section -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">Roles & Permissions</h5>
                        <div class="d-flex align-items-center flex-wrap gap-2 mb-3">
                            @if ($staff->roles->count() > 0)
                                @foreach ($staff->roles as $role)
                                    <span class="badge bg-primary fs-12 px-3 py-2">
                                        <i class="ti ti-user-check me-1"></i>
                                        {{ ucfirst(str_replace('_', ' ', $role->name)) }}
                                    </span>
                                @endforeach
                            @else
                                <span class="text-muted">No roles assigned</span>
                            @endif
                        </div>
                        @if ($staff->roles->count() > 0)
                            <div class="alert alert-info">
                                <i class="ti ti-info-circle me-2"></i>
                                This staff member has been assigned {{ $staff->roles->count() }} role(s) with
                                corresponding permissions.
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Clinic Assignments Section -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">Clinic Assignments
                            <span class="badge bg-primary ms-2">{{ count($staffClinics) }}</span>
                        </h5>
                        @if (count($staffClinics) > 0)
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Clinic Details</th>
                                            <th>Doctor</th>
                                            <th>Status</th>
                                            <th>Approval</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($staffClinics as $assignment)
                                            <tr>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-1 fw-semibold">
                                                            {{ $assignment['clinic']['name'] ?? 'N/A' }}</h6>
                                                        @if ($assignment['clinic']['address'])
                                                            <small class="text-muted">
                                                                <i
                                                                    class="ti ti-map-pin me-1"></i>{{ $assignment['clinic']['address'] }}
                                                            </small>
                                                        @endif
                                                        <div class="mt-1">
                                                            <small class="text-muted">
                                                                Assigned:
                                                                {{ \Carbon\Carbon::parse($assignment['created_at'])->format('M d, Y') }}
                                                            </small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-1 fw-semibold">
                                                            {{ $assignment['doctor']['name'] ?? 'N/A' }}</h6>
                                                        @if ($assignment['doctor']['email'])
                                                            <small
                                                                class="text-muted">{{ $assignment['doctor']['email'] }}</small>
                                                        @endif
                                                    </div>
                                                </td>
                                                <td>
                                                    <span
                                                        class="badge badge-soft-{{ $assignment['status'] === 'active' ? 'success' : 'danger' }}">
                                                        <i
                                                            class="ti ti-point-filled me-1 text-{{ $assignment['status'] === 'active' ? 'success' : 'danger' }}"></i>
                                                        {{ ucfirst($assignment['status']) }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <span
                                                        class="badge badge-soft-{{ $assignment['approval_status'] === 'approved' ? 'success' : ($assignment['approval_status'] === 'pending' ? 'warning' : 'danger') }}">
                                                        <i
                                                            class="ti ti-{{ $assignment['approval_status'] === 'approved' ? 'check' : ($assignment['approval_status'] === 'pending' ? 'clock' : 'x') }} me-1"></i>
                                                        {{ ucfirst($assignment['approval_status']) }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-1">
                                                        <a href="javascript:void(0);"
                                                            class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1"
                                                            data-bs-toggle="dropdown">
                                                            <i class="ti ti-dots-vertical"></i>
                                                        </a>
                                                        <ul class="dropdown-menu p-2 bg-white">
                                                            @can('edit staff')
                                                                <li>
                                                                    <a href="javascript:void(0);"
                                                                        class="dropdown-item d-flex align-items-center"
                                                                        wire:click="editStaff({{ $assignment['doctor'] }}, {{ $assignment['clinic']['id'] }})">
                                                                        <i class="ti ti-edit me-2"></i>Edit
                                                                    </a>
                                                                </li>
                                                            @endcan
                                                            <li>
                                                                <a href="javascript:void(0);"
                                                                    class="dropdown-item d-flex align-items-center"
                                                                    wire:click="toggleClinicStatus({{ $assignment['id'] }})">
                                                                    <i class="ti ti-power me-2"></i>
                                                                    {{ $assignment['status'] === 'active' ? 'Deactivate' : 'Activate' }}
                                                                </a>
                                                            </li>
                                                            <li>
                                                                <a href="javascript:void(0);"
                                                                    class="dropdown-item d-flex align-items-center text-danger"
                                                                    wire:click="removeStaff({{ $assignment['id'] }},{{ $assignment['doctor']['id'] }},{{ $assignment['clinic']['id'] }})">
                                                                    <i class="ti ti-trash me-2"></i>Remove
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </td>
                                            </tr>
                                            @if ($assignment['permissions'] && is_array($assignment['permissions']) && count($assignment['permissions']) > 0)
                                                <tr>
                                                    <td colspan="5" class="border-top-0 pt-0">
                                                        <div class="d-flex align-items-center flex-wrap gap-1">
                                                            <small class="text-muted me-2">Permissions:</small>
                                                            @foreach ($assignment['permissions'] as $permission)
                                                                <span
                                                                    class="badge bg-light text-dark">{{ $permission }}</span>
                                                            @endforeach
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endif
                                            @if (
                                                $assignment['notes'] &&
                                                    ((is_array($assignment['notes']) && count($assignment['notes']) > 0) ||
                                                        (is_string($assignment['notes']) && !empty($assignment['notes']))))
                                                <tr>
                                                    <td colspan="5" class="border-top-0 pt-0">
                                                        <div class="alert alert-light mb-0">
                                                            <i class="ti ti-note me-2"></i>
                                                            <strong>Notes:</strong>
                                                            @if (is_array($assignment['notes']))
                                                                {{ implode(', ', $assignment['notes']) }}
                                                            @else
                                                                {{ $assignment['notes'] }}
                                                            @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-5">
                                <i class="ti ti-building-hospital fs-1 text-muted mb-3"></i>
                                <h6 class="text-muted mb-2">No Clinic Assignments</h6>
                                <p class="text-muted mb-3">This staff member has not been assigned to any clinics yet.
                                </p>
                                <button type="button" class="btn btn-primary" wire:click="addStaff">
                                    <i class="ti ti-plus me-1"></i>Assign to Clinic
                                </button>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Activity Timeline Section -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">Activity Timeline</h5>
                        <ul class="activity-feed rounded">
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2">Staff Account Created</h6>
                                <p>{{ $staff->created_at->format('M d, Y \a\t g:i A') }}</p>
                                <p class="text-muted">Staff member {{ $staff->name }} was added to the system.</p>
                            </li>
                            @if ($staff->updated_at != $staff->created_at)
                                <li class="feed-item timeline-item">
                                    <h6 class="fw-bold mb-2">Profile Updated</h6>
                                    <p>{{ $staff->updated_at->format('M d, Y \a\t g:i A') }}</p>
                                    <p class="text-muted">Staff profile information was last updated.</p>
                                </li>
                            @endif
                            @if (count($staffClinics) > 0)
                                @foreach ($staffClinics as $assignment)
                                    <li class="feed-item timeline-item">
                                        <h6 class="fw-bold mb-2">Clinic Assignment</h6>
                                        <p>{{ \Carbon\Carbon::parse($assignment['created_at'])->format('M d, Y \a\t g:i A') }}
                                        </p>
                                        <p class="text-muted">Assigned to
                                            {{ $assignment['clinic']['name'] ?? 'Unknown Clinic' }} under Dr.
                                            {{ $assignment['doctor']['name'] ?? 'Unknown Doctor' }}</p>
                                    </li>
                                @endforeach
                            @endif
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Sidebar Section -->
            <div class="col-xl-4 theiaStickySidebar">
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">About</h6>
                        <div>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-id"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Staff ID</h6>
                                    <p>#{{ $staff->id }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-phone"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Phone Number</h6>
                                    <p>{{ $staff->phone_number ?: 'Not provided' }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-mail"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Email Address</h6>
                                    <p>{{ $staff->email }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-calendar"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Date Joined</h6>
                                    <p>{{ $staff->created_at->format('M d, Y') }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-clock"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Last Updated</h6>
                                    <p>{{ $staff->updated_at->format('M d, Y') }}</p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-shield-check"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Account Status</h6>
                                    <p class="text-capitalize">
                                        <span
                                            class="badge badge-soft-{{ $staffRecord->status === 'active' ? 'success' : 'danger' }}">
                                            {{ $staffRecord->status }}
                                        </span>
                                    </p>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-building-hospital"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Total Clinic Assignments</h6>
                                    <p>{{ count($staffClinics) }} Assignment{{ count($staffClinics) != 1 ? 's' : '' }}
                                    </p>
                                </div>
                            </div>
                            @if ($staff->roles->count() > 0)
                                <div class="d-flex align-items-center mb-3">
                                    <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                        <i class="ti ti-user-check"></i>
                                    </span>
                                    <div>
                                        <h6 class="fw-semibold fs-13 mb-1">Assigned Roles</h6>
                                        <div>
                                            @foreach ($staff->roles as $role)
                                                <span
                                                    class="badge bg-light text-dark me-1 mb-1">{{ ucfirst(str_replace('_', ' ', $role->name)) }}</span>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">Quick Actions</h6>
                        <div class="d-grid gap-2">
                            {{-- <button type="button"
                                class="btn btn-outline-{{ $staffRecord->status === 'active' ? 'danger' : 'success' }} btn-sm"
                                wire:click="toggleStatus"
                                onclick="return confirm('Are you sure you want to {{ $staffRecord->status === 'active' ? 'deactivate' : 'activate' }} this staff member?')">
                                <i class="ti ti-power me-1"></i>
                                {{ $staffRecord->status === 'active' ? 'Deactivate' : 'Activate' }}
                            </button> --}}
                            <button type="button" class="btn btn-outline-info btn-sm" wire:click="backToList">
                                <i class="ti ti-arrow-left me-1"></i>Back to List
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Statistics -->
                @if (count($staffClinics) > 0)
                    <div class="card">
                        <div class="card-body">
                            <h6 class="fw-bold mb-3">Assignment Statistics</h6>
                            <div class="text-center">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <h4 class="text-success mb-1">
                                                {{ collect($staffClinics)->where('status', 'active')->count() }}
                                            </h4>
                                            <small class="text-muted">Active</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <h4 class="text-warning mb-1">
                                                {{ collect($staffClinics)->where('approval_status', 'pending')->count() }}
                                            </h4>
                                            <small class="text-muted">Pending</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <h4 class="text-info mb-1">
                                                {{ collect($staffClinics)->where('approval_status', 'approved')->count() }}
                                            </h4>
                                            <small class="text-muted">Approved</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <h4 class="text-danger mb-1">
                                                {{ collect($staffClinics)->where('status', 'inactive')->count() }}
                                            </h4>
                                            <small class="text-muted">Inactive</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    @else
        <!-- Staff Not Found Section -->
        <div class="card">
            <div class="card-body text-center py-5">
                <i class="ti ti-exclamation-triangle fs-1 text-warning mb-3"></i>
                <h4>Staff Not Found</h4>
                <p class="text-muted mb-3">The staff member you're looking for could not be found.</p>
                <button type="button" class="btn btn-primary" wire:click="backToList">
                    <i class="ti ti-arrow-left me-1"></i>Back to Staff List
                </button>
            </div>
        </div>
    @endif
</div>

@push('scripts')
    <script>
        // Additional JavaScript for staff view functionality can be added here
        $(document).ready(function() {
            // Add any custom interactions if needed
            console.log('Staff details view loaded');
        });
    </script>
@endpush
