<div class="content">
    <!-- Success Message -->
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Error Message -->
    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Start Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">Staff List
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Staff: {{ $staffAssociations->total() }}
                </span>
            </h4>
        </div>
        <div class="text-end d-flex">
            <!-- Add New Staff -->
            <a href="{{ route('doctor.staff.add') }}" class="btn btn-primary ms-2 fs-13 btn-md">
                <i class="ti ti-plus me-1"></i>Add New Staff
            </a>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Start Filter -->
    <div class="d-flex align-items-center justify-content-between flex-wrap">
        <!-- Search -->
        <div>
            <div class="search-set mb-3">
                <div class="d-flex align-items-center flex-wrap gap-2">
                    <div class="table-search d-flex align-items-center mb-0">
                        <div class="search-input">
                            <input type="text" wire:model.live.debounce.300ms="search"
                                class="form-control form-control-md" placeholder="Search staff...">
                            <a href="javascript:void(0);" class="btn-searchset"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters and Sort -->
        <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
            <!-- Filter Dropdown -->
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" class="link-danger text-decoration-underline"
                                wire:click="clearAllFilters">Clear All</a>
                        </div>
                    </div>
                    <div class="filter-body pb-0">
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Status</label>
                                <a href="javascript:void(0);" class="link-primary mb-1"
                                    wire:click="resetStatusFilter">Reset</a>
                            </div>
                            <select class="form-select" wire:model="statusFilter">
                                <option value="all">All Status</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                                <option value="beta">Beta</option>
                            </select>
                        </div>

                        <!-- Docotr Filter -->
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Doctor</label>
                                <a href="javascript:void(0);" wire:click="$set('doctorFilter', 'all')"
                                    class="link-primary mb-1">Reset</a>
                            </div>
                            <select class="form-select" wire:model="doctorFilter">
                                <option value="all">All Doctors</option>
                                @foreach ($allDoctors as $association)
                                    @php
                                        $doctor = $association->doctor;
                                    @endphp
                                    <option value="{{ $doctor->id }}">{{ $doctor->name }}</option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                    <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                        <a href="javascript:void(0);" class="btn btn-light btn-md me-2"
                            data-bs-toggle="dropdown">Close</a>
                        <button type="button" class="btn btn-primary btn-md" wire:click="applyFilters"
                            data-bs-toggle="dropdown">Filter</button>
                    </div>
                </div>
            </div>

            <!-- Sort Dropdown -->
            <div class="dropdown">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1">Sort By : </span> {{ ucfirst($sortField) }}
                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('name')">Name</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('status')">Status</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <!-- End Filter -->

    <!-- Start Table -->
    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th wire:click="sortBy('name')" style="cursor: pointer;">
                        Name
                        {!! $sortField === 'name' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Assigned Doctor</th>
                    <th wire:click="sortBy('status')" style="cursor: pointer;">
                        Status
                        {!! $sortField === 'status' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($staffAssociations as $association)
                    @php
                        $user = $association->staff;
                        $doctor = $association->doctor;
                        $profileImage = $user->staff?->profile_image;
                    @endphp
                    <tr>
                        <td>
                            <a href="{{ route('doctor.staff.view', $user) }}" class="text-dark fw-semibold">
                                <x-user.avatar-name :name="$user->name" :profileImage="$profileImage" />
                            </a>
                        </td>
                        <td>{{ $user->email }}</td>
                        <td>{{ $user->phone_number ?? 'N/A' }}</td>
                        <td>
                            @if ($doctor)
                                <x-user.avatar-name :name="$doctor->name" :profileImage="$doctor->doctor->profile_image" />
                            @else
                                Not assigned
                            @endif
                        </td>
                        <td>
                            <span
                                class="badge badge-soft-{{ $association->status === 'active' ? 'success' : 'danger' }} rounded text-{{ $association->status === 'active' ? 'success' : 'danger' }} border border-{{ $association->status === 'active' ? 'success' : 'danger' }}">
                                {{ ucfirst($association->status ?? 'Inactive') }}
                            </span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                <a href="javascript:void(0);"
                                    class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1"
                                    data-bs-toggle="dropdown">
                                    <i class="ti ti-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu p-2 bg-white">
                                    <li>
                                        <a href="{{ route('doctor.staff.view', $user->id) }}"
                                            class="dropdown-item d-flex align-items-center">
                                            <i class="ti ti-eye me-2"></i>View
                                        </a>
                                    </li>
                                    @can('edit staff')
                                        <li>
                                            <a href="{{ route('doctor.staff.edit', ['staff'=>$user , 'doctor'=>$doctor]) }}"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-edit me-2"></i>Edit
                                            </a>
                                        </li>
                                    @endcan
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center"
                                            wire:click="toggleStatus({{ $association }})">
                                            <i class="ti ti-power me-2"></i>
                                            {{ $association->status === 'active' ? 'Deactivate' : 'Activate' }}
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);"
                                            class="dropdown-item d-flex align-items-center text-danger"
                                            wire:click="delete({{ $association->id }})">
                                            <i class="ti ti-trash me-2"></i>Remove
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center">No staff members found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <!-- End Table -->

    <!-- Pagination -->
    <x-table.pagination :paginator="$staffAssociations" :position="'both'" />
</div>
