<div class="sidebar-top shadow-sm p-2 rounded-1 mb-3 dropend">
    @if (count($clinics) > 0)
        <a href="javascript:void(0);" class="drop-arrow-none" data-bs-toggle="dropdown" data-bs-auto-close="outside"
            data-bs-offset="0,22" aria-haspopup="false" aria-expanded="false">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <div
                        class="avatar-initial rounded-circle bg-success text-white d-flex align-items-center justify-content-center fw-bold" 
                        style="width: 35px; height: 35px; font-size: 16px;">
                        {{ getInitials($currentClinic['name'] ?? 'S') }}
                    </div>

                    <div class="ms-2">
                        <h6 class="fs-14 fw-semibold mb-0">{{ $currentClinic['name'] ?? 'Select Clinic' }}</h6>
                        <p class="fs-13 mb-0">
                            <span class="badge bg-primary">Staff Access</span>
                        </p>
                    </div>
                </div>
                <i class="ti ti-arrows-transfer-up"></i>
            </div>
        </a>
        <div class="dropdown-menu dropdown-menu-lg bg-white">
            <div class="p-2">
                <div class="text-muted fs-12 mb-2 px-2">
                    <i class="ti ti-user-check me-1"></i>My Assigned Clinics
                </div>
                @foreach ($clinics as $clinic)
                    <label class="dropdown-item d-flex align-items-center justify-content-between p-1"
                        wire:click="selectClinic('{{ $clinic['id'] }}')">
                        <span class="d-flex align-items-center">
                            <div
                                class="avatar-initial rounded-circle bg-success text-white d-flex align-items-center justify-content-center fw-bold me-2"
                                style="width: 35px; height: 35px; font-size: 16px;">
                                {{ getInitials($clinic['name']) }}
                            </div>

                            <span class="fw-semibold text-dark">
                                {{ $clinic['name'] }}
                                <small class="d-block text-muted fw-normal fs-13">
                                    {{ $clinic['location'] ?? 'Staff Assignment' }}
                                    @if(isset($clinic['doctor_id']) && $clinic['doctor_id'])
                                        <br><span class="badge bg-light text-dark">Under Dr. {{ $clinic['doctor_name'] ?? 'Supervisor' }}</span>
                                    @endif
                                </small>
                            </span>
                        </span>
                        <input class="form-check-input m-0 me-2" type="radio" name="staff_clinic_selection"
                            {{ $selectedClinic == $clinic['id'] ? 'checked' : '' }}>
                    </label>
                @endforeach
            </div>
        </div>
    @else
        <div class="sidebar-top shadow-sm p-2 rounded-1 mb-3">
            <div class="d-flex align-items-center text-warning">
                <span class="avatar rounded-circle flex-shrink-0 p-2">
                    <i class="fas fa-exclamation-triangle"></i>
                </span>
                <div class="ms-2">
                    <h6 class="fs-14 fw-semibold mb-0 text-warning">No clinics assigned</h6>
                    <p class="fs-13 mb-0 text-muted">Contact your supervising doctor</p>
                </div>
            </div>
        </div>
    @endif
</div>