<div class="content" id="profilePage">
    <!-- Page Header -->
    <div class="mb-3 border-bottom pb-3">
        <h4 class="fw-bold mb-0">Profile Settings</h4>
    </div>
    <!-- End Page Header -->

    <div class="card">
        <div class="card-body p-0">
            <div class="settings-wrapper d-flex">

                <!-- Start Settings Sidebar -->
                <div class="sidebars settings-sidebar" id="sidebar2">
                    <div class="sidebar-inner" data-simplebar>
                        <div id="sidebar-menu5" class="sidebar-menu mt-0 p-0">
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);" class="active">
                                        <i class="ti ti-user-cog me-2"></i><span>Profile Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);" class="active">Basic Information</a></li>
                                        <li><a href="javascript:void(0);">Security</a></li>
                                        <li><a href="javascript:void(0);">Notifications</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- End Settings Sidebar -->

                <div class="card flex-fill mb-0 border-0 bg-light-500 shadow-none">
                    <div class="card-header border-bottom px-0 mx-3 d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Profile Information</h5>
                        {{-- <a href="{{ route('doctor.staff.doctor-dashboard') }}" class="btn btn-outline-secondary btn-sm">← Back to Dashboard</a> --}}
                    </div>
                    <div class="card-body px-0 mx-3">
                        @if (session()->has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('message') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif

                        <!-- start row -->
                        <div class="row border-bottom mb-3">
                            <div class="col-lg-12">
                                <!-- Profile Image Section -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-2">
                                        <label class="form-label mb-0">Profile Image<span class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-10">
                                        <div class="position-relative d-inline-block">
                                            @if ($newProfilePicturePreview)
                                                <!-- When new image is selected (preview) -->
                                                <div class="position-relative">
                                                    <img src="{{ $newProfilePicturePreview }}" alt="Profile"
                                                        class="rounded-circle"
                                                        style="width: 80px; height: 80px; object-fit: cover;">
                                                    <button wire:click.prevent="removeProfilePicture" type="button"
                                                        class="btn btn-danger btn-icon btn-xs position-absolute rounded-circle"
                                                        style="top: -5px; right: -5px; width: 20px; height: 20px; padding: 0; border: 2px solid white;">
                                                        <i class="ti ti-x" style="font-size: 10px;"></i>
                                                    </button>
                                                </div>
                                            @elseif($currentProfilePicture)
                                                <!-- When existing image is present -->
                                                <div class="position-relative">
                                                    <img src="{{ asset('storage/' . $currentProfilePicture) }}"
                                                        alt="Profile" class="rounded-circle"
                                                        style="width: 80px; height: 80px; object-fit: cover;">
                                                    <button wire:click.prevent="removeExistingProfilePicture"
                                                        type="button"
                                                        class="btn btn-danger btn-icon btn-xs position-absolute rounded-circle"
                                                        style="top: -5px; right: -5px; width: 20px; height: 20px; padding: 0; border: 2px solid white;">
                                                        <i class="ti ti-x" style="font-size: 10px;"></i>
                                                    </button>
                                                </div>
                                            @else
                                                <!-- When no image - show initial letter avatar -->
                                                <div class="position-relative">
                                                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center"
                                                        style="width: 80px; height: 80px; font-size: 32px; font-weight: bold;">
                                                        {{ strtoupper(substr($name ?: 'U', 0, 1)) }}
                                                    </div>
                                                    <a href="javascript:void(0);"
                                                        class="position-absolute bottom-0 end-0 bg-dark rounded-circle p-1"
                                                        onclick="document.getElementById('profileUpload').click();">
                                                        <i class="ti ti-camera text-white" style="font-size: 12px;"></i>
                                                    </a>
                                                </div>
                                            @endif
                                        </div>

                                        @error('profile_image')
                                            <small class="text-danger d-block mt-1">{{ $message }}</small>
                                        @enderror

                                        @if ($newProfilePicturePreview || $currentProfilePicture)
                                            <div class="mt-2">
                                                <button type="button" class="btn btn-outline-primary btn-sm"
                                                    onclick="document.getElementById('profileUpload').click();">
                                                    Change Image
                                                </button>
                                            </div>
                                        @endif

                                        <input type="file" wire:model="profile_image" id="profileUpload"
                                            style="display: none;" accept="image/*">
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Full Name -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Full Name<span class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="name" type="text" class="form-control"
                                            placeholder="Enter your full name">
                                        @error('name')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Email -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Email<span class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="email" type="email" class="form-control"
                                            placeholder="Enter your email">
                                        @error('email')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Phone Number -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Primary Phone Number<span class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="phone_number" type="text" class="form-control"
                                            placeholder="Enter phone number">
                                        @error('phone_number')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                        <!-- Profile Details Section -->
                        <div class="row border-bottom mb-3">
                            <div class="mb-3">
                                <h5 class="fw-bold mb-0">Profile Details</h5>
                            </div>

                            <div class="col-lg-6">
                                <!-- First Name -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">First Name<span class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="first_name" type="text" class="form-control"
                                            placeholder="Enter first name">
                                        @error('first_name')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Last Name -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Last Name<span class="text-danger ms-1">*</span></label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="last_name" type="text" class="form-control"
                                            placeholder="Enter last name">
                                        @error('last_name')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Alternate Phone -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Alternate Phone</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="phone" type="text" class="form-control"
                                            placeholder="Enter alternate phone">
                                        @error('alternate_phone')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Gender -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Gender</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <select wire:model="gender" class="form-select">
                                            <option value="">Select Gender</option>
                                            <option value="male">Male</option>
                                            <option value="female">Female</option>
                                            <option value="other">Other</option>
                                        </select>
                                        @error('gender')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="date_of_birth" class="form-label mb-1 fw-medium">Date Of Birth</label>
                                    <div class="input-icon-end position-relative">
                                        <input wire:ignore id="date_of_birth" type="text"
                                            class="form-control datetimepicker" placeholder="dd/mm/yyyy">
                                        <span class="input-icon-addon">
                                            <i class="ti ti-calendar"></i>
                                        </span>
                                    </div>
                                    @error('date_of_birth')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Timezone -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Timezone</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <select wire:model="timezone" class="form-select">
                                            <option value="">Select Timezone</option>
                                            @foreach (timezone_identifiers_list() as $tz)
                                                <option value="{{ $tz }}">{{ $tz }}</option>
                                            @endforeach
                                        </select>
                                        @error('timezone')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                        <!-- Password Section -->
                        <div class="row mb-3">
                            <div class="mb-3">
                                <h5 class="fw-bold mb-0">Change Password</h5>
                            </div>

                            <div class="col-lg-6">
                                <!-- New Password -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">New Password</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="password" type="password" class="form-control"
                                            placeholder="Enter new password">
                                        @error('password')
                                            <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <!-- Confirm Password -->
                                <div class="row align-items-center mb-3">
                                    <div class="col-lg-4">
                                        <label class="form-label mb-0">Confirm Password</label>
                                    </div>
                                    <div class="col-lg-8">
                                        <input wire:model="password_confirmation" type="password"
                                            class="form-control" placeholder="Confirm new password">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

                        <div class="d-flex align-items-center justify-content-end">
                            <a href="{{ route('doctor.staff.doctor-dashboard') }}" class="btn btn-light me-3">Cancel</a>
                            <button wire:click="save" class="btn btn-primary">Update Profile</button>
                        </div>
                    </div>
                </div>
            </div>

        </div><!-- end card body -->
    </div><!-- end card -->
</div>