<div class="content">
    <!-- Page Header -->
    <div class="mb-3 border-bottom pb-3">
        <h4 class="fw-bold mb-0">Doctor Profile</h4>
    </div>
    <!-- End Page Header -->

    <div class="card" id="profilePage">
        <div class="card-body">
            <div class="row">
                <div class="col-lg-3">
                    <div class="text-start justify-content-start">
                        <a wire:click="setActiveTab('about')" 
                           class="d-block w-100 btn btn-md border rounded fs-14 fw-medium mb-1 w-100 text-start @if($activeTab === 'about') active text-primary @else text-dark @endif">
                           <i class="ti ti-user me-2 @if($activeTab === 'about') text-primary @else text-dark @endif"></i> About
                        </a>
                        <a wire:click="setActiveTab('basic-info')" 
                           class="d-block w-100 btn btn-md border rounded fs-14 fw-medium mb-1 w-100 text-start @if($activeTab === 'basic-info') active text-primary @else text-dark @endif">
                           <i class="ti ti-user-cog me-2 @if($activeTab === 'basic-info') text-primary @else text-dark @endif"></i> Basic Info
                        </a>
                        <a wire:click="setActiveTab('education')" 
                           class="d-block w-100 btn btn-md border rounded fs-14 fw-medium mb-1 w-100 text-start @if($activeTab === 'education') active text-primary @else text-dark @endif">
                           <i class="ti ti-school me-2 @if($activeTab === 'education') text-primary @else text-dark @endif"></i> Education
                        </a>
                        <a wire:click="setActiveTab('experience')" 
                           class="d-block w-100 btn btn-md border rounded fs-14 fw-medium mb-1 w-100 text-start @if($activeTab === 'experience') active text-primary @else text-dark @endif">
                           <i class="ti ti-briefcase me-2 @if($activeTab === 'experience') text-primary @else text-dark @endif"></i> Experience
                        </a>
                        <a wire:click="setActiveTab('certificates')" 
                           class="d-block w-100 btn btn-md border rounded fs-14 fw-medium mb-1 w-100 text-start @if($activeTab === 'certificates') active text-primary @else text-dark @endif">
                           <i class="ti ti-certificate me-2 @if($activeTab === 'certificates') text-primary @else text-dark @endif"></i> Certificates
                        </a>
                        <a wire:click="setActiveTab('patients')" 
                           class="d-block w-100 btn btn-md border rounded fs-14 fw-medium mb-1 w-100 text-start @if($activeTab === 'patients') active text-primary @else text-dark @endif">
                           <i class="ti ti-users me-2 @if($activeTab === 'patients') text-primary @else text-dark @endif"></i> Patients
                        </a>
                    </div>
                </div><!-- end col -->

                <div class="col-lg-9">
                    <div class="border-1 border-start ps-4">
                        @if($activeTab === 'about')
                            @livewire('doctor.profile.doctor-about-component')
                        @elseif($activeTab === 'basic-info')
                            @livewire('doctor.profile.doctor-basic-info-component')
                        @elseif($activeTab === 'education')
                            @livewire('doctor.profile.doctor-education-component')
                        @elseif($activeTab === 'experience')
                            @livewire('doctor.profile.doctor-experience-component')
                        @elseif($activeTab === 'certificates')
                            @livewire('doctor.profile.doctor-certificates-component')
                        @elseif($activeTab === 'patients')
                            @livewire('doctor.profile.doctor-patients-table')
                        @endif
                    </div>
                </div> <!-- end col -->
            </div>
        </div><!-- end card body -->
    </div>
</div>