<div class="content">
    <!-- Success/Error Messages -->
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">
                <i class="ti ti-users me-2 text-primary"></i>My Patients
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Patients: {{ $patients->total() ?? 0 }}
                </span>
            </h4>
            <small class="text-muted">Manage all patients assigned to you</small>
        </div>

        <div class="search-set">
            <div class="table-search d-flex align-items-center mb-0">
                <div class="search-input">
                    <a href="javascript:void(0);" class="btn-searchset"></a>
                    <div class="dataTables_filter">
                        <label>
                            <input type="search" class="form-control form-control-sm" placeholder="Search patients..."
                                wire:model.live.debounce.300ms="searchTerm" aria-controls="DataTables_Table_0">
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if (!$isLoaded)
        <div class="text-center py-4">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p class="mt-2">Loading patients...</p>
        </div>
    @else
        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead class="">
                    <tr>
                        <th wire:click="sortBy('name')" style="cursor: pointer;">
                            <i class="ti ti-user me-1"></i>Name
                            {!! $sortField === 'name' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                        </th>
                        <th wire:click="sortBy('email')" style="cursor: pointer;">
                            <i class="ti ti-mail me-1"></i>Email
                            {!! $sortField === 'email' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                        </th>
                        <th>
                            <i class="ti ti-building-hospital me-1"></i>Clinic
                        </th>
                        <th>
                            <i class="ti ti-info-circle me-1"></i>Status
                        </th>
                        <th>
                            <i class="ti ti-calendar me-1"></i>Joined Date
                        </th>
                        <th class="text-end">
                            <i class="ti ti-settings me-1"></i>Actions
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($patients as $patient)
                        @foreach ($patient->patientClinics as $association)
                            @php
                                $user = $association->patient;
                                $profileImage = $user->patient?->profile_image;
                            @endphp
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <x-user.avatar-name :name="$user->name" :profileImage="$profileImage" />                                        
                                    </div>
                                </td>
                                <td>
                                    <span class="text-primary">{{ $patient->email }}</span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <i class="ti ti-building-hospital text-info me-2"></i>
                                        <span class="fw-medium">{{ $association->clinic->name ?? 'N/A' }}</span>
                                    </div>
                                </td>
                                <td>
                                    <span
                                        wire:click="togglePatientStatus({{ $patient->id }}, {{ $association->clinic_id }}, {{ $association->doctor_id }})"
                                        style="cursor: pointer;"
                                        class="badge badge-soft-{{ $association->status === 'active' ? 'success' : 'danger' }} border border-{{ $association->status === 'active' ? 'success' : 'danger' }}">
                                        <i class="ti ti-{{ $association->status === 'active' ? 'check' : 'x' }} me-1"></i>
                                        {{ ucfirst($association->status ?? 'Inactive') }}
                                    </span>
                                </td>
                                <td>
                                    <small class="text-muted">
                                        <i class="ti ti-calendar me-1"></i>
                                        {{ $association->created_at ? $association->created_at->format('M d, Y') : 'N/A' }}
                                    </small>
                                </td>
                                <td class="text-end">
                                    <div class="d-flex align-items-center justify-content-end">
                                        <div class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu dropdown-menu-end bg-white">
                                                <li>
                                                    <a class="dropdown-item d-flex align-items-center" href="#">
                                                        <i class="ti ti-eye me-2 text-info"></i>View Profile
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item d-flex align-items-center" href="#">
                                                        <i class="ti ti-notes me-2 text-primary"></i>Medical Records
                                                    </a>
                                                </li>
                                                <li class="dropdown-divider"></li>
                                                <li>
                                                    <a href="javascript:void(0);" @click="$dispatch('show-shared-delete-modal', {
                                                                                            title: 'Delete Patient',
                                                                                            message: 'Are you sure you want to remove this patient from the clinic?',
                                                                                            patientId: {{ $patient->id }},
                                                                                            clinicId: {{ $association->clinic_id }},
                                                                                            action: 'confirm-delete-patient'
                                                                                        })" class="dropdown-item text-danger">
                                                        <i class="ti ti-trash me-2"></i> Remove
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @empty
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <div class="empty-state">
                                    <i class="ti ti-users text-muted mb-3" style="font-size: 3rem;"></i>
                                    <h5 class="text-muted">No Patients Found</h5>
                                    <p class="text-muted">
                                        @if ($searchTerm)
                                            No patients match your search criteria.
                                        @else
                                            You don't have any patients assigned yet.
                                        @endif
                                    </p>
                                    @if ($searchTerm)
                                        <button wire:click="$set('searchTerm', '')" class="btn btn-sm btn-outline-primary">
                                            <i class="ti ti-x me-1"></i>Clear Search
                                        </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if ($patients->hasPages())
            <div class="d-flex justify-content-center mt-3">
                {{ $patients->links('vendor.livewire.bootstrap') }}
            </div>
        @endif
    @endif
</div>