<div>
    <h5 class="fw-bold pb-3 mb-4 border-1 border-bottom">Experience Information</h5>

    @if(session()->has('message'))
        <div class="alert alert-success">
            {{ session('message') }}
        </div>
    @endif

    <form wire:submit.prevent="save">
        @foreach($experiences as $index => $experience)
        <div class="experience-entry border rounded p-3 mb-3 position-relative" >
            @if($index > 0)
            <button type="button" wire:click="removeExperience({{ $index }})" 
                    class="btn btn-sm btn-outline-danger position-absolute top-0 end-0 mt-2 me-2">
                <i class="fa fa-times"></i>
            </button>
            @endif

            <div class="row g-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label fw-bold">Position <span class="text-danger">*</span></label>
                        <input wire:model="experiences.{{ $index }}.position" type="text" 
                               class="form-control @error('experiences.'.$index.'.position') is-invalid @enderror" 
                               placeholder="Job title/position">
                        @error('experiences.'.$index.'.position')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label fw-bold">Organization <span class="text-danger">*</span></label>
                        <input wire:model="experiences.{{ $index }}.organization" type="text" 
                               class="form-control @error('experiences.'.$index.'.organization') is-invalid @enderror" 
                               placeholder="Hospital/Clinic name">
                        @error('experiences.'.$index.'.organization')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label fw-bold">Start Date <span class="text-danger">*</span></label>
                        <input wire:model="experiences.{{ $index }}.start_date" type="date" 
                               class="form-control @error('experiences.'.$index.'.start_date') is-invalid @enderror">
                        @error('experiences.'.$index.'.start_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="form-label fw-bold">End Date</label>
                        <input wire:model="experiences.{{ $index }}.end_date" type="date" 
                               class="form-control @error('experiences.'.$index.'.end_date') is-invalid @enderror">
                        <small class="text-muted">Leave empty if current position</small>
                        @error('experiences.'.$index.'.end_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
        </div>
        @endforeach

        <div class="d-flex justify-content-between align-items-center mb-4">
            <button type="button" wire:click="addExperience" class="btn btn-outline-primary">
                <i class="fa fa-plus me-1"></i> Add Experience
            </button>
            
            <div>
                <button type="reset" class="btn btn-light btn-md fs-13 fw-medium rounded me-2">Cancel</button>
                <button type="submit" class="btn btn-primary btn-md fs-13 fw-medium rounded">
                    <span wire:loading.remove>Save Changes</span>
                    <span wire:loading>Saving...</span>
                </button>
            </div>
        </div>
    </form>
</div>