<!-- Start Content -->
<div class="content pb-0">

    <!-- Profile Header Card -->
    <div class="card">
        <div class="card-body d-flex align-items-center justify-content-between flex-wrap row-gap-3">
            <div class="d-flex align-items-center flex-sm-nowrap flex-wrap row-gap-3">
                <div class="me-3 doctor-profile-img">
                    <a href="#">
                        @if ($doctor->profile_image)
                            <img src="{{ Storage::url($doctor->profile_image) }}" class="rounded" alt="Profile Image"
                                style="width: 80px; height: 80px; object-fit: cover;">
                        @else
                            <div class="avatar avatar-xxxl {{ $this->getAvatarColorClass(Auth::user()->name) }} rounded d-flex align-items-center justify-content-center text-white"
                                style="font-size: 2rem;">
                                {{ $this->getInitials(Auth::user()->name) }}
                            </div>
                        @endif
                    </a>
                </div>
                <div class="flex-fill">
                    <div class="d-flex align-items-center mb-1">
                        <h6 class="mb-0 fw-semibold">{{ Auth::user()->name }}</h6>
                        <span class="badge border bg-white text-dark fw-medium ms-2">
                            <i
                                class="ti ti-point-filled me-1 text-info"></i>{{ $doctor->specialization ?? 'Specialization' }}
                        </span>
                    </div>
                    <span class="d-block mb-3 fs-13">
                        @if (count($educations) > 0)
                            {{ $educations->first()->degree ?? 'Medical Degree' }}
                        @else
                            Medical Professional
                        @endif
                    </span>
                    <div class="d-flex align-items-center">
                        <p class="mb-0 fs-13"><i class="ti ti-building-hospital me-1"></i>Employee ID :
                            DR-{{ str_pad(Auth::id(), 4, '0', STR_PAD_LEFT) }}</p>
                        @if ($doctor->verification_status === 'verified')
                            <span class="badge badge-soft-success fw-medium ms-2"><i
                                    class="ti ti-point-filled me-1 text-success"></i>Verified</span>
                        @elseif($doctor->verification_status === 'pending')
                            <span class="badge badge-soft-warning fw-medium ms-2"><i
                                    class="ti ti-point-filled me-1 text-warning"></i>Pending</span>
                        @else
                            <span class="badge badge-soft-secondary fw-medium ms-2"><i
                                    class="ti ti-point-filled me-1 text-secondary"></i>Not Verified</span>
                        @endif
                    </div>
                </div>
            </div>
            <div>
                <p class="mb-2">Years of Experience</p>
                <h6 class="fs-18 fw-bold mb-3">{{ $doctor->years_of_experience ?? '0' }} <span
                        class="fw-normal text-body fs-14">Years</span></h6>
                <a href="#" class="btn btn-primary"><i class="ti ti-calendar-event me-1"></i>Book Appointment</a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div>
                <!-- Bio Section -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">About Me</h5>
                        <p>{{ $doctor->bio ?? 'No bio information available.' }}</p>
                    </div>
                </div>

                <!-- Education Information -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">Education Information</h5>
                        @if (count($educations) > 0)
                            <ul class="activity-feed rounded">
                                @foreach ($educations as $education)
                                    <li class="feed-item timeline-item">
                                        <h6 class="fw-bold mb-2">{{ $education->institution ?? 'N/A' }} -
                                            {{ $education->degree ?? 'N/A' }}</h6>
                                        <p>{{ $education->start_year ?? 'N/A' }} -
                                            {{ $education->end_year ?? 'Present' }}</p>
                                    </li>
                                @endforeach
                            </ul>
                        @else
                            <p>No education information available.</p>
                        @endif
                    </div>
                </div>

                <!-- Experience -->
                @if (count($experiences) > 0)
                    <div class="card">
                        <div class="card-body">
                            <h5 class="fw-bold mb-3">Professional Experience</h5>
                            <ul class="activity-feed rounded">
                                @foreach ($experiences as $experience)
                                    <li class="feed-item timeline-item">
                                        <h6 class="fw-bold mb-2">{{ $experience->position ?? 'N/A' }}</h6>
                                        @if ($experience->organization)
                                            <div class="mb-1">{{ $experience->organization }}</div>
                                        @endif
                                        <p>
                                            @if ($experience->start_date)
                                                {{ \Carbon\Carbon::parse($experience->start_date)->format('M Y') }}
                                                -
                                                @if (empty($experience->end_date))
                                                    Present
                                                @else
                                                    {{ \Carbon\Carbon::parse($experience->end_date)->format('M Y') }}
                                                @endif
                                            @else
                                                N/A
                                            @endif
                                        </p>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                @endif

                <!-- Certificates -->
                @if (count($uploadedCertificates) > 0)
                    <div class="card">
                        <div class="card-body">
                            <h5 class="fw-bold mb-3">Certifications</h5>
                            <div class="row">
                                @foreach ($uploadedCertificates as $certificate)
                                    <div class="col-md-6 mb-3">
                                        <div class="d-flex align-items-center mb-2">
                                            <span class="me-2"><i class="ti ti-award"></i></span>
                                            <h6 class="mb-0 fw-bold">{{ $certificate['name'] }}</h6>
                                        </div>
                                        <p class="small text-muted mb-2">
                                            Uploaded:
                                            {{ \Carbon\Carbon::parse($certificate['uploaded_at'])->diffForHumans() }}
                                        </p>
                                        <a href="{{ Storage::url($certificate['path']) }}" target="_blank"
                                            class="btn btn-sm btn-primary">
                                            <i class="ti ti-eye me-1"></i> View Certificate
                                        </a>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-xl-4 theiaStickySidebar">
            <div class="card">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">About</h6>
                    <div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-file"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Medical License Number</h6>
                                <p>{{ $doctor->license_number ?? 'N/A' }}</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-phone"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Phone Number</h6>
                                <p>{{ Auth::user()->phone_number ?? 'N/A' }}</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-mail"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Email Address</h6>
                                <p>{{ Auth::user()->email }}</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-user-check"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Years of Experience</h6>
                                <p>{{ $doctor->years_of_experience ?? '0' }} Years</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-shield-check"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Verification Status</h6>
                                <p>
                                    @if ($doctor->verification_status === 'verified')
                                        <span class="badge bg-success">Verified</span>
                                        @if ($doctor->verified_at)
                                            <small class="text-muted d-block">Verified on:
                                                {{ $doctor->verified_at->format('M d, Y') }}</small>
                                        @endif
                                    @elseif($doctor->verification_status === 'pending')
                                        <span class="badge bg-warning">Pending Verification</span>
                                    @else
                                        <span class="badge bg-secondary">Not Submitted</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-id"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Employee ID</h6>
                                <p>DR-{{ str_pad(Auth::id(), 4, '0', STR_PAD_LEFT) }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Content -->
