<div class="container-fluid">
    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if ($user && $patient)
        <div class="content">
            <!-- Page Header -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <button type="button" class="btn p-0 text-dark me-2" wire:click="backToList">
                        <i class="ti ti-chevron-left me-1"></i>Patients
                    </button>
                </h6>
            </div>

            <!-- Patient Header Card -->
            <div class="card">
                <div class="row align-items-end">
                    <div class="col-xl-9 col-lg-8">
                        <div class="d-sm-flex align-items-center position-relative z-0 overflow-hidden p-3">
                            <img src="{{ asset('assets/img/icons/shape-01.svg') }}" alt="img"
                                class="z-n1 position-absolute end-0 top-0 d-none d-lg-flex">

                            <div class="avatar avatar-xxxl patient-avatar me-2 flex-shrink-0">
                                @if ($patient->profile_image)
                                    <img src="{{ Storage::url($patient->profile_image) }}" alt="{{ $user->name }}"
                                        class="rounded">
                                @else
                                    <div class="avatar avatar-xxxl {{ getAvatarColorClass($user->name) }} rounded d-flex align-items-center justify-content-center text-white"
                                        style="font-size: 2rem;">
                                        {{ getInitials($user->name) }}
                                    </div>
                                @endif
                            </div>

                            <div>
                                <p class="text-primary mb-1">#PT{{ str_pad($patient->id, 4, '0', STR_PAD_LEFT) }}</p>
                                <h5 class="mb-1"><span class="fw-bold">{{ $user->name }}</span></h5>
                                <p class="mb-3">{{ $patient->address ?: 'Address not provided' }}</p>
                                <div class="d-flex align-items-center flex-wrap">
                                    <p class="mb-0 d-inline-flex align-items-center">
                                        <i class="ti ti-phone me-1 text-dark"></i>Phone :
                                        <span class="text-dark ms-1">{{ $patient->phone ?: 'Not provided' }}</span>
                                    </p>
                                    <span class="mx-2 text-light">|</span>
                                    <p class="mb-0 d-inline-flex align-items-center">
                                        <i class="ti ti-calendar-time me-1 text-dark"></i>Last Visited :
                                        <span class="text-dark ms-1">{{ $user->updated_at->format('d M Y') }}</span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4">
                        <div class="p-3 text-lg-end">
                            <div class="mb-4">
                                <a href="tel:{{ $patient->phone }}"
                                    class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2">
                                    <i class="ti ti-phone"></i>
                                </a>
                                <a href="mailto:{{ $user->email }}"
                                    class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2">
                                    <i class="ti ti-message-circle"></i>
                                </a>
                                <a href="javascript:void(0);"
                                    class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14">
                                    <i class="ti ti-video"></i>
                                </a>
                            </div>
                            <!-- <button type="button" class="btn btn-primary" wire:click="bookAppointment">
                                <i class="ti ti-calendar-event me-1"></i>Book Appointment
                            </button> -->
                            <a href="{{ route('doctor.appointments.create') }}" class="btn btn-primary ms-2 fs-13 btn-md"><i class="ti ti-calendar-event me-1"></i>Book Appointment </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Patient Details Row -->
            <div class="row">
                <!-- About Section -->
                <div class="col-xl-5 d-flex">
                    <div class="card shadow-sm flex-fill w-100">
                        <div class="card-header">
                            <h5 class="fw-bold mb-0"><i class="ti ti-user-star me-1"></i>About</h5>
                        </div>
                        <div class="card-body pb-0">
                            <div class="row">
                                <div class="col-sm-5">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2">
                                            <i class="ti ti-calendar-event fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1">DOB</h6>
                                            <p class="mb-0">
                                                {{ $patient->date_of_birth ? $patient->date_of_birth->format('d M Y') : 'Not provided' }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-7">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2">
                                            <i class="ti ti-droplet fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1">Blood Group</h6>
                                            <p class="mb-0">{{ $patient->blood_group ?? 'Not provided' }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-5">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2">
                                            <i
                                                class="ti ti-gender-{{ $patient->gender === 'female' ? 'female' : 'male' }} fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1">Gender</h6>
                                            <p class="mb-0">
                                                {{ $patient->gender ? ucfirst($patient->gender) : 'Not specified' }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-7">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2">
                                            <i class="ti ti-mail fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1">Email</h6>
                                            <p class="mb-0 text-break">{{ $user->email }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Vital Signs Section -->
                <div class="col-xl-7 d-flex">
                    <div class="card shadow-sm flex-fill w-100">
                        <div class="card-header">
                            <h5 class="fw-bold mb-0"><i class="ti ti-book me-1"></i>Patient Information</h5>
                        </div>
                        <div class="card-body pb-0">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border">
                                            <i class="ti ti-calendar-check fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1 text-truncate">Age</h6>
                                            <p class="mb-0 d-inline-flex align-items-center text-truncate">
                                                <i class="ti ti-point-filled me-1 text-success fs-18"></i>
                                                {{ $this->getAge() ? $this->getAge() . ' years' : 'N/A' }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border">
                                            <i class="ti ti-shield-check fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1 text-truncate">Status</h6>
                                            <p class="mb-0 d-inline-flex align-items-center text-truncate">
                                                <i
                                                    class="ti ti-point-filled me-1 {{ $user->status === 'active' ? 'text-success' : 'text-danger' }} fs-18"></i>
                                                {{ ucfirst($user->status) }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border">
                                            <i class="ti ti-building-hospital fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1">Clinics</h6>
                                            <p class="mb-0 d-inline-flex align-items-center text-truncate">
                                                <i class="ti ti-point-filled me-1 text-info fs-18"></i>
                                                {{ $patientClinics->count() }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border">
                                            <i class="ti ti-map-pin fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1 text-truncate">City</h6>
                                            <p class="mb-0 d-inline-flex align-items-center text-truncate">
                                                <i class="ti ti-point-filled me-1 text-primary fs-18"></i>
                                                {{ $patient->city ?: 'N/A' }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border">
                                            <i class="ti ti-calendar-plus fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1 text-truncate">Registered</h6>
                                            <p class="mb-0 d-inline-flex align-items-center text-truncate">
                                                <i class="ti ti-point-filled me-1 text-success fs-18"></i>
                                                {{ $user->created_at->format('M Y') }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border">
                                            <i class="ti ti-id fs-16"></i>
                                        </span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1 text-truncate">Patient ID</h6>
                                            <p class="mb-0 d-inline-flex align-items-center text-truncate">
                                                <i class="ti ti-point-filled me-1 text-secondary fs-18"></i>
                                                #PT{{ str_pad($patient->id, 4, '0', STR_PAD_LEFT) }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabs Section -->
            <ul class="nav nav-tabs nav-bordered mb-3">
                <li class="nav-item">
                    <button type="button"
                        class="nav-link {{ $activeTab === 'appointments' ? 'active' : '' }} bg-transparent border-0"
                        wire:click="setActiveTab('appointments')">
                        <span>Clinic Associations</span>
                    </button>
                </li>
                <li class="nav-item">
                    <button type="button"
                        class="nav-link {{ $activeTab === 'medical' ? 'active' : '' }} bg-transparent border-0"
                        wire:click="setActiveTab('medical')">
                        <span>Medical History</span>
                    </button>
                </li>
            </ul>

            <!-- Tab Content -->
            <div class="tab-content">
                <!-- Clinic Associations Tab -->
                <div class="tab-pane {{ $activeTab === 'appointments' ? 'show active' : '' }}">
                    @if ($patientClinics->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-nowrap">
                                <thead>
                                    <tr>
                                        <th>Clinic Name</th>
                                        <th>Doctor</th>
                                        <th>Status</th>
                                        <th>Approval</th>
                                        <th>Added Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($patientClinics as $association)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar rounded-circle bg-primary text-white me-2">
                                                        <i class="ti ti-building-hospital"></i>
                                                    </div>
                                                    <div>
                                                        <h6 class="fs-14 mb-1">
                                                            {{ $association->clinic->name ?? 'Unknown Clinic' }}</h6>
                                                        <p class="mb-0 fs-13 text-muted">
                                                            {{ $association->clinic->address ?? '' }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    @if ($association->doctor && $association->doctor->doctor && $association->doctor->doctor->profile_image)
                                                        <div class="avatar rounded-circle me-2"
                                                            style="width: 40px; height: 40px;">
                                                            <img src="{{ asset('storage/' . $association->doctor->doctor->profile_image) }}"
                                                                alt="{{ $association->doctor->name }}"
                                                                class="rounded-circle w-100 h-100"
                                                                style="object-fit: cover;">
                                                        </div>
                                                    @elseif($association->doctor)
                                                        <div class="avatar rounded-circle bg-success text-white me-2 d-flex align-items-center justify-content-center"
                                                            style="width: 40px; height: 40px; font-size: 14px;">
                                                            {{ getInitials($association->doctor->name) }}
                                                        </div>
                                                    @else
                                                        <div class="avatar rounded-circle bg-secondary text-white me-2 d-flex align-items-center justify-content-center"
                                                            style="width: 40px; height: 40px;">
                                                            <i class="ti ti-user-doctor fs-14"></i>
                                                        </div>
                                                    @endif
                                                    <div>
                                                        <h6 class="fs-14 mb-1">
                                                            {{ $association->doctor->name ?? 'Unknown Doctor' }}</h6>
                                                        <p class="mb-0 fs-13 text-muted">Doctor</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <span
                                                    class="badge fs-13 {{ $association->status === 'active' ? 'badge-soft-success text-success' : 'badge-soft-danger text-danger' }} rounded fw-medium">
                                                    {{ ucfirst($association->status) }}
                                                </span>
                                            </td>
                                            <td>
                                                <span
                                                    class="badge fs-13 {{ $association->approval_status === 'approved' ? 'badge-soft-success text-success' : 'badge-soft-warning text-warning' }} rounded fw-medium">
                                                    {{ ucfirst($association->approval_status) }}
                                                </span>
                                            </td>
                                            <td>{{ $association->created_at->format('d M Y') }}</td>
                                            {{-- <td class="action-item">
                                                <button type="button" class="btn btn-sm btn-light"
                                                    data-bs-toggle="dropdown">
                                                    <i class="ti ti-dots-vertical"></i>
                                                </button>
                                                <ul class="dropdown-menu p-2 bg-white">
                                                    <li>
                                                        <button type="button" class="dropdown-item">View
                                                            Details</button>
                                                    </li>
                                                </ul>
                                            </td> --}}
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="ti ti-info-circle me-2"></i>
                            This patient is not associated with any clinics yet.
                        </div>
                    @endif
                </div>

                <!-- Medical History Tab -->
                <div class="tab-pane {{ $activeTab === 'medical' ? 'show active' : '' }}">
                    @if ($patient->medical_history)
                        <div class="card">
                            <div class="card-body">
                                <h6 class="fw-bold mb-3">Medical History</h6>
                                <div class="border p-3 rounded bg-light">
                                    <p class="mb-0">{{ $patient->medical_history }}</p>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="ti ti-info-circle me-2"></i>
                            No medical history available for this patient.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @else
        <div class="alert alert-danger">
            <i class="ti ti-exclamation-triangle me-2"></i>
            Patient data could not be loaded.
        </div>
    @endif
    <style>
        .avatar-xxxl {
            width: 120px;
            height: 120px;
        }

        .nav-tabs .nav-link {
            border: none;
            border-bottom: 2px solid transparent;
        }

        .nav-tabs .nav-link.active {
            border-bottom-color: #0d6efd;
            background: transparent;
        }

        .badge-soft-success {
            background-color: rgba(25, 135, 84, 0.1);
            border: 1px solid rgba(25, 135, 84, 0.2);
        }

        .badge-soft-danger {
            background-color: rgba(220, 53, 69, 0.1);
            border: 1px solid rgba(220, 53, 69, 0.2);
        }

        .badge-soft-warning {
            background-color: rgba(255, 193, 7, 0.1);
            border: 1px solid rgba(255, 193, 7, 0.2);
        }

        .badge-soft-info {
            background-color: rgba(13, 202, 240, 0.1);
            border: 1px solid rgba(13, 202, 240, 0.2);
        }
    </style>
</div>
