<div class="content">
    <!-- Start Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">Patients List
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Patients : {{ $totalPatients }}
                </span>
            </h4>
        </div>
        <div class="text-end d-flex">
            <!-- Export Dropdown -->
            {{-- <div class="dropdown me-1">
                <a href="javascript:void(0);"
                    class="btn btn-md fs-14 fw-normal border bg-white rounded text-dark d-inline-flex align-items-center"
                    data-bs-toggle="dropdown">
                    Export<i class="ti ti-chevron-down ms-2"></i>
                </a>
                <ul class="dropdown-menu p-2 bg-white">
                    <li>
                        <a class="dropdown-item" href="#">Download as PDF</a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="#">Download as Excel</a>
                    </li>
                </ul>
            </div>

            <!-- View Toggle -->
            <div
                class="bg-white border shadow-sm rounded px-1 pb-0 text-center d-flex align-items-center justify-content-center">
                <a href="#" class="bg-light rounded p-1 d-flex align-items-center justify-content-center">
                    <i class="ti ti-list fs-14 text-dark"></i>
                </a>
                <a href="#" class="bg-white rounded p-1 d-flex align-items-center justify-content-center">
                    <i class="ti ti-layout-grid fs-14 text-body"></i>
                </a>
            </div> --}}

            <!-- Add New Patient -->
            <a href="{{ route('doctor.patient.management') }}" class="btn btn-primary ms-2 fs-13 btn-md">
                <i class="ti ti-plus me-1"></i>New Patient
            </a>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Start Filter -->
    <div class="d-flex align-items-center justify-content-between flex-wrap">
        <!-- Search -->
        <div>
            <div class="search-set mb-3">
                <div class="d-flex align-items-center flex-wrap gap-2">
                    <div class="table-search d-flex align-items-center mb-0">
                        <div class="search-input">
                            <input type="text" wire:model.live.debounce.300ms="searchTerm"
                                class="form-control form-control-md" placeholder="Search patients...">
                            <a href="javascript:void(0);" class="btn-searchset"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters and Sort -->
        <!-- Filters and Sort -->
        <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
            <!-- Filter Dropdown -->
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" wire:click="resetFilters"
                                class="link-danger text-decoration-underline">Clear All</a>
                        </div>
                    </div>
                    <form wire:submit.prevent="$refresh">
                        <div class="filter-body pb-0">
                            <!-- Status Filter -->
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Status</label>
                                    <a href="javascript:void(0);" wire:click="$set('statusFilter', 'all')"
                                        class="link-primary mb-1">Reset</a>
                                </div>
                                <select class="form-select" wire:model="statusFilter">
                                    <option value="all">All Statuses</option>
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>

                            <!-- Gender Filter -->
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Gender</label>
                                    <a href="javascript:void(0);" wire:click="$set('genderFilter', 'all')"
                                        class="link-primary mb-1">Reset</a>
                                </div>
                                <select class="form-select" wire:model="genderFilter">
                                    <option value="all">All Genders</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>

                            <!-- Doctor Filter -->
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Doctor</label>
                                    <a href="javascript:void(0);" wire:click="$set('doctorFilter', 'all')"
                                        class="link-primary mb-1">Reset</a>
                                </div>
                                <select class="form-select" wire:model="doctorFilter">
                                    <option value="all">All Doctors</option>
                                    @foreach ($doctors as $doctor)
                                        <option value="{{ $doctor->id }}">{{ $doctor->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                            <a href="javascript:void(0);" class="btn btn-light btn-md me-2" id="close-filter">Close</a>
                            <button type="submit" class="btn btn-primary btn-md">Apply</button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Keep your existing Sort Dropdown -->
            <div class="dropdown">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1">Sort By : </span> {{ ucfirst($sortBy) }}
                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('recent')">Recent</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('oldest')">Oldest</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <!-- End Filter -->

    <!-- Start Table -->
    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th>Patient</th>
                    <th>Phone</th>
                    <th>Doctor</th>
                    <th>Address</th>
                    <th>Last Visit</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($patients as $patient)
                    @php
                        // Get the most recent active patient clinic association
                        $patientClinic = $patient;

                        $doctor = $patientClinic->doctor ?? null;
                        $lastVisit = $patientClinic ? $patientClinic->created_at->format('d M Y') : 'N/A';
                        $profileImage = $patient->patient->patient->profile_image ?? null;
                        $initials = getInitials($patient->patient->name);
                    @endphp

                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <a href="{{ route('doctor.patient.view', $patient->patient_id) }}" class="avatar avatar-md me-2">
                                    @if ($profileImage && file_exists(public_path('storage/' . $profileImage)))
                                        <img src="{{ asset('storage/' . $profileImage) }}" alt="{{ $patient->patient->name }}"
                                            class="rounded-circle">
                                    @else
                                        <div
                                            class="avatar-initial rounded-circle bg-primary text-white d-flex align-items-center justify-content-center fw-bold">
                                            {{ $initials }}
                                        </div>
                                    @endif
                                </a>
                                <a href="{{ route('doctor.patient.view', $patient->patient->id) }}" class="text-dark fw-semibold">
                                    {{ $patient->patient->name }}
                                    <span class="text-body fs-13 fw-normal d-block">
                                        {{ ucfirst($patient->patient->patient->gender ?? 'N/A') }}
                                    </span>
                                </a>
                            </div>
                        </td>
                        <td>{{ $patient->patient->patient->phone ?? 'N/A' }}</td>
                        <td>
                            @if ($doctor)
                                <div class="d-flex align-items-center">
                                    <!-- Doctor Avatar -->
                                    <div class="avatar avatar-md me-2">
                                        @php
                                            // Access the doctor profile through the doctor relationship
                                            $doctorProfile = $doctor->doctor;
                                            $doctorProfileImage = $doctorProfile->profile_image ?? null;
                                            $doctorInitials = getInitials($doctor->name);
                                            $avatarColorClass = getAvatarColorClass($doctor->name);
                                        @endphp

                                        @if ($doctorProfileImage && Storage::disk('public')->exists($doctorProfileImage))
                                            <img src="{{ Storage::url($doctorProfileImage) }}"
                                                alt="{{ $doctor->name }}" class="rounded-circle">
                                        @else
                                            <div
                                                class="avatar-initial rounded-circle {{ $avatarColorClass }} text-white d-flex align-items-center justify-content-center fw-bold">
                                                {{ $doctorInitials }}
                                            </div>
                                        @endif
                                    </div>

                                    <!-- Doctor Info -->
                                    <div>
                                        <h6 class="fs-14 mb-1">
                                            <a href="{{ route('doctor.doctor-management.view', $doctor->id) }}"
                                                class="fw-semibold">
                                                {{ $doctor->name }}
                                            </a>
                                        </h6>
                                        <p class="mb-0 fs-13">
                                            {{ $doctorProfile->specialization ?? 'General Practitioner' }}
                                        </p>
                                    </div>
                                </div>
                            @else
                                Not assigned
                            @endif
                        </td>
                        <td>{{ $patient->patient->patient->address ?? 'N/A' }}</td>
                        <td>{{ $lastVisit }}</td>
                        <td>
                            <span
                                class="badge badge-soft-{{ $patient->status === 'active' ? 'success' : 'danger' }} rounded text-{{ $patient->status === 'active' ? 'success' : 'danger' }} border border-{{ $patient->status === 'active' ? 'success' : 'danger' }}">
                                {{ ucfirst($patient->status) }}
                            </span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                {{-- <a href="{{ {{ route('doctor.appointments', ['patient_id' => $patient->id]) }} }}"
                                    class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                    <i class="ti ti-calendar-cog"></i>
                                </a> --}}
                                <a href="javascript:void(0);"
                                    class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1"
                                    data-bs-toggle="dropdown">
                                    <i class="ti ti-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu p-2 bg-white">
                                    <li>
                                        <a href="{{ route('doctor.patient.management', ['edit_id' => $patient->patient->id]) }}"
                                            class="dropdown-item d-flex align-items-center"><i
                                                class="ti ti-edit me-2"></i>Edit</a>
                                    </li>
                                    <li>
                                        <a href="{{ route('doctor.patient.view', $patient->patient->id) }}"
                                            class="dropdown-item d-flex align-items-center"><i
                                                class="ti ti-eye me-2"></i>View</a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center"
                                            wire:click="toggleStatus({{ $patient }})">
                                            <i class="ti ti-power me-2"></i>
                                            {{ $patient->status === 'active' ? 'Deactivate' : 'Activate' }}
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);"
                                            class="dropdown-item d-flex align-items-center text-danger"
                                            data-bs-toggle="modal" data-bs-target="#delete_patient"
                                            onclick="setDeletePatientId({{ $patient->patient->id }}, '{{ $patient->patient->name }}')">
                                            <i class="ti ti-trash me-2"></i>Delete
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center">No patients found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <!-- End Table -->
    <x-table.pagination :paginator="$patients" :position="'both'" />

    <!-- Start Delete Modal -->
    <div class="modal fade" id="delete_patient">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center position-relative">
                    <img src="{{ asset('assets/img/bg/delete-modal-bg-01.png') }}" alt=""
                        class="img-fluid position-absolute top-0 start-0">

                    <img src="{{ asset('assets/img/bg/delete-modal-bg-02.png') }}" alt=""
                        class="img-fluid position-absolute bottom-0 end-0">

                    <div class="mb-3">
                        <span class="avatar avatar-lg bg-danger text-white"><i class="ti ti-trash fs-24"></i></span>
                    </div>
                    <h5 class="fw-bold mb-1">Delete Confirmation</h5>
                    <p class="mb-3">Are you sure you want to delete <strong id="patientName"></strong>?</p>
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btn btn-light position-relative z-1 me-3"
                            data-bs-dismiss="modal">Cancel</a>
                        <a href="javascript:void(0);" class="btn btn-danger position-relative z-1"
                            id="confirmDeleteBtn">Yes, Delete</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .avatar-initial {
            width: 40px;
            height: 40px;
            font-size: 16px;
            font-weight: 600;
        }

        .avatar .avatar-initial {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .avatar-initial.bg-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
        }

        .avatar-initial.bg-success {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%) !important;
        }

        .avatar-initial.bg-info {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%) !important;
        }

        .avatar-initial.bg-warning {
            background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%) !important;
        }

        .avatar-initial.bg-danger {
            background: linear-gradient(135deg, #fa709a 0%, #fee140 100%) !important;
        }

        .avatar-initial.bg-secondary {
            background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%) !important;
        }
    </style>
</div>

@push('scripts')
    <script>
        let patientIdToDelete = null;

        function setDeletePatientId(patientId, patientName) {
            patientIdToDelete = patientId;
            document.getElementById('patientName').textContent = patientName;
        }

        document.getElementById('confirmDeleteBtn').addEventListener('click', function() {
            if (patientIdToDelete) {
                @this.call('deletePatient', patientIdToDelete);

                const modal = bootstrap.Modal.getInstance(document.getElementById('delete_patient'));
                modal.hide();

                patientIdToDelete = null;
            }
        });
    </script>
@endpush
