<div class="content pb-0">
    <!-- Start Page Header -->
    <div class="mb-3">
        <h6 class="fw-semibold fs-14 mb-0">
            <a href="{{ back()->getTargetUrl() }}"><i class="ti ti-chevron-left me-1"></i>Doctors</a>
        </h6>
    </div>
    <!-- End Page Header -->

    <div class="card">
        <div class="row align-items-end">
            <div class="col-xl-9 col-lg-8">
                <div class="d-sm-flex align-items-center position-relative z-0 overflow-hidden p-3">
                    <img src="{{ asset('assets/img/icons/shape-01.svg') }}" alt="img"
                        class="z-n1 position-absolute end-0 top-0 d-none d-lg-flex">

                    <div class="avatar avatar-xxxl patient-avatar me-2 flex-shrink-0">
                        @if ($doctor->profile_photo_url)
                            <img src="{{ $doctor->profile_photo_url }}" alt="{{ $doctor->name }}" class="rounded">
                        @else
                            <div class="avatar avatar-xxxl {{ getAvatarColorClass($doctor->name) }} rounded d-flex align-items-center justify-content-center text-white"
                                style="font-size: 2rem;">
                                {{ getInitials($doctor->name) }}
                            </div>
                        @endif
                    </div>

                    <div>
                        <p class="text-primary mb-1">#DR{{ str_pad($doctor->id, 4, '0', STR_PAD_LEFT) }}</p>
                        <h5 class="mb-1">
                            <span class="fw-bold">{{ $doctor->name }}</span>
                            <span class="badge border bg-white text-dark fw-medium ms-2">
                                <i class="ti ti-point-filled me-1 text-info"></i>
                                {{ $doctor->doctor->specialization ?? ($doctor->doctorProfile->specialization ?? 'N/A') }}
                            </span>
                        </h5>
                        <p class="mb-3">{{ $doctor->doctor->qualifications ?? 'N/A' }}</p>
                        <div class="d-flex align-items-center flex-wrap">
                            @if ($primaryClinic)
                                <p class="mb-0 d-inline-flex align-items-center">
                                    <i class="ti ti-building-hospital me-1 text-dark"></i>Clinic :
                                    <span class="text-dark ms-1">{{ $primaryClinic->name }}</span>
                                </p>
                                <span class="mx-2 text-light">|</span>
                            @endif
                            <p class="mb-0 d-inline-flex align-items-center">
                                <i
                                    class="ti ti-point-filled me-1 text-{{ $doctor->status === 'active' ? 'success' : 'danger' }}"></i>Status
                                :
                                <span class="text-dark ms-1">{{ ucfirst($doctor->status) }}</span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4">
                <div class="p-3 text-lg-end">
                    @if ($primaryClinic && $primaryClinic->pivot)
                        <div class="mb-4">
                            <h6 class="fs-18 fw-bold mb-1">
                                ₹{{ number_format($primaryClinic->pivot->in_person_fee ?? 0, 2) }}
                                <span class="fw-normal text-body fs-14">/
                                    {{ $primaryClinic->pivot->in_person_duration ?? 30 }} Min</span>
                            </h6>
                            <p class="mb-0 fs-13">Consultation Charge</p>
                        </div>
                    @endif
                    <!-- <button type="button" class="btn btn-primary" wire:click="bookAppointment">
                        <i class="ti ti-calendar-event me-1"></i>Book Appointment
                    </button> -->
                    <a href="{{ route('doctor.appointments.create') }}" class="btn btn-primary ms-2 fs-13 btn-md"><i class="ti ti-calendar-event me-1"></i>Book Appointment </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- Availability Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Availability</h5>
                    @foreach($availabilities as $availability)
                        @foreach(json_decode($availability->day, true) as $day)
                            @php
                                $status = 'active'; // yeh aap dynamic bhi kar sakte ho
                            @endphp
                            <span class="me-4 p-2">
                                <h6>{{ ucfirst($day) }} - </h6>
                                @foreach($availabilities as $availability)
                                    @foreach(json_decode($availability->time_slot, true) as $slot)
                                        <a href="#"
                                            class="d-inline-flex align-items-center bg-primary rounded flex-fill text-center justify-content-center p-1 text-light me-1 mb-3">
                                            {{ $slot }}
                                        </a>
                                    @endforeach
                                @endforeach
                            </span><hr/>
                        @endforeach
                    @endforeach
                </div>
            </div>

            <!-- Bio Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Short Bio</h5>
                    <p>{{ $doctor->doctor->bio ?? ($doctor->doctorProfile->bio ?? 'No biography available.') }}</p>
                    @if (
                        ($doctor->doctor->bio ?? $doctor->doctorProfile->bio) &&
                            strlen($doctor->doctor->bio ?? $doctor->doctorProfile->bio) > 200)
                        <div class="more-menu" style="display: none;">
                            <p>{{ substr($doctor->doctor->bio ?? $doctor->doctorProfile->bio, 200) }}</p>
                        </div>
                        <div class="view-all mt-2">
                            <a href="javascript:void(0);" class="viewall-button text-primary fw-medium">
                                <span>See More</span>
                                <i class="ti ti-chevron-down fs-10 ms-2"></i>
                            </a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Education Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Education Information</h5>
                    <ul class="activity-feed rounded">
                        @forelse($educations as $education)
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2">{{ $education->institution }} - {{ $education->degree }}</h6>
                                @if ($education->field_of_study)
                                    <p class="mb-1">{{ $education->field_of_study }}</p>
                                @endif
                                <p>
                                    {{ $education->start_year }} -
                                    @if ($education->is_current)
                                        Present
                                    @else
                                        {{ $education->end_year }}
                                    @endif
                                </p>
                                @if ($education->description)
                                    <p class="mt-2">{{ $education->description }}</p>
                                @endif
                            </li>
                        @empty
                            <li class="feed-item timeline-item">
                                <p>No education information available.</p>
                            </li>
                        @endforelse
                    </ul>
                </div>
            </div>

            <!-- Experience Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Work Experience</h5>
                    <ul class="activity-feed rounded">
                        @forelse($experiences as $experience)
                            <li class="feed-item timeline-item">
                                <h6 class="fw-bold mb-2">{{ $experience->position }} at
                                    {{ $experience->organization }}</h6>
                                <p>
                                    {{ $experience->start_date->format('M Y') }} -
                                    @if ($experience->is_current)
                                        Present
                                    @else
                                        {{ $experience->end_date->format('M Y') }}
                                    @endif
                                </p>
                                @if ($experience->description)
                                    <p class="mt-2">{{ $experience->description }}</p>
                                @endif
                            </li>
                        @empty
                            <li class="feed-item timeline-item">
                                <p>No work experience information available.</p>
                            </li>
                        @endforelse
                    </ul>
                </div>
            </div>

            <!-- Certifications Section -->
            <div class="card">
                <div class="card-body">
                    <h5 class="fw-bold mb-3">Certifications & Licenses</h5>
                    <div class="mb-3">
                        <div class="d-flex align-items-center mb-2">
                            <span class="me-2"><i class="ti ti-award"></i></span>
                            <h6 class="mb-0 fw-bold">License:
                                {{ $doctor->doctor->license_number ?? ($doctor->doctorProfile->license_number ?? 'N/A') }}
                            </h6>
                        </div>
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->license_state)
                            <p>State: {{ $doctor->doctorProfile->license_state }}</p>
                        @endif
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->license_valid_until)
                            <p>Valid Until: {{ $doctor->doctorProfile->license_valid_until->format('M d, Y') }}</p>
                        @endif
                    </div>

                    @if ($certificates)
                        @foreach ($certificates as $certificate)
                            <div class="mb-3">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="me-2"><i class="ti ti-certificate"></i></span>
                                    <h6 class="mb-0 fw-bold">{{ $certificate->name ?? 'Certificate' }}</h6>
                                </div>
                                @if (isset($certificate->uploaded_at))
                                    <p>Date: {{ $certificate->uploaded_at }}</p>
                                @endif
                                {{-- @if (isset($certificate['issuer']))
                                    <p>Issuer: {{ $certificate['issuer'] }}</p>
                                @endif --}}
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>

            <!-- Associated Clinics, Patients & Staff Tabs -->
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-transparent border-bottom p-0">
                        <ul class="nav nav-tabs" id="clinicTabs" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="clinics-tab" data-bs-toggle="tab" data-bs-target="#clinics"
                                    type="button" role="tab">
                                    <i class="ti ti-user me-2"></i> Clinic
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="patients-tab" data-bs-toggle="tab" data-bs-target="#patients"
                                    type="button" role="tab">
                                    <i class="ti ti-user me-2"></i> Patients
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="staff-tab" data-bs-toggle="tab" data-bs-target="#staff"
                                    type="button" role="tab">
                                    <i class="ti ti-users me-2"></i> Staff
                                </button>
                            </li>
                        </ul>
                    </div>

                    <div class="card-body">
                        <div class="tab-content" id="clinicTabsContent">
                            <!-- Clinics Tab -->
                            <div class="tab-pane fade show active" id="clinics" role="tabpanel" aria-labelledby="clinics-tab">
                                <!-- Clinics Section -->
                                @if ($clinics->isNotEmpty())
                                    <div class="table-responsive">
                                        <h6>Clinic Management</h6><hr>
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Clinic Name</th>
                                                    <th>Email</th>
                                                    <th>Contact Number</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($clinics as $clinic)
                                                    <tr>
                                                        <td>
                                                            {{ $clinic->name }}
                                                            @if ($clinic->pivot->is_primary)
                                                                <span class="badge bg-primary ms-2">Primary</span>
                                                            @endif
                                                        </td>
                                                        <td>{{ $clinic->email ?? '-' }}</td>
                                                        <td>
                                                            @if(!empty($clinic->contact_numbers))
                                                                {{-- contact_numbers agar JSON ya CSV hai toh handle karne ke liye --}}
                                                                @php
                                                                    $contacts = is_array($clinic->contact_numbers) 
                                                                        ? $clinic->contact_numbers 
                                                                        : explode(',', $clinic->contact_numbers);
                                                                @endphp
                                                                {{ implode(', ', $contacts) }}
                                                            @else
                                                                -
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <span
                                                                class="badge badge-soft-{{ $clinic->pivot->status === 'active' ? 'success' : 'danger' }}">
                                                                {{ ucfirst($clinic->pivot->status) }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @endif
                            </div>

                            <!-- Patients Tab -->
                            <div class="tab-pane fade" id="patients" role="tabpanel" aria-labelledby="patients-tab">
                                <!-- Patients Section -->
                                @if ($patients->isNotEmpty())
                                    <div class="table-responsive">
                                        <h5>Patient Management</h5><hr>
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Assigned Doctor</th>
                                                    <th>Status</th>
                                                    <th>Approval Status</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($patients as $patient)
                                                    <tr>
                                                        <td>{{ $patient->name ?? '-' }}</td>
                                                        <td>{{ $patient->email ?? '-' }}</td>
                                                        <td>{{ $doctor->name ?? '-' }}</td>
                                                        <td>
                                                            <span class="badge badge-soft-{{ $patient->status === 'active' ? 'success' : 'danger' }}">
                                                                {{ ucfirst($patient->status) }}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-soft-{{ $patient->approval_status === 'approved' ? 'success' : 'warning' }}">
                                                                {{ ucfirst($patient->approval_status) }}
                                                            </span>
                                                        </td>
                                                        <td class="action-item">
                                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                                <i class="ti ti-dots-vertical"></i>
                                                            </a>
                                                            <ul class="dropdown-menu p-2">
                                                                <li>
                                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center">
                                                                        <i class="ti ti-plus me-2"></i> Add
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center">
                                                                        <i class="ti ti-eye me-2"></i> View
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <p class="text-muted mt-2">No patients found.</p>
                                @endif
                            </div>

                            <!-- Staff Tab -->
                            <div class="tab-pane fade" id="staff" role="tabpanel" aria-labelledby="staff-tab">
                                <!-- Staff Section -->
                                @if ($staff->isNotEmpty())
                                    <div class="table-responsive">
                                        <h5>Staff Members</h5><hr/>
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Supervisor Doctor</th>
                                                    <th>Status</th>
                                                    <th>Approval Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($staff as $member)
                                                    <tr>
                                                        <td>{{ $member->name ?? '-' }}</td>
                                                        <td>{{ $member->email ?? '-' }}</td>
                                                        <td>{{ $doctor->name ?? '-' }}</td>
                                                        <td>
                                                            <span class="badge badge-soft-{{ $member->status === 'active' ? 'success' : 'danger' }}">
                                                                {{ ucfirst($member->status) }}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-soft-{{ $member->approval_status === 'approved' ? 'success' : 'warning' }}">
                                                                {{ ucfirst($member->approval_status) }}
                                                            </span>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @else
                                    <p class="text-muted mt-2">No staff members found.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar Section -->
        <div class="col-xl-4 theiaStickySidebar">
            <div class="card">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">About</h6>
                    <div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-file"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Medical License Number</h6>
                                <p>{{ $doctor->doctor->license_number ?? ($doctor->doctorProfile->license_number ?? 'N/A') }}
                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-phone"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Phone Number</h6>
                                <p>{{ $doctor->phone_number ?? 'N/A' }}</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-mail"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Email Address</h6>
                                <p>{{ $doctor->email }}</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                <i class="ti ti-user-check"></i>
                            </span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Years of Experience</h6>
                                <p>{{ $doctor->doctor->experience_years ?? ($doctor->doctorProfile->years_of_experience ?? '0') }}
                                    Years</p>
                            </div>
                        </div>
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->languages_spoken)
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-language"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Languages Spoken</h6>
                                    <p>{{ implode(', ', $doctor->doctorProfile->languages_spoken) }}</p>
                                </div>
                            </div>
                        @endif
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->sub_specializations)
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-stethoscope"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Sub-specializations</h6>
                                    <p>{{ implode(', ', $doctor->doctorProfile->sub_specializations) }}</p>
                                </div>
                            </div>
                        @endif
                        @if ($doctor->doctorProfile)
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-user-plus"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Accepts New Patients</h6>
                                    <p>{{ $doctor->doctorProfile->accepts_new_patients ? 'Yes' : 'No' }}</p>
                                </div>
                            </div>
                        @endif
                        @if ($doctor->doctorProfile && $doctor->doctorProfile->verification_status)
                            <div class="d-flex align-items-center mb-3">
                                <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2">
                                    <i class="ti ti-shield-check"></i>
                                </span>
                                <div>
                                    <h6 class="fw-semibold fs-13 mb-1">Verification Status</h6>
                                    <p class="text-capitalize">{{ $doctor->doctorProfile->verification_status }}</p>
                                    @if ($doctor->doctorProfile->verified_at)
                                        <small class="text-muted">Verified on:
                                            {{ $doctor->doctorProfile->verified_at->format('M d, Y') }}</small>
                                    @endif
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Ratings Section -->
            @if ($doctor->doctorProfile && ($doctor->doctorProfile->rating || $doctor->doctorProfile->reviews_count))
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">Ratings & Reviews</h6>
                        <div class="text-center">
                            <div class="d-flex align-items-center justify-content-center mb-2">
                                <h2 class="me-2 mb-0">{{ number_format($doctor->doctorProfile->rating, 1) }}</h2>
                                <div class="star-rating">
                                    @for ($i = 1; $i <= 5; $i++)
                                        @if ($i <= floor($doctor->doctorProfile->rating))
                                            <i class="ti ti-star-filled text-warning"></i>
                                        @elseif($i - 0.5 <= $doctor->doctorProfile->rating)
                                            <i class="ti ti-star-half-filled text-warning"></i>
                                        @else
                                            <i class="ti ti-star text-warning"></i>
                                        @endif
                                    @endfor
                                </div>
                            </div>
                            <p class="text-muted">{{ $doctor->doctorProfile->reviews_count }} reviews</p>
                            <a href="#" class="btn btn-outline-primary btn-sm">View All Reviews</a>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@push('scripts')
    <script>
        // For the "See More" functionality
        $(document).ready(function() {
            $('.viewall-button').click(function() {
                $(this).closest('.card-body').find('.more-menu').toggle();
                var span = $(this).find('span');
                var icon = $(this).find('i');

                if (span.text() === 'See More') {
                    span.text('See Less');
                    icon.removeClass('ti ti-chevron-down').addClass('ti ti-chevron-up');
                } else {
                    span.text('See More');
                    icon.removeClass('ti ti-chevron-up').addClass('ti ti-chevron-down');
                }
            });
        });
    </script>
@endpush

@push('styles')
    <style>
        .card {
            border-radius: 0.75rem;
            border: 1px solid rgba(0, 0, 0, 0.08);
            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.05);
        }

        .nav-tabs .nav-link {
            border: none;
            padding: 1rem 1.5rem;
            color: #6c757d;
            font-weight: 500;
        }

        .nav-tabs .nav-link.active {
            color: #2B7F75;
            border-bottom: 2px solid #2B7F75;
            background-color: transparent;
        }

        .alert {
            border-radius: 0.75rem;
        }

        .badge {
            font-weight: 500;
        }
    </style>
@endpush