<div class="page-wrapper">
    <div class="content">
        <!-- Page Header -->
        @component('components.page-header')
            @slot('title')
                <a href="{{ route('doctor.doctor-dashboard') }}">Dashboard</a>
            @endslot
            @slot('li_1')
                <a href="{{ route('doctor.doctor-management.list') }}">Manage Doctors</a>
            @endslot
        @endcomponent
        <!-- /Page Header -->

        @if (session()->has('message'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('message') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if (session()->has('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5>{{ $userIdBeingEdited ? 'Edit Doctor' : 'Add New Doctor' }}</h5>
                        <button wire:click="resetForm" class="btn btn-sm btn-secondary">Back</button>
                    </div>
    
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="name" class="form-label">Name</label>
                                <input wire:model.defer="name" type="text" id="name" class="form-control" placeholder="Dr. John Doe">
                                @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-md-6">
                                <label for="email" class="form-label">Email</label>
                                <input wire:model.defer="email" type="email" id="email" class="form-control" placeholder="doctor@example.com">
                                @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-md-6">
                                <label for="password" class="form-label">Password</label>
                                <input wire:model.defer="password" type="password" id="password" class="form-control" placeholder="Password">
                                @error('password') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-md-6">
                                <label for="password_confirmation" class="form-label">Confirm Password</label>
                                <input wire:model.defer="password_confirmation" type="password" id="password_confirmation" class="form-control" placeholder="Confirm Password">
                            </div>
    
                            <div class="col-md-6">
                                <label for="specialization" class="form-label">Specialization</label>
                                <input wire:model.defer="specialization" type="text" id="specialization" class="form-control" placeholder="Cardiology">
                                @error('specialization') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-md-6">
                                <label for="license_number" class="form-label">License Number</label>
                                <input wire:model.defer="license_number" type="text" id="license_number" class="form-control" placeholder="MD123456">
                                @error('license_number') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-md-6">
                                <label for="qualifications" class="form-label">Qualifications</label>
                                <input wire:model.defer="qualifications" type="text" id="qualifications" class="form-control" placeholder="MBBS, MD">
                                @error('qualifications') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-md-6">
                                <label for="experience_years" class="form-label">Experience (Years)</label>
                                <input wire:model.defer="experience_years" type="number" id="experience_years" class="form-control" placeholder="10">
                                @error('experience_years') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-12">
                                <label for="bio" class="form-label">Bio</label>
                                <textarea wire:model.defer="bio" id="bio" class="form-control" rows="3" placeholder="Brief about the doctor"></textarea>
                                @error('bio') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-md-6">
                                <label class="form-label">Status</label>
                                <div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="status" id="statusActive" value="active">
                                        <label class="form-check-label" for="statusActive">Active</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="status" id="statusInactive" value="inactive">
                                        <label class="form-check-label" for="statusInactive">Inactive</label>
                                    </div>
                                </div>
                                @error('status') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
    
                            <div class="col-12">
                                <button wire:click="save" class="btn btn-primary">{{ $userIdBeingEdited ? 'Update Doctor' : 'Create Doctor' }}</button>
                            </div>
                        </div>
                    </div>
                </div>
    
                {{-- Doctor List --}}
                <div class="card mt-4">
                    <div class="card-header">
                        <h5>Doctor List</h5>
                    </div>
    
                    <div class="card-body">
                        <input type="text" wire:model="searchTerm" class="form-control mb-3" placeholder="Search by name or email">
    
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Specialization</th>
                                    <th>License</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($users as $user)
                                    <tr>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>{{ $user->doctor?->specialization ?? 'N/A' }}</td>
                                        <td>{{ $user->doctor?->license_number ?? 'N/A' }}</td>
                                        <td>{{ ucfirst($user->status) }}</td>
                                        <td>
                                            <button wire:click="edit({{ $user->id }})" class="btn btn-sm btn-warning">Edit</button>
                                            <button wire:click="deleteDoctor({{ $user->id }})" class="btn btn-sm btn-danger">Delete</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">No doctors found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
    
                        <div class="mt-3">
                            {{ $users->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>