@php
    use App\Models\User;
    $isEditing = $editId !== null;
@endphp

<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('admin.clinics.view', $clinic) }}" class="text-dark">
                        <i
                            class="ti ti-chevron-left me-1"></i>{{ isset($editId) && $editId ? 'Edit Doctor' : 'Add New Doctor' }}
                    </a>
                </h6>
            </div>

            @if (session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <form wire:submit.prevent="{{ $isEditing ? 'updateDoctor' : 'createDoctor' }}">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $isEditing ? 'Edit Doctor' : 'Add New Doctor' }}
                            @if ($isEditing && $has_primary_clinic)
                                <span class="badge bg-primary">
                                    Primary
                                </span>
                            @endif
                        </h4>
                    </div>

                    <div class="card-body">
                        {{-- Flash Messages --}}
                        @if (session()->has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('message') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif

                        @if (session()->has('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif

                        {{-- Doctor Mode --}}
                        @if (!$editId)
                            <div class="mb-3 col-md-12">
                                <label class="form-label d-block">Doctor Selection Mode</label>
                                <div class="form-check form-check-inline">
                                    <input type="radio" name="doctorMode" class="form-check-input" id="createMode"
                                        wire:click="toggleDoctorMode('create')" value="create"
                                        @checked($doctorMode === 'create')>
                                    <label class="form-check-label" for="createMode">Create New Doctor</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input type="radio" name="doctorMode" class="form-check-input" id="selectMode"
                                        wire:click="toggleDoctorMode('select')" value="select"
                                        @checked($doctorMode === 'select')>
                                    <label class="form-check-label" for="selectMode">Select Existing Doctor</label>
                                </div>
                            </div>
                        @endif

                        {{-- Existing doctor Selection --}}
                        @if ($doctorMode === 'select')
                            <div class="mb-3 col-md-6" x-data>
                                <label class="form-label">Select Doctor</label>

                                <div class="position-relative">
                                    <input type="text" class="form-control" placeholder="Search doctor..."
                                        wire:model.live.debounce.300ms="searchTerm" @focus="dropdownVisible = true"
                                        x-ref="searchInput">

                                    @if ($dropdownVisible)
                                        <div class="mt-1 dropdown-menu d-block position-absolute w-100 bg-white"
                                            style="z-index: 1000; max-height: 300px; overflow-y: auto;">
                                            @forelse($existingDoctors as $doctor)
                                                <button type="button" class="dropdown-item"
                                                    wire:click="selectDoctor({{ $doctor->id }})">
                                                    {{ $doctor->name }} ({{ $doctor->email }})
                                                </button>
                                            @empty
                                                <div class="dropdown-item text-muted">No doctor found</div>
                                            @endforelse
                                        </div>
                                    @endif
                                </div>

                                @if ($selectedExistingDoctor)
                                    <div class="p-2 mt-2 rounded bg-light">
                                        <strong>Selected:</strong>
                                        {{ optional(User::find($selectedExistingDoctor))->name }}
                                        <button type="button" class="btn btn-sm btn-link text-danger"
                                            wire:click="$set('selectedExistingDoctor', null)">
                                            Clear
                                        </button>
                                    </div>
                                @endif

                                @error('selectedExistingDoctor')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        @endif

                        @if ($doctorMode === 'create' && !$editId)
                            <div class="row">
                                {{-- Basic Information Section --}}
                                <div class="col-12">
                                    <h6 class="text-muted mb-3">Basic Information</h6>
                                </div>

                                <!-- Profile Image -->
                                <div class="col-lg-12">
                                    <div class="mb-3 d-flex align-items-center">
                                        <label class="form-label mb-0 fw-medium">Profile Image</label>
                                        <div
                                            class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 ms-4 p-0">

                                            @php
                                                $imageUrl = $this->getProfileImageUrl();
                                            @endphp

                                            @if ($imageUrl)
                                                <!-- Show current image -->
                                                <img src="{{ $imageUrl }}" alt="Profile" class="w-100 h-100"
                                                    style="object-fit: cover;">
                                                <!-- Remove button -->
                                                <div class="position-absolute top-0 end-0 m-1">
                                                    <button type="button" wire:click="removeProfileImage"
                                                        class="btn btn-danger btn-sm rounded-circle p-1"
                                                        style="width: 24px; height: 24px; z-index: 10;">
                                                        <i class="ti ti-x fs-12"></i>
                                                    </button>
                                                </div>
                                            @else
                                                <!-- Show placeholder when no image -->
                                                <i class="ti ti-user-plus fs-16"></i>
                                            @endif

                                            <!-- File input -->
                                            <input type="file" wire:model="profile_image"
                                                class="form-control image-sign position-absolute top-0 start-0 w-100 h-100 opacity-0"
                                                accept="image/*" style="cursor: pointer;">

                                            <!-- Camera icon overlay -->
                                            <div class="position-absolute bottom-0 end-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center"
                                                style="z-index: 1;">
                                                <span
                                                    class="text-white d-flex align-items-center justify-content-center">
                                                    <i class="ti ti-photo fs-14"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Loading indicator -->
                                    <div wire:loading wire:target="profile_image" class="text-primary">
                                        <small><i class="spinner-border spinner-border-sm me-1"></i>Uploading
                                            image...</small>
                                    </div>

                                    <!-- Error display -->
                                    @error('profile_image')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="name" class="form-label">Name <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                        id="name" wire:model="name" placeholder="Enter doctor's full name">
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email <span
                                            class="text-danger">*</span></label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                        id="email" wire:model="email" placeholder="doctor@example.com">
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                {{-- Status --}}
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label mb-1 fw-medium">Status<span
                                                class="text-danger ms-1">*</span></label>
                                        <select class="form-select @error('status') is-invalid @enderror"
                                            wire:model="status">
                                            <option value="active">Active</option>
                                            <option value="inactive">Inactive</option>
                                        </select>
                                        @error('status')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                {{-- Professional Information Section --}}
                                <div class="col-12 mt-4">
                                    <h6 class="text-muted mb-3">Professional Information</h6>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="specialization" class="form-label">Specialization <span
                                            class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('specialization') is-invalid @enderror"
                                        id="specialization" wire:model="specialization"
                                        placeholder="e.g., Cardiology, Pediatrics">
                                    @error('specialization')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="license_number" class="form-label">License Number <span
                                            class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('license_number') is-invalid @enderror"
                                        id="license_number" wire:model="license_number"
                                        placeholder="Medical license number">
                                    @error('license_number')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="qualifications" class="form-label">Qualifications</label>
                                    <input type="text"
                                        class="form-control @error('qualifications') is-invalid @enderror"
                                        id="qualifications" wire:model="qualifications"
                                        placeholder="e.g., MD, MBBS, PhD">
                                    @error('qualifications')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="experience_years" class="form-label">Years of Experience</label>
                                    <input type="number"
                                        class="form-control @error('experience_years') is-invalid @enderror"
                                        id="experience_years" wire:model="experience_years" min="0"
                                        placeholder="0">
                                    @error('experience_years')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-12 mb-3">
                                    <label for="bio" class="form-label">Bio</label>
                                    <textarea class="form-control @error('bio') is-invalid @enderror" id="bio" rows="3" wire:model="bio"
                                        placeholder="Brief description about the doctor's background and expertise"></textarea>
                                    @error('bio')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        @endif

                        @if ($editId)
                            <div class="row">
                                {{-- Basic Information Section --}}
                                <div class="col-12">
                                    <h6 class="text-muted mb-3">Basic Information</h6>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="name" class="form-label">Name <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                        id="name" wire:model="name" placeholder="Enter doctor's full name"
                                        readonly>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email <span
                                            class="text-danger">*</span></label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                        id="email" wire:model="email" placeholder="doctor@example.com" readonly>
                                </div>
                            </div>
                        @endif
                        {{-- Permissions --}}
                        {{-- Permissions --}}
                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="fw-bold mb-0">Doctor Permissions</h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive border">
                                    <table class="table table-nowrap">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Module</th>
                                                <th>CREATE</th>
                                                <th>EDIT</th>
                                                <th>DELETE</th>
                                                <th>VIEW</th>
                                                <th>TOGGLE ALL</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($permissionGroups as $groupName => $groupPermissions)
                                                @php
                                                    $allChecked =
                                                        count(array_intersect($groupPermissions, $permissions)) ===
                                                            count($groupPermissions) ||
                                                        $groupName === 'Dashboard Access';
                                                    $isDisabled = in_array($groupName, [
                                                        'Appointment Management',
                                                        'Medical Records',
                                                        'Financial',
                                                        'Staff Management',
                                                    ]);
                                                @endphp
                                                <tr>
                                                    <td>
                                                        <p class="fw-medium text-dark">{{ $groupName }}</p>
                                                    </td>
                                                    @php
                                                        $permissionTypes = ['create', 'edit', 'delete', 'view'];
                                                        $permissionColumns = [];

                                                        foreach ($permissionTypes as $type) {
                                                            $permissionColumns[$type] = false;
                                                            foreach ($groupPermissions as $permission) {
                                                                if (str_contains($permission, $type)) {
                                                                    $permissionColumns[$type] = $permission;
                                                                    break;
                                                                }
                                                            }
                                                        }

                                                        if ($groupName === 'Dashboard Access') {
                                                            $permissionColumns['view'] = 'access admin dashboard';
                                                        }
                                                    @endphp

                                                    @foreach ($permissionTypes as $type)
                                                        <td>
                                                            @if ($permissionColumns[$type])
                                                                <div class="form-check form-check-md">
                                                                    <input class="form-check-input" type="checkbox"
                                                                        id="perm_{{ $permissionColumns[$type] }}"
                                                                        @checked(
                                                                            $permissionColumns[$type] === 'access admin dashboard' ||
                                                                                (is_array($permissions) && in_array($permissionColumns[$type], $permissions)))
                                                                        @disabled($permissionColumns[$type] === 'access admin dashboard' || $isDisabled)
                                                                        wire:click="togglePermission('{{ $permissionColumns[$type] }}')">
                                                                    @if ($permissionColumns[$type] === 'access admin dashboard')
                                                                        <span class="text-muted">(Required)</span>
                                                                    @endif
                                                                </div>
                                                            @endif
                                                        </td>
                                                    @endforeach

                                                    <td>
                                                        <button type="button"
                                                            class="btn btn-sm {{ $allChecked ? 'btn-outline-danger' : 'btn-outline-primary' }}"
                                                            wire:click="toggleAllPermissionsInGroup('{{ $groupName }}')"
                                                            @disabled($permissionColumns[$type] === 'access admin dashboard' || $isDisabled)>
                                                            {{ $allChecked ? 'Deny All' : 'Allow All' }}
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                @if ($doctorMode === 'create' && !$editId)
                                    <div class="alert alert-warning mt-3">
                                        A default password will be generated for the new sub doctor. They can reset it
                                        via the "Forgot Password" option.
                                    </div>
                                @endif
                                @error('permissions')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>



                    {{-- Form Actions --}}
                    <div class="card-footer d-flex justify-content-between">
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>
                                {{ $isEditing ? 'Update Doctor' : 'Create Doctor' }}
                            </button>
                        </div>

                        <div>
                            <a href="{{ route('admin.clinics.view', $clinic) }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>
                                Cancel
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
