<div>
    <div class="mb-4">
        <h5>Select Features to Include in This Plan</h5>
        <p class="text-muted">Check the features you want to include in this subscription plan.</p>
    </div>

    @error('selected_features')
        <div class="alert alert-danger py-2">{{ $message }}</div>
    @enderror

    <div class="row">
        @foreach ($available_features as $feature)
            <div class="col-md-4 mb-3">
                <div class="card">
                    <div class="card-body">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" wire:model="selected_features"
                                value="{{ $feature->id }}" id="feature_{{ $feature->id }}">
                            <label class="form-check-label fw-bold" for="feature_{{ $feature->id }}">
                                {{ $feature->feature_name }} -
                                <small class="text-muted">{{ $feature->feature_code }}</small>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <div class="mt-4 d-flex justify-content-between">
        <button type="button" wire:click="previous" class="btn btn-secondary">Previous</button>
        <button type="button" wire:click="next" class="btn btn-primary">Next: Usage Rates</button>
    </div>
</div>
